/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.LongDateTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class SecondDateTranslator
extends LongDateTranslator {
    static final long sdSecondFactor = 1L;
    static final long sdMinuteFactor = 60L;
    static final long sdHourFactor = 3600L;
    static final long sdDayFactor = 86400L;

    public SecondDateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public SecondDateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        this(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, false);
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        long ja;
        if (this.isNull(controller, mem)) {
            return null;
        }
        long value = mem.getInt8(this.bufpos_output);
        long datevalue = --value / 86400L;
        long timevalue = value - datevalue * 86400L;
        int hour = (int)(timevalue / 3600L);
        int minute = (int)((timevalue -= 3600L * (long)hour) / 60L);
        int second = (int)((timevalue -= 60L * (long)minute) / 1L);
        timevalue -= 1L * (long)second;
        long julian = datevalue + 1721424L;
        if (julian >= 2299161L) {
            long jalpha = (int)(((double)(julian - 1867216L) - 0.25) / 36524.25);
            ja = julian + 1L + jalpha - (long)((int)(0.25 * (double)jalpha));
        } else {
            ja = julian;
        }
        long jb = ja + 1524L;
        long jc = (int)(6680.0 + ((double)(jb - 2439870L) - 122.1) / 365.25);
        long jd = (int)((double)(365L * jc) + 0.25 * (double)jc);
        long je = (int)((double)(jb - jd) / 30.6001);
        int day = (int)(jb - jd - (long)((int)(30.6001 * (double)je)));
        int month = (int)(je - 1L);
        if (month > 12) {
            month -= 12;
        }
        int year = (int)(jc - 4715L);
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            --year;
        }
        if (cal == null) {
            return new Timestamp(year - 1900, month - 1, day, hour, minute, second, 0);
        }
        cal.clear();
        cal.set(year, month - 1, day, hour, minute, second);
        return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, 0);
    }

    public Object transTimestampForInput(Timestamp val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        TimeZone tz = cal.getTimeZone();
        long timeInMillis = cal.getTimeInMillis();
        int offset = tz.getOffset(timeInMillis);
        long ts = (timeInMillis + 62135769600000L + (long)offset) / 1000L + 1L;
        byte[] value = new byte[9];
        value[0] = 62;
        dataFormat.putInt8(value, ts, 1);
        return value;
    }

    public int getPrecision() {
        return 19;
    }

    public int getColumnDisplaySize() {
        return 19;
    }
}

