/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.VariableDataLengthTranslator;
import com.sap.db.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;

class StringTranslator
extends VariableDataLengthTranslator {
    StringTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getString(controller, mem);
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        String value = this.getString(controller, mem);
        BigDecimal result = null;
        if (value == null) {
            result = BigDecimal.valueOf(0L);
        } else {
            try {
                result = new BigDecimal(value);
            }
            catch (NumberFormatException exc) {
                try {
                    result = new BigDecimal(value.trim());
                }
                catch (NumberFormatException ex) {
                    throw this.newParseException(value, "BigDecimal");
                }
            }
        }
        return result;
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        String value = this.getString(controller, mem);
        if (value == null) {
            return false;
        }
        Boolean parsedBool = Boolean.valueOf(value);
        if (parsedBool.booleanValue()) {
            return true;
        }
        try {
            double doubleVal = Double.parseDouble(value);
            return doubleVal != 0.0;
        }
        catch (NumberFormatException exc) {
            return false;
        }
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        String result = this.getString(controller, mem);
        if (result != null) {
            return result.getBytes();
        }
        return null;
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        return this.bigDecimal2Byte(this.getBigDecimal(controller, mem));
    }

    public Reader getCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        String asString = this.getString(controller, mem);
        if (asString == null) {
            return null;
        }
        StringReader result = new StringReader(asString);
        return result;
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        String asString = this.getString(controller, mem);
        if (asString == null) {
            return null;
        }
        StringBufferInputStream result = new StringBufferInputStream(asString);
        return result;
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        return this.bigDecimal2Double(this.getBigDecimal(controller, mem));
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        return this.bigDecimal2Float(this.getBigDecimal(controller, mem));
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        return this.bigDecimal2Int(this.getBigDecimal(controller, mem));
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        return this.bigDecimal2Long(this.getBigDecimal(controller, mem));
    }

    public short getShort(SQLParamController controller, DataPart mem) throws SQLException {
        return this.bigDecimal2Short(this.getBigDecimal(controller, mem));
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getString(this.bufpos_output, this.logicalLength);
        }
        return result;
    }

    public Object transCharacterStreamForInput(Reader stream, long length) throws SQLException {
        if (stream == null || length == 0L) {
            return null;
        }
        try {
            String val;
            if (length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", "Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            if (length == -1L) {
                int erg;
                StringBuffer sb = new StringBuffer(128);
                char[] ba = new char[128];
                while ((erg = stream.read(ba)) != -1) {
                    sb.append(ba, 0, erg);
                }
                val = sb.toString();
            } else {
                char[] ba = new char[(int)length];
                int r = stream.read(ba);
                if ((long)r != length) {
                    if (r == -1) {
                        r = 0;
                    }
                    char[] ba2 = ba;
                    ba = new char[r];
                    System.arraycopy(ba2, 0, ba, 0, r);
                }
                val = new String(ba);
            }
            return this.transStringForInput(val);
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
        }
    }

    public Object transAsciiStreamForInput(InputStream stream, long length) throws SQLException {
        if (stream == null || length == 0L) {
            return null;
        }
        try {
            String val;
            if (length > Integer.MAX_VALUE) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", "Streams that size is longer than Integer.MAX_VALUE are not supported");
            }
            if (length == -1L) {
                int erg;
                StringBuffer sb = new StringBuffer(128);
                byte[] ba = new byte[128];
                while ((erg = stream.read(ba)) != -1) {
                    sb.append(new String(ba, 0, erg));
                }
                val = sb.toString();
            } else {
                byte[] ba = new byte[(int)length];
                int r = stream.read(ba);
                if ((long)r != length) {
                    if (r == -1) {
                        r = 0;
                    }
                    byte[] ba2 = ba;
                    ba = new byte[r];
                    System.arraycopy(ba2, 0, ba, 0, r);
                }
                val = new String(ba);
            }
            return this.transStringForInput(val);
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioex.getMessage());
        }
    }

    public Object transBinaryStreamForInput(InputStream stream, long length) throws SQLException {
        throw this.newSetException("java.io.InputStream");
    }

    protected Object transSpecificForInput(Object obj) throws SQLException {
        if (obj instanceof byte[]) {
            throw this.newSetException("byte[]");
        }
        return null;
    }
}

