/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.WrapperDummy;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class DataSourceSAPBase
extends WrapperDummy {
    public static final int DEFAULT_LOGINTIMEOUT = 30;
    public static final int DEFAULT_XATIMEOUT = 30;
    protected Properties connectProperties = new Properties();
    protected PrintWriter logWriter;

    public DataSourceSAPBase() {
        this.connectProperties.setProperty("serverName", "localhost");
        this.connectProperties.setProperty("port", "30115");
    }

    public String getUser() {
        return this.connectProperties.getProperty("user");
    }

    public void setLoginTimeout(int timeout) {
        this.connectProperties.setProperty("logintimeout", Integer.toString(timeout));
    }

    public int getLoginTimeout() {
        String s = this.connectProperties.getProperty("logintimeout");
        if (s == null) {
            return 30;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatEx) {
            return 30;
        }
    }

    public void setTimeout(int timeout) {
        this.connectProperties.setProperty("timeout", Integer.toString(timeout));
    }

    public int getTimeout() {
        String s = this.connectProperties.getProperty("timeout");
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatEx) {
            return 0;
        }
    }

    public String getPassword() {
        return this.connectProperties.getProperty("password");
    }

    public String getDescription() {
        return this.connectProperties.getProperty("description");
    }

    public String getServerName() {
        return this.connectProperties.getProperty("serverName");
    }

    public String getServerNames() {
        return this.connectProperties.getProperty("hostlist");
    }

    public void setUser(String user) {
        this.connectProperties.setProperty("user", user);
    }

    public void setPassword(String password) {
        this.connectProperties.setProperty("password", password);
    }

    public void setServerName(String serverName) {
        this.connectProperties.setProperty("serverName", serverName);
    }

    public void setServerNames(String serverNames) {
        this.connectProperties.setProperty("hostlist", serverNames);
    }

    public void setPortNumber(int port) {
        this.setPort(port);
    }

    public void setPort(int port) {
        this.connectProperties.setProperty("port", Integer.toString(port));
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.connectProperties.getProperty("port", "30115"));
        }
        catch (NumberFormatException nfex) {
            return 30115;
        }
    }

    public void setUrl(String url) {
        this.setServerNames(this.serverNamesFromUrl(url));
    }

    public String getURL() {
        StringBuffer sb = new StringBuffer("jdbc:sap://");
        String serverNames = this.getServerNames();
        if (serverNames != null) {
            sb.append(serverNames);
        } else {
            sb.append(this.getServerName() + ":" + this.getPort());
        }
        sb.append("/");
        return sb.toString();
    }

    private String serverNamesFromUrl(String url) {
        int closingSlashPos;
        String host;
        int urlLength = url.length();
        String delim = "";
        StringBuffer preferedHostList = new StringBuffer();
        int slashPos = "jdbc:sap:".length();
        if (urlLength >= slashPos + 3 && url.substring(slashPos, slashPos + 2).equals("//") && (host = url.substring(slashPos + 2, closingSlashPos = url.indexOf(47, slashPos + 2))) != null && host.length() > 0) {
            StringTokenizer st = new StringTokenizer(host, ";");
            while (st.hasMoreTokens()) {
                String hostname;
                String port;
                String singleHost = st.nextToken();
                int pos = singleHost.indexOf(58);
                if (pos == -1) {
                    port = "30015";
                    hostname = singleHost;
                } else {
                    hostname = singleHost.substring(0, pos);
                    port = singleHost.substring(pos + 1);
                }
                preferedHostList.append(delim);
                preferedHostList.append(hostname);
                preferedHostList.append(":");
                preferedHostList.append(port);
                delim = ";";
            }
        }
        return preferedHostList.toString();
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public void setTransport(String transport) {
        this.connectProperties.setProperty("transport", transport);
    }

    public String getTransport() {
        return this.connectProperties.getProperty("transport", "socket");
    }

    public void setReconnect(String reconnect) {
        this.connectProperties.setProperty("reconnect", reconnect);
    }

    public String getReconnect() {
        return this.connectProperties.getProperty("reconnect");
    }

    public void setTrace(String trace) {
        this.connectProperties.setProperty("trace", trace);
    }

    public String getTrace() {
        return this.connectProperties.getProperty("trace");
    }

    public void setTraceSize(String tracesize) {
        this.connectProperties.setProperty("tracesize", tracesize);
    }

    public String getTraceSize() {
        return this.connectProperties.getProperty("tracesize");
    }

    public void setXATrace(String xatrace) {
        this.connectProperties.setProperty("xatrace", xatrace);
    }

    public String getXATrace() {
        return this.connectProperties.getProperty("xatrace");
    }

    public void setSchema(String schema) {
        this.connectProperties.setProperty("currentschema", schema);
    }

    public String getSchema() {
        return this.connectProperties.getProperty("currentschema");
    }

    public void setXATimeout(int xatimeout) {
        this.connectProperties.setProperty("xatimeout", Integer.toString(xatimeout));
    }

    public int getXATimeout() {
        String s = this.connectProperties.getProperty("xatimeout");
        if (s == null) {
            return 30;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatEx) {
            return 30;
        }
    }

    public void setProperties(Properties p) {
        this.connectProperties = (Properties)p.clone();
    }

    public Connection openPhysicalConnection() throws SQLException {
        Properties p = (Properties)this.connectProperties.clone();
        String servernames = p.getProperty("hostlist");
        String url = "jdbc:sap://";
        if (servernames != null) {
            url = url + servernames + "/";
        } else {
            String serverName = p.getProperty("serverName", "localhost");
            url = url + serverName + ":" + this.getPort() + "/";
        }
        return Driver.singleton().connect(url, p);
    }

    public Connection openPhysicalConnection(String username, String password) throws SQLException {
        Properties p = (Properties)this.connectProperties.clone();
        p.setProperty("user", username);
        p.setProperty("password", password);
        String servernames = p.getProperty("hostlist");
        String url = "jdbc:sap://";
        if (servernames != null) {
            url = url + servernames + "/";
        } else {
            String serverName = p.getProperty("serverName", "localhost");
            url = url + serverName + ":" + this.getPort() + "/";
        }
        return Driver.singleton().connect(url, p);
    }

    public Connection openPhysicalConnection(Properties p) throws SQLException {
        String servernames = p.getProperty("hostlist");
        String url = "jdbc:sap://";
        if (servernames != null) {
            url = url + servernames + "/";
        } else {
            String serverName = p.getProperty("serverName", "localhost");
            url = url + serverName + ":" + this.getPort() + "/";
        }
        return Driver.singleton().connect(url, p);
    }

    protected Reference createReference(String classname) {
        Reference result = new Reference(classname, "com.sap.db.jdbcext.DataSourceSapDBFactory", null);
        if (this.getUser() != null) {
            result.add(new StringRefAddr("user", this.getUser()));
        }
        result.add(new StringRefAddr("logintimeout", Integer.toString(this.getLoginTimeout())));
        if (this.connectProperties.getProperty("timeout") != null) {
            result.add(new StringRefAddr("timeout", Integer.toString(this.getTimeout())));
        }
        if (this.getPassword() != null) {
            result.add(new StringRefAddr("password", this.getPassword()));
        }
        if (this.getDescription() != null) {
            result.add(new StringRefAddr("description", this.getDescription()));
        }
        if (this.getServerName() != null) {
            result.add(new StringRefAddr("serverName", this.getServerName()));
        }
        if (this.getServerNames() != null) {
            result.add(new StringRefAddr("hostlist", this.getServerNames()));
        }
        result.add(new StringRefAddr("port", Integer.toString(this.getPort())));
        if (this.getTransport() != null) {
            result.add(new StringRefAddr("transport", this.getTransport()));
        }
        if (this.getReconnect() != null) {
            result.add(new StringRefAddr("reconnect", this.getReconnect()));
        }
        if (this.getTrace() != null) {
            result.add(new StringRefAddr("trace", this.getTrace()));
        }
        if (this.getTraceSize() != null) {
            result.add(new StringRefAddr("tracesize", this.getTraceSize()));
        }
        if (this.getXATrace() != null) {
            result.add(new StringRefAddr("xatrace", this.getXATrace()));
        }
        result.add(new StringRefAddr("xatimeout", Integer.toString(this.getXATimeout())));
        return result;
    }
}

