/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.rte.comm;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.topology.Location;
import com.sap.db.rte.comm.DbPacketLayout;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.rte.comm.PacketLayout;
import com.sap.db.rte.comm.RTEException;
import com.sap.db.rte.comm.RteC;
import com.sap.db.rte.comm.RteSocketPacket;
import com.sap.db.util.FullswapMem;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.StructuredBytes;
import com.sap.db.util.StructuredMem;
import com.sap.db.util.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Properties;

public abstract class BasicSocketComm
extends JdbcCommunication {
    private static final byte[] cancelpacket = new byte[]{-8, 73, -25, 30, 0, 0, 0, 0, 6, 0, 0, 0, 72, 0, 0, 0, -80, -5, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 1, 0, 0, 0, 0, 0, 32, 0, 0, 0, -104, -5, 1, 0, 65, 76, 84, 69, 82, 32, 83, 89, 83, 84, 69, 77, 32, 75, 73, 76, 76, 32, 83, 69, 83, 83, 73, 79, 78, 32, 39, 67, 65, 70, 69, 39};
    protected int maxSendLen;
    protected int receiverRef;
    protected int senderRef;
    protected OutputStream outstream;
    protected InputStream instream;
    protected static int DEFAULT_TIMEOUT = 0;
    protected int socketTimeOut;
    protected boolean dbSession;
    protected PacketLayout packetLayout;
    protected int remoteSwapping;
    public static final int controlPacketSize_C = 16384;
    protected Socket socket;
    protected int m_serviceType;
    protected Tracer m_tracer;
    protected int m_MessageID = 0;
    protected long m_SessionID = -1L;
    protected int m_MajorDBVersion = 0;
    protected int m_MinorDBVersion = 0;

    protected BasicSocketComm(Location location, Properties properties, Tracer tracer) throws RTEException {
        super(location);
        this.m_tracer = tracer;
        String timeout = null;
        if (properties != null) {
            timeout = properties.getProperty("communicationtimeout");
        }
        if (timeout == null) {
            this.socketTimeOut = DEFAULT_TIMEOUT;
        } else {
            try {
                this.socketTimeOut = Integer.parseInt(timeout);
            }
            catch (NumberFormatException numberFormatEx) {
                this.socketTimeOut = DEFAULT_TIMEOUT;
            }
        }
    }

    private int getDefaultPort() {
        return 30015;
    }

    protected abstract void openSocket() throws RTEException;

    protected abstract boolean supportsInfoRequest();

    protected DbPacketLayout doInfoRequest(String dbroot, String pgm) throws RTEException {
        StructuredBytes rawRequest = BasicSocketComm.createInfoRequestPacket(1);
        rawRequest.putInt4(-1, 0);
        rawRequest.putInt1(4, 4);
        rawRequest.putInt2(20, 5);
        rawRequest.putInt1(4, 7);
        rawRequest.putInt2(1, 8);
        rawRequest.putInt1(0, 10);
        rawRequest.putInt1(1, 11);
        rawRequest.putInt1(1, 12);
        rawRequest.putInt1(1, 13);
        this.sendRawData(rawRequest, 14);
        this.receiveInfoRequest();
        return new DbPacketLayout();
    }

    protected static StructuredBytes createRawPacket(int dataSize) {
        return new FullswapMem(dataSize);
    }

    protected static StructuredBytes createInfoRequestPacket(int numberOfOptions) {
        return new StructuredBytes(12 + numberOfOptions * 2);
    }

    protected static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void connectDB() throws RTEException {
        Object layout = null;
        this.packetLayout = this.doInfoRequest(null, null);
        this.dbSession = true;
    }

    public String toString() {
        String result = super.toString() + " on " + this.socket;
        return result;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    protected void finalize() throws Throwable {
        if (this.socket != null) {
            this.release();
        }
        super.finalize();
    }

    protected void buildRTEHeader(StructuredBytes packet, int messClass) {
        packet.putInt8(this.m_SessionID, 0);
        packet.putInt4(this.m_MessageID++, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        try {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                Object var3_2 = null;
                this.socket = null;
            }
            Object var3_1 = null;
            this.socket = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.socket = null;
            throw throwable;
        }
    }

    public void sqlarequest(StructuredMem userPacket, int len) throws RTEException {
        this.request(userPacket, len);
    }

    public void sqlarelease() throws RTEException {
        this.release();
    }

    public StructuredMem sqlareceive() throws RTEException {
        return this.receive();
    }

    public void cancel() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "basicSocketComm", "cancel");
    }

    protected void sendData(StructuredBytes packet, int len) throws RTEException {
        if (this.m_tracer != null && this.m_tracer.isEnabled()) {
            this.m_tracer.printPacket("Request: ", packet.bytes(), len);
        }
        this.sendRawData(packet, len);
    }

    protected void sendRawData(StructuredBytes packet, int len) throws RTEException {
        OutputStream ostream;
        try {
            if (this.outstream == null) {
                this.outstream = this.socket.getOutputStream();
            }
            ostream = this.outstream;
        }
        catch (IOException ioExc1) {
            throw new RTEException("sendData: getOutputStream failed", RteC.CommunicationErrorCodeMap_C[7], this.m_tracer, 7);
        }
        try {
            ostream.write(packet.bytes(), 0, len);
        }
        catch (IOException ioExc2) {
            this.release();
            throw new RTEException(MessageTranslator.translate("error.send.write", ioExc2.getMessage()), RteC.CommunicationErrorCodeMap_C[7], this.m_tracer, 7);
        }
    }

    public void request(StructuredMem[] packetVec, int[] lengthVec) throws RTEException {
        OutputStream ostream;
        try {
            if (this.outstream == null) {
                this.outstream = this.socket.getOutputStream();
            }
            ostream = this.outstream;
        }
        catch (IOException ioExc1) {
            throw new RTEException("sendData: getOutputStream failed", RteC.CommunicationErrorCodeMap_C[7], this.m_tracer, 7);
        }
        try {
            for (int i = 0; i < packetVec.length; ++i) {
                StructuredBytes rawPacket = (StructuredBytes)packetVec[i].getPointer(0);
                ostream.write(rawPacket.bytes(), 0, lengthVec[i]);
            }
        }
        catch (IOException ioExc2) {
            this.release();
            throw new RTEException(MessageTranslator.translate("error.send.write", ioExc2.getMessage()), RteC.CommunicationErrorCodeMap_C[7], this.m_tracer, 7);
        }
    }

    public void request(StructuredMem userPacket, int len) throws RTEException {
        StructuredBytes rawPacket = (StructuredBytes)userPacket.getPointer(0);
        this.buildRTEHeader(rawPacket, 63);
        this.sendData(rawPacket, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        block5: {
            try {
                try {
                    this.socket.close();
                }
                catch (IOException ioexc) {
                    Object var3_2 = null;
                    this.socket = null;
                    break block5;
                }
                catch (NullPointerException nullPointerException) {
                    Object var3_3 = null;
                    this.socket = null;
                }
                Object var3_1 = null;
                this.socket = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.socket = null;
                throw throwable;
            }
        }
    }

    public void reconnectInner() throws RTEException {
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception ignore) {
            this.socket = null;
        }
        this.m_SessionID = -1L;
        this.openSocket();
        if (!this.dbSession) {
            throw new RTEException(MessageTranslator.translate("error.admin.reconnect"), RteC.CommunicationErrorCodeMap_C[3], this.m_tracer, 3);
        }
        this.connectDB();
    }

    protected StructuredMem receiveData() throws RTEException {
        boolean firstPacket = true;
        byte[] header = new byte[32];
        int dataLength = 0;
        int bytesRead = 0;
        byte[] readBuf = null;
        StructuredBytes replyHeader = null;
        StructuredBytes result = null;
        try {
            InputStream instream = this.instream;
            while (firstPacket || bytesRead < dataLength) {
                int chunkRead;
                int headerLength = instream.read(header, 0, 32);
                if (headerLength != 32) {
                    RTEException rteExc = new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
                    throw rteExc;
                }
                if (firstPacket) {
                    replyHeader = this.replyMem(header);
                    firstPacket = false;
                    this.m_SessionID = replyHeader.getInt8(0);
                    dataLength = replyHeader.getInt4(12);
                    readBuf = new byte[dataLength + 32];
                    System.arraycopy(header, 0, readBuf, 0, 32);
                    bytesRead = 32;
                    result = this.replyMem(readBuf);
                }
                for (int actSendLength = dataLength; actSendLength > 0; actSendLength -= chunkRead) {
                    try {
                        chunkRead = instream.read(readBuf, bytesRead, actSendLength);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayExc) {
                        throw new ArrayIndexOutOfBoundsException(MessageTranslator.translate("error.chunkoverflow", Integer.toString(actSendLength), Integer.toString(bytesRead), Integer.toString(readBuf.length)));
                    }
                    if (chunkRead < 0) {
                        throw new RTEException(MessageTranslator.translate("error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
                    }
                    bytesRead += chunkRead;
                }
            }
        }
        catch (IOException ioexc) {
            this.release();
            throw new RTEException(MessageTranslator.translate("error.data.receivefailed.reason", ioexc.getMessage()), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
        }
        if (this.m_tracer != null && this.m_tracer.isEnabled()) {
            this.m_tracer.printPacket("Receive: ", result.bytes(), bytesRead);
        }
        return result;
    }

    public StructuredMem receive() throws RTEException {
        return this.receiveData();
    }

    protected int lookupPort() {
        return this.m_location.getPortNumber();
    }

    public StructuredMem getRequestPacket(int size) throws RTEException {
        if (size <= 0) {
            RteSocketPacket result = new RteSocketPacket(this.packetLayout.maxCmdDataLength());
            return result;
        }
        RteSocketPacket result = new RteSocketPacket(size);
        return result;
    }

    protected StructuredBytes receiveInfoRequest() throws RTEException {
        StructuredBytes reply;
        byte[] connectReply = new byte[8];
        try {
            int replyLen = this.instream.read(connectReply, 0, 8);
            if (replyLen < 8) {
                throw new RTEException(MessageTranslator.translate("error.recv.connect"), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
            }
            reply = new StructuredBytes(connectReply);
            this.m_MajorDBVersion = reply.getInt1(0);
            this.m_MinorDBVersion = reply.getInt2(1);
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", ioexc.getMessage()), RteC.CommunicationErrorCodeMap_C[1], this.m_tracer, 1);
        }
        return reply;
    }

    protected StructuredBytes receiveConnect() throws RTEException {
        StructuredBytes reply;
        int expectedReplyLen = 8268;
        byte[] connectReply = new byte[expectedReplyLen];
        try {
            int nowreceived;
            int replyLen;
            if (replyLen < 33) {
                throw new RTEException(MessageTranslator.translate("error.recv.connect"), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
            }
            this.remoteSwapping = connectReply[33];
            reply = this.replyMem(connectReply);
            int fullReplyLen = reply.getInt4(0);
            if (fullReplyLen < 0 || fullReplyLen > 512000) {
                throw new RTEException(MessageTranslator.translate("error.connectreply.garbled"), RteC.CommunicationErrorCodeMap_C[8], this.m_tracer, 8);
            }
            for (replyLen = this.instream.read(connectReply, 0, expectedReplyLen); replyLen < fullReplyLen; replyLen += nowreceived) {
                nowreceived = this.instream.read(connectReply, replyLen, fullReplyLen - replyLen);
                if (nowreceived == -1) {
                    throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", "End of file before packet was read."), RteC.CommunicationErrorCodeMap_C[1], this.m_tracer, 1);
                }
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException irx) {
                    // empty catch block
                }
            }
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate("error.connect.receivefailed", ioexc.getMessage()), RteC.CommunicationErrorCodeMap_C[1], this.m_tracer, 1);
        }
        return reply;
    }

    protected StructuredBytes replyMem(byte[] buf) throws RTEException {
        FullswapMem result = new FullswapMem(buf);
        return result;
    }

    public int getKernelTaskID() {
        return this.senderRef;
    }

    protected int getInitialRequestType() {
        return 47;
    }

    protected boolean closeSocketAfterInfoRequest() {
        return true;
    }

    public long getSessionID() {
        return this.m_SessionID;
    }

    public int getMajorDBVersion() {
        return this.m_MajorDBVersion;
    }

    public int getMinorDBVersion() {
        return this.m_MinorDBVersion;
    }
}

