/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.StringUtil;
import com.sap.db.util.StructuredMem;
import com.sap.db.util.Traceable;
import com.sap.db.util.UnicodeUtil;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class StructuredBytes
implements StructuredMem,
Traceable {
    public static final String sapdbEncodingC = "ISO8859_1";
    public static final String sapdbCESUEncodingC = "UTF-8";
    protected byte[] data;
    protected int ptrOffs;
    protected int byteSize;
    protected static final byte blank_C = 32;
    public static final char[] hexDigits_C = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int fillBufSizeC = 1024;
    private static final int unicodeWidthC = 2;
    static byte[] zeroBytes = new byte[1024];
    static byte[] blankBytes = new byte[1024];
    static byte[] blankUnicodeBytes = new byte[2048];

    public StructuredBytes(byte[] data) {
        this.data = data;
        this.ptrOffs = 0;
        this.byteSize = data.length;
    }

    public StructuredBytes(byte[] data, int offset) {
        this.data = data;
        this.ptrOffs = offset;
        this.byteSize = data.length - this.ptrOffs;
    }

    public StructuredBytes(int size) {
        this.data = new byte[size];
        this.byteSize = size;
    }

    public byte[] bytes() {
        return this.data;
    }

    public byte[] getBytes(int offset, int len) {
        byte[] result = new byte[len];
        System.arraycopy(this.data, offset + this.ptrOffs, result, 0, len);
        return result;
    }

    public int[] getIntArray(int offset, int len) {
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.getUInt1(offset + i);
        }
        return result;
    }

    public byte getInt1(int offset) {
        return this.data[offset + this.ptrOffs];
    }

    public int getUInt1(int offset) {
        int result = this.data[offset + this.ptrOffs];
        if (result < 0) {
            result += 256;
        }
        return result;
    }

    public int getInt2(int offset) {
        int ofs = offset + this.ptrOffs;
        int lowerByte = this.data[ofs + 1];
        if (lowerByte < 0) {
            lowerByte += 256;
        }
        return this.data[ofs] * 256 + lowerByte;
    }

    public int getInt4(int offset) {
        byte[] d = this.data;
        int ofs = offset + this.ptrOffs;
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int oneByte = d[ofs + i];
            if (oneByte < 0) {
                oneByte += 256;
            }
            result = result * 256 + oneByte;
        }
        return result;
    }

    public StructuredMem getPointer(int offset) {
        return new StructuredBytes(this.data, this.ptrOffs + offset);
    }

    public String getString(int offset, int len) {
        try {
            return StringUtil.getStringFromCesu8(this.data, offset + this.ptrOffs, len);
        }
        catch (Exception e) {
            return new String(this.data, 0, offset + this.ptrOffs, len);
        }
    }

    public String getString(int offset, int len, int encoding) {
        try {
            switch (encoding) {
                case 0: {
                    return this.getString(offset, len);
                }
                case 1: {
                    return new String(this.data, offset + this.ptrOffs, len, "UTF-16BE");
                }
                case 2: {
                    return new String(this.data, offset + this.ptrOffs, len, sapdbCESUEncodingC);
                }
            }
            return this.getString(offset, len);
        }
        catch (UnsupportedEncodingException ex) {
            return this.getString(offset, len);
        }
    }

    public byte[] getStrippedBytes(int offset, int len) {
        while (len > 0 && this.data[offset + this.ptrOffs + len - 1] == 0) {
            --len;
        }
        return this.getBytes(offset, len);
    }

    public String getStrippedUnicodeString(int offset, int len) {
        while (len > 1 && this.data[offset + this.ptrOffs + len - 1] == 32 && this.data[offset + this.ptrOffs + len - 2] == 0) {
            len -= 2;
        }
        return new String(UnicodeUtil.bigUnicode2Chars(this.data, offset + this.ptrOffs, len));
    }

    public String getStrippedString(int offset, int len) {
        while (len > 0 && this.data[offset + this.ptrOffs + len - 1] == 32) {
            --len;
        }
        return this.getString(offset, len);
    }

    public char getBigUnicodeChar(int offset) {
        int low;
        int realOffset = this.ptrOffs + offset;
        int high = this.data[realOffset];
        if (high < 0) {
            high += 256;
        }
        if ((low = this.data[realOffset + 1]) < 0) {
            low += 256;
        }
        int result = (high << 8) + low;
        return (char)result;
    }

    public char getChar(int offset, int[] lengths) throws SQLException {
        char dstBuf;
        int realOffset = this.ptrOffs + offset;
        int byteLen = 0;
        if ((this.data[realOffset] & 0x80) == 0) {
            dstBuf = (char)this.data[realOffset];
            ++byteLen;
        } else if ((this.data[realOffset] & 0xE0) == 192) {
            this.assertThat((this.data[realOffset + 1] & 0xC0) == 128);
            dstBuf = (char)((short)((this.data[realOffset] & 0x1F) << 6) + (short)(this.data[realOffset + 1] & 0x3F));
            byteLen += 2;
        } else if ((this.data[realOffset] & 0xF0) == 224) {
            this.assertThat((this.data[realOffset + 1] & 0xC0) == 128);
            this.assertThat((this.data[realOffset + 2] & 0xC0) == 128);
            dstBuf = (char)((short)((this.data[realOffset] & 0xF) << 12) + (short)((this.data[realOffset + 1] & 0x3F) << 6) + (short)(this.data[realOffset + 2] & 0x3F));
            byteLen += 3;
        } else {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.cesu8");
        }
        this.moveBase(byteLen);
        lengths[0] = lengths[0] - byteLen;
        lengths[1] = lengths[1] - 1;
        return dstBuf;
    }

    public int getCharArray(char[] dstBuf, int dstPos, int offset, int[] lengths) throws SQLException {
        int charCnt;
        int srcPos = this.ptrOffs + offset;
        int byteCnt = 0;
        int charLength = lengths[1];
        int byteLength = lengths[0];
        for (charCnt = 0; charCnt < charLength && dstPos < dstBuf.length && byteCnt < byteLength; ++dstPos, ++charCnt) {
            if ((this.data[srcPos] & 0x80) == 0) {
                dstBuf[dstPos] = (char)this.data[srcPos];
                ++byteCnt;
                ++srcPos;
                continue;
            }
            if ((this.data[srcPos] & 0xE0) == 192) {
                this.assertThat((this.data[srcPos + 1] & 0xC0) == 128);
                dstBuf[dstPos] = (char)((short)((this.data[srcPos] & 0x1F) << 6) + (short)(this.data[srcPos + 1] & 0x3F));
                byteCnt += 2;
                srcPos += 2;
                continue;
            }
            if ((this.data[srcPos] & 0xF0) == 224) {
                this.assertThat((this.data[srcPos + 1] & 0xC0) == 128);
                this.assertThat((this.data[srcPos + 2] & 0xC0) == 128);
                dstBuf[dstPos] = (char)((short)((this.data[srcPos] & 0xF) << 12) + (short)((this.data[srcPos + 1] & 0x3F) << 6) + (short)(this.data[srcPos + 2] & 0x3F));
                byteCnt += 3;
                srcPos += 3;
                continue;
            }
            throw SQLExceptionSapDB.generateSQLException("error.invalid.cesu8");
        }
        this.moveBase(srcPos - (this.ptrOffs + offset));
        lengths[0] = lengths[0] - byteCnt;
        lengths[1] = lengths[1] - charCnt;
        return charCnt;
    }

    public int getAsciiBytes(byte[] dstBuf, int dstPos, int offset, int length) throws SQLException {
        int srcPos = this.ptrOffs + offset;
        for (int charCnt = 0; charCnt < length && dstPos < dstBuf.length; ++dstPos, ++charCnt) {
            int currChar;
            if ((this.data[srcPos] & 0x80) == 0) {
                currChar = this.data[srcPos];
                ++srcPos;
            } else if ((this.data[srcPos] & 0xE0) == 192) {
                this.assertThat((this.data[srcPos + 1] & 0xC0) == 128);
                currChar = (char)((short)((this.data[srcPos] & 0x1F) << 6) + (short)(this.data[srcPos + 1] & 0x3F));
                srcPos += 2;
            } else if ((this.data[srcPos] & 0xF0) == 224) {
                currChar = 63;
                srcPos += 3;
            } else {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.cesu8");
            }
            dstBuf[dstPos] = currChar <= 255 ? (int)currChar : 63;
        }
        this.moveBase(srcPos - (this.ptrOffs + offset));
        return dstPos;
    }

    public char[] getBigUnicode(int offset, int lenInBytes) {
        int realOffset = this.ptrOffs + offset;
        return UnicodeUtil.bigUnicode2Chars(this.data, realOffset, lenInBytes);
    }

    public void moveBase(int offset) {
        this.ptrOffs += offset;
        if (this.size() < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.byteSize -= offset;
    }

    public int putBytes(byte[] value, int offset) {
        int pos = offset + this.ptrOffs;
        int len = value.length;
        if (pos + len > this.data.length) {
            return -1;
        }
        System.arraycopy(value, 0, this.data, pos, len);
        return len;
    }

    private int putBytes(byte[] value, int offset, int len, byte[] filler) {
        int copyLen = value.length;
        int fillLen = 0;
        int pos = offset + this.ptrOffs;
        if (copyLen > len) {
            copyLen = len;
        } else if (copyLen < len) {
            fillLen = len - copyLen;
        }
        if (pos + copyLen + fillLen > this.data.length) {
            return -1;
        }
        System.arraycopy(value, 0, this.data, pos, copyLen);
        if (fillLen > 0) {
            this.fill(offset + copyLen, fillLen, filler);
        }
        return copyLen + fillLen;
    }

    public int putBytes(byte[] value, int offset, int len) {
        return this.putBytes(value, offset, len, zeroBytes);
    }

    public int putStringBytes(byte[] value, int offset, int len) {
        return this.putBytes(value, offset, len, blankBytes);
    }

    public int putUnicodeBytes(byte[] value, int offset, int len) {
        return this.putBytes(value, offset, len, blankUnicodeBytes);
    }

    public int putBigUnicode(char[] sBuf, int startOffset, int lenInChars) {
        int offset = startOffset + this.ptrOffs;
        for (int i = 0; i < lenInChars; ++i) {
            char code = sBuf[i];
            if (code < '\u0080') {
                this.data[offset++] = (byte)(code & 0x7F);
                continue;
            }
            if (code < '\u0800') {
                this.data[offset] = (byte)(code >>> 6 & 0x1F | 0xC0);
                this.data[offset + 1] = (byte)(code & 0x3F | 0x80);
                offset += 2;
                continue;
            }
            this.data[offset] = (byte)(code >>> 12 & 0xF | 0xE0);
            this.data[offset + 1] = (byte)(code >>> 6 & 0x3F | 0x80);
            this.data[offset + 2] = (byte)(code & 0x3F | 0xFFFFFF80);
            offset += 3;
        }
        return offset - (startOffset + this.ptrOffs);
    }

    public int putInt1(int value, int offset) {
        int pos = offset + this.ptrOffs;
        if (this.data.length < pos + 1) {
            return -1;
        }
        this.data[pos] = (byte)value;
        return 1;
    }

    public int putInt2(int value, int offset) {
        int ofs = offset + this.ptrOffs;
        if (this.data.length < ofs + 2) {
            return -1;
        }
        byte[] d = this.data;
        if (value == 0) {
            d[ofs + 1] = 0;
            d[ofs] = 0;
            return 2;
        }
        d[ofs] = (byte)(value >> 8 & 0xFF);
        d[ofs + 1] = (byte)(value & 0xFF);
        return 2;
    }

    public int putInt4(int value, int offset) {
        int ofs = offset + this.ptrOffs;
        if (this.data.length < ofs + 4) {
            return -1;
        }
        byte[] d = this.data;
        if (value == 0) {
            d[ofs + 3] = 0;
            d[ofs + 2] = 0;
            d[ofs + 1] = 0;
            d[ofs] = 0;
            return 4;
        }
        for (int i = 3; i >= 0; --i) {
            d[ofs + i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        return 4;
    }

    public int putInt8(long value, int offset) {
        int ofs = offset + this.ptrOffs;
        if (this.data.length < ofs + 8) {
            return -1;
        }
        byte[] d = this.data;
        if (value == 0L) {
            d[ofs + 7] = 0;
            d[ofs + 6] = 0;
            d[ofs + 5] = 0;
            d[ofs + 4] = 0;
            d[ofs + 3] = 0;
            d[ofs + 2] = 0;
            d[ofs + 1] = 0;
            d[ofs] = 0;
            return 8;
        }
        for (int i = 7; i >= 0; --i) {
            d[ofs + i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return 8;
    }

    public int putString(String value, int offset) throws SQLException {
        int ofs = offset + this.ptrOffs;
        return StringUtil.bytes_cesu8(value, this.data, ofs);
    }

    public int putStringNTS(String value, int offset) throws SQLException {
        int ofs = offset + this.ptrOffs;
        int len = StringUtil.bytes_cesu8(value, this.data, ofs);
        if (len == -1) {
            return -1;
        }
        this.data[ofs + len] = 0;
        return ++len;
    }

    public int putString(String value, int offset, int len) {
        int ofs = offset + this.ptrOffs;
        char[] ca = value.toCharArray();
        int strlen = ca.length;
        if (this.data.length < ofs + strlen) {
            return -1;
        }
        if (strlen >= len) {
            for (int i = 0; i < len; ++i) {
                char c = ca[i];
                this.data[ofs + i] = c <= '\u00ff' ? (int)c : 63;
            }
        } else {
            for (int i = 0; i < strlen; ++i) {
                char c = ca[i];
                this.data[ofs + i] = c <= '\u00ff' ? (int)c : 63;
            }
            this.fill(offset + strlen, len - strlen, blankBytes);
        }
        return len;
    }

    public int size() {
        return this.data.length - this.ptrOffs;
    }

    private void fill(int offset, int len, byte[] filler) {
        while (len > 0) {
            int chunkLen = Math.min(len, 1024);
            System.arraycopy(filler, 0, this.data, offset + this.ptrOffs, chunkLen);
            len -= chunkLen;
            offset += chunkLen;
        }
    }

    public void traceOn(PrintStream outstream) {
        this.traceOn(outstream, 0, this.byteSize);
    }

    public void traceOn(PrintStream outstream, int maxBuf) {
        this.traceOn(outstream, 0, maxBuf);
    }

    public void traceOn(PrintStream outstream, int from, int to) {
        outstream.print(StringUtil.hexDump(this.data, from + this.ptrOffs, to + this.ptrOffs));
    }

    public static byte[] getInt4Const(int value) {
        byte[] int4bytes = new byte[4];
        for (int i = 3; i >= 0; --i) {
            byte oneByte;
            int4bytes[i] = oneByte = (byte)(value & 0xFF);
            value >>= 8;
        }
        return int4bytes;
    }

    public long getInt8(int offset) {
        byte[] d = this.data;
        int ofs = offset + this.ptrOffs;
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            int oneByte = d[ofs + i];
            if (oneByte < 0) {
                oneByte += 256;
            }
            result = result * 256L + (long)oneByte;
        }
        return result;
    }

    public void getBytes(byte[] result, int offset, int len) {
        System.arraycopy(this.data, offset + this.ptrOffs, result, 0, len);
    }

    public int getPtrOffs() {
        return this.ptrOffs;
    }

    public void resize() {
        byte[] newData = new byte[this.data.length * 2];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
        this.byteSize = this.data.length - this.ptrOffs;
    }

    private void assertThat(boolean assertion) throws SQLException {
        if (!assertion) {
            throw new SQLException();
        }
    }

    static {
        for (int i = 0; i < 1024; i += 2) {
            StructuredBytes.zeroBytes[i + 1] = 0;
            StructuredBytes.zeroBytes[i] = 0;
            StructuredBytes.blankBytes[i + 1] = 32;
            StructuredBytes.blankBytes[i] = 32;
            StructuredBytes.blankUnicodeBytes[i] = 0;
            StructuredBytes.blankUnicodeBytes[i + 1] = 32;
        }
    }
}

