/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.jdbc.Driver;
import com.sap.db.util.TraceConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TraceTool
extends JFrame {
    private TraceConfiguration settings;
    private JPanel jPanelConfiguration = null;
    private JPanel jPanelSettings = null;
    private JPanel jPanelButtons = null;
    private JButton jButtonOkay = null;
    private JButton jButtonCancel = null;
    private JButton jButtonApply = null;
    private JLabel jLabelTraceEnabled = null;
    private JLabel jLabelTracefileFolder = null;
    private JLabel jLabelTracefileName = null;
    private JLabel jLabelTracefileSize = null;
    private JLabel jLabelStopOnError = null;
    private JCheckBox jCheckBoxTraceEnabled = null;
    private JTextField jTextFieldTracefileFolder = null;
    private JTextField jTextFieldTracefileName = null;
    private JTextField jTextFieldTracefileSize = null;
    private JTextField jTextFieldStopOnError = null;
    private JButton jButtonChooseDirectory = null;
    private JComboBox jComboBoxTracefileSize = null;
    private JButton jButtonChooseTraceFile = null;
    private JCheckBox jCheckBoxLimitFileSize = null;
    private JCheckBox jCheckBoxStopOnError = null;
    private JLabel jLabelShmPath = null;
    private JLabel jLabelShmFileName = null;

    private void setTracefileSize(long len) {
        if (len != 0L && len % 1024L == 0L) {
            len /= 1024L;
            this.getJComboBoxTracefileSize().setSelectedItem("KB");
        }
        if (len != 0L && len % 1024L == 0L) {
            len /= 1024L;
            this.getJComboBoxTracefileSize().setSelectedItem("MB");
        }
        if (len != 0L && len % 1024L == 0L) {
            len /= 1024L;
            this.getJComboBoxTracefileSize().setSelectedItem("GB");
        }
        this.getJTextFieldTracefileSize().setText(String.valueOf(len));
    }

    private void getTracefilePath() {
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
        fileChooser.setFileSelectionMode(1);
        if (0 == fileChooser.showDialog(null, "Choose Trace Folder")) {
            File res = fileChooser.getSelectedFile();
            if (!res.isDirectory()) {
                this.logError("\"" + res.getPath() + "\" is not a valid directory.");
            }
            this.getJTextFieldTracefileFolder().setText(res.getPath());
        }
    }

    private void displayTraceSettings() {
        this.getJCheckBoxTraceEnabled().setSelected(this.settings.isTraceOn());
        this.getJTextFieldTracefileFolder().setText(this.settings.getTraceFolder());
        this.getJTextFieldTracefileName().setText(this.settings.getTraceFileName());
        if (this.settings.getTraceSize() == Long.MAX_VALUE) {
            this.getJCheckBoxLimitFileSize().setSelected(false);
        } else {
            this.getJCheckBoxLimitFileSize().setSelected(true);
            this.setTracefileSize(this.settings.getTraceSize());
        }
        if (this.settings.getStopOnError() == 0) {
            this.getJCheckBoxStopOnError().setSelected(false);
        } else {
            this.getJCheckBoxStopOnError().setSelected(true);
            this.getJTextFieldStopOnError().setText(String.valueOf(this.settings.getStopOnError()));
        }
        this.JCheckBoxTraceEnabled_actionPerformed();
        this.jLabelShmFileName.setText(this.settings.getSharedMemoryName());
    }

    private boolean saveTraceSettings() {
        this.settings.setTraceOn(this.getJCheckBoxTraceEnabled().isSelected());
        String folder = this.getJTextFieldTracefileFolder().getText();
        if (!new File(folder).isDirectory()) {
            this.logError("\"" + folder + "\" is not a valid directory.");
            return false;
        }
        this.settings.setTraceFolder(folder);
        this.settings.setTraceFileName(this.getJTextFieldTracefileName().getText());
        if (this.getJCheckBoxLimitFileSize().isSelected()) {
            this.settings.setTraceSize(Long.parseLong(this.getJTextFieldTracefileSize().getText()), (String)this.getJComboBoxTracefileSize().getSelectedItem());
        } else {
            this.settings.setTraceSize(Long.MAX_VALUE, "");
        }
        if (this.getJCheckBoxStopOnError().isSelected()) {
            this.settings.setStopOnError(Integer.parseInt(this.getJTextFieldStopOnError().getText()));
        } else {
            this.settings.setStopOnError(0);
        }
        try {
            this.settings.saveTraceSettings();
        }
        catch (FileNotFoundException ex) {
            this.logError(ex);
        }
        catch (IOException ex) {
            this.logError(ex);
        }
        this.settings.setTraceSettingsChangeFlag();
        return true;
    }

    public TraceTool() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(418, 269));
        this.setContentPane(this.getJPanel());
        this.setTitle("NGDB JDBC Trace  " + Driver.getStaticShortVersion());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TraceTool.this.this_windowClosing(e);
            }
        });
        this.settings = new TraceConfiguration();
        this.pack();
        this.setVisible(true);
        this.displayTraceSettings();
    }

    void this_windowClosing(WindowEvent e) {
        System.exit(0);
    }

    private void logError(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        this.logError(sw.toString());
    }

    private void logError(String error) {
        JOptionPane.showMessageDialog(this, error, "Error", 0);
    }

    private JPanel getJPanel() {
        if (this.jPanelConfiguration == null) {
            this.jPanelConfiguration = new JPanel();
            this.jPanelConfiguration.setLayout(new BorderLayout());
            this.jPanelConfiguration.setName("Configuration");
            this.jPanelConfiguration.setBorder(BorderFactory.createTitledBorder(null, "Configuration", 0, 0, null, null));
            this.jPanelConfiguration.setPreferredSize(new Dimension(418, 269));
            this.jPanelConfiguration.add((Component)this.getJPanelSettings(), "Center");
            this.jPanelConfiguration.add((Component)this.getJPanelButtons(), "South");
        }
        return this.jPanelConfiguration;
    }

    private JPanel getJPanelSettings() {
        if (this.jPanelSettings == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.gridwidth = 3;
            gridBagConstraints22.weightx = 0.0;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.gridy = 5;
            this.jLabelShmFileName = new JLabel();
            this.jLabelShmFileName.setText("");
            this.jLabelShmFileName.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints13.gridy = 5;
            this.jLabelShmPath = new JLabel();
            this.jLabelShmPath.setText("Sync file name");
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 1;
            gridBagConstraints31.gridy = 4;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.gridy = 3;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 3;
            gridBagConstraints12.weightx = 0.0;
            gridBagConstraints12.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.gridy = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 3;
            gridBagConstraints11.weightx = 0.0;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints11.gridwidth = 1;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridx = 3;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 3;
            gridBagConstraints10.weightx = 0.0;
            gridBagConstraints10.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.gridy = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 4;
            gridBagConstraints9.weightx = 0.0;
            gridBagConstraints9.weighty = 0.0;
            gridBagConstraints9.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints9.gridx = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 3;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.weighty = 0.0;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints8.gridx = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.weightx = 0.0;
            gridBagConstraints7.weighty = 0.0;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 2.0;
            gridBagConstraints6.weighty = 0.0;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.weighty = 0.0;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridy = 4;
            this.jLabelStopOnError = new JLabel();
            this.jLabelStopOnError.setText("Stop on error");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.gridy = 3;
            this.jLabelTracefileSize = new JLabel();
            this.jLabelTracefileSize.setText("Limit file size");
            this.jLabelTracefileSize.setHorizontalTextPosition(10);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.gridy = 2;
            this.jLabelTracefileName = new JLabel();
            this.jLabelTracefileName.setText("Trace file name");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.gridy = 1;
            this.jLabelTracefileFolder = new JLabel();
            this.jLabelTracefileFolder.setText("Trace file folder");
            this.jLabelTracefileFolder.setHorizontalTextPosition(2);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            this.jLabelTraceEnabled = new JLabel();
            this.jLabelTraceEnabled.setText("Trace enabled");
            this.jLabelTraceEnabled.setHorizontalTextPosition(10);
            this.jPanelSettings = new JPanel();
            this.jPanelSettings.setLayout(new GridBagLayout());
            this.jPanelSettings.setPreferredSize(new Dimension(418, 269));
            this.jPanelSettings.add((Component)this.jLabelTraceEnabled, gridBagConstraints);
            this.jPanelSettings.add((Component)this.jLabelTracefileFolder, gridBagConstraints1);
            this.jPanelSettings.add((Component)this.jLabelTracefileName, gridBagConstraints2);
            this.jPanelSettings.add((Component)this.jLabelTracefileSize, gridBagConstraints3);
            this.jPanelSettings.add((Component)this.jLabelStopOnError, gridBagConstraints4);
            this.jPanelSettings.add((Component)this.getJCheckBoxTraceEnabled(), gridBagConstraints5);
            this.jPanelSettings.add((Component)this.getJTextFieldTracefileFolder(), gridBagConstraints6);
            this.jPanelSettings.add((Component)this.getJTextFieldTracefileName(), gridBagConstraints7);
            this.jPanelSettings.add((Component)this.getJTextFieldTracefileSize(), gridBagConstraints8);
            this.jPanelSettings.add((Component)this.getJTextFieldStopOnError(), gridBagConstraints9);
            this.jPanelSettings.add((Component)this.getJButtonChooseDirectory(), gridBagConstraints10);
            this.jPanelSettings.add((Component)this.getJComboBoxTracefileSize(), gridBagConstraints11);
            this.jPanelSettings.add((Component)this.getJButtonChooseTraceFile(), gridBagConstraints12);
            this.jPanelSettings.add((Component)this.getJCheckBoxLimitFileSize(), gridBagConstraints21);
            this.jPanelSettings.add((Component)this.getJCheckBoxStopOnError(), gridBagConstraints31);
            this.jPanelSettings.add((Component)this.jLabelShmPath, gridBagConstraints13);
            this.jPanelSettings.add((Component)this.jLabelShmFileName, gridBagConstraints22);
        }
        return this.jPanelSettings;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            gridLayout.setHgap(5);
            gridLayout.setVgap(5);
            gridLayout.setColumns(3);
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(gridLayout);
            this.jPanelButtons.setPreferredSize(new Dimension(10, 25));
            this.jPanelButtons.add((Component)this.getJButtonOkay(), null);
            this.jPanelButtons.add((Component)this.getJButtonCancel(), null);
            this.jPanelButtons.add((Component)this.getJButtonApply(), null);
        }
        return this.jPanelButtons;
    }

    private JButton getJButtonOkay() {
        if (this.jButtonOkay == null) {
            this.jButtonOkay = new JButton();
            this.jButtonOkay.setText("OK");
            this.jButtonOkay.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TraceTool.this.JButtonOkayactionPerformed(e);
                }
            });
        }
        return this.jButtonOkay;
    }

    private void JButtonOkayactionPerformed(ActionEvent e) {
        if (this.saveTraceSettings()) {
            System.exit(0);
        }
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TraceTool.this.JButtonCancel_actionPerformed(e);
                }
            });
        }
        return this.jButtonCancel;
    }

    private void JButtonCancel_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    private JButton getJButtonApply() {
        if (this.jButtonApply == null) {
            this.jButtonApply = new JButton();
            this.jButtonApply.setText("Apply");
            this.jButtonApply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TraceTool.this.JButtonApply_actionPerformed(e);
                }
            });
        }
        return this.jButtonApply;
    }

    private void JButtonApply_actionPerformed(ActionEvent e) {
        this.saveTraceSettings();
    }

    private JCheckBox getJCheckBoxTraceEnabled() {
        if (this.jCheckBoxTraceEnabled == null) {
            this.jCheckBoxTraceEnabled = new JCheckBox();
            this.jCheckBoxTraceEnabled.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TraceTool.this.JCheckBoxTraceEnabled_actionPerformed();
                }
            });
        }
        return this.jCheckBoxTraceEnabled;
    }

    private void JCheckBoxTraceEnabled_actionPerformed() {
        if (this.getJCheckBoxTraceEnabled().isSelected()) {
            this.getJTextFieldTracefileFolder().setEnabled(true);
            this.getJButtonChooseDirectory().setEnabled(true);
            this.getJButtonChooseTraceFile().setEnabled(true);
            this.getJTextFieldTracefileName().setEnabled(true);
            this.getJCheckBoxLimitFileSize().setEnabled(true);
            this.getJCheckBoxStopOnError().setEnabled(true);
        } else {
            this.getJTextFieldTracefileFolder().setEnabled(false);
            this.getJButtonChooseDirectory().setEnabled(false);
            this.getJButtonChooseTraceFile().setEnabled(false);
            this.getJTextFieldTracefileName().setEnabled(false);
            this.getJCheckBoxLimitFileSize().setEnabled(false);
            this.getJCheckBoxStopOnError().setEnabled(false);
        }
        this.getJCheckBoxStopOnError_actionPerformed();
        this.getJCheckBoxLimitFileSize_actionPerformed();
    }

    private JTextField getJTextFieldTracefileFolder() {
        if (this.jTextFieldTracefileFolder == null) {
            this.jTextFieldTracefileFolder = new JTextField();
            this.jTextFieldTracefileFolder.setHorizontalAlignment(2);
        }
        return this.jTextFieldTracefileFolder;
    }

    private JTextField getJTextFieldTracefileName() {
        if (this.jTextFieldTracefileName == null) {
            this.jTextFieldTracefileName = new JTextField();
            this.jTextFieldTracefileName.setHorizontalAlignment(2);
        }
        return this.jTextFieldTracefileName;
    }

    private JTextField getJTextFieldTracefileSize() {
        if (this.jTextFieldTracefileSize == null) {
            this.jTextFieldTracefileSize = new JTextField();
            this.jTextFieldTracefileSize.setHorizontalAlignment(2);
        }
        return this.jTextFieldTracefileSize;
    }

    private JTextField getJTextFieldStopOnError() {
        if (this.jTextFieldStopOnError == null) {
            this.jTextFieldStopOnError = new JTextField();
            this.jTextFieldStopOnError.setHorizontalAlignment(2);
        }
        return this.jTextFieldStopOnError;
    }

    private JButton getJButtonChooseDirectory() {
        if (this.jButtonChooseDirectory == null) {
            this.jButtonChooseDirectory = new JButton();
            this.jButtonChooseDirectory.setPreferredSize(new Dimension(34, 20));
            this.jButtonChooseDirectory.setIcon(new ImageIcon(this.getClass().getResource("/com/sap/db/util/tracefolder.gif")));
            this.jButtonChooseDirectory.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TraceTool.this.getTracefilePath();
                }
            });
        }
        return this.jButtonChooseDirectory;
    }

    private JComboBox getJComboBoxTracefileSize() {
        if (this.jComboBoxTracefileSize == null) {
            this.jComboBoxTracefileSize = new JComboBox<String>(new String[]{"KB", "MB", "GB"});
            this.jComboBoxTracefileSize.setPreferredSize(new Dimension(30, 20));
            this.jComboBoxTracefileSize.setMaximumRowCount(3);
        }
        return this.jComboBoxTracefileSize;
    }

    private JButton getJButtonChooseTraceFile() {
        if (this.jButtonChooseTraceFile == null) {
            this.jButtonChooseTraceFile = new JButton();
            this.jButtonChooseTraceFile.setText("");
            this.jButtonChooseTraceFile.setIcon(new ImageIcon(this.getClass().getResource("/com/sap/db/util/tracefile.gif")));
            this.jButtonChooseTraceFile.setPreferredSize(new Dimension(34, 20));
            this.jButtonChooseTraceFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TraceTool.this.getTracefileName();
                }
            });
        }
        return this.jButtonChooseTraceFile;
    }

    private void getTracefileName() {
        JFileChooser fileChooser = new JFileChooser(this.getJTextFieldTracefileFolder().getText());
        if (0 == fileChooser.showDialog(null, "Choose Trace File")) {
            File res = fileChooser.getSelectedFile();
            this.getJTextFieldTracefileName().setText(res.getName());
        }
    }

    private JCheckBox getJCheckBoxLimitFileSize() {
        if (this.jCheckBoxLimitFileSize == null) {
            this.jCheckBoxLimitFileSize = new JCheckBox();
            this.jCheckBoxLimitFileSize.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TraceTool.this.getJCheckBoxLimitFileSize_actionPerformed();
                }
            });
        }
        return this.jCheckBoxLimitFileSize;
    }

    private void getJCheckBoxLimitFileSize_actionPerformed() {
        JCheckBox jcb = this.getJCheckBoxLimitFileSize();
        if (jcb.isSelected() && jcb.isEnabled()) {
            this.getJTextFieldTracefileSize().setEnabled(true);
            this.getJComboBoxTracefileSize().setEnabled(true);
        } else {
            this.getJTextFieldTracefileSize().setEnabled(false);
            this.getJComboBoxTracefileSize().setEnabled(false);
        }
    }

    private void getJCheckBoxStopOnError_actionPerformed() {
        JCheckBox jcb = this.getJCheckBoxStopOnError();
        if (jcb.isSelected() && jcb.isEnabled()) {
            this.getJTextFieldStopOnError().setEnabled(true);
        } else {
            this.getJTextFieldStopOnError().setEnabled(false);
        }
    }

    private JCheckBox getJCheckBoxStopOnError() {
        if (this.jCheckBoxStopOnError == null) {
            this.jCheckBoxStopOnError = new JCheckBox();
            this.jCheckBoxStopOnError.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TraceTool.this.getJCheckBoxStopOnError_actionPerformed();
                }
            });
        }
        return this.jCheckBoxStopOnError;
    }

    public static void main(String[] args) {
        new TraceTool();
    }
}

