/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.BasicSession;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.ConnectionSapDBFinalize;
import com.sap.db.jdbc.Host;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.SecureSession;
import com.sap.db.jdbc.SecureStore;
import com.sap.db.jdbc.SecureStoreLoginInformation;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.Topology;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.DistributionMode;
import com.sap.db.jdbc.trace.TraceConfiguration;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.TraceTool;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.DriverVersionInfo;
import com.sap.db.util.MessageTranslator;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@ThreadSafe
public class Driver
implements java.sql.Driver {
    public static final Driver INSTANCE;
    private static final String COMPUTER_NAME;
    private static final String FULL_COMPUTER_NAME;
    private static final int JAVA_VERSION;
    private static final int PROCESS_ID;
    @GuardedBy(value="itself")
    private static final Set<ConnectionSapDB> CONNECTIONS;
    private static final String DATABASE_NAME = "HDB";
    private static final String DRIVER_NAME = "HDB";
    private static final DriverVersionInfo VERSION_INFO;
    private static final Tracer TRACER;
    private static final String PROTOCOL_NAME = "jdbc:sap:";
    private static final int PROTOCOL_NAME_LENGTH;
    private static final int DEFAULT_DB_BASE_PORT = 30015;
    private static final int DEFAULT_SYSTEM_DB_BASE_PORT = 30013;
    private static final String OBFUSCATED_PSWD_STRING = "***";
    public static final TraceControl pptracer;
    @GuardedBy(value="Driver.class")
    private static Class _nativeAuthenticationClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean isHeadless = GraphicsEnvironment.isHeadless();
        int argCount = args.length;
        if (argCount == 0) {
            Driver._showTraceSettings(isHeadless);
            return;
        }
        String arg = args[0];
        if (arg.equals("-h") || arg.equals("--help") || arg.equalsIgnoreCase("HELP")) {
            Driver._printUsage(null);
        } else if (arg.equalsIgnoreCase("-v") || arg.equals("--version") || arg.equalsIgnoreCase("VERSION")) {
            System.out.println(VERSION_INFO.toString());
        } else if (arg.equals("-g") || arg.equals("--gui") || arg.equalsIgnoreCase("GUI")) {
            if (isHeadless) {
                System.err.println("GUI not available.");
            }
            Driver._showTraceSettings(isHeadless);
        } else if (arg.equalsIgnoreCase("SHOW")) {
            Driver._showTraceSettings(true);
        } else if (arg.equalsIgnoreCase("TRACE")) {
            if (argCount < 2) {
                Driver._printUsage("Invalid command, missing argument.");
            }
            TraceConfiguration settings = new TraceConfiguration();
            arg = args[1];
            if (arg.equalsIgnoreCase("ON")) {
                settings.setTraceEnabled(true);
            } else if (arg.equalsIgnoreCase("OFF")) {
                settings.setTraceEnabled(false);
            } else if (arg.equalsIgnoreCase("FILENAME")) {
                if (argCount < 3) {
                    Driver._printUsage("Invalid command, missing argument.");
                }
                settings.setTraceFileName(args[2]);
            } else if (arg.equalsIgnoreCase("API")) {
                if (argCount < 3) {
                    Driver._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(0, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(0, false);
                } else {
                    Driver._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("PACKET")) {
                if (argCount < 3) {
                    Driver._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(1, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(1, false);
                } else {
                    Driver._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("DISTRIBUTION")) {
                if (argCount < 3) {
                    Driver._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(2, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(2, false);
                } else {
                    Driver._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("STATISTICS")) {
                if (argCount < 3) {
                    Driver._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(3, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(3, false);
                } else {
                    Driver._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("SIZE")) {
                if (argCount < 3) {
                    Driver._printUsage("Invalid command, missing argument.");
                }
                long fileSize = Long.MAX_VALUE;
                String units = "";
                arg = args[2];
                if (!arg.equalsIgnoreCase("UNLIMITED")) {
                    int i;
                    StringBuilder builder = new StringBuilder();
                    for (i = 2; i < argCount; ++i) {
                        builder.append(args[i].toUpperCase(Locale.ENGLISH));
                    }
                    String size = builder.toString();
                    int n = size.length();
                    for (i = 0; i < n; ++i) {
                        if (!Character.isDigit(size.charAt(i))) {
                            if (i == 0) {
                                Driver._printUsage("Invalid command, invalid size:", args, 2);
                                break;
                            }
                            fileSize = Long.parseLong(size.substring(0, i));
                            switch (size.charAt(i)) {
                                case 'K': {
                                    units = TraceConfiguration.SizeUnits.KILOBYTES.getDisplayString();
                                    break;
                                }
                                case 'M': {
                                    units = TraceConfiguration.SizeUnits.MEGABYTES.getDisplayString();
                                    break;
                                }
                                case 'G': {
                                    units = TraceConfiguration.SizeUnits.GIGABYTES.getDisplayString();
                                    break;
                                }
                                default: {
                                    Driver._printUsage("Invalid command, invalid size:", args, 2);
                                    break;
                                }
                            }
                            break;
                        }
                        if (i + 1 != n) continue;
                        fileSize = Long.parseLong(size);
                    }
                }
                settings.setTraceSize(fileSize, units);
            } else if (arg.equalsIgnoreCase("STOP")) {
                if (argCount < 4 || !args[2].equalsIgnoreCase("ON") || !args[3].equalsIgnoreCase("ERROR")) {
                    Driver._printUsage("Invalid command:", args, 0);
                }
                if (argCount < 5) {
                    Driver._printUsage("Invalid command, missing argument.");
                }
                int errorNum = 0;
                arg = args[4];
                if (!arg.equalsIgnoreCase("OFF")) {
                    try {
                        errorNum = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException e) {
                        Driver._printUsage("Invalid command, invalid error number:" + arg);
                    }
                }
                settings.setStopOnError(errorNum);
            } else {
                Driver._printUsage("Invalid command:", args, 0);
            }
            try {
                settings.saveTraceSettings();
            }
            catch (IOException e) {
                System.err.println("Can't save trace settings: " + e.getMessage());
            }
            settings.setTraceSettingsChanged();
            settings.printTraceSettings();
        } else if (arg.equalsIgnoreCase("PERFORMANCETRACE")) {
            if (argCount < 2) {
                Driver._printUsage("Invalid command, missing argument.");
            }
            TraceConfiguration settings = new TraceConfiguration();
            arg = args[1];
            if (arg.equalsIgnoreCase("ON")) {
                settings.setPerformanceTraceEnabled(true);
            } else if (arg.equalsIgnoreCase("OFF")) {
                settings.setPerformanceTraceEnabled(false);
            } else if (arg.equalsIgnoreCase("FILENAME")) {
                if (argCount < 3) {
                    Driver._printUsage("Invalid command, missing argument.");
                }
                settings.setPerformanceTraceFileName(args[2]);
            } else {
                Driver._printUsage("Invalid command:", args, 0);
            }
            try {
                settings.saveTraceSettings();
            }
            catch (IOException e) {
                System.err.println("Can't save trace settings: " + e.getMessage());
            }
            settings.setTraceSettingsChanged();
            settings.printTraceSettings();
        } else if (arg.equals("-u")) {
            int idx;
            if (argCount < 2) {
                Driver._printUsage("Missing username and password.");
            }
            if ((idx = (arg = args[1]).indexOf(44)) == -1 || idx == 0 || idx == arg.length() - 1) {
                Driver._printUsage("Invalid username and password:", arg);
            }
            String hostAndPort = "localhost:30015";
            String command = "SELECT CURRENT_TIMESTAMP FROM DUMMY";
            Properties info = new Properties();
            Connection connection = null;
            Statement statement = null;
            info.setProperty(ConnectionProperty.USER.getName(), arg.substring(0, idx));
            info.setProperty(ConnectionProperty.PASSWD.getName(), arg.substring(idx + 1));
            for (int i = 2; i < argCount; ++i) {
                arg = args[i];
                if (arg.equals("-n")) {
                    if (i == argCount - 1) {
                        Driver._printUsage("Missing host name.");
                    }
                    hostAndPort = args[++i];
                    continue;
                }
                if (arg.equals("-d")) {
                    if (i == argCount - 1) {
                        Driver._printUsage("Missing database name.");
                    }
                    info.setProperty(ConnectionProperty.DATABASE_NAME.getName(), args[++i]);
                    continue;
                }
                if (arg.equals("-i")) {
                    if (i == argCount - 1) {
                        Driver._printUsage("Missing instance number.");
                    }
                    info.setProperty(ConnectionProperty.INSTANCE_NUMBER.getName(), args[++i]);
                    continue;
                }
                if (arg.equals("-o")) {
                    if (i == argCount - 1) {
                        Driver._printUsage("Missing option name and value.");
                    }
                    if ((idx = (arg = args[++i]).indexOf(61)) == -1 || idx == 0 || idx == arg.length() - 1) {
                        Driver._printUsage("Invalid option name and value:", arg);
                    }
                    info.setProperty(arg.substring(0, idx), arg.substring(idx + 1));
                    continue;
                }
                if (arg.equals("-c")) {
                    if (i == argCount - 1) {
                        Driver._printUsage("Missing SQL command.");
                    }
                    command = args[++i];
                    continue;
                }
                Driver._printUsage("Invalid argument:", arg);
            }
            try {
                connection = Driver._connect(Driver.buildURL(hostAndPort, new ConnectionProperties(info)), info);
                System.out.println("Connected.");
                statement = connection.createStatement();
                if (statement.execute(command)) {
                    Driver.printResultSet(System.out, statement.getResultSet());
                }
                System.out.println(statement.getUpdateCount() + " row(s) affected");
            }
            catch (SQLException e) {
                System.err.println("SQLException: " + e.getMessage());
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        } else {
            Driver._printUsage("Invalid argument:", arg);
        }
    }

    public static int getAnchorConnectionID(Connection connection) {
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB == null || connectionSapDB._isClosed()) {
            return -1;
        }
        Session anchorSession = connectionSapDB.getSessionPool().getAnchorSession();
        if (anchorSession == null) {
            return -1;
        }
        return anchorSession.getConnectionID();
    }

    public static int getPrimaryConnectionID(Connection connection) {
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB == null || connectionSapDB._isClosed()) {
            return -1;
        }
        Session primarySession = connectionSapDB.getSessionPool().getPrimarySession();
        if (primarySession == null) {
            return -1;
        }
        return primarySession.getConnectionID();
    }

    public static boolean isEmptyDate(Date date) {
        return date != null && date.getTime() == AbstractConverter.getEmptyDayDateMilliseconds();
    }

    public static boolean isEmptyTime(Time time) {
        return time != null && time.getTime() == AbstractConverter.getEmptySecondTimeMilliseconds();
    }

    public static boolean isEmptyTimestamp(Timestamp timestamp) {
        return timestamp != null && (timestamp.getTime() == AbstractConverter.getEmptySecondDateMilliseconds() || timestamp.getTime() == AbstractConverter.getEmptyLongDateMilliseconds() && timestamp.getNanos() == AbstractConverter.getEmptyLongDateNanoseconds());
    }

    public static Driver getInstance() {
        return INSTANCE;
    }

    public static Driver singleton() {
        return INSTANCE;
    }

    public static String getComputerName() {
        return COMPUTER_NAME;
    }

    public static String getFullComputerName() {
        return FULL_COMPUTER_NAME;
    }

    public static int getJavaVersion() {
        return JAVA_VERSION;
    }

    public static int getProcessID() {
        return PROCESS_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ConnectionSapDB> getConnections() {
        Set<ConnectionSapDB> set = CONNECTIONS;
        synchronized (set) {
            return new HashSet<ConnectionSapDB>(CONNECTIONS);
        }
    }

    public static String getDatabaseName() {
        return "HDB";
    }

    public static String getDriverName() {
        return "HDB";
    }

    public static DriverVersionInfo getVersionInfo() {
        return VERSION_INFO;
    }

    public static Tracer getTracer() {
        return TRACER;
    }

    public static TraceControl getTraceControl() {
        return TRACER.getTraceControl();
    }

    public static SessionFactory getCommunicationFactory(ConnectionProperties connectionProperties, Tracer tracer) throws RTEException {
        SessionFactory factory;
        String transport = connectionProperties.getBooleanProperty(ConnectionProperty.ENCRYPT) ? "secure" : connectionProperties.getProperty(ConnectionProperty.TRANSPORT);
        if (transport.equals("socket")) {
            factory = BasicSession.SESSION_FACTORY;
        } else if (transport.equals("secure")) {
            factory = SecureSession.SECURE_SESSION_FACTORY;
        } else {
            throw new RTEException(tracer, MessageTranslator.translate("error.invalid.transport", transport), RteReturnCode.SQLNOTOK, -10899);
        }
        return factory;
    }

    public static String buildURL(String locations, ConnectionProperties connectionProperties) {
        String url = "jdbc:sap://" + locations;
        boolean hasOption = false;
        if (connectionProperties != null) {
            String value = connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
            if (value != null && !value.isEmpty()) {
                url = url + "?" + ConnectionProperty.DATABASE_NAME.getName() + "=" + value;
                hasOption = true;
            }
            if ((value = connectionProperties.getProperty(ConnectionProperty.INSTANCE_NUMBER)) != null) {
                url = url + (hasOption ? "&" : "?") + ConnectionProperty.INSTANCE_NUMBER.getName() + "=" + value;
            }
        }
        return url;
    }

    public static Connection getConnection(String url, Properties info) throws SQLException {
        return Driver._connect(url, info);
    }

    public static void printResultSet(PrintStream out, ResultSet resultSet) throws SQLException {
        int width;
        int i;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        int[] widths = new int[columnCount];
        out.printf("|", new Object[0]);
        int totalWidth = 1;
        for (i = 1; i <= columnCount; ++i) {
            String columnName = resultSetMetaData.getColumnName(i);
            int dataType = resultSetMetaData.getColumnType(i);
            width = resultSetMetaData.getPrecision(i);
            if (width > 200 && DataType.decode(dataType).isLOB()) {
                width = 200;
            } else if (width > 100) {
                width = 100;
            } else if (width < 6) {
                width = 6;
            }
            widths[i - 1] = width;
            out.printf(" %-" + width + "." + width + "s |", columnName);
            totalWidth += width + 3;
        }
        out.println();
        out.printf(String.format("%" + totalWidth + "s\n", "").replace(' ', '-'), new Object[0]);
        long rowCount = 0L;
        while (resultSet.next()) {
            out.printf("|", new Object[0]);
            for (i = 1; i <= columnCount; ++i) {
                String value = resultSet.getString(i);
                if (value == null) {
                    value = "(NULL)";
                }
                width = widths[i - 1];
                out.printf(" %-" + width + "." + width + "s |", value);
            }
            out.println();
            ++rowCount;
        }
        out.printf("%d rows.\n", rowCount);
    }

    public static synchronized Class loadNativeAuthentication() throws SQLException {
        if (_nativeAuthenticationClass != null) {
            return _nativeAuthenticationClass;
        }
        try {
            System.loadLibrary("jniAuthentication");
            _nativeAuthenticationClass = Class.forName("com.sap.db.util.security.NativeAuthenticationManager");
        }
        catch (SecurityException e) {
            throw SQLExceptionSapDB.newInstance("error.library.notloaded", "jniAuthentication", e.toString());
        }
        catch (UnsatisfiedLinkError e) {
            throw SQLExceptionSapDB.newInstance("error.library.notloaded", "jniAuthentication", e.toString());
        }
        catch (ClassNotFoundException e) {
            throw SQLExceptionSapDB.newInstance("error.library.notloaded", "jniAuthentication", e.toString());
        }
        return _nativeAuthenticationClass;
    }

    public static synchronized void setNativeAuthenticationClass(Class<?> clas) throws SQLException {
        String[] methods = new String[]{"init", "release", "evaluate"};
        Class[][] parameterTypes = new Class[][]{{String.class, String.class}, {Long.TYPE}, {Long.TYPE, byte[].class}};
        for (int i = 0; i < methods.length; ++i) {
            try {
                clas.getMethod(methods[i], parameterTypes[i]);
                continue;
            }
            catch (SecurityException e) {
                throw SQLExceptionSapDB.newInstance("error.wrong.autenticationclass", e.toString());
            }
            catch (NoSuchMethodException e) {
                throw SQLExceptionSapDB.newInstance("error.wrong.autenticationclass", e.toString());
            }
        }
        _nativeAuthenticationClass = clas;
    }

    public static TraceControl openTrace(Properties info) {
        return Driver._openTrace(new ConnectionProperties(info)).getTraceControl();
    }

    public static void switchTraceOff() {
        TRACER.switchTraceOff();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        TRACER.refreshTraceSettings();
        boolean on = TRACER.on();
        boolean pon = TRACER.pon();
        TraceRecord r = pon ? Driver._newTraceRecord("connect") : null;
        try {
            if (on) {
                TRACER.printCall(this, "connect", Driver._getDisplayUrl(url), Driver._getDisplayProperties(info));
            }
            Connection result = Driver._connect(url, info);
            if (on) {
                TRACER.printResult(result);
            }
            Connection connection = result;
            return connection;
        }
        catch (SQLException e) {
            if (on) {
                TRACER.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                Driver._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptsURL(String url) throws SQLException {
        TRACER.refreshTraceSettings();
        boolean on = TRACER.on();
        boolean pon = TRACER.pon();
        TraceRecord r = pon ? Driver._newTraceRecord("acceptsURL") : null;
        try {
            if (on) {
                TRACER.printCall(this, "acceptsURL", Driver._getDisplayUrl(url));
            }
            boolean result = Driver._acceptsURL(url);
            if (on) {
                TRACER.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                Driver._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        TRACER.refreshTraceSettings();
        boolean on = TRACER.on();
        boolean pon = TRACER.pon();
        TraceRecord r = pon ? Driver._newTraceRecord("getPropertyInfo") : null;
        try {
            if (on) {
                TRACER.printCall(this, "getPropertyInfo", Driver._getDisplayUrl(url), Driver._getDisplayProperties(info));
            }
            DriverPropertyInfo[] result = Driver._getPropertyInfo(info);
            if (on) {
                TRACER.printResult(result);
            }
            DriverPropertyInfo[] driverPropertyInfoArray = result;
            return driverPropertyInfoArray;
        }
        finally {
            if (pon) {
                Driver._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMajorVersion() {
        TRACER.refreshTraceSettings();
        boolean on = TRACER.on();
        boolean pon = TRACER.pon();
        TraceRecord r = pon ? Driver._newTraceRecord("getMajorVersion") : null;
        try {
            if (on) {
                TRACER.printCall(this, "getMajorVersion", new Object[0]);
            }
            int result = VERSION_INFO.getMajorVersion();
            if (on) {
                TRACER.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                Driver._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinorVersion() {
        TRACER.refreshTraceSettings();
        boolean on = TRACER.on();
        boolean pon = TRACER.pon();
        TraceRecord r = pon ? Driver._newTraceRecord("getMinorVersion") : null;
        try {
            if (on) {
                TRACER.printCall(this, "getMinorVersion", new Object[0]);
            }
            int result = VERSION_INFO.getMinorVersion();
            if (on) {
                TRACER.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                Driver._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean jdbcCompliant() {
        TRACER.refreshTraceSettings();
        boolean on = TRACER.on();
        boolean pon = TRACER.pon();
        TraceRecord r = pon ? Driver._newTraceRecord("jdbcCompliant") : null;
        try {
            if (on) {
                TRACER.printCall(this, "jdbcCompliant", new Object[0]);
            }
            boolean result = true;
            if (on) {
                TRACER.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                Driver._publish(r);
            }
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        TRACER.refreshTraceSettings();
        boolean on = TRACER.on();
        boolean pon = TRACER.pon();
        TraceRecord r = pon ? Driver._newTraceRecord("getParentLogger") : null;
        try {
            try {
                if (on) {
                    TRACER.printCall(this, "getParentLogger", new Object[0]);
                }
                throw new SQLFeatureNotSupportedException();
            }
            catch (SQLFeatureNotSupportedException e) {
                if (on) {
                    TRACER.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                Driver._publish(r);
            }
            throw throwable;
        }
    }

    protected static String _getDisplayUrl(String url) {
        Properties info = new Properties();
        String urlPrefix = Driver._getUrlPrefixAndCanonicalProperties(url, new Properties(), info);
        StringBuilder builder = new StringBuilder(urlPrefix);
        boolean isFirst = true;
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String key = entry.getKey().toString();
            ConnectionProperty connectionProperty = ConnectionProperty.getConnectionProperty(key);
            String value = connectionProperty != null && connectionProperty.isPassword() ? OBFUSCATED_PSWD_STRING : entry.getValue().toString();
            builder.append(isFirst ? "?" : "&").append(key).append("=").append(value);
            isFirst = false;
        }
        return builder.toString();
    }

    protected static Map<String, String> _getDisplayProperties(Properties info) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String key = entry.getKey().toString();
            ConnectionProperty connectionProperty = ConnectionProperty.getConnectionProperty(key);
            String value = connectionProperty != null && connectionProperty.isPassword() ? OBFUSCATED_PSWD_STRING : entry.getValue().toString();
            map.put(key, value);
        }
        return map;
    }

    protected static Map<String, String> _getDisplayProperties(ConnectionProperties connectionProperties) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<ConnectionProperty, String> entry : connectionProperties.getProperties().entrySet()) {
            ConnectionProperty key = entry.getKey();
            String value = key.isPassword() ? OBFUSCATED_PSWD_STRING : entry.getValue();
            map.put(key.getName(), value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _addConnection(ConnectionSapDB connection) {
        Set<ConnectionSapDB> set = CONNECTIONS;
        synchronized (set) {
            CONNECTIONS.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _removeConnection(ConnectionSapDB connection) {
        Set<ConnectionSapDB> set = CONNECTIONS;
        synchronized (set) {
            CONNECTIONS.remove(connection);
        }
    }

    private static void _showTraceSettings(boolean toConsole) {
        if (toConsole) {
            new TraceConfiguration().printTraceSettings();
        } else {
            TraceTool.showWindow();
        }
    }

    private static void _printUsage(String message) {
        Driver._printUsage(message, null, 0);
    }

    private static void _printUsage(String message, String arg) {
        Driver._printUsage(message, new String[]{arg}, 0);
    }

    private static void _printUsage(String message, String[] args, int firstArg) {
        if (message != null) {
            if (args != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(message);
                int n = args.length;
                for (int i = firstArg; i < n; ++i) {
                    builder.append(' ').append(args[i]);
                }
                System.err.println(builder.toString());
            } else {
                System.err.println(message);
            }
            System.err.println();
        }
        System.out.println("Usage: java -jar ngdbc.jar -h | --help | HELP\n         to show this message.\n\n   or  java -jar ngdbc.jar -v | --version | VERSION\n         to show the version information.\n\n   or  java -jar ngdbc.jar -g | --gui | GUI\n         to run a GUI tool to configure trace settings.\n\n   or  java -jar ngdbc.jar -u <user,password>\n         [-n <host-name>[:<port>]]\n         [-d <database-name>]\n         [-i <instance-number>]\n         [-o <connect-option-name>=<connect-option-value>]\n         [-c <sql-command>]\n         to check whether a connection can be established or to execute\n         a command.\n\n   or  java -jar ngdbc.jar <command>\n         Commands:\n           TRACE ON | OFF\n             Enables/disables trace.\n           TRACE FILENAME <filename>\n             Sets the name of the trace file. The driver adds a unique\n             suffix to the trace file name.\n           TRACE API ON | OFF\n             Enables/disables JDBC API trace.\n           TRACE PACKET ON | OFF\n             Enables/disables trace of communication packets.\n           TRACE DISTRIBUTION ON | OFF\n             Enables/disables trace of distribution features.\n           TRACE STATISTICS ON | OFF\n             Enables/disables trace of sent/received packet/byte counts.\n           TRACE SIZE <size> [KB | MB | GB] | UNLIMITED\n             Limits the size of the trace file to <size>. Minimum size\n             is 8192 bytes.\n           TRACE STOP ON ERROR <error> | OFF\n             Stops tracing after the error <error> is encountered or\n             switches the trace stop feature off.\n           PERFORMANCETRACE ON | OFF\n             Enables/disables performance trace.\n           PERFORMANCETRACE FILENAME\n             Sets the name of the performance trace file. The driver\n             adds a unique suffix to the trace file name.\n           SHOW [ALL | TRACESETTINGS]\n             Displays the current trace settings.");
        System.exit(1);
    }

    private static Connection _connect(String url, Properties info) throws SQLException {
        List<Host> preferredHosts;
        SecureStoreLoginInformation loginInfo;
        if (!Driver._acceptsURL(url)) {
            return null;
        }
        Session session = null;
        Properties mergedInfo = new Properties();
        url = Driver._getUrlPrefixAndCanonicalProperties(url, info, mergedInfo);
        ConnectionProperties connectionProperties = new ConnectionProperties(mergedInfo);
        Tracer tracer = Driver._openTrace(connectionProperties);
        tracer.refreshTraceSettings();
        if (tracer.on()) {
            tracer.printProperties(Driver._getDisplayProperties(connectionProperties), "New connection: " + url);
        }
        if ((loginInfo = Driver._getLoginInfoFromSecureStore(connectionProperties, tracer)) != null) {
            url = Driver.buildURL(loginInfo.getLocation(), null);
            connectionProperties.setProperty(ConnectionProperty.USER, loginInfo.getUsername());
            connectionProperties.setProperty(ConnectionProperty.PASSWD, loginInfo.getPasswd());
            String databaseName = loginInfo.getDatabaseName();
            if (databaseName != null && databaseName.trim().length() > 0) {
                connectionProperties.setProperty(ConnectionProperty.DATABASE_NAME, databaseName);
            }
        }
        try {
            preferredHosts = Driver._getPreferredHosts(url, connectionProperties, tracer);
            boolean isConnectionRouting = DistributionMode.decode(connectionProperties.getProperty(ConnectionProperty.DISTRIBUTION)).isConnectionRouting();
            session = Topology.getSession(preferredHosts, connectionProperties, isConnectionRouting, tracer, Driver.getCommunicationFactory(connectionProperties, tracer), null, Location.SiteType.NONE);
        }
        catch (RTEException e) {
            if (tracer.on()) {
                tracer.printMessage("using " + session);
            }
            throw SQLExceptionSapDB.newInstance(e.getCause(), "error.connect.rteexception", "", e.getDetailErrorCode(), 0, e.getRTEReturnCode(), SQLExceptionSapDB.NO_UPDATE_COUNTS, url, e.getMessage());
        }
        ConnectionSapDB connection = connectionProperties.getBooleanProperty(ConnectionProperty.CLOSE_HANDLES_ON_FINALIZE) ? ConnectionSapDBFinalize.newInstance(tracer, session, mergedInfo, connectionProperties, preferredHosts) : ConnectionSapDB.newInstance(tracer, session, mergedInfo, connectionProperties, preferredHosts);
        if (tracer.isForOneConnection()) {
            tracer.setConnection(connection);
        }
        if (tracer.on()) {
            tracer.printMessage("using " + connection.getSessionPool().getPrimarySession() + " SID=" + connection.getEngineFeatures().getSystemID());
        }
        if (tracer.on()) {
            tracer.printSessionOpened(session, connection.getEngineFeatures().getSystemID());
        }
        return connection;
    }

    private static boolean _acceptsURL(String url) {
        return url != null && url.startsWith(PROTOCOL_NAME);
    }

    private static String _getUrlPrefixAndCanonicalProperties(String url, Properties input, Properties output) {
        String urlPrefix;
        int idx = url.indexOf(63);
        if (idx != -1) {
            urlPrefix = url.substring(0, idx);
            for (String arg : url.substring(idx + 1).split("&")) {
                idx = arg.indexOf(61);
                if (idx == -1) continue;
                String name = arg.substring(0, idx);
                String value = arg.substring(idx + 1);
                output.setProperty(ConnectionProperty.getCanonicalName(name), value);
            }
        } else {
            urlPrefix = url;
        }
        String[] stringArray = input.entrySet().iterator();
        while (stringArray.hasNext()) {
            Map.Entry<Object, Object> object;
            Map.Entry<Object, Object> entry = object = stringArray.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            output.put(key instanceof String ? ConnectionProperty.getCanonicalName((String)key) : key, val);
        }
        return urlPrefix;
    }

    private static Tracer _openTrace(ConnectionProperties connectionProperties) {
        Tracer tracer = TRACER;
        String traceFileName = connectionProperties.getProperty(ConnectionProperty.TRACE);
        String maxTraceSize = connectionProperties.getProperty(ConnectionProperty.TRACE_SIZE);
        if ((traceFileName == null || traceFileName.isEmpty()) && (traceFileName = connectionProperties.getProperty(ConnectionProperty.CONNECTION_TRACE)) != null && !traceFileName.isEmpty()) {
            tracer = new Tracer(true);
        }
        if (traceFileName != null && !traceFileName.isEmpty()) {
            boolean wasTraceFileNameChanged = tracer.setTraceFileName(traceFileName);
            boolean wasMaxTraceSizeChanged = tracer.setTraceSize(maxTraceSize);
            if (wasTraceFileNameChanged || wasMaxTraceSizeChanged) {
                tracer.switchTraceOff();
            }
            tracer.switchTraceOn();
        }
        return tracer;
    }

    private static SecureStoreLoginInformation _getLoginInfoFromSecureStore(ConnectionProperties connectionProperties, Tracer tracer) throws SQLException {
        SecureStoreLoginInformation loginInfo;
        String key = connectionProperties.getProperty(ConnectionProperty.KEY);
        if (key == null || key.trim().isEmpty()) {
            return null;
        }
        String virtualHostName = connectionProperties.getProperty(ConnectionProperty.VIRTUAL_HOST_NAME);
        if ((virtualHostName == null || virtualHostName.trim().isEmpty()) && ((virtualHostName = System.getenv("SAPLOCALHOST")) == null || virtualHostName.trim().isEmpty())) {
            String path = Driver.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            int index = path.lastIndexOf("ngdbc.jar");
            if (index != -1) {
                virtualHostName = SecureStore.getVirtualHostNameFromIniFile(path.substring(0, index));
                if (tracer.on()) {
                    tracer.printMessage("The jar location is " + virtualHostName);
                }
            } else {
                virtualHostName = "";
            }
        }
        if (tracer.on()) {
            tracer.printMessage("The Secure Store key is ***\nThe Virtual Hostname is " + virtualHostName);
        }
        if ((loginInfo = SecureStore.getLoginInformation(tracer, key, virtualHostName)) == null) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorenulllogin", new String[0]);
        }
        return loginInfo;
    }

    private static List<Host> _getPreferredHosts(String url, ConnectionProperties connectionProperties, Tracer tracer) throws RTEException {
        int idx;
        if (!url.startsWith(PROTOCOL_NAME)) {
            throw new RTEException(tracer, "Invalid URL: " + Driver._getDisplayUrl(url), RteReturnCode.SQLNOTOK, -708);
        }
        String hosts = url.substring(PROTOCOL_NAME_LENGTH);
        String instanceNumberString = connectionProperties.getProperty(ConnectionProperty.INSTANCE_NUMBER);
        String databaseName = connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
        int instanceNumber = -1;
        int defaultPort = -1;
        if (hosts.startsWith("//")) {
            hosts = hosts.substring(2);
        }
        if ((idx = hosts.indexOf(47)) != -1) {
            hosts = hosts.substring(0, idx);
        }
        connectionProperties.setProperty(ConnectionProperty.DBURL, Driver.buildURL(hosts, connectionProperties));
        if (instanceNumberString != null && !instanceNumberString.isEmpty()) {
            try {
                instanceNumber = Integer.parseInt(instanceNumberString);
            }
            catch (NumberFormatException e) {
                throw new RTEException(tracer, "Invalid instance number: " + instanceNumberString, RteReturnCode.SQLNOTOK, -708);
            }
            defaultPort = instanceNumber * 100 + (databaseName == null || databaseName.isEmpty() ? 30015 : 30013);
        }
        ArrayList<Host> preferredHosts = new ArrayList<Host>();
        for (String host : hosts.split(";")) {
            int port;
            String portString;
            idx = host.indexOf(58);
            String hostName = idx != -1 ? host.substring(0, idx) : host;
            String string = portString = idx != -1 && idx != host.length() ? host.substring(idx + 1) : null;
            if (portString != null && !portString.isEmpty()) {
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    throw new RTEException(tracer, "Invalid port number: " + portString, RteReturnCode.SQLNOTOK, -708);
                }
                if (instanceNumber != -1 && instanceNumber != port % 10000 / 100) {
                    throw new RTEException(tracer, "Ambiguous port number: Instance number " + instanceNumber + " conflicts with port " + port, RteReturnCode.SQLNOTOK, -708);
                }
            } else if (defaultPort != -1) {
                port = defaultPort;
            } else {
                throw new RTEException(tracer, "Invalid host, missing port number: " + host, RteReturnCode.SQLNOTOK, -708);
            }
            preferredHosts.add(new Host(hostName, port));
        }
        return preferredHosts;
    }

    private static DriverPropertyInfo[] _getPropertyInfo(Properties info) {
        DriverPropertyInfo propertyInfo;
        ArrayList<DriverPropertyInfo> propertyInfos = new ArrayList<DriverPropertyInfo>();
        if (info.getProperty(ConnectionProperty.USER.getName()) == null) {
            propertyInfo = new DriverPropertyInfo(ConnectionProperty.USER.getName(), null);
            propertyInfo.required = true;
            propertyInfos.add(propertyInfo);
        }
        if (info.getProperty(ConnectionProperty.PASSWD.getName()) == null) {
            propertyInfo = new DriverPropertyInfo(ConnectionProperty.PASSWD.getName(), null);
            propertyInfo.required = true;
            propertyInfos.add(propertyInfo);
        }
        return propertyInfos.toArray(new DriverPropertyInfo[propertyInfos.size()]);
    }

    private static TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(null, null, null, "Driver", methodName);
    }

    private static void _publish(TraceRecord r) {
        r.update(null);
        TraceRecordPublisher.getInstance().publish(r);
    }

    static {
        int pos;
        INSTANCE = new Driver();
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            System.err.println("Can't register driver: " + INSTANCE.getClass().getCanonicalName() + ": " + e.getMessage());
        }
        String computerName = null;
        String fullComputerName = null;
        int javaVersion = 6;
        int processID = 0;
        try {
            computerName = InetAddress.getLocalHost().getHostName();
            pos = computerName.indexOf(46);
            if (pos != -1) {
                computerName = computerName.substring(0, pos);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        COMPUTER_NAME = computerName;
        try {
            fullComputerName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        FULL_COMPUTER_NAME = fullComputerName;
        try {
            String javaSpecificationVersion = System.getProperty("java.specification.version");
            if (javaSpecificationVersion != null) {
                String[] components = javaSpecificationVersion.split(Pattern.quote("."));
                javaVersion = components.length >= 2 ? Integer.parseInt(components[1]) : Integer.parseInt(javaSpecificationVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JAVA_VERSION = javaVersion;
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            pos = name.indexOf(64);
            if (pos != -1) {
                processID = Integer.parseInt(name.substring(0, pos));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        PROCESS_ID = processID;
        CONNECTIONS = Collections.newSetFromMap(new WeakHashMap());
        VERSION_INFO = DriverVersionInfo.newInstance(Driver.class.getPackage().toString());
        TRACER = new Tracer(false);
        PROTOCOL_NAME_LENGTH = PROTOCOL_NAME.length();
        pptracer = TRACER.getTraceControl();
    }
}

