/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.BasicSession;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.trace.Tracer;

@NotThreadSafe
public class LatencySession
extends BasicSession {
    private final int _latency;

    LatencySession(Tracer tracer, Location location, ConnectionProperties connectionProperties) throws RTEException {
        super(tracer, location, connectionProperties);
        this._latency = connectionProperties.getIntProperty(ConnectionProperty.LATENCY);
    }

    @Override
    protected HReplyPacket _receivePacket() throws RTEException {
        this._createLatency();
        return super._receivePacket();
    }

    private void _createLatency() {
        try {
            Thread.sleep(this._latency);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

