/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.HanaSystem;
import com.sap.db.jdbc.Host;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.TopologyInformationOption;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadSafe
final class Topology {
    @GuardedBy(value="Topology.class")
    private static final Map<String, Map<String, HanaSystem>> SYSTEMS = new HashMap<String, Map<String, HanaSystem>>();

    private Topology() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    static synchronized Set<HanaSystem> getSystems() {
        HashSet<HanaSystem> systems = new HashSet<HanaSystem>();
        for (Map<String, HanaSystem> innerMap : SYSTEMS.values()) {
            for (HanaSystem system : innerMap.values()) {
                systems.add(system);
            }
        }
        return Collections.unmodifiableSet(systems);
    }

    static int getNumberOfRegisteredSystems() {
        return Topology.getSystems().size();
    }

    static synchronized HanaSystem addSystem(String sidAndDatabase, Host hostPortFromURL) {
        HanaSystem system = HanaSystem.newInstance(sidAndDatabase);
        if (!SYSTEMS.containsKey(sidAndDatabase)) {
            HashMap<String, HanaSystem> innerMap = new HashMap<String, HanaSystem>();
            innerMap.put(hostPortFromURL.toString(), system);
            SYSTEMS.put(sidAndDatabase, innerMap);
        } else {
            SYSTEMS.get(sidAndDatabase).put(hostPortFromURL.toString(), system);
        }
        return system;
    }

    static synchronized HanaSystem getSystemByHost(Host hostNameAndPort, String databaseName) {
        Set<String> sidDatabaseNameSet = SYSTEMS.keySet();
        if (sidDatabaseNameSet == null || sidDatabaseNameSet.isEmpty()) {
            return null;
        }
        HashSet<HanaSystem> checkedSystem = new HashSet<HanaSystem>();
        for (String sidDatabaseName : sidDatabaseNameSet) {
            if (SYSTEMS.get(sidDatabaseName) == null || SYSTEMS.get(sidDatabaseName).size() == 0 || databaseName != null && !databaseName.isEmpty() && sidDatabaseName.length() > 3 && !sidDatabaseName.substring(3).equals(databaseName)) continue;
            if (SYSTEMS.get(sidDatabaseName).containsKey(hostNameAndPort.toString())) {
                return SYSTEMS.get(sidDatabaseName).get(hostNameAndPort.toString());
            }
            Map<String, HanaSystem> innerMap = SYSTEMS.get(sidDatabaseName);
            for (String hostName : innerMap.keySet()) {
                HanaSystem system = innerMap.get(hostName);
                if (system == null || checkedSystem.contains(system)) continue;
                checkedSystem.add(system);
                if (system.getLocation(hostNameAndPort, true) == null) continue;
                return system;
            }
        }
        return null;
    }

    static String getOwnLocation(HMultiLineOptionsPart mo) {
        do {
            String ownHost = "";
            boolean isOwn = false;
            int ownPort = 0;
            do {
                switch (TopologyInformationOption.decode(mo.getOptionName())) {
                    case HostName: {
                        ownHost = mo.getOptionStringValue();
                        break;
                    }
                    case HostPortNumber: {
                        ownPort = mo.getOptionIntValue();
                        break;
                    }
                    case IsCurrentSession: {
                        isOwn = mo.getOptionBooleanValue();
                        break;
                    }
                }
            } while (mo.nextOption());
            if (!isOwn || ownPort <= 0 || ownHost.isEmpty()) continue;
            return ownHost + ":" + ownPort;
        } while (mo.nextLine());
        return "";
    }

    static Session getSession(List<Host> preferredHosts, ConnectionProperties connectionProperties, boolean connectionRoutingEnabled, Tracer tracer, SessionFactory factory, HanaSystem system, Location.SiteType reconnectSiteType) throws RTEException, SQLException {
        ArrayList<Location> locations = new ArrayList<Location>();
        String databaseName = connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
        int tryCnt = 0;
        StringBuilder errorMsg = new StringBuilder();
        RTEException caughtRTE = null;
        for (Host host : preferredHosts) {
            Location loc = new Location(host, "");
            locations.add(loc);
        }
        HanaSystem tmpSys = null;
        if (system == null) {
            boolean hasPrimary = false;
            boolean hasSecondary = false;
            for (Host host : preferredHosts) {
                tmpSys = Topology.getSystemByHost(host, databaseName);
                if (tmpSys == null) continue;
                Location location = tmpSys.getLocation(host, true);
                Location.SiteType siteType = Location.SiteType.NONE;
                if (location != null) {
                    siteType = location.getSiteType();
                    hasPrimary |= location.isPrimarySite();
                    hasSecondary |= location.isSecondarySite();
                }
                String dbNameFromSystem = tmpSys.getDatabaseName();
                if (databaseName == null || databaseName.isEmpty()) {
                    connectionProperties.setProperty(ConnectionProperty.DATABASE_NAME, dbNameFromSystem);
                } else if (dbNameFromSystem != null && !dbNameFromSystem.isEmpty() && !databaseName.equals(dbNameFromSystem)) {
                    throw new AssertionError((Object)"Internal JDBC error: Unexpected database name found!");
                }
                tmpSys.getLocationsList(locations, connectionRoutingEnabled, siteType);
            }
            if (hasPrimary && hasSecondary) {
                throw SQLExceptionSapDB.newInstance("error.host.multisitedirect", new String[0]);
            }
        } else {
            system.getLocationsList(locations, connectionRoutingEnabled, reconnectSiteType);
        }
        HanaSystem usedSystem = system == null ? tmpSys : system;
        for (Location location : locations) {
            if (location.getSystem() == null) {
                location.setSystem(usedSystem);
            }
            try {
                String ignoreTopology;
                Host before = location.getHost();
                Session session = factory.newInstance(tracer, location, connectionProperties, true);
                Host after = session.getLocation().getHost();
                if (!before.equals(after) && (ignoreTopology = connectionProperties.getProperty(ConnectionProperty.IGNORE_TOPOLOGY)).trim().equals("1")) {
                    throw SQLExceptionSapDB.newInstance("error.connection.invalidproperties", new String[0]);
                }
                return session;
            }
            catch (UnsatisfiedLinkError linkErr) {
                throw new RTEException(tracer, MessageTranslator.translate("error.library.notloaded", "jniAuthentication", linkErr.toString()), RteReturnCode.SQLNOTOK, -10899);
            }
            catch (RTEException rteex) {
                if (tryCnt == 0) {
                    errorMsg.append(rteex.getMessage());
                } else {
                    errorMsg.append("; host = ");
                    errorMsg.append(location.getHostName()).append(":").append(location.getPortNumber());
                    errorMsg.append(" error = ");
                    errorMsg.append(rteex.getMessage());
                }
                location.setAvailable(false);
                ++tryCnt;
                if (usedSystem != null) {
                    usedSystem.incrementNextLocationPointer();
                }
                if (caughtRTE != null) continue;
                caughtRTE = rteex;
            }
            catch (SQLException e) {
                if (tryCnt == 0) {
                    errorMsg.append(e.getMessage());
                } else {
                    errorMsg.append("; host = ");
                    errorMsg.append(location.getHostName()).append(":").append(location.getPortNumber());
                    errorMsg.append(" error = ");
                    errorMsg.append(e.getMessage());
                }
                location.setAvailable(false);
                ++tryCnt;
                if (usedSystem == null) continue;
                usedSystem.incrementNextLocationPointer();
            }
        }
        if (tryCnt > 1) {
            throw new RTEException(tracer, MessageTranslator.translate("error.connect.rteexceptionMultipleHosts", errorMsg), RteReturnCode.SQLNOTOK, -708, caughtRTE);
        }
        if (caughtRTE == null) {
            throw new RTEException(tracer, errorMsg.toString(), RteReturnCode.SQLNOTOK, -708);
        }
        throw caughtRTE;
    }

    protected static synchronized Map<String, Map<String, HanaSystem>> _getSystemsMap() {
        return SYSTEMS;
    }
}

