/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AlphanumConverter;
import com.sap.db.jdbc.converters.ArrayConverter;
import com.sap.db.jdbc.converters.BigIntConverter;
import com.sap.db.jdbc.converters.BinaryConverter;
import com.sap.db.jdbc.converters.BlobConverter;
import com.sap.db.jdbc.converters.BooleanConverter;
import com.sap.db.jdbc.converters.CharacterConverter;
import com.sap.db.jdbc.converters.ClobConverter;
import com.sap.db.jdbc.converters.DateConverter;
import com.sap.db.jdbc.converters.DayDateConverter;
import com.sap.db.jdbc.converters.DecimalConverter;
import com.sap.db.jdbc.converters.DoubleConverter;
import com.sap.db.jdbc.converters.FixedDecimalConverter;
import com.sap.db.jdbc.converters.IntConverter;
import com.sap.db.jdbc.converters.LongDateConverter;
import com.sap.db.jdbc.converters.RealConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.converters.SecondDateConverter;
import com.sap.db.jdbc.converters.SecondTimeConverter;
import com.sap.db.jdbc.converters.SmallIntConverter;
import com.sap.db.jdbc.converters.SpatialConverter;
import com.sap.db.jdbc.converters.TimeConverter;
import com.sap.db.jdbc.converters.TimestampConverter;
import com.sap.db.jdbc.converters.TinyIntConverter;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataFormatVersion;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Set;

@ThreadSafe
public abstract class AbstractConverter {
    protected static final Charset CHARSET_ISO_8859_1 = Charset.forName("ISO-8859-1");
    protected static final int BUFFER_SIZE = 256;
    protected static final int BUFFER_SIZE_LOB = 4096;
    protected final ConnectionSapDB _connection;
    protected final Set<ParameterOption> _parameterOptions;
    protected final ParameterMode _parameterMode;
    protected final DataType _dataType;
    protected final int _index;
    protected final int _inputFieldPos;
    protected final int _outputFieldPos;
    protected final int _length;
    protected final String _schemaName;
    protected final String _tableName;
    protected final String _columnName;
    protected final String _columnLabel;
    protected final DataFormatVersion _dataFormatVersion;
    protected final boolean _emptyTimestampIsNull;
    protected final boolean _inexactDoubleToDecimalConversion;

    public static AbstractConverter newInstance(ConnectionSapDB conn, Set<ParameterOption> parmOptions, ParameterMode parmMode, DataType dataType, int index, int inPos, int outPos, int len, int frac, String schemaName, String tableName, String columnName, String columnLabel) throws SQLException {
        AbstractConverter converter;
        switch (dataType) {
            case BOOLEAN: {
                converter = new BooleanConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case TINYINT: {
                converter = new TinyIntConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case SMALLINT: {
                converter = new SmallIntConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case INT: {
                converter = new IntConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case BIGINT: {
                converter = new BigIntConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case REAL: {
                converter = new RealConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case DOUBLE: {
                converter = new DoubleConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case DECIMAL: {
                converter = new DecimalConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case FIXED8: 
            case FIXED12: 
            case FIXED16: {
                converter = new FixedDecimalConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case DATE: {
                converter = new DateConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case TIME: {
                converter = new TimeConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case TIMESTAMP: {
                converter = new TimestampConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case DAYDATE: {
                converter = new DayDateConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case SECONDTIME: {
                converter = new SecondTimeConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case SECONDDATE: {
                converter = new SecondDateConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case LONGDATE: {
                converter = new LongDateConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case VARCHAR2: 
            case STRING: 
            case NSTRING: {
                converter = new CharacterConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case ALPHANUM: {
                converter = new AlphanumConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case BINARY: 
            case VARBINARY: 
            case BSTRING: {
                converter = new BinaryConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case GEOMETRY: 
            case POINT: {
                converter = new SpatialConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: {
                converter = new ClobConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel, dataType != DataType.CLOB && dataType != DataType.LOCATOR);
                break;
            }
            case BLOB: 
            case BLOCATOR: {
                converter = new BlobConverter(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case ARRAY: {
                throw new AssertionError((Object)"ARRAY is not an element type");
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.noconverter", dataType.getDisplayName());
            }
        }
        AbstractConverter result = parmOptions.contains((Object)ParameterOption.ArrayType) ? new ArrayConverter(conn, parmOptions, parmMode, DataType.ARRAY, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel, dataType, converter) : converter;
        return result;
    }

    public static long getEmptyDayDateMilliseconds() {
        return -62135856000000L;
    }

    public static long getEmptySecondTimeMilliseconds() {
        return -62135769601000L;
    }

    public static long getEmptySecondDateMilliseconds() {
        return -62135769601000L;
    }

    public static long getEmptyLongDateMilliseconds() {
        return -62135769600001L;
    }

    public static int getEmptyLongDateNanoseconds() {
        return 999999900;
    }

    protected AbstractConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        this._connection = connection;
        this._parameterOptions = parameterOptions;
        this._parameterMode = parameterMode;
        this._dataType = dataType;
        this._index = index;
        this._inputFieldPos = inputFieldPos;
        this._outputFieldPos = outputFieldPos;
        this._length = length;
        this._schemaName = schemaName;
        this._tableName = tableName;
        this._columnName = columnName;
        this._columnLabel = columnLabel;
        this._dataFormatVersion = connection.getEngineFeatures().getDataFormatVersion2();
        this._emptyTimestampIsNull = connection.emptyTimestampIsNull();
        this._inexactDoubleToDecimalConversion = connection.inexactDoubleToDecimalConversion();
    }

    public abstract int getEstimatedColumnSize();

    protected abstract int _getNonNullInputArgLength(Object var1) throws SQLException;

    protected abstract int _putNonNullInputArg(HDataPart var1, Object var2) throws SQLException;

    public int isNullable() {
        int result = this._parameterOptions.contains((Object)ParameterOption.Mandatory) ? 0 : (this._parameterOptions.contains((Object)ParameterOption.Optional) ? 1 : 2);
        return result;
    }

    public boolean isReadOnly() {
        return this._parameterOptions.contains((Object)ParameterOption.Readonly);
    }

    public boolean isAutoIncrement() {
        return this._parameterOptions.contains((Object)ParameterOption.Autoincrement);
    }

    public ParameterMode getParameterMode() {
        return this._parameterMode;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public int getColumnType() {
        return this._dataType.getSQLType();
    }

    public String getColumnTypeName() {
        return this._dataType.getSQLTypeName();
    }

    public String getColumnClassName() {
        return this._dataType.getJavaClassName();
    }

    public boolean isSigned() {
        return this._dataType.isSigned();
    }

    public boolean isLOB() {
        return this._dataType.isLOB();
    }

    public int getIndex() {
        return this._index;
    }

    public int getInputFieldPos() {
        return this._inputFieldPos;
    }

    public int getOutputFieldPos() {
        return this._outputFieldPos;
    }

    public int getColumnDisplaySize() {
        return this._length;
    }

    public int getPrecision() {
        return this._length;
    }

    public int getScale() {
        return 0;
    }

    public String getCatalogName() {
        return "";
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public String getColumnLabel() {
        return this._columnLabel;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean isSearchable() {
        return true;
    }

    public boolean isCurrency() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDefinitelyWritable() {
        return false;
    }

    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.lang.Object");
    }

    public Object setObject(Object value) throws SQLException {
        throw this._newSetException("java.lang.Object");
    }

    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("boolean");
    }

    public Object setBoolean(boolean value) throws SQLException {
        throw this._newSetException("boolean");
    }

    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("byte");
    }

    public Object setByte(byte value) throws SQLException {
        throw this._newSetException("byte");
    }

    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("short");
    }

    public Object setShort(short value) throws SQLException {
        throw this._newSetException("short");
    }

    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("int");
    }

    public Object setInt(int value) throws SQLException {
        throw this._newSetException("int");
    }

    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("long");
    }

    public Object setLong(long value) throws SQLException {
        throw this._newSetException("long");
    }

    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("float");
    }

    public Object setFloat(float value) throws SQLException {
        throw this._newSetException("float");
    }

    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("double");
    }

    public Object setDouble(double value) throws SQLException {
        throw this._newSetException("double");
    }

    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.math.BigDecimal");
    }

    public Object setBigDecimal(BigDecimal value) throws SQLException {
        throw this._newSetException("java.math.BigDecimal");
    }

    public Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        throw this._newGetException("java.sql.Date");
    }

    public Object setDate(Date value, Calendar cal) throws SQLException {
        throw this._newSetException("java.sql.Date");
    }

    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        throw this._newGetException("java.sql.Time");
    }

    public Object setTime(Time value, Calendar cal) throws SQLException {
        throw this._newSetException("java.sql.Time");
    }

    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        throw this._newGetException("java.sql.Timestamp");
    }

    public Object setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        throw this._newSetException("java.sql.Timestamp");
    }

    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("String");
    }

    public Object setString(String value) throws SQLException {
        throw this._newSetException("String");
    }

    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("byte[]");
    }

    public Object setBytes(byte[] value) throws SQLException {
        throw this._newSetException("byte[]");
    }

    public Reader getCharacterStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.io.Reader");
    }

    public Object setCharacterStream(Reader value, long length) throws SQLException {
        throw this._newSetException("java.io.Reader");
    }

    public InputStream getAsciiStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.io.InputStream");
    }

    public Object setAsciiStream(InputStream value, long length) throws SQLException {
        throw this._newSetException("java.io.InputStream");
    }

    public InputStream getUnicodeStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.io.InputStream");
    }

    public Object setUnicodeStream(InputStream value) throws SQLException {
        throw this._newSetException("java.io.InputStream");
    }

    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.io.InputStream");
    }

    public Object setBinaryStream(InputStream value, long length) throws SQLException {
        throw this._newSetException("java.io.InputStream");
    }

    public Clob getClob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.sql.Clob");
    }

    public Object setClob(Clob clob) throws SQLException {
        throw this._newSetException("java.sql.Clob");
    }

    public Blob getBlob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.sql.Blob");
    }

    public Object setBlob(Blob blob) throws SQLException {
        throw this._newSetException("java.sql.Blob");
    }

    public Array getArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.sql.Array");
    }

    public Object cloneObjectForBatch(Object object) {
        return object;
    }

    public int getInputArgLength(Object data) throws SQLException {
        if (!this._parameterMode.isInput()) {
            return 0;
        }
        int len = data == null ? 1 : this._getNonNullInputArgLength(data);
        return len;
    }

    public int putInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!this._parameterMode.isInput()) {
            return 0;
        }
        int len = data == null ? this._putNullInputArg(dataPart) : this._putNonNullInputArg(dataPart, data);
        return len;
    }

    protected SQLException _newGetException(String javaType) {
        return SQLExceptionSapDB.newInstance("error.conversion.sqljava", this.getColumnTypeName(), javaType);
    }

    protected SQLException _newSetException(String javaType) {
        return SQLExceptionSapDB.newInstance("error.conversion.javasql", javaType, this.getColumnTypeName());
    }

    protected SQLException _newGetConversionException(String data, String javaType) {
        return SQLExceptionSapDB.newInstance("error.conversion.data", data, javaType);
    }

    protected SQLException _newSetConversionException(String data) {
        return SQLExceptionSapDB.newInstance("error.conversion.data", data, this.getColumnTypeName());
    }

    protected SQLException _newSetConversionException(String data, String javaType) {
        return SQLExceptionSapDB.newInstance("error.conversion.data", data, javaType);
    }

    protected Object _defaultSetObject(Object value) throws SQLException {
        if (value instanceof char[]) {
            return this.setString(new String((char[])value));
        }
        return this.setString(value.toString());
    }

    protected int _putNullInputArg(HDataPart dataPart) {
        return dataPart.putNull(this._dataType);
    }

    protected static String _convertReaderToString(Reader reader, long length) throws SQLException {
        if (length == 0L) {
            return "";
        }
        if (length > Integer.MAX_VALUE) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", "Streams with size greater than Integer.MAX_VALUE are not supported");
        }
        try {
            String value;
            if (length == -1L) {
                int n;
                StringBuilder builder = new StringBuilder(256);
                char[] buf = new char[256];
                while ((n = reader.read(buf)) != -1) {
                    builder.append(buf, 0, n);
                }
                value = builder.toString();
            } else {
                char[] buf = new char[(int)length];
                int n = reader.read(buf);
                if (n == -1) {
                    n = 0;
                }
                value = new String(buf, 0, n);
            }
            return value;
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
    }

    protected static byte[] _convertInputStreamToBytes(InputStream stream, long length) throws SQLException {
        if (length == 0L) {
            return new byte[0];
        }
        if (length > Integer.MAX_VALUE) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", "Streams with size greater than Integer.MAX_VALUE are not supported");
        }
        try {
            byte[] value;
            if (length == -1L) {
                int n;
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                value = new byte[256];
                while ((n = stream.read(value)) != -1) {
                    out.write(value, 0, n);
                }
                value = out.toByteArray();
            } else {
                value = new byte[(int)length];
                int n = stream.read(value);
                if (n == -1) {
                    n = 0;
                }
                if ((long)n != length) {
                    value = Arrays.copyOfRange(value, 0, n);
                }
            }
            return value;
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
    }
}

