/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.Cesu8Utils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class DecimalConverter
extends AbstractNumericConverter {
    protected DecimalConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        return 16;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof BigDecimal) && !(data instanceof String)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (data instanceof BigDecimal) {
            return 17;
        }
        int dataLen = Cesu8Utils.getByteLength((String)data);
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen + 1;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof BigDecimal) && !(data instanceof String)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (data instanceof BigDecimal) {
            return dataPart.putBigDecimalAsDecimal((BigDecimal)data);
        }
        return dataPart.putStringAsString((String)data);
    }

    @Override
    public int getColumnDisplaySize() {
        return this._length + (this._fraction > 0 ? 1 : 0) + (this._length < this._fraction ? 1 : 0) + 1;
    }

    @Override
    public int getScale() {
        return this._fraction == Short.MAX_VALUE ? 0 : this._fraction;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBigDecimal(controller, dataPart, true);
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? false : this._getValueAsBigDecimal(controller, dataPart, false).longValue() != 0L;
    }

    @Override
    public BigDecimal setBoolean(boolean value) throws SQLException {
        return value ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? (byte)0 : this._getValueAsBigDecimal(controller, dataPart, false).byteValue();
    }

    @Override
    public BigDecimal setByte(byte value) throws SQLException {
        return BigDecimal.valueOf(value);
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? (short)0 : this._getValueAsBigDecimal(controller, dataPart, false).shortValue();
    }

    @Override
    public BigDecimal setShort(short value) throws SQLException {
        return BigDecimal.valueOf(value);
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? 0 : this._getValueAsBigDecimal(controller, dataPart, false).intValue();
    }

    @Override
    public BigDecimal setInt(int value) throws SQLException {
        return BigDecimal.valueOf(value);
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? 0L : this._getValueAsBigDecimal(controller, dataPart, false).longValue();
    }

    @Override
    public BigDecimal setLong(long value) throws SQLException {
        return BigDecimal.valueOf(value);
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? 0.0f : this._getValueAsBigDecimal(controller, dataPart, false).floatValue();
    }

    @Override
    public BigDecimal setFloat(float value) throws SQLException {
        BigDecimal bigDecimal = this._inexactDoubleToDecimalConversion ? BigDecimal.valueOf(value) : new BigDecimal(value);
        return bigDecimal;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? 0.0 : this._getValueAsBigDecimal(controller, dataPart, false).doubleValue();
    }

    @Override
    public BigDecimal setDouble(double value) throws SQLException {
        BigDecimal bigDecimal = this._inexactDoubleToDecimalConversion ? BigDecimal.valueOf(value) : new BigDecimal(value);
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBigDecimal(controller, dataPart, true);
    }

    @Override
    public BigDecimal setBigDecimal(BigDecimal value) throws SQLException {
        return value;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : String.valueOf(this._getValueAsBigDecimal(controller, dataPart, false));
    }

    @Override
    public Object setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        return value;
    }

    @Override
    public BigDecimal setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetConversionException(Arrays.toString(value));
        }
        return BigDecimal.valueOf(value[0] & 0xFF);
    }

    protected BigDecimal _getValueAsBigDecimal(SQLParamController controller, HDataPart dataPart, boolean doNullCheck) throws SQLException {
        if (doNullCheck && dataPart.isNull(controller)) {
            return null;
        }
        return dataPart.getDecimalAsBigDecimal(this._fraction);
    }
}

