/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class RealConverter
extends AbstractNumericConverter {
    protected RealConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        return 4;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Float)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return 5;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Float)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Float value = (Float)data;
        return dataPart.putFloatAsReal(value.floatValue());
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(Float.MAX_VALUE).length() + 1;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : Float.valueOf(this._getValueAsFloat(controller, dataPart, false));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsFloat(controller, dataPart, true) != 0.0f;
    }

    @Override
    public Float setBoolean(boolean value) throws SQLException {
        return Float.valueOf(value ? 1 : 0);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (byte)this._getValueAsFloat(controller, dataPart, true);
    }

    @Override
    public Float setByte(byte value) throws SQLException {
        return Float.valueOf(value);
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (short)this._getValueAsFloat(controller, dataPart, true);
    }

    @Override
    public Float setShort(short value) throws SQLException {
        return Float.valueOf(value);
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (int)this._getValueAsFloat(controller, dataPart, true);
    }

    @Override
    public Float setInt(int value) throws SQLException {
        return Float.valueOf(value);
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (long)this._getValueAsFloat(controller, dataPart, true);
    }

    @Override
    public Float setLong(long value) throws SQLException {
        return Float.valueOf(value);
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsFloat(controller, dataPart, true);
    }

    @Override
    public Float setFloat(float value) throws SQLException {
        return Float.valueOf(value);
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsFloat(controller, dataPart, true);
    }

    @Override
    public Float setDouble(double value) throws SQLException {
        return Float.valueOf((float)value);
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : BigDecimal.valueOf(this._getValueAsFloat(controller, dataPart, false));
    }

    @Override
    public Float setBigDecimal(BigDecimal value) throws SQLException {
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : String.valueOf(this._getValueAsFloat(controller, dataPart, false));
    }

    @Override
    public Float setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return Float.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw this._newSetConversionException(value, "float");
        }
    }

    @Override
    public Float setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetConversionException(Arrays.toString(value));
        }
        return Float.valueOf(value[0] & 0xFF);
    }

    private float _getValueAsFloat(SQLParamController controller, HDataPart dataPart, boolean doNullCheck) throws SQLException {
        if (doNullCheck && dataPart.isNull(controller)) {
            return 0.0f;
        }
        return dataPart.getRealAsFloat();
    }
}

