/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.Cesu8Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class SpatialConverter
extends AbstractConverter {
    protected SpatialConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        return 5002;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof byte[]) && !(data instanceof String)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        int dataLen = data instanceof byte[] ? ((byte[])data).length : Cesu8Utils.getByteLength((String)data);
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen + 1;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof byte[]) && !(data instanceof String)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (data instanceof byte[]) {
            return dataPart.putBytesAsBinary((byte[])data);
        }
        return dataPart.putStringAsString((String)data);
    }

    @Override
    public int getColumnDisplaySize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        if (value instanceof byte[]) {
            return this.setBytes((byte[])value);
        }
        if (value instanceof InputStream) {
            return this.setBinaryStream((InputStream)value, -1L);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public String setString(String value) throws SQLException {
        return value;
    }

    @Override
    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart);
    }

    public byte[] setBytes(byte[] value) throws SQLException {
        return value != null ? (byte[])value.clone() : null;
    }

    @Override
    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart);
        return value != null ? new ByteArrayInputStream(value) : null;
    }

    public byte[] setBinaryStream(InputStream value, long length) throws SQLException {
        return value != null ? SpatialConverter._convertInputStreamToBytes(value, length) : null;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) {
        return dataPart.putNull(DataType.VARBINARY);
    }

    private byte[] _getValueAsByteArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        if (dataPart.isNull(controller)) {
            return null;
        }
        return dataPart.getBinaryAsBytes();
    }
}

