/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbcext.DataSourceSAPFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;

@ThreadSafe
public abstract class AbstractDataSource
extends WrapperDummy
implements CommonDataSource,
Referenceable {
    private static final String SERVER_NAME = "servername";
    private static final String PORT = "port";
    private static final String TIMEOUT = "timeout";
    private static final String LOGIN_TIMEOUT = "logintimeout";
    private static final String XA_TIMEOUT = "xatimeout";
    private static final String XA_TRACE = "xatrace";
    private static final String DESCRIPTION = "description";
    private static final String DEFAULT_SERVER_NAME = "localhost";
    private static final int DEFAULT_PORT = 30015;
    private static final int DEFAULT_TIMEOUT = 0;
    private static final int DEFAULT_LOGINTIMEOUT = 30;
    private static final int DEFAULT_XATIMEOUT = 30;
    private AtomicReference<Properties> _connectProperties = new AtomicReference<Properties>(new Properties());
    private AtomicReference<PrintWriter> _logWriter;

    public AbstractDataSource() {
        this._connectProperties.get().setProperty(SERVER_NAME, DEFAULT_SERVER_NAME);
        this._connectProperties.get().setProperty(PORT, String.valueOf(30015));
        this._logWriter = new AtomicReference();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._logWriter.get();
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this._logWriter.set(logWriter);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._getIntProperty(LOGIN_TIMEOUT, 30);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this._connectProperties.get().setProperty(LOGIN_TIMEOUT, String.valueOf(seconds));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reference getReference() throws NamingException {
        return this._createReference(this.getClass().getName());
    }

    public Connection openPhysicalConnection() throws SQLException {
        return this.openPhysicalConnection(false, null, null);
    }

    public Connection openPhysicalConnection(boolean forceDistributionOff) throws SQLException {
        return this.openPhysicalConnection(forceDistributionOff, null, null);
    }

    public Connection openPhysicalConnection(String username, String passwd) throws SQLException {
        return this.openPhysicalConnection(false, username, passwd);
    }

    public Connection openPhysicalConnection(boolean forceDistributionOff, String username, String passwd) throws SQLException {
        String url = this._buildURLFromServerNames();
        boolean setUsernameAndPasswd = username != null && passwd != null;
        Properties properties = (Properties)this._connectProperties.get().clone();
        if (forceDistributionOff || setUsernameAndPasswd) {
            if (forceDistributionOff) {
                properties.setProperty(ConnectionProperty.DISTRIBUTION.getName(), "OFF");
            }
            if (setUsernameAndPasswd) {
                properties.setProperty(ConnectionProperty.USER.getName(), username);
                properties.setProperty(ConnectionProperty.PASSWD.getName(), passwd);
            }
        }
        return Driver.getConnection(url, properties);
    }

    public Properties getProperties() {
        return (Properties)this._connectProperties.get().clone();
    }

    public void setProperties(Properties p) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)p);
        this._connectProperties.set(properties);
    }

    public String getServerNames() {
        return this._connectProperties.get().getProperty(ConnectionProperty.HOSTLIST.getName());
    }

    public void setServerNames(String serverNames) {
        this._connectProperties.get().setProperty(ConnectionProperty.HOSTLIST.getName(), serverNames);
    }

    public String getServerName() {
        return this._connectProperties.get().getProperty(SERVER_NAME);
    }

    public void setServerName(String serverName) {
        this._connectProperties.get().setProperty(SERVER_NAME, serverName);
    }

    public int getPort() {
        return this._getIntProperty(PORT, 30015);
    }

    public void setPort(int port) {
        this._connectProperties.get().setProperty(PORT, String.valueOf(port));
    }

    public String getURL() {
        return this._buildURLFromServerNames();
    }

    public void setUrl(String url) {
        this.setServerNames(this._parseServerNamesFromURL(url));
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public void setPortNumber(int port) {
        this.setPort(port);
    }

    public String getUser() {
        return this._connectProperties.get().getProperty(ConnectionProperty.USER.getName());
    }

    public void setUser(String user) {
        this._connectProperties.get().setProperty(ConnectionProperty.USER.getName(), user);
    }

    public String getPassword() {
        return this._connectProperties.get().getProperty(ConnectionProperty.PASSWD.getName());
    }

    public void setPassword(String passwd) {
        this._connectProperties.get().setProperty(ConnectionProperty.PASSWD.getName(), passwd);
    }

    public String getTransport() {
        return this._connectProperties.get().getProperty(ConnectionProperty.TRANSPORT.getName(), ConnectionProperty.TRANSPORT.getDefaultValue());
    }

    public void setTransport(String transport) {
        this._connectProperties.get().setProperty(ConnectionProperty.TRANSPORT.getName(), transport);
    }

    public String getReconnect() {
        return this._connectProperties.get().getProperty(ConnectionProperty.RECONNECT.getName(), ConnectionProperty.RECONNECT.getDefaultValue());
    }

    public void setReconnect(String reconnect) {
        this._connectProperties.get().setProperty(ConnectionProperty.RECONNECT.getName(), reconnect);
    }

    public String getSchema() {
        return this._connectProperties.get().getProperty(ConnectionProperty.CURRENT_SCHEMA.getName());
    }

    public void setSchema(String schema) {
        this._connectProperties.get().setProperty(ConnectionProperty.CURRENT_SCHEMA.getName(), schema);
    }

    public String getDescription() {
        return this._connectProperties.get().getProperty(DESCRIPTION);
    }

    public void setDescription(String description) {
        this._connectProperties.get().setProperty(DESCRIPTION, description);
    }

    public int getTimeout() {
        return this._getIntProperty(TIMEOUT, 0);
    }

    public void setTimeout(int timeout) {
        this._connectProperties.get().setProperty(TIMEOUT, String.valueOf(timeout));
    }

    public int getXATimeout() {
        return this._getIntProperty(XA_TIMEOUT, 30);
    }

    public void setXATimeout(int xatimeout) {
        this._connectProperties.get().setProperty(XA_TIMEOUT, String.valueOf(xatimeout));
    }

    public String getTrace() {
        return this._connectProperties.get().getProperty(ConnectionProperty.TRACE.getName());
    }

    public void setTrace(String trace) {
        this._connectProperties.get().setProperty(ConnectionProperty.TRACE.getName(), trace);
    }

    public String getTraceSize() {
        return this._connectProperties.get().getProperty(ConnectionProperty.TRACE_SIZE.getName());
    }

    public void setTraceSize(String traceSize) {
        this._connectProperties.get().setProperty(ConnectionProperty.TRACE_SIZE.getName(), traceSize);
    }

    public String getXATrace() {
        return this._connectProperties.get().getProperty(XA_TRACE);
    }

    public void setXATrace(String xatrace) {
        this._connectProperties.get().setProperty(XA_TRACE, xatrace);
    }

    private int _getIntProperty(String name, int defaultValue) {
        int result = defaultValue;
        String value = this._connectProperties.get().getProperty(name);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private Reference _createReference(String className) {
        Reference reference = new Reference(className, DataSourceSAPFactory.class.getCanonicalName(), null);
        Properties properties = (Properties)this._connectProperties.get().clone();
        reference.add(new StringRefAddr(ConnectionProperty.TRANSPORT.getName(), properties.getProperty(ConnectionProperty.TRANSPORT.getName(), ConnectionProperty.TRANSPORT.getDefaultValue())));
        reference.add(new StringRefAddr(LOGIN_TIMEOUT, properties.getProperty(LOGIN_TIMEOUT, String.valueOf(30))));
        reference.add(new StringRefAddr(XA_TIMEOUT, properties.getProperty(XA_TIMEOUT, String.valueOf(30))));
        for (String name : properties.stringPropertyNames()) {
            String value = properties.getProperty(name);
            if (value == null) continue;
            reference.add(new StringRefAddr(name, value));
        }
        return reference;
    }

    private String _buildURLFromServerNames() {
        String serverNames = this.getServerNames();
        return "jdbc:sap://" + (serverNames != null ? serverNames : this.getServerName() + ":" + this.getPort()) + "/";
    }

    private String _parseServerNamesFromURL(String url) {
        int closingSlashPos;
        String hosts;
        int urlLength = url.length();
        int slashPos = "jdbc:sap:".length();
        String delim = "";
        StringBuilder preferredHostList = new StringBuilder();
        if (urlLength >= slashPos + 3 && url.substring(slashPos, slashPos + 2).equals("//") && !(hosts = url.substring(slashPos + 2, closingSlashPos = url.indexOf(47, slashPos + 2))).isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(hosts, ";");
            while (tokenizer.hasMoreTokens()) {
                String port;
                String hostName;
                String host = tokenizer.nextToken();
                int pos = host.indexOf(58);
                if (pos == -1) {
                    hostName = host;
                    port = String.valueOf(30015);
                } else {
                    hostName = host.substring(0, pos);
                    port = host.substring(pos + 1);
                }
                preferredHostList.append(delim);
                preferredHostList.append(hostName);
                preferredHostList.append(":");
                preferredHostList.append(port);
                delim = ";";
            }
        }
        return preferredHostList.toString();
    }
}

