/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.DataFormatVersion;
import java.util.Map;
import java.util.TreeMap;

@Immutable
public enum ConnectionProperty {
    USER("user"),
    PASSWD(true, "password"),
    INSTANCE_NUMBER("instanceNumber"),
    KEY(true, "key"),
    VIRTUAL_HOST_NAME("virtualHostName"),
    DATABASE_NAME("databaseName"),
    ENCRYPT("encrypt", false),
    LOCALE("locale"),
    RECONNECT("reconnect", true),
    DISTRIBUTION("distribution", "STATEMENT"),
    LATENCY("latency", 0),
    COMMUNICATION_TIMEOUT("communicationTimeout", 0),
    PACKET_SIZE("packetSize", 130000),
    CLOSE_HANDLES_ON_FINALIZE("closeHandlesOnFinalize", true),
    SPLIT_BATCH_COMMANDS("splitBatchCommands", false),
    TRACE("trace"),
    EMPTY_TIMESTAMP_IS_NULL("emptyTimestampIsNull", true),
    IGNORE_TOPOLOGY("ignoreTopology", ""),
    VALIDATE_CERTIFICATE("validateCertificate", true),
    HOST_NAME_IN_CERTIFICATE("hostNameInCertificate"),
    KEY_STORE("keyStore"),
    KEY_STORE_TYPE("keyStoreType"),
    KEY_STORE_PASSWD(true, "keyStorePassword"),
    TRUST_STORE("trustStore"),
    TRUST_STORE_TYPE("trustStoreType"),
    TRUST_STORE_PASSWD(true, "trustStorePassword"),
    SNI_HOSTNAME("sniHostname"),
    PREFETCH("prefetch", true),
    COMPRESS("compress", false),
    PROXY_HOST_NAME("proxyHostName", ""),
    PROXY_PORT("proxyPort", 1080),
    PROXY_USER_NAME("proxyUserName", ""),
    PROXY_PASSWD(true, "proxyPassword", ""),
    PROXY_SCP_ACCOUNT("proxyScpAccount", ""),
    AUTO_COMMIT("autoCommit", true),
    READ_ONLY("readOnly", false),
    ISOLATION("isolation", "TRANSACTION_READ_COMMITTED"),
    CURRENT_SCHEMA("currentSchema"),
    DBURL("dburl"),
    HOSTLIST("hostlist"),
    AUTHENTICATION("authentication", false),
    NATIVE_AUTHENTICATION("nativeAuthentication", false),
    TRANSPORT("transport", "socket"),
    ASSOCIATED_CONNECTION_ID("associatedConnectionID"),
    CONNECTION_TRACE("connectionTrace"),
    TRACE_SIZE("traceSize"),
    DATA_FORMAT_SUPPORT("dataFormatSupport", DataFormatVersion.Level7.getValue()),
    SYSTEM_REPLICATION_PROTOCOL_VERSION("systemReplicationProtocolVersion", ActiveActiveProtocolVersion.Level2.getValue()),
    HINT_ROUTING_BACKOFF_MIN("hintRoutingBackoffMin", 5),
    HINT_ROUTING_BACKOFF_MAX("hintRoutingBackoffMax", 300),
    COMPRESS_LOCAL("compressLocal", false),
    DYNAMIC_FETCH_SIZE("dynamicFetchSize", true),
    INEXACT_DOUBLE_TO_DECIMAL_CONVERSION("inexactDoubleToDecimalConversion", false),
    PRIMARY_CONNECTION("primaryConnection", "ANCHOR");

    public static final String SESSION_VARIABLE_PREFIX = "sessionVariable:";
    public static final String JNI_AUTHENTICATION = "jniAuthentication";
    private static final Map<String, String> CANONICAL_NAME_MAP;
    private static final Map<String, ConnectionProperty> CONNECTION_PROPERTY_MAP;
    private final boolean _isPassword;
    private final String _canonicalName;
    private final String _defaultValue;

    public static String getCanonicalName(String name) {
        String canonicalName = CANONICAL_NAME_MAP.get(name);
        return canonicalName != null ? canonicalName : name;
    }

    public static ConnectionProperty getConnectionProperty(String name) {
        ConnectionProperty connectionProperty = CONNECTION_PROPERTY_MAP.get(name);
        return connectionProperty;
    }

    private ConnectionProperty(String canonicalName) {
        this(false, canonicalName, null);
    }

    private ConnectionProperty(String canonicalName, boolean defaultValue) {
        this(false, canonicalName, String.valueOf(defaultValue));
    }

    private ConnectionProperty(String canonicalName, int defaultValue) {
        this(false, canonicalName, String.valueOf(defaultValue));
    }

    private ConnectionProperty(String canonicalName, String defaultValue) {
        this(false, canonicalName, defaultValue);
    }

    private ConnectionProperty(boolean isPassword, String canonicalName) {
        this(isPassword, canonicalName, null);
    }

    private ConnectionProperty(boolean isPassword, String canonicalName, String defaultValue) {
        this._isPassword = isPassword;
        this._canonicalName = canonicalName;
        this._defaultValue = defaultValue;
    }

    public boolean isPassword() {
        return this._isPassword;
    }

    public String getName() {
        return this._canonicalName;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public String toString() {
        return this._canonicalName;
    }

    static {
        CANONICAL_NAME_MAP = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        CONNECTION_PROPERTY_MAP = new TreeMap<String, ConnectionProperty>();
        for (ConnectionProperty value : ConnectionProperty.values()) {
            CANONICAL_NAME_MAP.put(value._canonicalName, value._canonicalName);
            CONNECTION_PROPERTY_MAP.put(value._canonicalName, value);
        }
    }
}

