/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class BigIntConverter
extends AbstractNumericConverter {
    protected BigIntConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        return 9;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Long)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return 9;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Long)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Long value = (Long)data;
        return dataPart.putLongAsBigInt(value);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(Long.MAX_VALUE).length() + 1;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : Long.valueOf(this._getValueAsLong(controller, dataPart, false));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsLong(controller, dataPart, true) != 0L;
    }

    @Override
    public Long setBoolean(boolean value) throws SQLException {
        return value ? 1 : 0;
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (byte)this._getValueAsLong(controller, dataPart, true);
    }

    @Override
    public Long setByte(byte value) throws SQLException {
        return value;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (short)this._getValueAsLong(controller, dataPart, true);
    }

    @Override
    public Long setShort(short value) throws SQLException {
        return value;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (int)this._getValueAsLong(controller, dataPart, true);
    }

    @Override
    public Long setInt(int value) throws SQLException {
        return value;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsLong(controller, dataPart, true);
    }

    @Override
    public Long setLong(long value) throws SQLException {
        return value;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsLong(controller, dataPart, true);
    }

    @Override
    public Long setFloat(float value) throws SQLException {
        return (long)value;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsLong(controller, dataPart, true);
    }

    @Override
    public Long setDouble(double value) throws SQLException {
        return (long)value;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : BigDecimal.valueOf(this._getValueAsLong(controller, dataPart, false));
    }

    @Override
    public Long setBigDecimal(BigDecimal value) throws SQLException {
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : String.valueOf(this._getValueAsLong(controller, dataPart, false));
    }

    @Override
    public Long setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw this._newSetConversionException(value, "long");
        }
    }

    @Override
    public Long setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetConversionException(Arrays.toString(value));
        }
        return value[0] & 0xFF;
    }

    private long _getValueAsLong(SQLParamController controller, HDataPart dataPart, boolean doNullCheck) throws SQLException {
        if (doNullCheck && dataPart.isNull(controller)) {
            return 0L;
        }
        return dataPart.getBigIntAsLong();
    }
}

