/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.InputStreamFilter;
import com.sap.db.jdbc.converters.ReaderFilter;
import com.sap.db.jdbc.converters.ReaderInputStream;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class BinaryConverter
extends AbstractConverter {
    protected BinaryConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        int dataLen = this._length;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        int valueLength;
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte[] value = (byte[])data;
        int dataLen = valueLength = value.length;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen + 1;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte[] value = (byte[])data;
        return dataPart.putBytesAsBinary(value);
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        if (value instanceof byte[]) {
            return this.setBytes((byte[])value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart);
        return value != null && value.length > 0 ? value[0] : (byte)0;
    }

    public byte[] setByte(byte value) throws SQLException {
        return new byte[]{value};
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart);
        return value != null ? new String(value) : null;
    }

    public byte[] setString(String value) throws SQLException {
        return value != null ? value.getBytes() : null;
    }

    @Override
    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart);
    }

    public byte[] setBytes(byte[] value) throws SQLException {
        return value != null ? (byte[])value.clone() : null;
    }

    @Override
    public Reader getCharacterStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart);
        return value != null ? new StringReader(new String(value)) : null;
    }

    public byte[] setCharacterStream(Reader value, long length) throws SQLException {
        return value != null ? BinaryConverter._convertInputStreamToBytes(new ReaderInputStream(length >= 0L ? new ReaderFilter(value, length) : value, 256), -1L) : null;
    }

    @Override
    public InputStream getAsciiStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart);
        return value != null ? new ByteArrayInputStream(new String(value).getBytes(CHARSET_ISO_8859_1)) : null;
    }

    public byte[] setAsciiStream(InputStream value, long length) throws SQLException {
        return value != null ? BinaryConverter._convertInputStreamToBytes(new ReaderInputStream(new InputStreamReader(length >= 0L ? new InputStreamFilter(value, length) : value, CHARSET_ISO_8859_1), 4096), -1L) : null;
    }

    @Override
    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] value = this._getValueAsByteArray(controller, dataPart);
        return value != null ? new ByteArrayInputStream(value) : null;
    }

    public byte[] setBinaryStream(InputStream value, long length) throws SQLException {
        return value != null ? BinaryConverter._convertInputStreamToBytes(value, length) : null;
    }

    private byte[] _getValueAsByteArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        if (dataPart.isNull(controller)) {
            return null;
        }
        return dataPart.getBinaryAsBytes();
    }
}

