/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class IntConverter
extends AbstractNumericConverter {
    protected IntConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        return 5;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Integer)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return 5;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Integer)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Integer value = (Integer)data;
        return dataPart.putIntAsInt(value);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(Integer.MAX_VALUE).length() + 1;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : Integer.valueOf(this._getValueAsInt(controller, dataPart, false));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true) != 0;
    }

    @Override
    public Integer setBoolean(boolean value) throws SQLException {
        return value ? 1 : 0;
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (byte)this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public Integer setByte(byte value) throws SQLException {
        return value;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (short)this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public Integer setShort(short value) throws SQLException {
        return value;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public Integer setInt(int value) throws SQLException {
        return value;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public Integer setLong(long value) throws SQLException {
        return (int)value;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public Integer setFloat(float value) throws SQLException {
        return (int)value;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public Integer setDouble(double value) throws SQLException {
        return (int)value;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : BigDecimal.valueOf(this._getValueAsInt(controller, dataPart, false));
    }

    @Override
    public Integer setBigDecimal(BigDecimal value) throws SQLException {
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : String.valueOf(this._getValueAsInt(controller, dataPart, false));
    }

    @Override
    public Integer setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            throw this._newSetConversionException(value, "int");
        }
    }

    @Override
    public Integer setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetConversionException(Arrays.toString(value));
        }
        return value[0] & 0xFF;
    }

    private int _getValueAsInt(SQLParamController controller, HDataPart dataPart, boolean doNullCheck) throws SQLException {
        if (doNullCheck && dataPart.isNull(controller)) {
            return 0;
        }
        return dataPart.getIntAsInt();
    }
}

