/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.DemoApp;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.ui.GTable;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.ImageLabel;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public abstract class AddOrChangeAbstract
extends JDialog {
    private static Logger _logger = Logger.getLogger(AddOrChangeAbstract.class);
    private static final long serialVersionUID = 1L;
    public static final ImageIcon NO_PICTURE = SwingUtils.readImageIcon(DemoApp.class, "images/no_photo.jpg");
    public static final int MAX_PICTURE_SIZE = 51200;
    public static final String PROPKEY_APP_PREFIX = "DemoClient.";
    public static final String PROPKEY_blankToNull = "DemoClient.AddOrChange.blank.to.null";
    public static final boolean DEFAULT_blankToNull = false;
    protected String _name = "";
    protected Window _owner = null;
    private OpType _opType;
    private ConnectionProvider _connProvider = null;
    private JLabel _description = new JLabel();
    private JLabel _deleteWarning = new JLabel("<html><font color=\"red\">Are you <b>sure</b> you want to delete</font></html>");
    private JLabel _problemDesc = new JLabel();
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    protected int _ret = -1;
    protected int _status = 0;
    public static final int CANCEL = -1;
    public static final int OK = 1;
    public static final int UNKNOWN = 0;
    public static final int FAIL = -1;
    public static final int SUCCESS = 1;
    protected JLabel _picture_lbl = new JLabel("Picture");
    protected JTextField _picture_txt = new JTextField();
    protected JButton _picture_but = new JButton("...");
    protected ImageLabel _picture_ilbl = new ImageLabel(NO_PICTURE, new Dimension(170, 220));
    protected byte[] _picture_ba = null;
    protected String _picture_lastLoaded = "";

    private boolean getConf_blankToNull() {
        return Configuration.getCombinedConfiguration().getBooleanProperty(PROPKEY_blankToNull, false);
    }

    private static String createDescription(OpType type, String name) {
        String prefix = "UNKNOWN";
        String suffix = "";
        switch (type) {
            case INSERT: {
                prefix = "New ";
                suffix = ".";
                break;
            }
            case UPDATE: {
                prefix = "Change ";
                suffix = " details.";
                break;
            }
            case DELETE: {
                prefix = "Remove ";
                suffix = " details.";
            }
        }
        return prefix + name + suffix;
    }

    public AddOrChangeAbstract(String name, Window owner, ConnectionProvider connProvider, OpType opType) {
        super(owner, AddOrChangeAbstract.createDescription(opType, name), Dialog.ModalityType.APPLICATION_MODAL);
        this._name = name;
        this._owner = owner;
        this._connProvider = connProvider;
        this._opType = opType;
    }

    protected void init() {
        this.setLayout((LayoutManager)new MigLayout());
        this._description.setText(AddOrChangeAbstract.createDescription(this._opType, this._name));
        this._description.setFont(new Font("Dialog", 1, 14));
        this._problemDesc.setForeground(Color.RED);
        this.add((Component)this._description, "span, wrap 15");
        this.add((Component)this.createPanel(), "grow, push, wrap");
        this.add((Component)new JLabel(), "split, span, growx, pushx");
        this.add((Component)this._problemDesc, "hidemode 3");
        this.add((Component)this._deleteWarning, "hidemode 3");
        this.add((Component)this._ok, "tag ok");
        this.add((Component)this._cancel, "tag cancel");
        this._deleteWarning.setVisible(false);
        if (OpType.DELETE.equals((Object)this._opType)) {
            this._deleteWarning.setVisible(true);
        }
        if (this.isDelete()) {
            this._picture_txt.setEnabled(false);
            this._picture_but.setEnabled(false);
        }
        this._cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddOrChangeAbstract.this._ret = -1;
                AddOrChangeAbstract.this.setVisible(false);
            }
        });
        this._ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddOrChangeAbstract.this._status = -1;
                switch (AddOrChangeAbstract.this._opType) {
                    case INSERT: {
                        if (!AddOrChangeAbstract.this.internal_doInsert()) break;
                        AddOrChangeAbstract.this._status = 1;
                        break;
                    }
                    case UPDATE: {
                        if (!AddOrChangeAbstract.this.internal_doUpdate()) break;
                        AddOrChangeAbstract.this._status = 1;
                        break;
                    }
                    case DELETE: {
                        if (!AddOrChangeAbstract.this.internal_doDelete()) break;
                        AddOrChangeAbstract.this._status = 1;
                    }
                }
                if (AddOrChangeAbstract.this._status == 1) {
                    AddOrChangeAbstract.this._ret = 1;
                    AddOrChangeAbstract.this.setVisible(false);
                }
                if (DemoApp.hasInstance()) {
                    DemoApp.getInstance().refreshStatusBar();
                }
            }
        });
        this._picture_but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(AddOrChangeAbstract.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    AddOrChangeAbstract.this.loadImage(file.toString());
                }
            }
        });
        this._picture_txt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddOrChangeAbstract.this.loadImage(AddOrChangeAbstract.this._picture_txt.getText());
            }
        });
        this._picture_txt.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AddOrChangeAbstract.this.loadImage(AddOrChangeAbstract.this._picture_txt.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.pack();
        this.setLocationRelativeTo(this._owner);
        this.validateContent();
    }

    public void validateContent() {
        String problem = this.getProblemText();
        if (problem == null) {
            this._ok.setEnabled(true);
            this._problemDesc.setText("");
        } else {
            this._ok.setEnabled(false);
            this._problemDesc.setText(problem);
        }
    }

    public String getProblemText() {
        return null;
    }

    public Object sqlFix(Object obj, boolean addQuotes) {
        return this.sqlFix(obj, true, addQuotes);
    }

    public Object sqlFix(Object obj, boolean emptyStringToNull, boolean addQuotes) {
        if (obj == null) {
            return "NULL";
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (emptyStringToNull && "".equals(str)) {
                return "NULL";
            }
            if (str.equalsIgnoreCase("null")) {
                return "NULL";
            }
            if (addQuotes) {
                str = str.replace("'", "''");
                return "'" + str + "'";
            }
            return str;
        }
        return obj;
    }

    public String getStringValue(JTextField field) {
        return this.getStringValue(field, this.getConf_blankToNull());
    }

    public String getStringValue(JTextField field, boolean emptyIsNull) {
        String str = field.getText();
        if (str == null) {
            return null;
        }
        if (str.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (emptyIsNull && str.trim().equals("")) {
            return null;
        }
        return str;
    }

    public BigDecimal getBigDecimalValue(JFormattedTextField field) {
        Object o = field.getValue();
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return new BigDecimal(((Number)o).doubleValue());
        }
        try {
            return new BigDecimal(o.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public BigDecimal getBigDecimalValue(JTextField field) {
        String str = field.getText();
        if (str == null) {
            return null;
        }
        if (str.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (str.trim().equals("")) {
            return null;
        }
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getPicture() {
        return this._picture_ba;
    }

    public int open() {
        this.setVisible(true);
        return this._ret;
    }

    public int getStatus() {
        return this._status;
    }

    public OpType getOpType() {
        return this._opType;
    }

    public boolean isInsert() {
        return OpType.INSERT.equals((Object)this._opType);
    }

    public boolean isUpdate() {
        return OpType.UPDATE.equals((Object)this._opType);
    }

    public boolean isDelete() {
        return OpType.DELETE.equals((Object)this._opType);
    }

    public ConnectionProvider getConnectionProvider() {
        return this._connProvider;
    }

    public Connection getConnection() throws SQLException {
        return this._connProvider.getConnection();
    }

    public abstract void setFields(GTable var1, int var2);

    public abstract JPanel createPanel();

    public abstract boolean doInsert();

    public abstract boolean doUpdate();

    public abstract boolean doDelete();

    private boolean internal_doInsert() {
        boolean retval = this.doInsert();
        SqlStatement.showWarningMessages(this.getConnectionProvider(), this.getOwner(), "Warning messages from db for: " + this.getName());
        return retval;
    }

    private boolean internal_doUpdate() {
        boolean retval = this.doUpdate();
        SqlStatement.showWarningMessages(this.getConnectionProvider(), this.getOwner(), "Warning messages from db for: " + this.getName());
        return retval;
    }

    private boolean internal_doDelete() {
        boolean retval = this.doDelete();
        SqlStatement.showWarningMessages(this.getConnectionProvider(), this.getOwner(), "Warning messages from db for: " + this.getName());
        return retval;
    }

    public byte[] getImageFromDb(String procStr, String keyCol, Integer key) {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, procStr);
        stmnt.addParam(SqlStatementParam.createInParam(keyCol, 4, key));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        try {
            ResultSet rs = stmnt.executeQuery(this.getConnectionProvider());
            byte[] ba = null;
            while (rs.next()) {
                ba = rs.getBytes(1);
            }
            SqlStatement.putWarningMessages(this.getConnectionProvider(), null, rs);
            rs.close();
            return ba;
        }
        catch (SQLException e) {
            SqlStatement.showErrorMessage(e, stmnt, this.getOwner(), "Getting Picture <b>failed.</b>");
            return null;
        }
    }

    private byte[] compressImage(BufferedImage image, float quality) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("jpeg");
        if (!writers.hasNext()) {
            throw new IllegalStateException("No writers found");
        }
        ImageWriter writer = writers.next();
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionQuality(quality);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(32768);
        ImageOutputStream ios = ImageIO.createImageOutputStream(bos);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(image, null, null), param);
        ios.flush();
        return bos.toByteArray();
    }

    protected void loadImage(String fileStr) {
        if (StringUtil.isNullOrBlank(fileStr)) {
            return;
        }
        if (fileStr.equals(this._picture_lastLoaded)) {
            _logger.info((Object)("loadImage(): The filename '" + fileStr + "' already seems to be loaded..."));
            return;
        }
        try {
            File f = new File(fileStr);
            byte[] imageData = new byte[(int)f.length()];
            DataInputStream dis = new DataInputStream(new FileInputStream(f));
            dis.readFully(imageData);
            dis.close();
            if (f.length() > 51200L) {
                ByteArrayInputStream in = new ByteArrayInputStream(imageData);
                BufferedImage bImageFromConvert = ImageIO.read(in);
                long compSize = f.length();
                float compQuality = 1.0f;
                float[] compQualities = new float[]{1.0f, 0.9f, 0.8f, 0.7f, 0.6f, 0.5f, 0.4f, 0.3f, 0.2f, 0.1f, 0.09f, 0.08f, 0.097f, 0.06f, 0.05f, 0.04f, 0.03f, 0.02f, 0.01f};
                for (int cr = 0; cr < compQualities.length && (compSize = (long)(imageData = this.compressImage(bImageFromConvert, compQuality = compQualities[cr])).length) >= 51200L; ++cr) {
                }
                if (compSize < 51200L) {
                    String htmlMsg = "<html>I had to <b>compress</b> the picture, it was above the limit.<br>The maximum uncompressed size is " + StringUtil.bytesToHuman(51200L) + "<br><br>The origin file: " + f + "<br>The origin size was " + StringUtil.bytesToHuman(f.length()) + "<br><br>The used compression quality was " + compQuality + "<br>The final compressed size was " + StringUtil.bytesToHuman(compSize) + "<br><br><i>JPEG files is preferred, other filetypes might not compress well.</i><br></html>";
                    SwingUtils.showWarnMessage(this, "Picture was compressed", htmlMsg, null);
                } else {
                    String htmlMsg = "<html>File size it <b>to large</b><br><b>Sorry</b> you can't use this file!<br><br>The file: " + f + "<br>The origin size was " + StringUtil.bytesToHuman(f.length()) + "<br><br>The result of unsuccessful compression:<br>The lowest used compression quality was " + compQuality + "<br>The lowest compressed size achived was " + StringUtil.bytesToHuman(compSize) + "<br><br><i>JPEG files is preferred, other filetypes might not compress well.</i><br><br>The maximum allowed size is <b>" + StringUtil.bytesToHuman(51200L) + "</b><br><b>You need to choose another file</b><br><br></html>";
                    SwingUtils.showErrorMessage(this, "Problem", htmlMsg, null);
                    return;
                }
            }
            ImageIcon pic = new ImageIcon(imageData);
            this._picture_ilbl.setIcon(pic);
            this._picture_txt.setText(fileStr);
            this._picture_ba = imageData;
            this._picture_lastLoaded = fileStr;
        }
        catch (Throwable e) {
            String htmlMsg = "<html>Reading file <b>failed.</b><br><br>Exception: " + e + "<br><br></html>";
            SwingUtils.showErrorMessage(this, "Problem", htmlMsg, e);
        }
    }

    protected void loadImage(byte[] image) {
        if (image == null) {
            return;
        }
        ImageIcon pic = new ImageIcon(image);
        this._picture_ilbl.setIcon(pic);
    }

    public static enum OpType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

