/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.AddOrChangeAbstract;
import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.ui.GTable;
import com.sap.dbmtk.demo.utils.DbUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class AddOrChangeAuthor
extends AddOrChangeAbstract {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Author";
    private int _au_id = -1;
    private JLabel _au_id_lbl = new JLabel("au_id");
    private JTextField _au_id_txt = new JTextField(10);
    private JLabel _fname_lbl = new JLabel("First Name");
    private JTextField _fname_txt = new JTextField(50);
    private JLabel _lname_lbl = new JLabel("Last Name");
    private JTextField _lname_txt = new JTextField();
    private JLabel _phone_lbl = new JLabel("Phone");
    private JTextField _phone_txt = new JTextField();
    private JLabel _address_lbl = new JLabel("Address");
    private JTextField _address_txt = new JTextField();
    private JLabel _state_lbl = new JLabel("State");
    private JTextField _state_txt = new JTextField();
    private JLabel _city_lbl = new JLabel("City");
    private JTextField _city_txt = new JTextField();
    private JLabel _country_lbl = new JLabel("Country");
    private JTextField _country_txt = new JTextField();
    private JLabel _postalcode_lbl = new JLabel("Postal Code");
    private JTextField _postalcode_txt = new JTextField();

    public AddOrChangeAuthor(Window owner, ConnectionProvider connProvider, AddOrChangeAbstract.OpType opType) {
        super(NAME, owner, connProvider, opType);
        super.init();
    }

    @Override
    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        if (this.isUpdate() || this.isDelete()) {
            this._au_id_txt.setEnabled(false);
            panel.add((Component)this._au_id_lbl, "");
            panel.add((Component)this._au_id_txt, "growx, pushx, wrap 20");
        }
        panel.add((Component)this._fname_lbl, "");
        panel.add((Component)this._fname_txt, "growx, pushx, wrap");
        panel.add((Component)this._lname_lbl, "");
        panel.add((Component)this._lname_txt, "growx, pushx, wrap");
        panel.add((Component)this._phone_lbl, "");
        panel.add((Component)this._phone_txt, "growx, pushx, wrap");
        panel.add((Component)this._address_lbl, "");
        panel.add((Component)this._address_txt, "growx, pushx, wrap");
        panel.add((Component)this._city_lbl, "");
        panel.add((Component)this._city_txt, "growx, pushx, wrap");
        panel.add((Component)this._state_lbl, "");
        panel.add((Component)this._state_txt, "growx, pushx, wrap");
        panel.add((Component)this._country_lbl, "");
        panel.add((Component)this._country_txt, "growx, pushx, wrap");
        panel.add((Component)this._postalcode_lbl, "");
        panel.add((Component)this._postalcode_txt, "growx, pushx, wrap");
        panel.add((Component)this._picture_lbl, "");
        panel.add((Component)this._picture_txt, "split, growx, pushx");
        panel.add((Component)this._picture_but, "wrap 20");
        panel.add((Component)this._picture_ilbl, "center, width 85:170:400, height 220:220:220, gapright 10, dock west, wrap");
        if (this.isDelete()) {
            this._fname_txt.setEnabled(false);
            this._lname_txt.setEnabled(false);
            this._phone_txt.setEnabled(false);
            this._address_txt.setEnabled(false);
            this._city_txt.setEnabled(false);
            this._state_txt.setEnabled(false);
            this._country_txt.setEnabled(false);
            this._postalcode_txt.setEnabled(false);
        }
        return panel;
    }

    private byte[] getImageFromDb(int au_id) {
        return this.getImageFromDb("{call get_author_picture(?,?)}", "au_id", au_id);
    }

    @Override
    public void setFields(GTable table, int vrow) {
        this._au_id = table.getValueAsInteger(vrow, "au_id", false);
        this._au_id_txt.setText(this._au_id + "");
        this._fname_txt.setText(table.getValueAsString(vrow, "first_name", false));
        this._lname_txt.setText(table.getValueAsString(vrow, "last_name", false));
        this._phone_txt.setText(table.getValueAsString(vrow, "phone", false));
        this._address_txt.setText(table.getValueAsString(vrow, "address", false));
        this._city_txt.setText(table.getValueAsString(vrow, "city", false));
        this._state_txt.setText(table.getValueAsString(vrow, "state", false));
        this._country_txt.setText(table.getValueAsString(vrow, "country", false));
        this._postalcode_txt.setText(table.getValueAsString(vrow, "postalcode", false));
        byte[] ba = this.getImageFromDb(this._au_id);
        this.loadImage(ba);
    }

    public String getFirstName() {
        return this.getStringValue(this._fname_txt);
    }

    public String getLastName() {
        return this.getStringValue(this._lname_txt);
    }

    public String getPhone() {
        return this.getStringValue(this._phone_txt);
    }

    public String getAddress() {
        return this.getStringValue(this._address_txt);
    }

    public String getCity() {
        return this.getStringValue(this._city_txt);
    }

    public String getState() {
        return this.getStringValue(this._state_txt);
    }

    public String getCountry() {
        return this.getStringValue(this._country_txt);
    }

    public String getPostalcode() {
        return this.getStringValue(this._postalcode_txt);
    }

    @Override
    public boolean doInsert() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call insert_author(?, ?, ?, ?, ?, ?, ?, ?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("first_name", 12, this.getFirstName()));
        stmnt.addParam(SqlStatementParam.createInParam("last_name", 12, this.getLastName()));
        stmnt.addParam(SqlStatementParam.createInParam("phone", 12, this.getPhone()));
        stmnt.addParam(SqlStatementParam.createInParam("address", 12, this.getAddress()));
        stmnt.addParam(SqlStatementParam.createInParam("city", 12, this.getCity()));
        stmnt.addParam(SqlStatementParam.createInParam("state", 12, this.getState()));
        stmnt.addParam(SqlStatementParam.createInParam("country", 12, this.getCountry()));
        stmnt.addParam(SqlStatementParam.createInParam("postalcode", 12, this.getPostalcode()));
        stmnt.addParam(SqlStatementParam.createInParam("picture", 2004, this.getPicture()));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Adding Author information <b>failed.</b>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doUpdate() {
        SqlStatement stmnt = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (this.getConnectionProvider().isAutoCommitEnabledAtConnect()) {
                DbUtils.setAutoCommit(conn, null, this.getOwner(), false, "Add or Change Author Dialog");
            }
            stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call update_author(?, ?, ?, ?, ?, ?, ?, ?, ?)}");
            stmnt.addParam(SqlStatementParam.createInParam("au_id", 4, this._au_id));
            stmnt.addParam(SqlStatementParam.createInParam("first_name", 12, this.getFirstName()));
            stmnt.addParam(SqlStatementParam.createInParam("last_name", 12, this.getLastName()));
            stmnt.addParam(SqlStatementParam.createInParam("phone", 12, this.getPhone()));
            stmnt.addParam(SqlStatementParam.createInParam("address", 12, this.getAddress()));
            stmnt.addParam(SqlStatementParam.createInParam("city", 12, this.getCity()));
            stmnt.addParam(SqlStatementParam.createInParam("state", 12, this.getState()));
            stmnt.addParam(SqlStatementParam.createInParam("country", 12, this.getCountry()));
            stmnt.addParam(SqlStatementParam.createInParam("postalcode", 12, this.getPostalcode()));
            stmnt.executeWithGuiProgress(this.getConnectionProvider(), this.getOwner());
            if (this.getPicture() != null) {
                stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call update_author_picture(?, ?)}");
                stmnt.addParam(SqlStatementParam.createInParam("au_id", 4, this._au_id));
                stmnt.addParam(SqlStatementParam.createInParam("picture", 2004, this.getPicture()));
                stmnt.executeWithGuiProgress(this.getConnectionProvider(), this.getOwner());
            }
            conn.commit();
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            SqlStatement.showErrorMessage(ex, stmnt, this._owner, "Updating Author information <b>failed.</b>");
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    SqlStatement.showErrorMessage(ex2, stmnt, this._owner, "Error when rolling back the executed statements");
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null && this.getConnectionProvider().isAutoCommitEnabledAtConnect()) {
                DbUtils.setAutoCommit(conn, null, this.getOwner(), true, "Add or Change Author Dialog");
            }
        }
    }

    @Override
    public boolean doDelete() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call delete_author(?)}");
        stmnt.addParam(SqlStatementParam.createInParam("au_id", 4, this._au_id));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Deleting Author information <b>failed.</b>");
    }
}

