/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.AddOrChangeAbstract;
import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.ui.GTable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class AddOrChangePublisher
extends AddOrChangeAbstract {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Publisher";
    private int _pub_id = -1;
    private JLabel _pub_id_lbl = new JLabel("pub_id");
    private JTextField _pub_id_txt = new JTextField(10);
    private JLabel _pub_name_lbl = new JLabel("Publisher Name");
    private JTextField _pub_name_txt = new JTextField(50);
    private JLabel _city_lbl = new JLabel("City");
    private JTextField _city_txt = new JTextField();
    private JLabel _state_lbl = new JLabel("State");
    private JTextField _state_txt = new JTextField();

    public AddOrChangePublisher(Window owner, ConnectionProvider connProvider, AddOrChangeAbstract.OpType opType) {
        super(NAME, owner, connProvider, opType);
        super.init();
    }

    @Override
    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        if (this.isUpdate() || this.isDelete()) {
            this._pub_id_txt.setEnabled(false);
            panel.add((Component)this._pub_id_lbl, "");
            panel.add((Component)this._pub_id_txt, "growx, pushx, wrap 20");
        }
        panel.add((Component)this._pub_name_lbl, "");
        panel.add((Component)this._pub_name_txt, "growx, pushx, wrap");
        panel.add((Component)this._city_lbl, "");
        panel.add((Component)this._city_txt, "growx, pushx, wrap");
        panel.add((Component)this._state_lbl, "");
        panel.add((Component)this._state_txt, "growx, pushx, wrap 20");
        if (this.isDelete()) {
            this._pub_name_txt.setEnabled(false);
            this._city_txt.setEnabled(false);
            this._state_txt.setEnabled(false);
        }
        return panel;
    }

    @Override
    public void setFields(GTable table, int vrow) {
        this._pub_id = table.getValueAsInteger(vrow, "pub_id", false);
        this._pub_id_txt.setText(this._pub_id + "");
        this._pub_name_txt.setText(table.getValueAsString(vrow, "publisher_name", false));
        this._city_txt.setText(table.getValueAsString(vrow, "city", false));
        this._state_txt.setText(table.getValueAsString(vrow, "state", false));
    }

    public String getPubName() {
        return this.getStringValue(this._pub_name_txt);
    }

    public String getCity() {
        return this.getStringValue(this._city_txt);
    }

    public String getState() {
        return this.getStringValue(this._state_txt);
    }

    @Override
    public boolean doInsert() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call insert_publisher(?, ?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("pub_name", 12, this.getPubName()));
        stmnt.addParam(SqlStatementParam.createInParam("city", 12, this.getCity()));
        stmnt.addParam(SqlStatementParam.createInParam("state", 12, this.getState()));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Adding Publisher information <b>failed.</b>");
    }

    @Override
    public boolean doUpdate() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call update_publisher(?, ?, ?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("pub_id", 4, this._pub_id));
        stmnt.addParam(SqlStatementParam.createInParam("pub_name", 12, this.getPubName()));
        stmnt.addParam(SqlStatementParam.createInParam("city", 12, this.getCity()));
        stmnt.addParam(SqlStatementParam.createInParam("state", 12, this.getState()));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Updating Publisher information <b>failed.</b>");
    }

    @Override
    public boolean doDelete() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call delete_publisher(?)}");
        stmnt.addParam(SqlStatementParam.createInParam("pub_id", 4, this._pub_id));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Deleting Publisher information <b>failed.</b>");
    }
}

