/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.AddOrChangeAbstract;
import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.ui.GTable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class AddOrChangeStore
extends AddOrChangeAbstract {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Store";
    private int _store_id = -1;
    private JLabel _store_id_lbl = new JLabel("store_id");
    private JTextField _store_id_txt = new JTextField(10);
    private JLabel _store_name_lbl = new JLabel("Store Name");
    private JTextField _store_name_txt = new JTextField(50);
    private JLabel _address_lbl = new JLabel("Address");
    private JTextField _address_txt = new JTextField();
    private JLabel _city_lbl = new JLabel("City");
    private JTextField _city_txt = new JTextField();
    private JLabel _state_lbl = new JLabel("State");
    private JTextField _state_txt = new JTextField();
    private JLabel _country_lbl = new JLabel("Country");
    private JTextField _country_txt = new JTextField();
    private JLabel _postalcode_lbl = new JLabel("Postal Code");
    private JTextField _postalcode_txt = new JTextField();

    public AddOrChangeStore(Window owner, ConnectionProvider connProvider, AddOrChangeAbstract.OpType opType) {
        super(NAME, owner, connProvider, opType);
        super.init();
    }

    @Override
    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        if (this.isUpdate() || this.isDelete()) {
            this._store_id_txt.setEnabled(false);
            panel.add((Component)this._store_id_lbl, "");
            panel.add((Component)this._store_id_txt, "growx, pushx, wrap 20");
        }
        panel.add((Component)this._store_name_lbl, "");
        panel.add((Component)this._store_name_txt, "growx, pushx, wrap");
        panel.add((Component)this._address_lbl, "");
        panel.add((Component)this._address_txt, "growx, pushx, wrap");
        panel.add((Component)this._city_lbl, "");
        panel.add((Component)this._city_txt, "growx, pushx, wrap");
        panel.add((Component)this._state_lbl, "");
        panel.add((Component)this._state_txt, "growx, pushx, wrap");
        panel.add((Component)this._country_lbl, "");
        panel.add((Component)this._country_txt, "growx, pushx, wrap");
        panel.add((Component)this._postalcode_lbl, "");
        panel.add((Component)this._postalcode_txt, "growx, pushx, wrap 20");
        if (this.isDelete()) {
            this._store_name_txt.setEnabled(false);
            this._address_txt.setEnabled(false);
            this._city_txt.setEnabled(false);
            this._state_txt.setEnabled(false);
            this._country_txt.setEnabled(false);
            this._postalcode_txt.setEnabled(false);
        }
        return panel;
    }

    @Override
    public void setFields(GTable table, int vrow) {
        this._store_id = table.getValueAsInteger(vrow, "store_id", false);
        this._store_id_txt.setText("" + this._store_id);
        this._store_name_txt.setText(table.getValueAsString(vrow, "store_name", false));
        this._address_txt.setText(table.getValueAsString(vrow, "address", false));
        this._city_txt.setText(table.getValueAsString(vrow, "city", false));
        this._state_txt.setText(table.getValueAsString(vrow, "state", false));
        this._country_txt.setText(table.getValueAsString(vrow, "country", false));
        this._postalcode_txt.setText(table.getValueAsString(vrow, "postalcode", false));
    }

    public String getStoreName() {
        return this.getStringValue(this._store_name_txt);
    }

    public String getAddress() {
        return this.getStringValue(this._address_txt);
    }

    public String getCity() {
        return this.getStringValue(this._city_txt);
    }

    public String getState() {
        return this.getStringValue(this._state_txt);
    }

    public String getCountry() {
        return this.getStringValue(this._country_txt);
    }

    public String getPostalCode() {
        return this.getStringValue(this._postalcode_txt);
    }

    @Override
    public boolean doInsert() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call insert_store(?, ?, ?, ?, ?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("first_name", 12, this.getStoreName()));
        stmnt.addParam(SqlStatementParam.createInParam("last_name", 12, this.getAddress()));
        stmnt.addParam(SqlStatementParam.createInParam("phone", 12, this.getCity()));
        stmnt.addParam(SqlStatementParam.createInParam("address", 12, this.getState()));
        stmnt.addParam(SqlStatementParam.createInParam("city", 12, this.getCountry()));
        stmnt.addParam(SqlStatementParam.createInParam("state", 12, this.getPostalCode()));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Adding Store information <b>failed.</b>");
    }

    @Override
    public boolean doUpdate() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call update_store(?, ?, ?, ?, ?, ?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("store_id", 4, this._store_id));
        stmnt.addParam(SqlStatementParam.createInParam("first_name", 12, this.getStoreName()));
        stmnt.addParam(SqlStatementParam.createInParam("last_name", 12, this.getAddress()));
        stmnt.addParam(SqlStatementParam.createInParam("phone", 12, this.getCity()));
        stmnt.addParam(SqlStatementParam.createInParam("address", 12, this.getState()));
        stmnt.addParam(SqlStatementParam.createInParam("city", 12, this.getCountry()));
        stmnt.addParam(SqlStatementParam.createInParam("state", 12, this.getPostalCode()));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Updating Store information <b>failed.</b>");
    }

    @Override
    public boolean doDelete() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call delete_store(?)}");
        stmnt.addParam(SqlStatementParam.createInParam("store_id", 4, this._store_id));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Deleting Store information <b>failed.</b>");
    }
}

