/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.AddOrChangeAbstract;
import com.sap.dbmtk.demo.ConnectionProvider;
import com.sap.dbmtk.demo.SqlPickList;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.SqlTraceWindow;
import com.sap.dbmtk.demo.ui.GTable;
import com.sap.dbmtk.demo.utils.DbUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;

public class AddOrChangeTitle
extends AddOrChangeAbstract
implements ActionListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Title";
    private int _title_id = -1;
    private JLabel _title_id_lbl = new JLabel("title_id");
    private JTextField _title_id_txt = new JTextField(10);
    private JLabel _title_lbl = new JLabel("Title");
    private JTextField _title_txt = new JTextField(50);
    private JLabel _type_lbl = new JLabel("Type");
    private JTextField _type_txt = new JTextField();
    private JLabel _isbn_lbl = new JLabel("ISBN");
    private JTextField _isbn_txt = new JTextField();
    private JLabel _pubdate_lbl = new JLabel("Publication Date");
    private JXDatePicker _pubdate_dtp = new JXDatePicker();
    private JLabel _price_lbl = new JLabel("Price");
    private JTextField _price_txt = new JTextField();
    private JLabel _advance_lbl = new JLabel("Advance");
    private JTextField _advance_txt = new JTextField();
    private JLabel _total_sales_lbl = new JLabel("Total Sales");
    private JTextField _total_sales_txt = new JTextField();
    private JLabel _notes_lbl = new JLabel("Notes");
    private JTextField _notes_txt = new JTextField();
    private JLabel _contract_lbl = new JLabel("Contract");
    private JTextField _contract_txt = new JTextField();
    private JLabel _author_lbl = new JLabel("Author");
    private JLabel _authorFn_lbl = new JLabel("First Name");
    private JLabel _authorLn_lbl = new JLabel("Last Name");
    private JTextField _authorFn_txt = new JTextField();
    private JTextField _authorLn_txt = new JTextField();
    private JButton _author_but = new JButton("...");
    private JLabel _publisher_lbl = new JLabel("Publisher");
    private JTextField _publisher_txt = new JTextField();
    private JButton _publisher_but = new JButton("...");

    public AddOrChangeTitle(Window owner, ConnectionProvider connProvider, AddOrChangeAbstract.OpType opType) {
        super(NAME, owner, connProvider, opType);
        super.init();
    }

    @Override
    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        if (this.isUpdate() || this.isDelete()) {
            this._title_id_txt.setEnabled(false);
            panel.add((Component)this._title_id_lbl, "");
            panel.add((Component)this._title_id_txt, "growx, pushx, wrap 20");
        }
        panel.add((Component)this._title_lbl, "");
        panel.add((Component)this._title_txt, "growx, pushx, wrap");
        panel.add((Component)this._type_lbl, "");
        panel.add((Component)this._type_txt, "growx, pushx, wrap");
        panel.add((Component)this._isbn_lbl, "");
        panel.add((Component)this._isbn_txt, "growx, pushx, wrap");
        panel.add((Component)this._pubdate_lbl, "");
        panel.add((Component)this._pubdate_dtp, "growx, pushx, wrap");
        panel.add((Component)this._price_lbl, "");
        panel.add((Component)this._price_txt, "growx, pushx, wrap");
        panel.add((Component)this._advance_lbl, "");
        panel.add((Component)this._advance_txt, "growx, pushx, wrap");
        panel.add((Component)this._total_sales_lbl, "");
        panel.add((Component)this._total_sales_txt, "growx, pushx, wrap");
        panel.add((Component)this._notes_lbl, "");
        panel.add((Component)this._notes_txt, "growx, pushx, wrap");
        panel.add((Component)this._contract_lbl, "");
        panel.add((Component)this._contract_txt, "growx, pushx, wrap");
        panel.add((Component)this._author_lbl, "");
        panel.add((Component)this._authorFn_lbl, "split");
        panel.add((Component)this._authorFn_txt, "growx, pushx");
        panel.add((Component)this._authorLn_lbl, "");
        panel.add((Component)this._authorLn_txt, "growx, pushx");
        panel.add((Component)this._author_but, "wrap");
        panel.add((Component)this._publisher_lbl, "");
        panel.add((Component)this._publisher_txt, "split, growx, pushx");
        panel.add((Component)this._publisher_but, "wrap");
        panel.add((Component)this._picture_lbl, "");
        panel.add((Component)this._picture_txt, "split, growx, pushx");
        panel.add((Component)this._picture_but, "wrap 20");
        panel.add((Component)this._picture_ilbl, "center, width 85:170:400, height 220:220:220, gapright 10, dock west, wrap");
        if (this.isDelete()) {
            this._title_txt.setEnabled(false);
            this._type_txt.setEnabled(false);
            this._isbn_txt.setEnabled(false);
            this._pubdate_dtp.setEnabled(false);
            this._price_txt.setEnabled(false);
            this._advance_txt.setEnabled(false);
            this._total_sales_txt.setEnabled(false);
            this._notes_txt.setEnabled(false);
            this._contract_txt.setEnabled(false);
            this._authorFn_txt.setEnabled(false);
            this._authorLn_txt.setEnabled(false);
            this._author_but.setEnabled(false);
            this._publisher_txt.setEnabled(false);
            this._publisher_but.setEnabled(false);
        }
        this._authorFn_txt.addActionListener(this);
        this._authorLn_txt.addActionListener(this);
        this._author_but.addActionListener(this);
        this._publisher_txt.addActionListener(this);
        this._publisher_but.addActionListener(this);
        this._title_txt.addKeyListener(this);
        this._isbn_txt.addKeyListener(this);
        this._price_txt.addKeyListener(this);
        this._advance_txt.addKeyListener(this);
        this._total_sales_txt.addKeyListener(this);
        this._contract_txt.addKeyListener(this);
        this._title_txt.addFocusListener(this);
        this._isbn_txt.addFocusListener(this);
        this._price_txt.addFocusListener(this);
        this._advance_txt.addFocusListener(this);
        this._total_sales_txt.addFocusListener(this);
        this._contract_txt.addFocusListener(this);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._publisher_txt.equals(source) || this._publisher_but.equals(source)) {
            this.showPublisherPickTable();
        }
        if (this._authorFn_txt.equals(source) || this._authorLn_txt.equals(source) || this._author_but.equals(source)) {
            this.showAuthorPickTable();
        }
        this.validateContent();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.validateContent();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.validateContent();
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField) {
            JTextField field = (JTextField)e.getSource();
            field.selectAll();
        }
    }

    @Override
    public String getProblemText() {
        if (this.isInsert() || this.isUpdate()) {
            if (this._title_txt.getText().trim().length() == 0) {
                return "Title Name must be entered";
            }
            if (this._isbn_txt.getText().trim().length() == 0) {
                return "ISBN must be entered";
            }
            if (this._price_txt.getText().trim().length() > 0) {
                try {
                    new BigDecimal(this._price_txt.getText());
                }
                catch (NumberFormatException nfe) {
                    return "Price must be a Number";
                }
            }
            if (this._advance_txt.getText().trim().length() > 0) {
                try {
                    new BigDecimal(this._advance_txt.getText());
                }
                catch (NumberFormatException nfe) {
                    return "Advance must be a Number";
                }
            }
            if (this._total_sales_txt.getText().trim().length() > 0) {
                try {
                    new Integer(this._total_sales_txt.getText());
                }
                catch (NumberFormatException nfe) {
                    return "Total Sales must be a Integer";
                }
            }
            if (this._contract_txt.getText().trim().length() > 0) {
                try {
                    new Integer(this._contract_txt.getText());
                }
                catch (NumberFormatException nfe) {
                    return "Contract must be a Integer";
                }
            }
        }
        return null;
    }

    private byte[] getImageFromDb(int au_id) {
        return this.getImageFromDb("{call ${PKG:titles_pkg}get_title_picture(?,?)}", "title_id", this._title_id);
    }

    @Override
    public void setFields(GTable table, int vrow) {
        this._title_id = table.getValueAsInteger(vrow, "title_id", false);
        this._title_id_txt.setText("" + this._title_id);
        this._title_txt.setText(table.getValueAsString(vrow, "title", false));
        this._type_txt.setText(table.getValueAsString(vrow, "type", false));
        this._isbn_txt.setText(table.getValueAsString(vrow, "isbn", false));
        this._pubdate_dtp.setDate((Date)table.getValueAsTimestamp(vrow, "pubdate", false));
        this._price_txt.setText(table.getValueAsString(vrow, "price", false));
        this._advance_txt.setText(table.getValueAsString(vrow, "advance", false));
        this._total_sales_txt.setText(table.getValueAsString(vrow, "total_sales", false));
        this._notes_txt.setText(table.getValueAsString(vrow, "notes", false));
        this._contract_txt.setText(table.getValueAsString(vrow, "contract", false));
        Integer au_id = table.getValueAsInteger(vrow, "au_id", false);
        Integer pub_id = table.getValueAsInteger(vrow, "pub_id", false);
        this.getAuthorById(au_id);
        this.getPublisherById(pub_id);
        byte[] ba = this.getImageFromDb(this._title_id);
        this.loadImage(ba);
        this.validateContent();
    }

    public String getTitleName() {
        return this.getStringValue(this._title_txt);
    }

    public String getBookType() {
        return this.getStringValue(this._type_txt);
    }

    public String getIsbn() {
        return this.getStringValue(this._isbn_txt);
    }

    public Timestamp getPubDate() {
        return this._pubdate_dtp.getDate() == null ? null : new Timestamp(this._pubdate_dtp.getDate().getTime());
    }

    public BigDecimal getPrice() {
        return this.getBigDecimalValue(this._price_txt);
    }

    public BigDecimal getAdvance() {
        return this.getBigDecimalValue(this._advance_txt);
    }

    public BigDecimal getTotalSales() {
        return this.getBigDecimalValue(this._total_sales_txt);
    }

    public String getNotes() {
        return this.getStringValue(this._notes_txt);
    }

    public BigDecimal getContract() {
        return this.getBigDecimalValue(this._contract_txt);
    }

    public String getAuthorFName() {
        return this.getStringValue(this._authorFn_txt);
    }

    public String getAuthorLName() {
        return this.getStringValue(this._authorLn_txt);
    }

    public String getPubName() {
        return this.getStringValue(this._publisher_txt);
    }

    private void getAuthorById(int id) {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_author_by_id(?,?)}");
        stmnt.addParam(SqlStatementParam.createInParam("p_au_id", 4, id));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        try {
            ResultSet rs = stmnt.executeQuery(this.getConnectionProvider());
            int rowc = 0;
            while (rs.next()) {
                ++rowc;
                this._authorFn_txt.setText(rs.getString(1));
                this._authorLn_txt.setText(rs.getString(2));
            }
            SqlTraceWindow.getInstance().addRowcount(rowc);
            SqlStatement.putWarningMessages(this.getConnectionProvider(), null, rs);
            rs.close();
        }
        catch (SQLException e) {
            SqlStatement.showErrorMessage(e, stmnt, this.getOwner(), "Getting Author by ID <b>failed.</b>");
        }
    }

    private void getPublisherById(int id) {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_publisher_by_id(?,?)}");
        stmnt.addParam(SqlStatementParam.createInParam("p_pub_id", 4, id));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        try {
            ResultSet rs = stmnt.executeQuery(this.getConnectionProvider());
            int rowc = 0;
            while (rs.next()) {
                ++rowc;
                this._publisher_txt.setText(rs.getString(1));
            }
            SqlTraceWindow.getInstance().addRowcount(rowc);
            SqlStatement.putWarningMessages(this.getConnectionProvider(), null, rs);
            rs.close();
        }
        catch (SQLException e) {
            SqlStatement.showErrorMessage(e, stmnt, this.getOwner(), "Getting Publisher by ID <b>failed.</b>");
        }
    }

    private void showAuthorPickTable() {
        String au_fname = this._authorFn_txt.getText();
        String au_lname = this._authorLn_txt.getText();
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_authors_lookup(?,?,?)}");
        stmnt.addParam(SqlStatementParam.createInParam("first_name", 12, au_fname));
        stmnt.addParam(SqlStatementParam.createInParam("last_name", 12, au_lname));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        SqlPickList pickList = new SqlPickList((Window)this, this.getConnectionProvider(), stmnt, "title-AuthorName");
        boolean setValues = false;
        if (pickList.getRowCount() == 1) {
            setValues = true;
        } else {
            pickList.setVisible(true);
            if (pickList.wasOkPressed()) {
                setValues = true;
            }
        }
        if (setValues) {
            this._authorFn_txt.setText(pickList.getSelectedValuesAsString("first_name"));
            this._authorLn_txt.setText(pickList.getSelectedValuesAsString("last_name"));
        }
    }

    private void showPublisherPickTable() {
        String pub_name = this._publisher_txt.getText();
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_publishers_lookup(?,?)}");
        stmnt.addParam(SqlStatementParam.createInParam("pub_name", 12, pub_name));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        SqlPickList pickList = new SqlPickList((Window)this, this.getConnectionProvider(), stmnt, "title-PubName");
        boolean setValues = false;
        if (pickList.getRowCount() == 1) {
            setValues = true;
        } else {
            pickList.setVisible(true);
            if (pickList.wasOkPressed()) {
                setValues = true;
            }
        }
        if (setValues) {
            this._publisher_txt.setText(pickList.getSelectedValuesAsString("pub_name"));
        }
    }

    @Override
    public boolean doInsert() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}insert_title(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("title", 12, this.getTitleName()));
        stmnt.addParam(SqlStatementParam.createInParam("type", 12, this.getBookType()));
        stmnt.addParam(SqlStatementParam.createInParam("price", 2, this.getPrice()));
        stmnt.addParam(SqlStatementParam.createInParam("advance", 2, this.getAdvance()));
        stmnt.addParam(SqlStatementParam.createInParam("total_sales", 4, this.getTotalSales()));
        stmnt.addParam(SqlStatementParam.createInParam("notes", 12, this.getNotes()));
        stmnt.addParam(SqlStatementParam.createInParam("pubdate", 93, this.getPubDate()));
        stmnt.addParam(SqlStatementParam.createInParam("contract", 4, this.getContract()));
        stmnt.addParam(SqlStatementParam.createInParam("isbn", 12, this.getIsbn()));
        stmnt.addParam(SqlStatementParam.createInParam("au_first_name", 12, this.getAuthorFName()));
        stmnt.addParam(SqlStatementParam.createInParam("au_last_name", 12, this.getAuthorLName()));
        stmnt.addParam(SqlStatementParam.createInParam("pub_name", 12, this.getPubName()));
        stmnt.addParam(SqlStatementParam.createInParam("picture", 2004, this.getPicture()));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Adding Title information <b>failed.</b>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doUpdate() {
        SqlStatement stmnt = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (this.getConnectionProvider().isAutoCommitEnabledAtConnect()) {
                DbUtils.setAutoCommit(conn, null, this.getOwner(), false, "Add or Change Title Dialog");
            }
            stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}update_title(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
            stmnt.addParam(SqlStatementParam.createInParam("title_id", 4, this._title_id));
            stmnt.addParam(SqlStatementParam.createInParam("title", 12, this.getTitleName()));
            stmnt.addParam(SqlStatementParam.createInParam("type", 12, this.getBookType()));
            stmnt.addParam(SqlStatementParam.createInParam("price", 2, this.getPrice()));
            stmnt.addParam(SqlStatementParam.createInParam("advance", 2, this.getAdvance()));
            stmnt.addParam(SqlStatementParam.createInParam("total_sales", 4, this.getTotalSales()));
            stmnt.addParam(SqlStatementParam.createInParam("notes", 12, this.getNotes()));
            stmnt.addParam(SqlStatementParam.createInParam("pubdate", 93, this.getPubDate()));
            stmnt.addParam(SqlStatementParam.createInParam("contract", 4, this.getContract()));
            stmnt.addParam(SqlStatementParam.createInParam("isbn", 12, this.getIsbn()));
            stmnt.addParam(SqlStatementParam.createInParam("au_first_name", 12, this.getAuthorFName()));
            stmnt.addParam(SqlStatementParam.createInParam("au_last_name", 12, this.getAuthorLName()));
            stmnt.addParam(SqlStatementParam.createInParam("pub_name", 12, this.getPubName()));
            stmnt.executeWithGuiProgress(this.getConnectionProvider(), this.getOwner());
            if (this.getPicture() != null) {
                stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}update_title_picture(?, ?)}");
                stmnt.addParam(SqlStatementParam.createInParam("title_id", 4, this._title_id));
                stmnt.addParam(SqlStatementParam.createInParam("picture", 2004, this.getPicture()));
                stmnt.executeWithGuiProgress(this.getConnectionProvider(), this.getOwner());
            }
            conn.commit();
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            SqlStatement.showErrorMessage(ex, stmnt, this._owner, "Updating Title information <b>failed.</b>");
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    SqlStatement.showErrorMessage(ex2, stmnt, this._owner, "Error when rolling back the executed statements");
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null && this.getConnectionProvider().isAutoCommitEnabledAtConnect()) {
                DbUtils.setAutoCommit(conn, null, this.getOwner(), true, "Add or Change Title Dialog");
            }
        }
    }

    @Override
    public boolean doDelete() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}delete_title(?)}");
        stmnt.addParam(SqlStatementParam.createInParam("title_id", 4, this._title_id));
        return stmnt.execute(this.getConnectionProvider(), this._owner, "Deleting Title information <b>failed.</b>");
    }
}

