/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.DataPanelAbstract;
import com.sap.dbmtk.demo.DemoApp;
import com.sap.dbmtk.demo.ResultSetTable;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class DataPanelOrderDetails
extends DataPanelAbstract {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Order Detail(s)";
    private String[] _order_ids = new String[0];

    public DataPanelOrderDetails(DemoApp owner) {
        super(owner, NAME, true);
    }

    @Override
    public boolean showAddButton() {
        return false;
    }

    @Override
    public boolean showChangeButton() {
        return false;
    }

    @Override
    public boolean showRemoveButton() {
        return false;
    }

    @Override
    public void onParentTableSelection(DataPanelAbstract parent) {
        if ("Orders".equals(parent.getName())) {
            ResultSetTable tab = parent.getTable();
            int[] selectedRows = tab.getSelectedRows();
            this._order_ids = new String[selectedRows.length];
            for (int r = 0; r < selectedRows.length; ++r) {
                String str = tab.getValueAsString(selectedRows[r], "order_id", false);
                if (str == null) continue;
                this._order_ids[r] = str;
            }
        }
        this.refreshTableData();
    }

    @Override
    public SqlStatement getTableDataSqlStatement() {
        String order_id_values = null;
        if (this._order_ids.length > 0) {
            order_id_values = StringUtil.toCommaStr(this._order_ids, ",");
        }
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_order_details(?,?)}");
        stmnt.addParam(SqlStatementParam.createInParam("order_id_list", 12, order_id_values));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        return stmnt;
    }

    @Override
    public List<String> getHiddenColumns() {
        ArrayList<String> hiddenCols = new ArrayList<String>();
        hiddenCols.add("title_id");
        return hiddenCols;
    }
}

