/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.AddOrChangeAbstract;
import com.sap.dbmtk.demo.AddOrChangePublisher;
import com.sap.dbmtk.demo.DataPanelAbstract;
import com.sap.dbmtk.demo.DemoApp;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.SelectAllFocusListener;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class DataPanelPublishers
extends DataPanelAbstract {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Publishers";
    private JLabel _pubName_lbl;
    private JTextField _pubName_txt;

    public DataPanelPublishers(DemoApp owner) {
        super(owner, NAME, true);
    }

    @Override
    public JPanel createDbSearchPanel() {
        this._pubName_lbl = new JLabel("Publisher Name");
        this._pubName_txt = new JTextField();
        JPanel p = SwingUtils.createPanel("DB/Server Filter", true, (LayoutManager)new MigLayout());
        p.add((Component)this._pubName_lbl, "");
        p.add((Component)this._pubName_txt, "growx, pushx");
        p.add((Component)this._dbRowCount_lbl, "");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPanelPublishers.this._refresh_but.doClick();
            }
        };
        this._pubName_txt.addActionListener(al);
        this._pubName_txt.addFocusListener(new SelectAllFocusListener());
        return p;
    }

    @Override
    public int getDbRowCount() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_publishers_count(?)}");
        stmnt.addParam(SqlStatementParam.createOutParam("rcount", 4));
        stmnt.execute(this.getConnectionProvider(), this.getOwner(), "Get rowcount");
        Integer rcount = (Integer)stmnt.getParameterValue("rcount");
        return rcount == null ? -1 : rcount;
    }

    @Override
    public void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf != null) {
            conf.setProperty("Publishers.field.pubName", this._pubName_txt.getText());
        }
    }

    @Override
    public void loadProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        this._pubName_txt.setText(conf.getProperty("Publishers.field.pubName", "books"));
    }

    @Override
    public void actionAdd() {
        AddOrChangePublisher dialog = new AddOrChangePublisher(this._owner.getWindow(), this.getConnectionProvider(), AddOrChangeAbstract.OpType.INSERT);
        if (dialog.open() == 1) {
            this.refreshDbRowCount();
            this.refreshTableData();
        }
        dialog.dispose();
    }

    @Override
    public void actionChange() {
        AddOrChangePublisher dialog = new AddOrChangePublisher(this._owner.getWindow(), this.getConnectionProvider(), AddOrChangeAbstract.OpType.UPDATE);
        int vrow = this.getTable().getSelectedRow();
        ((AddOrChangeAbstract)dialog).setFields(this.getTable(), vrow);
        if (dialog.open() == 1) {
            this.refreshTableData();
        }
        dialog.dispose();
    }

    @Override
    public void actionRemove() {
        AddOrChangePublisher dialog = new AddOrChangePublisher(this._owner.getWindow(), this.getConnectionProvider(), AddOrChangeAbstract.OpType.DELETE);
        int vrow = this.getTable().getSelectedRow();
        ((AddOrChangeAbstract)dialog).setFields(this.getTable(), vrow);
        if (dialog.open() == 1) {
            this.refreshDbRowCount();
            this.refreshTableData();
        }
        dialog.dispose();
    }

    @Override
    public SqlStatement getTableDataSqlStatement() {
        String pubName = null;
        if (this.isDbSearchPanelVisible()) {
            pubName = this._pubName_txt.getText();
        }
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call get_publishers(?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("pub_name", 12, pubName));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        return stmnt;
    }

    @Override
    public List<String> getHiddenColumns() {
        ArrayList<String> hiddenCols = new ArrayList<String>();
        hiddenCols.add("pub_id");
        return hiddenCols;
    }
}

