/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.AddOrChangeAbstract;
import com.sap.dbmtk.demo.AddOrChangeAuthor;
import com.sap.dbmtk.demo.AddOrChangeTitle;
import com.sap.dbmtk.demo.DataPanelAbstract;
import com.sap.dbmtk.demo.DemoApp;
import com.sap.dbmtk.demo.ResultSetTable;
import com.sap.dbmtk.demo.SqlStatement;
import com.sap.dbmtk.demo.SqlStatementParam;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.SelectAllFocusListener;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;

public class DataPanelTitles
extends DataPanelAbstract {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Titles";
    private String[] _au_ids = new String[0];
    private String[] _pub_ids = new String[0];
    private JLabel _titleName_lbl;
    private JTextField _titleName_txt;
    private JComboBox _image_cbx;

    public DataPanelTitles(DemoApp owner) {
        super(owner, NAME, true);
    }

    @Override
    public boolean showTableToolTipCheckbox() {
        return true;
    }

    @Override
    public JPanel createDbSearchPanel() {
        this._titleName_lbl = new JLabel("Title Name");
        this._titleName_txt = new JTextField();
        this._image_cbx = new JComboBox<String>(new String[]{"With or Without Picture", "With Picture", "Without Picture"});
        JPanel p = SwingUtils.createPanel("DB/Server Filter", true, (LayoutManager)new MigLayout());
        p.add((Component)this._titleName_lbl, "");
        p.add((Component)this._titleName_txt, "growx, pushx");
        p.add((Component)this._image_cbx, "");
        p.add((Component)this._dbRowCount_lbl, "");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPanelTitles.this._refresh_but.doClick();
            }
        };
        this._titleName_txt.addActionListener(al);
        this._image_cbx.addActionListener(al);
        this._titleName_txt.addFocusListener(new SelectAllFocusListener());
        return p;
    }

    private Integer getPictureParamValue() {
        int index = this._image_cbx.getSelectedIndex();
        if (index == 0) {
            return null;
        }
        if (index == 1) {
            return 1;
        }
        if (index == 2) {
            return 0;
        }
        return null;
    }

    @Override
    public int getDbRowCount() {
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}get_titles_count(?)}");
        stmnt.addParam(SqlStatementParam.createOutParam("rcount", 4));
        stmnt.execute(this.getConnectionProvider(), this.getOwner(), "Get rowcount");
        Integer rcount = (Integer)stmnt.getParameterValue("rcount");
        return rcount == null ? -1 : rcount;
    }

    @Override
    public void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf != null) {
            conf.setProperty("Titles.field.titleName", this._titleName_txt.getText());
            conf.setProperty("Titles.field.image", this._image_cbx.getSelectedIndex());
        }
    }

    @Override
    public void loadProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        this._titleName_txt.setText(conf.getProperty("Titles.field.titleName", "The"));
        this._image_cbx.setSelectedIndex(conf.getIntProperty("Titles.field.image", 0));
    }

    @Override
    public void actionAdd() {
        AddOrChangeTitle dialog = new AddOrChangeTitle(this._owner.getWindow(), this.getConnectionProvider(), AddOrChangeAbstract.OpType.INSERT);
        if (dialog.open() == 1) {
            this.refreshDbRowCount();
            this.refreshTableData();
        }
        dialog.dispose();
    }

    @Override
    public void actionChange() {
        AddOrChangeTitle dialog = new AddOrChangeTitle(this._owner.getWindow(), this.getConnectionProvider(), AddOrChangeAbstract.OpType.UPDATE);
        int vrow = this.getTable().getSelectedRow();
        ((AddOrChangeAbstract)dialog).setFields(this.getTable(), vrow);
        if (dialog.open() == 1) {
            this.refreshTableData();
        }
        dialog.dispose();
    }

    @Override
    public void actionRemove() {
        AddOrChangeTitle dialog = new AddOrChangeTitle(this._owner.getWindow(), this.getConnectionProvider(), AddOrChangeAbstract.OpType.DELETE);
        int vrow = this.getTable().getSelectedRow();
        ((AddOrChangeAbstract)dialog).setFields(this.getTable(), vrow);
        if (dialog.open() == 1) {
            this.refreshDbRowCount();
            this.refreshTableData();
        }
        dialog.dispose();
    }

    @Override
    public void actionRefresh() {
        this._au_ids = new String[0];
        this._pub_ids = new String[0];
        super.actionRefresh();
    }

    @Override
    public void onParentTableSelection(DataPanelAbstract parent) {
        String str;
        int r;
        int[] selectedRows;
        ResultSetTable tab;
        if (!this.isUndocked()) {
            return;
        }
        if ("Author".equals(parent.getName())) {
            tab = parent.getTable();
            selectedRows = tab.getSelectedRows();
            this._au_ids = new String[selectedRows.length];
            for (r = 0; r < selectedRows.length; ++r) {
                str = tab.getValueAsString(selectedRows[r], "au_id", false);
                if (str == null) continue;
                this._au_ids[r] = str;
            }
        }
        if ("Publishers".equals(parent.getName())) {
            tab = parent.getTable();
            selectedRows = tab.getSelectedRows();
            this._pub_ids = new String[selectedRows.length];
            for (r = 0; r < selectedRows.length; ++r) {
                str = tab.getValueAsString(selectedRows[r], "pub_id", false);
                if (str == null) continue;
                this._pub_ids[r] = str;
            }
        }
        this.refreshTableData();
    }

    @Override
    public SqlStatement getTableDataSqlStatement() {
        String au_id_values = null;
        if (this._au_ids.length > 0) {
            au_id_values = StringUtil.toCommaStr(this._au_ids, ",");
        }
        String pub_id_values = null;
        if (this._pub_ids.length > 0) {
            pub_id_values = StringUtil.toCommaStr(this._pub_ids, ",");
        }
        String titleName = null;
        Integer pictureType = null;
        if (this.isDbSearchPanelVisible()) {
            titleName = this._titleName_txt.getText();
            pictureType = this.getPictureParamValue();
        }
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}get_titles(?, ?, ?, ?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("au_id_list", 12, au_id_values));
        stmnt.addParam(SqlStatementParam.createInParam("pub_id_list", 12, pub_id_values));
        stmnt.addParam(SqlStatementParam.createInParam("title_name", 12, titleName));
        stmnt.addParam(SqlStatementParam.createInParam("has_picture", 4, pictureType));
        stmnt.addParam(SqlStatementParam.createOracleResultSetParam("a_cursor"));
        return stmnt;
    }

    @Override
    public List<String> getHiddenColumns() {
        ArrayList<String> hiddenCols = new ArrayList<String>();
        hiddenCols.add("title_id");
        hiddenCols.add("au_id");
        hiddenCols.add("pub_id");
        return hiddenCols;
    }

    @Override
    public String getTableToolTipText(ResultSetTableModel rstm, int mrow, int mcol) {
        if (!this.isTableToolTipEnabled()) {
            return null;
        }
        String tt = this.getTableToolTipTextWithPicture(rstm, mrow, mcol, "{call ${PKG:titles_pkg}get_title_picture(?,?)}", "title_id", AddOrChangeAuthor.NO_PICTURE, new Dimension(300, 400));
        int titleId = rstm.getValueAsInteger(mrow, "title_id", false);
        SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}get_title_report(?, ?)}");
        stmnt.addParam(SqlStatementParam.createInParam("p_title_id", 4, titleId));
        stmnt.addParam(SqlStatementParam.createOutParam("p_report_output", 12));
        stmnt.execute(this.getConnectionProvider(), this.getOwner(), "Sales Details Report <b>failed.</b>");
        String report = (String)stmnt.getParameterValue("p_report_output");
        if (StringUtil.hasValue(report)) {
            report = "<h3>Sales Details Report</h3>" + report.replace(";", "<br>");
            if (tt != null) {
                tt = tt.replace("</html>", report + "</html>");
            }
        }
        return tt;
    }

    @Override
    public JPopupMenu createDataTablePopupMenu(final ResultSetTable tab) {
        JMenuItem salesDetails_mi;
        JPopupMenu pm = super.createDataTablePopupMenu(tab);
        JMenuItem mi = salesDetails_mi = new JMenuItem("Sales Details...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int vrow = tab.getSelectedRow();
                int titleId = tab.getValueAsInteger(vrow, "title_id", false);
                SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call ${PKG:titles_pkg}get_title_report(?, ?)}");
                stmnt.addParam(SqlStatementParam.createInParam("p_title_id", 4, titleId));
                stmnt.addParam(SqlStatementParam.createOutParam("p_report_output", 12));
                stmnt.execute(DataPanelTitles.this.getConnectionProvider(), DataPanelTitles.this.getOwner(), "Sales Details Report <b>failed.</b>");
                String report = (String)stmnt.getParameterValue("p_report_output");
                if (StringUtil.hasValue(report)) {
                    SwingUtils.showInfoMessage(DataPanelTitles.this.getOwner(), "Sales Details Report", report);
                }
            }
        });
        pm.add(mi);
        pm.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean enable;
                boolean bl = enable = tab.getSelectedRowCount() == 1;
                if (salesDetails_mi != null) {
                    salesDetails_mi.setEnabled(enable);
                }
            }
        });
        return pm;
    }
}

