/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class PreferencesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Window _owner = null;
    private JButton _toDefault = new JButton("Set to Default");
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private boolean _okWasPressed = false;
    private JCheckBox _showExtErrInfo_chk = new JCheckBox("Show Extended Error information");
    private JCheckBox _enableDbmsOutput_chk = new JCheckBox("Enable DBMS Output subsystem");
    private JLabel _dbShowSearchPanelThreshold_lbl = new JLabel("Show DB Filter Panel Threshold");
    private JTextField _dbShowSearchPanelThreshold_txt = new JTextField();
    private JCheckBox _onRefreshGetDbCount_chk = new JCheckBox("On Refresh Get DB Table Count");
    private JCheckBox _sendBlankStrAsNull_chk = new JCheckBox("Send Empty Strings as NULL");
    private JLabel _sqlPopupGraceTime_lbl = new JLabel("Show Progress Window after X ms");
    private JTextField _sqlPopupGraceTime_txt = new JTextField();
    private JCheckBox _rsStringTrim_chk = new JCheckBox("Trim Strings");
    private JCheckBox _rsShowRowNumber_chk = new JCheckBox("Show Row Number");
    private JLabel _rsNullReplace_lbl = new JLabel("Show NULL Values as");
    private JTextField _rsNullReplace_txt = new JTextField();

    public PreferencesDialog(Window owner) {
        super(owner, "Application Preferences", Dialog.ModalityType.APPLICATION_MODAL);
        this._owner = owner;
        this.pinit();
        this.loadProps();
        this.pack();
        SwingUtils.installEscapeButton(this, this._cancel);
        this.setLocationRelativeTo(owner);
    }

    private void pinit() {
        this.setLayout((LayoutManager)new MigLayout());
        String desc = "<html><b>Application Preferences</b><br></html>";
        this.add((Component)new JLabel(desc), "growx, pushx, wrap");
        this.add((Component)this.createPrefPanel(), "grow, push, wrap");
        this.add((Component)this.createOkCancelPanel(), "growx, pushx, tag right, wrap");
        this._toDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.setAllToDefault();
            }
        });
        this._ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.saveProps();
                PreferencesDialog.this._okWasPressed = true;
                PreferencesDialog.this.setVisible(false);
            }
        });
        this._cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this._okWasPressed = false;
                PreferencesDialog.this.setVisible(false);
            }
        });
    }

    private JPanel createOkCancelPanel() {
        JPanel p = new JPanel((LayoutManager)new MigLayout());
        p.add((Component)new JLabel(), "split, span, growx, pushx");
        p.add((Component)this._ok, "tag ok");
        p.add((Component)this._cancel, "tag cancel");
        return p;
    }

    public boolean wasOkPressed() {
        return this._okWasPressed;
    }

    private JPanel createPrefPanel() {
        JPanel p = new JPanel((LayoutManager)new MigLayout());
        JPanel p1 = SwingUtils.createPanel("Error Handling", true, (LayoutManager)new MigLayout());
        p1.add((Component)this._showExtErrInfo_chk, "span, wrap");
        p1.add((Component)this._enableDbmsOutput_chk, "span, wrap");
        JPanel p2 = SwingUtils.createPanel("DB/Server Filter", true, (LayoutManager)new MigLayout());
        p2.add((Component)this._dbShowSearchPanelThreshold_lbl, "");
        p2.add((Component)this._dbShowSearchPanelThreshold_txt, "growx, pushx, wrap");
        p2.add((Component)this._onRefreshGetDbCount_chk, "span, wrap");
        JPanel p3 = SwingUtils.createPanel("Add/Change Dialogs", true, (LayoutManager)new MigLayout());
        p3.add((Component)this._sendBlankStrAsNull_chk, "span, wrap");
        JPanel p4 = SwingUtils.createPanel("SQL Execution", true, (LayoutManager)new MigLayout());
        p4.add((Component)this._sqlPopupGraceTime_lbl, "");
        p4.add((Component)this._sqlPopupGraceTime_txt, "growx, pushx, wrap");
        JPanel p5 = SwingUtils.createPanel("Result Set Options", true, (LayoutManager)new MigLayout());
        p5.add((Component)this._rsNullReplace_lbl, "");
        p5.add((Component)this._rsNullReplace_txt, "growx, pushx, wrap");
        p5.add((Component)this._rsShowRowNumber_chk, "span, wrap");
        p5.add((Component)this._rsStringTrim_chk, "span, wrap");
        p.add((Component)p1, "growx, pushx, wrap");
        p.add((Component)p2, "growx, pushx, wrap");
        p.add((Component)p3, "growx, pushx, wrap");
        p.add((Component)p4, "growx, pushx, wrap");
        p.add((Component)p5, "growx, pushx, wrap");
        p.add((Component)this._toDefault, "tag right, wrap");
        this.installHandlers();
        this.installToolTip();
        return p;
    }

    private void installHandlers() {
        this._dbShowSearchPanelThreshold_txt.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    Integer.parseInt(PreferencesDialog.this._dbShowSearchPanelThreshold_txt.getText().trim());
                }
                catch (NumberFormatException ex) {
                    SwingUtils.showErrorMessage(PreferencesDialog.this._owner, "Must be a Integer", "Must be a Integer", ex);
                    PreferencesDialog.this._dbShowSearchPanelThreshold_txt.setText("100");
                }
            }
        });
        this._sqlPopupGraceTime_txt.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    Integer.parseInt(PreferencesDialog.this._sqlPopupGraceTime_txt.getText().trim());
                }
                catch (NumberFormatException ex) {
                    SwingUtils.showErrorMessage(PreferencesDialog.this._owner, "Must be a Integer", "Must be a Integer", ex);
                    PreferencesDialog.this._sqlPopupGraceTime_txt.setText("1000");
                }
            }
        });
    }

    public void installToolTip() {
        this._showExtErrInfo_chk.setToolTipText("<html>Show ASE 'print' messages and 'decoded' messages from any SQLExceptions</html>");
        this._enableDbmsOutput_chk.setToolTipText("<html>Enable or Disable Oracle 'DBMS_OUTPUT' subsystem, which is emulated in the SAP DBMTK Runtime Components as 'buffered_output'.<br><b>NOTE</b>: The '<i>Show Extended Error information</i>' option must be enabled for this to work.</html>");
        this._dbShowSearchPanelThreshold_txt.setToolTipText("<html>Number of records in the <i>base table</i> before we show the <i>DB/Server Filter Panel</i>.<br><b>NOTE</b>: If this is set to -1 the <i>DB/Server Filter Panel</i> will always be visible after a connection has been established.</html>");
        this._dbShowSearchPanelThreshold_lbl.setToolTipText(this._dbShowSearchPanelThreshold_txt.getToolTipText());
        this._onRefreshGetDbCount_chk.setToolTipText("<html>Get rowcount from the <i>base table</i> when refreshing the data set. And also show/hide the <i>DB/Server Filter Panel</i>.</html>");
        this._sendBlankStrAsNull_chk.setToolTipText("<html>Should <i>empty</i> string fields in the Add/Change dialog be send as NULL or '' (empty strings).</html>");
        this._sqlPopupGraceTime_txt.setToolTipText("<html>Number of milliseconds before a progress dialog is displayed when executing SQL.</html>");
        this._sqlPopupGraceTime_lbl.setToolTipText(this._sqlPopupGraceTime_txt.getToolTipText());
        this._rsStringTrim_chk.setToolTipText("<html>When reading Results from the server, do we want strings to remove leading/trailing spaces?</html>");
        this._rsShowRowNumber_chk.setToolTipText("<html>Show a <i>row#</i> colummn in the Result Set<br><b>NOTE</b>: This requires a reconnect to work properly.</html>");
        this._rsNullReplace_txt.setToolTipText("<html>If the value from the server contains NULL, this is the String representation of the NULL value displaied in the GUI Table.</html>");
        this._rsNullReplace_lbl.setToolTipText(this._rsNullReplace_txt.getToolTipText());
    }

    private void setAllToDefault() {
        this._showExtErrInfo_chk.setSelected(true);
        this._enableDbmsOutput_chk.setSelected(true);
        this._dbShowSearchPanelThreshold_txt.setText("100");
        this._onRefreshGetDbCount_chk.setSelected(true);
        this._sendBlankStrAsNull_chk.setSelected(false);
        this._sqlPopupGraceTime_txt.setText("1000");
        this._rsStringTrim_chk.setSelected(true);
        this._rsShowRowNumber_chk.setSelected(false);
        this._rsNullReplace_txt.setText("(NULL)");
    }

    private void loadProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        this.setAllToDefault();
        this._showExtErrInfo_chk.setSelected(conf.getBooleanProperty("DemoClient.view.show.extended.error.info", true));
        this._enableDbmsOutput_chk.setSelected(conf.getBooleanProperty("DemoClient.view.enable.dbms.output", true));
        this._dbShowSearchPanelThreshold_txt.setText(conf.getProperty("show.db.search.panel.threshold", "100"));
        this._onRefreshGetDbCount_chk.setSelected(conf.getBooleanProperty("on.refresh.get.db.count", true));
        this._sendBlankStrAsNull_chk.setSelected(conf.getBooleanProperty("DemoClient.AddOrChange.blank.to.null", false));
        this._sqlPopupGraceTime_txt.setText(conf.getProperty("SqlStatement.exec.waitfor.popup.gracetime", "1000"));
        this._rsStringTrim_chk.setSelected(conf.getBooleanProperty("ResultSetTableModel.string.trim", true));
        this._rsShowRowNumber_chk.setSelected(conf.getBooleanProperty("ResultSetTableModel.show.rowNumber", false));
        this._rsNullReplace_txt.setText(conf.getProperty("ResultSetTableModel.replace.null.with", "(NULL)"));
    }

    private void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            return;
        }
        conf.setProperty("DemoClient.view.show.extended.error.info", this._showExtErrInfo_chk.isSelected());
        conf.setProperty("DemoClient.view.enable.dbms.output", this._enableDbmsOutput_chk.isSelected());
        conf.setProperty("show.db.search.panel.threshold", this._dbShowSearchPanelThreshold_txt.getText());
        conf.setProperty("on.refresh.get.db.count", this._onRefreshGetDbCount_chk.isSelected());
        conf.setProperty("DemoClient.AddOrChange.blank.to.null", this._sendBlankStrAsNull_chk.isSelected());
        conf.setProperty("SqlStatement.exec.waitfor.popup.gracetime", this._sqlPopupGraceTime_txt.getText());
        conf.setProperty("ResultSetTableModel.string.trim", this._rsStringTrim_chk.isSelected());
        conf.setProperty("ResultSetTableModel.show.rowNumber", this._rsShowRowNumber_chk.isSelected());
        conf.setProperty("ResultSetTableModel.replace.null.with", this._rsNullReplace_txt.getText());
    }
}

