/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.DataPanelAbstract;
import com.sap.dbmtk.demo.DemoApp;
import com.sap.dbmtk.demo.utils.Configuration;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.miginfocom.swing.MigLayout;

public class SplitPanelAbstract
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DemoApp _owner = null;
    protected DataPanelAbstract _left = null;
    protected DataPanelAbstract _right = null;
    private JSplitPane _splitPane = null;
    private JLabel _splitOrientation_lbl = new JLabel("Panel Orientation");
    private String[] _splitOrientation_val = new String[]{"Top to Bottom", "Side by Side"};
    private JComboBox _splitOrientation_cbx = new JComboBox<String>(this._splitOrientation_val);
    public static final String PROPKEY_SPLITPANE_DIVIDER_LOCATION = ".splitPane.dividerLocation";
    public static final String PROPKEY_SPLITPANE_DIVIDER_ORIENTATION = ".splitPane.dividerOrientation";

    public SplitPanelAbstract(DemoApp owner, String name, DataPanelAbstract left, DataPanelAbstract right) {
        this.setName(name);
        this._owner = owner;
        this._left = left;
        this._right = right;
        this._left.addChildTableSelectionListener(this._right);
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0"));
        String key = this.getName() + PROPKEY_SPLITPANE_DIVIDER_ORIENTATION;
        int val = Configuration.getCombinedConfiguration().getIntProperty(key, 1);
        this._splitPane = new JSplitPane(val, this._left, this._right);
        this._splitOrientation_cbx.setSelectedIndex(val);
        key = this.getName() + PROPKEY_SPLITPANE_DIVIDER_LOCATION;
        val = Configuration.getCombinedConfiguration().getIntProperty(key, -1);
        if (val >= 0) {
            this._splitPane.setDividerLocation(val);
        }
        this.add((Component)this._splitPane, "grow, push, wrap");
        this.add((Component)this._splitOrientation_lbl, "gapleft 5, split");
        this.add((Component)this._splitOrientation_cbx, "wrap");
        this._splitOrientation_cbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SplitPanelAbstract.this._splitOrientation_cbx.getSelectedIndex();
                Configuration conf = Configuration.getInstance("USER_TEMP");
                if (conf != null) {
                    String key = SplitPanelAbstract.this.getName() + SplitPanelAbstract.PROPKEY_SPLITPANE_DIVIDER_ORIENTATION;
                    int val = index;
                    conf.setProperty(key, val);
                    conf.save();
                }
                SplitPanelAbstract.this._splitPane.setOrientation(index);
            }
        });
        this._splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Configuration conf = Configuration.getInstance("USER_TEMP");
                if (conf != null) {
                    String key = SplitPanelAbstract.this.getName() + SplitPanelAbstract.PROPKEY_SPLITPANE_DIVIDER_LOCATION;
                    int val = SplitPanelAbstract.this._splitPane.getDividerLocation();
                    conf.setProperty(key, val);
                    conf.save();
                }
            }
        });
    }

    public DemoApp getOwner() {
        return this._owner;
    }

    public DataPanelAbstract getLeftPane() {
        return this._left;
    }

    public DataPanelAbstract getRightPane() {
        return this._right;
    }

    public void onConnect() {
        this._left.onConnect();
        this._right.onConnect();
    }

    public void onDisconnect() {
        this._left.onDisconnect();
        this._right.onDisconnect();
    }

    public void onTabSelected() {
        this._left.onTabSelected();
    }
}

