/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.utils.StringUtil;

public class SqlStatementParam {
    private int _sqlType = 1111;
    private Object _val = null;
    private String _paramName = null;
    private boolean _isOutput = false;
    private static int ORACLE_CURSOR_TYPE = -10;

    public boolean isOutput() {
        return this._isOutput;
    }

    public boolean isInput() {
        return !this._isOutput;
    }

    public Object getValue() {
        return this._val;
    }

    public int getSqlType() {
        return this._sqlType;
    }

    public String getParamName() {
        return this._paramName;
    }

    private SqlStatementParam() {
    }

    public static SqlStatementParam createInParam(String paramName, int sqlType, Object val) {
        SqlStatementParam p = new SqlStatementParam();
        p._paramName = paramName;
        p._isOutput = false;
        p._sqlType = sqlType;
        p._val = val;
        return p;
    }

    public static SqlStatementParam createOutParam(String paramName, int sqlType) {
        SqlStatementParam p = new SqlStatementParam();
        p._paramName = paramName;
        p._isOutput = true;
        p._sqlType = sqlType;
        p._val = null;
        return p;
    }

    public static SqlStatementParam createOracleResultSetParam(String paramName) {
        SqlStatementParam p = new SqlStatementParam();
        p._paramName = paramName;
        p._isOutput = true;
        p._sqlType = ORACLE_CURSOR_TYPE;
        p._val = null;
        return p;
    }

    public void setOutputParamValue(Object val) {
        this._val = val;
    }

    public boolean isOracleRsParam() {
        return this._sqlType == ORACLE_CURSOR_TYPE;
    }

    public String toString() {
        String str = "Param: name=" + StringUtil.left(this._paramName, 15) + (this._isOutput ? " OUT, " : " IN,  ");
        if (this._sqlType == ORACLE_CURSOR_TYPE) {
            str = str + "sqlType=ORACLE::REF_CURSOR";
            str = str + ", value=" + (this._val == null ? "NULL" : "-HAS-RESULT-SET-") + ".";
        } else {
            str = str + "sqlType=" + ResultSetTableModel.getColumnJavaSqlTypeName(this._sqlType);
            str = str + ", value=" + (this._val == null ? "NULL" : "'" + this._val + "'") + ".";
        }
        return str;
    }
}

