/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import java.text.ParseException;
import javax.swing.SortOrder;
import org.apache.log4j.Logger;

public class ColumnHeaderPropsEntry {
    private static Logger _logger = Logger.getLogger(ColumnHeaderPropsEntry.class);
    protected String _colName = null;
    protected int _modelPos = -1;
    protected int _viewPos = -1;
    protected boolean _isVisible = true;
    protected SortOrder _sortOrder = SortOrder.UNSORTED;
    protected int _sortOrderPos = -1;
    protected int _width = -1;

    public ColumnHeaderPropsEntry() {
    }

    public ColumnHeaderPropsEntry(String name, int modelPos, int viewPos, boolean isVisible, SortOrder sortOrder, int sortOrderPos, int width) {
        this._colName = name;
        this._modelPos = modelPos;
        this._viewPos = viewPos;
        this._isVisible = isVisible;
        this._sortOrder = sortOrder;
        this._sortOrderPos = sortOrderPos;
        this._width = width;
    }

    private static ColumnHeaderPropsEntry parse(boolean keyVal, String colName, String valStr) throws ParseException {
        ColumnHeaderPropsEntry e = new ColumnHeaderPropsEntry();
        valStr = valStr.trim();
        e._colName = colName;
        if (keyVal) {
            if (e._colName == null) {
                e._colName = "";
            }
            int startPos = valStr.indexOf("={");
            int endPos = valStr.lastIndexOf("}");
            if (startPos == -1) {
                throw new ParseException("Can't find '={' in the input string '" + valStr + "'.", 0);
            }
            if (endPos == -1) {
                throw new ParseException("Can't find ending '}' in the input string '" + valStr + "'.", 0);
            }
            e._colName = valStr.substring(0, startPos);
            valStr = valStr.substring(startPos + 2, endPos);
        }
        String[] strArr = valStr.split(",");
        for (int i = 0; i < strArr.length; ++i) {
            strArr[i] = strArr[i].trim();
            _logger.trace((Object)("parse() colName='" + e._colName + "': i=" + i + ", keyVal='" + strArr[i] + "'."));
            String[] strKeyVal = strArr[i].split("=");
            if (strKeyVal.length < 2) {
                _logger.info((Object)("Faulty key=value representation '" + strArr[i] + "' at position '" + i + "' in the string '" + strArr[i] + "'."));
                continue;
            }
            String key = strKeyVal[0].trim();
            String val = strKeyVal[1].trim();
            if (key.equals("modelPos")) {
                try {
                    e._modelPos = Integer.parseInt(val);
                    continue;
                }
                catch (NumberFormatException ignore) {
                    throw new ParseException("The value '" + val + "' for key '" + key + "' is not a number.", 0);
                }
            }
            if (key.equals("viewPos")) {
                try {
                    e._viewPos = Integer.parseInt(val);
                    continue;
                }
                catch (NumberFormatException ignore) {
                    throw new ParseException("The value '" + val + "' for key '" + key + "' is not a number.", 0);
                }
            }
            if (key.equals("isVisible")) {
                e._isVisible = !val.equalsIgnoreCase("false");
                continue;
            }
            if (key.equals("sortOrder")) {
                String[] soEntry = val.split(":");
                if (soEntry.length > 1) {
                    val = soEntry[1];
                    try {
                        e._sortOrderPos = Integer.parseInt(soEntry[0]);
                    }
                    catch (NumberFormatException ignore) {
                        e._sortOrderPos = -1;
                        throw new ParseException("The Sort Order position value '" + soEntry[0] + "' for key '" + key + "' is not a number.", 0);
                    }
                }
                if (SortOrder.UNSORTED.toString().equals(val)) {
                    e._sortOrder = SortOrder.UNSORTED;
                    continue;
                }
                if (SortOrder.ASCENDING.toString().equals(val)) {
                    e._sortOrder = SortOrder.ASCENDING;
                    continue;
                }
                if (SortOrder.DESCENDING.toString().equals(val)) {
                    e._sortOrder = SortOrder.DESCENDING;
                    continue;
                }
                throw new ParseException("The value '" + val + "' for key '" + key + "' has to be '" + (Object)((Object)SortOrder.UNSORTED) + "|" + (Object)((Object)SortOrder.ASCENDING) + "|" + (Object)((Object)SortOrder.DESCENDING) + "'.", 0);
            }
            if (key.equals("width")) {
                try {
                    e._width = Integer.parseInt(val);
                    continue;
                }
                catch (NumberFormatException ignore) {
                    throw new ParseException("The value '" + val + "' for key '" + key + "' is not a number.", 0);
                }
            }
            throw new ParseException("Unknown key value of '" + key + "' was found in the string '" + valStr + "'.", 0);
        }
        return e;
    }

    public static ColumnHeaderPropsEntry parseKeyValue(String propsStr) throws ParseException {
        return ColumnHeaderPropsEntry.parse(true, null, propsStr);
    }

    public static ColumnHeaderPropsEntry parseValue(String colName, String propsStr) throws ParseException {
        return ColumnHeaderPropsEntry.parse(false, colName, propsStr);
    }

    public String toString() {
        return this._colName + "={modelPos=" + this._modelPos + ",viewPos=" + this._viewPos + ",isVisible=" + this._isVisible + ",sortOrder=" + (this._sortOrder == SortOrder.UNSORTED ? this._sortOrder : this._sortOrderPos + ":" + (Object)((Object)this._sortOrder)) + ",width=" + this._width + "}";
    }

    public static void main(String[] args) {
        try {
            String s = "noSpace={modelPos=1,viewPos=1,isVisible=xxx,sortOrder=unsorted}";
            ColumnHeaderPropsEntry p = ColumnHeaderPropsEntry.parseKeyValue(s);
            System.out.println("SUCCEEDED: \n\t" + s + "\n\t" + p);
            s = "spaceInPropList={modelPos=1, viewPos=1, isVisible=false, sortOrder=ascending}";
            p = ColumnHeaderPropsEntry.parseKeyValue(s);
            System.out.println("SUCCEEDED: \n\t" + s + "\n\t" + p);
            s = "spaceKeyVal-1={modelPos =1, viewPos =1, isVisible =xxx, sortOrder =descending}";
            p = ColumnHeaderPropsEntry.parseKeyValue(s);
            System.out.println("SUCCEEDED: \n\t" + s + "\n\t" + p);
            s = "spaceKeyVal-2={modelPos= 1, viewPos= 1, isVisible= xxx, sortOrder= unsorted}";
            p = ColumnHeaderPropsEntry.parseKeyValue(s);
            System.out.println("SUCCEEDED: \n\t" + s + "\n\t" + p);
            s = "spaceKeyVal-3={modelPos = 1, viewPos = 1, isVisible = xxx, sortOrder = unsorted}";
            p = ColumnHeaderPropsEntry.parseKeyValue(s);
            System.out.println("SUCCEEDED: \n\t" + s + "\n\t" + p);
        }
        catch (ParseException e) {
            System.out.println("TEST FAILED:");
            e.printStackTrace();
        }
    }
}

