/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.ui.focusabletip.FocusableTip;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;

public class GLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    public static final String FOCUSABLE_TIPS_PROPERTY = "RSTA.focusableTips";
    private boolean _useFocusableTips = true;
    private FocusableTip _focusableTip = null;

    public GLabel() {
        this.init();
    }

    public GLabel(String text) {
        super(text);
        this.init();
    }

    public GLabel(Icon image) {
        super(image);
        this.init();
    }

    public GLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init();
    }

    public GLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.init();
    }

    public GLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init();
    }

    protected void init() {
        this.setUseFocusableTips(true);
    }

    public boolean getUseFocusableTips() {
        return this._useFocusableTips;
    }

    public void setUseFocusableTips(boolean use) {
        if (use != this._useFocusableTips) {
            this._useFocusableTips = use;
            this.firePropertyChange(FOCUSABLE_TIPS_PROPERTY, !use, use);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String text = super.getToolTipText(e);
        if (this.getUseFocusableTips()) {
            if (text != null) {
                if (this._focusableTip == null) {
                    this._focusableTip = new FocusableTip(this);
                }
                this._focusableTip.toolTipRequested(e, text);
            } else if (this._focusableTip != null) {
                this._focusableTip.possiblyDisposeOfTipWindow();
            }
            return null;
        }
        return text;
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
    }
}

