/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.ui.AbstractComponentDecorator;
import com.sap.dbmtk.demo.ui.DockUndockManagement;
import com.sap.dbmtk.demo.ui.GTabbedPaneViewDialog;
import com.sap.dbmtk.demo.ui.GTabbedPaneWindowProps;
import com.sap.dbmtk.demo.ui.focusabletip.FocusableTip;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class GTabbedPane
extends JTabbedPane
implements MouseListener,
DockUndockManagement {
    private static Logger _logger = Logger.getLogger(GTabbedPane.class);
    public static final String GROUP_STR_SEPARATOR = ":";
    private static final long serialVersionUID = 6963407617181792852L;
    private ImageIcon _undockedFrameIcon = new ImageIcon(GTabbedPane.class.getResource("images/undocked_frame_icon.gif"));
    private ImageIcon _iconWinPlus = new ImageIcon(GTabbedPane.class.getResource("images/window_plus.gif"));
    private ImageIcon _iconWinMinus = new ImageIcon(GTabbedPane.class.getResource("images/window_minus.gif"));
    private JPopupMenu _tabMenu = null;
    private Vector _extEntry = new Vector();
    private int _lastMouseClickAtTabIndex = -1;
    private boolean _restoreTabLayoutPolicy = true;
    private boolean _initialized = false;
    private Set<ChangeListener> _localChangeListeners = new LinkedHashSet<ChangeListener>();
    public static final String FOCUSABLE_TIPS_PROPERTY = "RSTA.focusableTips";
    private boolean _useFocusableTips = true;
    private FocusableTip _focusableTip = null;
    private int _useFocusableTipAboveSize = 1000;
    private TabOrderAndVisibilityListener _tabOrderAndVisibilityListener = null;
    private String _noComponentsStr = "No Components has been added to this tab";
    private Watermark _watermark = null;

    public GTabbedPane() {
        this.init();
    }

    public GTabbedPane(String name) {
        this.setName(name);
        this.init();
    }

    public GTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.init();
    }

    public GTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this._restoreTabLayoutPolicy = false;
        this.init();
    }

    private synchronized void init() {
        this.addMouseListener(this);
        this._tabMenu = this.createTabPopupMenu();
        this.setTabLayoutPolicy(super.getTabLayoutPolicy());
        this.setWatermarkAnchor(this);
        String name = this.getName();
        if (!StringUtil.isNullOrBlank(name) && this._restoreTabLayoutPolicy) {
            Configuration conf = Configuration.getCombinedConfiguration();
            this.setTabLayoutPolicy(conf.getIntProperty("GTabbedPane." + name + ".TabLayoutPolicy", this.getTabLayoutPolicy()));
        }
        this._initialized = true;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        super.addChangeListener(l);
        if (this._initialized) {
            if (this._localChangeListeners == null) {
                this._localChangeListeners = new LinkedHashSet<ChangeListener>();
            }
            this._localChangeListeners.add(l);
            for (int t = 0; t < this.getTabCount(); ++t) {
                Component comp = this.getComponentAt(t);
                if (!(comp instanceof JTabbedPane)) continue;
                ((JTabbedPane)comp).addChangeListener(l);
            }
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        super.removeChangeListener(l);
        if (this._initialized) {
            if (this._localChangeListeners != null) {
                this._localChangeListeners.remove(l);
            }
            for (int t = 0; t < this.getTabCount(); ++t) {
                Component comp = this.getComponentAt(t);
                if (!(comp instanceof JTabbedPane)) continue;
                ((JTabbedPane)comp).removeChangeListener(l);
            }
        }
    }

    public boolean getUseFocusableTips() {
        return this._useFocusableTips;
    }

    public void setUseFocusableTips(boolean use) {
        if (use != this._useFocusableTips) {
            this._useFocusableTips = use;
            this.firePropertyChange(FOCUSABLE_TIPS_PROPERTY, !use, use);
        }
    }

    public boolean getUseFocusableTipForText(String toolTipText) {
        int ttLen = 0;
        if (toolTipText != null) {
            ttLen = toolTipText.length();
        }
        return ttLen > this._useFocusableTipAboveSize;
    }

    public void setUseFocusableTipsSize(int size) {
        this._useFocusableTipAboveSize = size;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String text = super.getToolTipText(e);
        if (this.getUseFocusableTips() && this.getUseFocusableTipForText(text)) {
            if (text != null) {
                if (this._focusableTip == null) {
                    this._focusableTip = new FocusableTip(this);
                }
                this._focusableTip.toolTipRequested(e, text);
            } else if (this._focusableTip != null) {
                this._focusableTip.possiblyDisposeOfTipWindow();
            }
            return null;
        }
        return text;
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
    }

    public boolean contains(Component comp) {
        return GTabbedPane.contains(this, comp);
    }

    private static boolean contains(JTabbedPane tp, Component comp) {
        if (tp.equals(comp)) {
            return true;
        }
        for (int t = 0; t < tp.getTabCount(); ++t) {
            Component tcomp = tp.getComponentAt(t);
            if (tcomp.equals(comp)) {
                return true;
            }
            if (!(tcomp instanceof JTabbedPane) || !GTabbedPane.contains((JTabbedPane)tcomp, tcomp)) continue;
            return true;
        }
        return false;
    }

    public String getSelectedTitle(boolean doSubLevels) {
        return GTabbedPane.getSelectedTitle(this, doSubLevels);
    }

    private static String getSelectedTitle(JTabbedPane tp, boolean doSubLevels) {
        int index = tp.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        Component comp = tp.getComponentAt(index);
        if (comp instanceof JTabbedPane && doSubLevels) {
            return GTabbedPane.getSelectedTitle((JTabbedPane)comp, doSubLevels);
        }
        return tp.getTitleAt(index);
    }

    public Component getSelectedComponent(boolean doSubLevels) {
        return GTabbedPane.getSelectedComponent(this, doSubLevels);
    }

    @Override
    public Component getSelectedComponent() {
        return GTabbedPane.getSelectedComponent(this, true);
    }

    private static Component getSelectedComponent(JTabbedPane tp, boolean doSubLevels) {
        int index = tp.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        Component comp = tp.getComponentAt(index);
        if (comp instanceof JTabbedPane && doSubLevels) {
            return GTabbedPane.getSelectedComponent((JTabbedPane)comp, doSubLevels);
        }
        return tp.getComponentAt(index);
    }

    public boolean hasChildPanels() {
        return GTabbedPane.hasChildPanels(this);
    }

    public static boolean hasChildPanels(JTabbedPane tp) {
        if (tp == null) {
            return false;
        }
        for (int t = 0; t < tp.getTabCount(); ++t) {
            Component comp = tp.getComponentAt(t);
            if (!(comp instanceof JTabbedPane)) continue;
            return true;
        }
        return false;
    }

    public List<String> getAllTitles(String format) {
        ArrayList<String> titles = new ArrayList<String>();
        this.getAllTitles(this, titles, format, null);
        return titles;
    }

    public List<String> getAllTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        this.getAllTitles(this, titles, null, null);
        return titles;
    }

    private void getAllTitles(JTabbedPane tp, List<String> list, String format, String parentName) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            Component comp = tp.getComponentAt(t);
            String tabTitle = tp.getTitleAt(t);
            if (comp instanceof JTabbedPane) {
                this.getAllTitles((JTabbedPane)comp, list, format, tabTitle);
                continue;
            }
            String formatedStr = tabTitle;
            if (!StringUtil.isNullOrBlank(format)) {
                formatedStr = format;
                formatedStr = formatedStr.replace("${TAB_NAME}", tabTitle);
                formatedStr = formatedStr.replace("${GROUP_NAME}", parentName == null ? "" : parentName);
            }
            list.add(formatedStr);
        }
    }

    public boolean setSelectedTitle(String title) {
        return this.setSelectedTitle(this, title);
    }

    private boolean setSelectedTitle(JTabbedPane tp, String title) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            Component comp = tp.getComponentAt(t);
            String tabTitle = tp.getTitleAt(t);
            if (comp instanceof JTabbedPane) {
                boolean b = this.setSelectedTitle((JTabbedPane)comp, title);
                if (!b) continue;
                tp.setSelectedIndex(t);
                return true;
            }
            if (!tabTitle.equals(title)) continue;
            tp.setSelectedIndex(t);
            return true;
        }
        return false;
    }

    public String getParentTitleName(String title) {
        return this.getParentTitleName(this, title, null);
    }

    private String getParentTitleName(JTabbedPane tp, String title, String parent) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            Component comp = tp.getComponentAt(t);
            String tabTitle = tp.getTitleAt(t);
            if (comp instanceof JTabbedPane) {
                String p = this.getParentTitleName((JTabbedPane)comp, title, tabTitle);
                if (p == null) continue;
                return p;
            }
            if (!tabTitle.equals(title) || parent == null) continue;
            return parent;
        }
        return null;
    }

    public JMenuItem getMenuItemNamed(String name) {
        JPopupMenu tabMenu = this.getTabPopupMenu();
        if (tabMenu != null) {
            for (int i = 0; i < tabMenu.getComponentCount(); ++i) {
                JMenuItem mi;
                Component comp = tabMenu.getComponent(i);
                if (!(comp instanceof JMenuItem) || !name.equals((mi = (JMenuItem)comp).getName())) continue;
                _logger.debug((Object)("Found JMenuItem for name '" + name + "'."));
                return mi;
            }
        }
        return null;
    }

    public JMenu getMenuNamed(String name) {
        JPopupMenu tabMenu = this.getTabPopupMenu();
        if (tabMenu != null) {
            for (int i = 0; i < tabMenu.getComponentCount(); ++i) {
                JMenu m;
                Component comp = tabMenu.getComponent(i);
                if (!(comp instanceof JMenu) || (m = this.getMenuNamed((JMenu)comp, name)) == null) continue;
                return m;
            }
        }
        return null;
    }

    private JMenu getMenuNamed(JMenu menu, String name) {
        _logger.trace((Object)("getMenuNamed(): name='" + name + "', jmenu.getName()='" + menu.getName() + "'."));
        if (name.equals(menu.getName())) {
            _logger.debug((Object)("Found JMenu for name '" + name + "'."));
            return menu;
        }
        _logger.trace((Object)("getMenuNamed(): name='" + name + "', menu.getMenuComponentCount()='" + menu.getMenuComponentCount() + "'."));
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            JMenu m;
            Component comp = menu.getMenuComponent(i);
            if (!(comp instanceof JMenu) || (m = this.getMenuNamed((JMenu)comp, name)) == null) continue;
            return m;
        }
        return null;
    }

    public ImageIcon getUndockedFrameIcon() {
        return this._undockedFrameIcon;
    }

    public ImageIcon getWindowUndockIcon() {
        return this._iconWinPlus;
    }

    public ImageIcon getWindowDockIcon() {
        return this._iconWinMinus;
    }

    public void setUndockedFrameIcon(ImageIcon icon) {
        this._undockedFrameIcon = icon;
    }

    public void setWindowUndockIcon(ImageIcon icon) {
        this._iconWinPlus = icon;
    }

    public void setWindowDockIcon(ImageIcon icon) {
        this._iconWinMinus = icon;
    }

    public JButton getDockOrUndockButton(int viewIndex) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        return xe == null ? null : xe._winOpenCloseButton;
    }

    public JButton getDockOrUndockButton(String tabName) {
        TabExtendedEntry xe = this.getExtendedEntry(tabName);
        return xe == null ? null : xe._winOpenCloseButton;
    }

    public void setDockOrUndockButtonGui(JButton button) {
        button.setIcon(this.getWindowUndockIcon());
        button.setText(null);
        button.setContentAreaFilled(false);
        button.setMargin(new Insets(3, 3, 3, 3));
        button.setToolTipText("Show the content of this panel in it's own window (and disappear from the TabbedPane).\n To put the panel back on the TabbedPane, just close the window.");
    }

    public void setDockOrUndockButton(int index, JButton button, boolean setDefaultGui) {
        TabExtendedEntry xe = this.getViewExtendedEntry(index);
        if (xe == null) {
            return;
        }
        xe._winOpenCloseButton = button;
        if (xe._winOpenCloseButton == null) {
            return;
        }
        if (setDefaultGui) {
            this.setDockOrUndockButtonGui(xe._winOpenCloseButton);
        }
        xe._winOpenCloseButton.putClientProperty("TabExtendedEntry", xe);
        xe._winOpenCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button = (JButton)e.getSource();
                TabExtendedEntry xe = (TabExtendedEntry)button.getClientProperty("TabExtendedEntry");
                if (xe != null) {
                    GTabbedPane.this.windowOpenClose(xe._tabIndex);
                }
            }
        });
    }

    public void setDockOrUndockButton(String tabName, JButton button, boolean setDefaultGui) {
        this.setDockOrUndockButton(this.getModelExtendedEntryIndex(tabName), button, setDefaultGui);
    }

    public JButton createDockOrUndockButton() {
        JButton button = new JButton();
        this.setDockOrUndockButtonGui(button);
        return button;
    }

    public JPopupMenu getTabPopupMenu() {
        return this._tabMenu;
    }

    public JPopupMenu createTabPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem undock_mi = new JMenuItem("Un Dock, show content in a window");
        JMenuItem dock_mi = new JMenuItem("Dock, bring back the window into the tab");
        JMenuItem ontop_mi = new JMenuItem("On Top, bring un docked window to front");
        JRadioButtonMenuItem tabScroll_mi = new JRadioButtonMenuItem("Tab Layout Scroll");
        JRadioButtonMenuItem tabWrap_mi = new JRadioButtonMenuItem("Tab Layout Wrap");
        JMenu tabOptions_m = new JMenu("Tab Options");
        JMenuItem tabViewDialog_mi = new JMenuItem("Open Tab View Dialog...");
        JMenuItem hideThisTab_mi = new JMenuItem("Hide this Tab");
        JMenu showHideTab_m = new JMenu("Show or Hide Tab Named");
        JMenu gotoTab_m = new JMenu("Goto Tab Name");
        JMenuItem props_mi = new JMenuItem("Properties...");
        undock_mi.setName("UNDOCK");
        dock_mi.setName("DOCK");
        ontop_mi.setName("ONTOP");
        tabScroll_mi.setName("SCROLL");
        tabWrap_mi.setName("WRAP");
        tabOptions_m.setName("TAB_OPTIONS");
        gotoTab_m.setName("GOTO");
        props_mi.setName("PROPS");
        tabViewDialog_mi.setName("OPEN_TAB_VIEW_DIALOG");
        hideThisTab_mi.setName("HIDE_THIS_TAB");
        showHideTab_m.setName("SHOW_OR_HIDE");
        ActionListener dockAl = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTabbedPane.this.windowOpenClose(GTabbedPane.this._lastMouseClickAtTabIndex);
            }
        };
        undock_mi.addActionListener(dockAl);
        dock_mi.addActionListener(dockAl);
        ontop_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabExtendedEntry xe = GTabbedPane.this.getViewExtendedEntry(GTabbedPane.this._lastMouseClickAtTabIndex);
                if (xe == null) {
                    return;
                }
                if (xe._undockedFrame != null && !xe._isDocked) {
                    xe._undockedFrame.setVisible(true);
                }
            }
        });
        tabScroll_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTabbedPane.this.setTabLayoutPolicy(1);
            }
        });
        tabWrap_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTabbedPane.this.setTabLayoutPolicy(0);
            }
        });
        tabViewDialog_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GTabbedPaneViewDialog.showDialog(null, GTabbedPane.this);
            }
        });
        hideThisTab_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabExtendedEntry xe = GTabbedPane.this.getViewExtendedEntry(GTabbedPane.this._lastMouseClickAtTabIndex);
                if (xe == null) {
                    return;
                }
                GTabbedPane.this.setVisibleAtModel(xe._modelIndex, false);
            }
        });
        props_mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabExtendedEntry xe = GTabbedPane.this.getViewExtendedEntry(GTabbedPane.this._lastMouseClickAtTabIndex);
                if (xe == null) {
                    return;
                }
                if (xe._comp != null && xe._comp instanceof ShowProperties) {
                    ShowProperties sp = (ShowProperties)((Object)xe._comp);
                    sp.showProperties();
                }
            }
        });
        popupMenu.add(undock_mi);
        popupMenu.add(dock_mi);
        popupMenu.add(ontop_mi);
        popupMenu.addSeparator();
        popupMenu.add(tabScroll_mi);
        popupMenu.add(tabWrap_mi);
        popupMenu.addSeparator();
        popupMenu.add(tabOptions_m);
        popupMenu.add(gotoTab_m);
        popupMenu.add(props_mi);
        tabOptions_m.add(tabViewDialog_mi);
        tabOptions_m.add(hideThisTab_mi);
        tabOptions_m.add(showHideTab_m);
        return popupMenu;
    }

    private void windowOpenClose(int viewIndex) {
        _logger.debug((Object)("windowOpenClose(viewIndex=" + viewIndex + "): title='" + this.getTitleAt(viewIndex) + "'."));
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe == null) {
            _logger.debug((Object)("windowOpenClose(viewIndex=" + viewIndex + "): title='" + this.getTitleAt(viewIndex) + "'. NO TabExtendedEntry WAS FOUND, leaving method at top."));
            return;
        }
        if (xe._isDocked) {
            boolean allowed;
            if (xe._comp instanceof DockUndockManagement && !(allowed = ((DockUndockManagement)((Object)xe._comp)).beforeUndock())) {
                JOptionPane.showMessageDialog(this, "The tab named '" + xe._tabName + "' Can't be UnDocked.\nThe decision for this was taken by the underlying component.", "Un Dock", 1);
                return;
            }
            if (xe._winOpenCloseButton != null) {
                xe._winOpenCloseButton.setIcon(this.getWindowDockIcon());
            }
            if (xe._undockedFrame == null) {
                xe._undockedFrame = new JFrame(xe._tabName);
                xe._undockedFrame.setName(xe._tabName);
                xe._undockedFrame.setTitle(xe._tabName);
                boolean noIcon = true;
                if (xe._icon != null && xe._icon instanceof ImageIcon) {
                    xe._undockedFrame.setIconImage(((ImageIcon)xe._icon).getImage());
                    noIcon = false;
                }
                if (noIcon) {
                    xe._undockedFrame.setIconImage(this.getUndockedFrameIcon().getImage());
                }
                if (xe._comp != null) {
                    GTabbedPaneWindowProps wp = null;
                    if (xe._comp instanceof DockUndockManagement) {
                        wp = ((DockUndockManagement)((Object)xe._comp)).getWindowProps();
                    }
                    if (wp == null) {
                        wp = new GTabbedPaneWindowProps();
                    }
                    if (wp.width == -1 && wp.height == -1) {
                        Dimension dim = xe._comp.getPreferredSize();
                        if (dim.height < 100) {
                            dim.height = 100;
                        }
                        if (dim.width < 300) {
                            dim.width = 300;
                        }
                        wp.height = dim.height;
                        wp.width = dim.width;
                    }
                    xe._undockedFrame.setSize(wp.width, wp.height);
                    if (wp.posX != -1 && wp.posY != -1) {
                        xe._undockedFrame.setLocation(wp.posX, wp.posY);
                    }
                }
                xe._undockedFrame.addWindowListener(new WindowAdapter(){

                    private void saveWindowSize(boolean open, WindowEvent e) {
                        String name = e.getWindow().getName();
                        TabExtendedEntry xe = GTabbedPane.this.getExtendedEntry(name);
                        if (xe != null && xe._comp instanceof DockUndockManagement) {
                            GTabbedPaneWindowProps wp = new GTabbedPaneWindowProps();
                            wp.undocked = open;
                            wp.height = e.getWindow().getSize().height;
                            wp.width = e.getWindow().getSize().width;
                            wp.posX = e.getWindow().getX();
                            wp.posY = e.getWindow().getY();
                            ((DockUndockManagement)((Object)xe._comp)).saveWindowProps(wp);
                        }
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                        this.saveWindowSize(true, e);
                    }

                    @Override
                    public void windowOpened(WindowEvent e) {
                        this.saveWindowSize(true, e);
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        String name = e.getWindow().getName();
                        _logger.debug((Object)("FRAME.windowClosing: name = '" + name + "'."));
                        TabExtendedEntry xe = GTabbedPane.this.getExtendedEntry(name);
                        if (xe == null) {
                            _logger.info((Object)("The internal ExtendedEntry for '" + name + "' Can't be found. Can't undock the window..."));
                        } else {
                            this.saveWindowSize(false, e);
                            GTabbedPane.this.removeTabAt(xe._tabIndex);
                            GTabbedPane.this.insertTab(xe._tabName, xe._icon, xe, xe._toolTip, xe._tabIndex);
                            GTabbedPane.this.setSelectedIndex(xe._tabIndex);
                            xe._isDocked = true;
                            if (xe._winOpenCloseButton != null) {
                                xe._winOpenCloseButton.setIcon(GTabbedPane.this.getWindowUndockIcon());
                            }
                            if (xe._comp instanceof DockUndockManagement) {
                                ((DockUndockManagement)((Object)xe._comp)).afterDock();
                            }
                        }
                    }
                });
            }
            xe._isDocked = false;
            xe._undockedFrame.getContentPane().add(xe._comp);
            xe._undockedFrame.setVisible(true);
            UndockedTabHolder holder = new UndockedTabHolder(xe);
            this.insertTab(xe._tabName, xe._icon, holder, xe._toolTip, xe._tabIndex);
            this.setEnabledAt(xe._tabIndex, false);
            boolean foundOneActive = false;
            for (int i = xe._tabIndex; i < this.getTabCount(); ++i) {
                if (!this.isEnabledAt(i)) continue;
                foundOneActive = true;
                this.setSelectedIndex(i);
                break;
            }
            if (!foundOneActive && this.getTabCount() > 0) {
                this.setSelectedIndex(0);
            }
            if (xe._comp instanceof DockUndockManagement) {
                ((DockUndockManagement)((Object)xe._comp)).afterUndock();
            }
        } else {
            boolean allowed;
            if (xe._comp instanceof DockUndockManagement && !(allowed = ((DockUndockManagement)((Object)xe._comp)).beforeDock())) {
                JOptionPane.showMessageDialog(this, "The tab named '" + xe._tabName + "' Can't be Docked.\nThe decision for this was taken by the underlying component.", "Dock", 1);
                return;
            }
            xe._undockedFrame.dispatchEvent(new WindowEvent(xe._undockedFrame, 201));
        }
    }

    private TabExtendedEntry getViewExtendedEntry(int viewIndex) {
        _logger.trace((Object)("getViewExtendedEntry(index=" + viewIndex + "), _extEntry.size() = " + this._extEntry.size()));
        Enumeration iter = this._extEntry.elements();
        while (iter.hasMoreElements()) {
            Object o = iter.nextElement();
            TabExtendedEntry xe = null;
            xe = o instanceof UndockedTabHolder ? ((UndockedTabHolder)o)._xe : (TabExtendedEntry)o;
            if (xe == null) continue;
            _logger.debug((Object)("getViewExtendedEntry(viewIndex=" + viewIndex + ") - xe._saveName='" + xe._tabName + "'."));
            if (xe._tabIndex != viewIndex) continue;
            _logger.debug((Object)("getViewExtendedEntry(viewIndex=" + viewIndex + ") - FOUND ENTRY: " + xe));
            return xe;
        }
        _logger.debug((Object)("getViewExtendedEntry(viewIndex=" + viewIndex + ") - NOT FOUND -"));
        return null;
    }

    private TabExtendedEntry getModelExtendedEntry(int modelIndex) {
        Object o = this._extEntry.get(modelIndex);
        TabExtendedEntry xe = null;
        xe = o instanceof UndockedTabHolder ? ((UndockedTabHolder)o)._xe : (TabExtendedEntry)o;
        _logger.trace((Object)("getModelExtendedEntry(modelIndex=" + modelIndex + "), found entry(" + (o instanceof UndockedTabHolder ? "UndockedTabHolder" : "TabExtendedEntry") + "): " + xe));
        return xe;
    }

    private int getModelExtendedEntryIndex(String name) {
        Enumeration iter = this._extEntry.elements();
        while (iter.hasMoreElements()) {
            Object o = iter.nextElement();
            TabExtendedEntry xe = null;
            xe = o instanceof UndockedTabHolder ? ((UndockedTabHolder)o)._xe : (TabExtendedEntry)o;
            _logger.debug((Object)("getExtendedEntryIndex(name='" + name + "') - xe._saveName='" + xe._tabName + "'."));
            if (!name.equals(xe._tabName)) continue;
            _logger.debug((Object)("getExtendedEntryIndex(name='" + name + "') - FOUND ENTRY: " + xe));
            return xe._modelIndex;
        }
        _logger.debug((Object)("getExtendedEntryIndex(name='" + name + "') - NOT FOUND -"));
        return -1;
    }

    private TabExtendedEntry getExtendedEntry(String name) {
        return GTabbedPane.getExtendedEntry(this, name);
    }

    private static TabExtendedEntry getExtendedEntry(GTabbedPane tp, String name) {
        if (name == null) {
            return null;
        }
        Enumeration iter = tp._extEntry.elements();
        while (iter.hasMoreElements()) {
            Object o = iter.nextElement();
            TabExtendedEntry xe = null;
            xe = o instanceof UndockedTabHolder ? ((UndockedTabHolder)o)._xe : (TabExtendedEntry)o;
            if (xe == null) continue;
            _logger.debug((Object)("getExtendedEntry(name='" + name + "') - xe._saveName='" + xe._tabName + "'."));
            if (!name.equals(xe._tabName)) continue;
            _logger.debug((Object)("getExtendedEntry(name='" + name + "') - FOUND ENTRY: " + xe));
            return xe;
        }
        _logger.debug((Object)("getExtendedEntry(name='" + name + "') - NOT FOUND -"));
        return null;
    }

    public boolean isTabUnDocked(String title) {
        return GTabbedPane.isTabUnDocked(this, title, true);
    }

    public boolean isTabUnDocked(String title, boolean doSubLevels) {
        return GTabbedPane.isTabUnDocked(this, title, doSubLevels);
    }

    private static boolean isTabUnDocked(GTabbedPane tp, String title, boolean doSubLevels) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            String titleName = tp.getTitleAt(t);
            Component comp = tp.getComponentAt(t);
            if (title.equals(titleName)) {
                TabExtendedEntry xe = tp.getExtendedEntry(title);
                if (xe == null) {
                    return false;
                }
                return !xe._isDocked;
            }
            if (!(comp instanceof GTabbedPane) || !doSubLevels) continue;
            return GTabbedPane.isTabUnDocked((GTabbedPane)comp, title, doSubLevels);
        }
        return false;
    }

    public boolean isTabUnDocked(int viewIndex) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe == null) {
            return false;
        }
        return !xe._isDocked;
    }

    public JFrame getTabUnDockedFrame(String name) {
        TabExtendedEntry xe = this.getExtendedEntry(name);
        if (xe == null) {
            return null;
        }
        return !xe._isDocked ? xe._undockedFrame : null;
    }

    public JFrame getTabUnDockedFrame(int viewIndex) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe == null) {
            return null;
        }
        return !xe._isDocked ? xe._undockedFrame : null;
    }

    private void printExtendedEntryTable(String preStr) {
        Enumeration iter = this._extEntry.elements();
        while (iter.hasMoreElements()) {
            Object o = iter.nextElement();
            System.out.println(preStr + o);
        }
    }

    public void setVisibleAtModel(List<String> tabNameList, boolean toVisible) {
        for (String tabName : tabNameList) {
            this.setVisibleAtModel(tabName, toVisible);
        }
    }

    public void setVisibleAtModel(String parentName, String tabName, boolean toVisible) {
        int modelIndex;
        Component comp;
        int index;
        GTabbedPane tp = this;
        if (!StringUtil.isNullOrBlank(parentName) && (index = tp.indexOfTab(parentName)) >= 0 && (comp = tp.getComponentAt(index)) instanceof GTabbedPane) {
            tp = (GTabbedPane)comp;
        }
        if ((modelIndex = tp.getModelExtendedEntryIndex(tabName)) < 0) {
            _logger.warn((Object)("setVisibleAtModel(parentName='" + parentName + "', tabName='" + tabName + "', toVisible=" + toVisible + ") Couldn't find tabName. modelIndex=" + modelIndex));
            return;
        }
        tp.setVisibleAtModel(modelIndex, toVisible);
    }

    public void setVisibleAtModel(String tabName, boolean toVisible) {
        int modelIndex = this.getModelExtendedEntryIndex(tabName);
        if (modelIndex < 0) {
            _logger.warn((Object)("setVisibleAtModel(tabName='" + tabName + "', toVisible=" + toVisible + ") Couldn't find tabName. modelIndex=" + modelIndex));
            return;
        }
        this.setVisibleAtModel(modelIndex, toVisible);
    }

    public void setVisibleAtModel(int modelIndex, boolean toVisible) {
        TabExtendedEntry xe = this.getModelExtendedEntry(modelIndex);
        if (xe == null) {
            return;
        }
        if (xe._isVisible == toVisible) {
            return;
        }
        if (toVisible) {
            int atIndex = this.getInvisibleTabInsertionPoint(this.getTabOrder(), xe);
            super.insertTab(xe._tabName, xe._icon, xe._comp, xe._toolTip, atIndex);
            xe._isVisible = true;
            this.fixTabExtendedEntry();
        } else {
            int nextIndex = this.indexOfTab(xe._tabName) + 1;
            xe._rmBeforeTab = nextIndex >= this.getTabCount() ? null : this.getTitleAt(nextIndex);
            super.removeTabAt(xe._tabIndex);
            xe._isVisible = false;
            this.fixTabExtendedEntry();
        }
    }

    private void fixTabExtendedEntry() {
        List<String> visibleTabs = this.getTabOrder();
        for (int i = 0; i < this._extEntry.size(); ++i) {
            TabExtendedEntry xe = this.getModelExtendedEntry(i);
            if (xe == null) continue;
            xe._modelIndex = i;
            xe._tabIndex = visibleTabs.indexOf(xe._tabName);
        }
    }

    private int getInvisibleTabInsertionPoint(List<String> colList, TabExtendedEntry xe) {
        if (colList == null) {
            throw new RuntimeException("getInvisibleTabInsertionPoint() colList, can't be null.");
        }
        if (xe == null || xe != null && xe._rmBeforeTab == null) {
            return colList.size();
        }
        String rmBeforeTab = xe._rmBeforeTab;
        int atIndex = -1;
        for (int m = 0; m < 256 && rmBeforeTab != null && (atIndex = colList.indexOf(rmBeforeTab)) < 0; ++m) {
            TabExtendedEntry x1 = this.getExtendedEntry(rmBeforeTab);
            rmBeforeTab = x1 != null ? x1._rmBeforeTab : null;
        }
        if (atIndex < 0 || atIndex > colList.size()) {
            atIndex = colList.size();
        }
        return atIndex;
    }

    public boolean isVisibleAtModel(String tabName) {
        int modelIndex = this.getModelExtendedEntryIndex(tabName);
        if (modelIndex < 0) {
            _logger.warn((Object)("isVisibleAtModel(tabName='" + tabName + "') Couldn't find tabName. modelIndex=" + modelIndex));
            return false;
        }
        return this.isVisibleAtModel(modelIndex);
    }

    public boolean isVisibleAtModel(int modelIndex) {
        TabExtendedEntry xe = this.getModelExtendedEntry(modelIndex);
        if (xe == null) {
            return false;
        }
        return xe._isVisible;
    }

    public int getVisibleTabCount() {
        return this.getTabCount();
    }

    public int getModelTabCount() {
        return this._extEntry.size();
    }

    public String getTitleAtModel(int modelIndex) {
        return ((TabExtendedEntry)this._extEntry.get(modelIndex))._tabName;
    }

    public Icon getIconAtModel(int modelIndex) {
        return ((TabExtendedEntry)this._extEntry.get(modelIndex))._icon;
    }

    public String getToolTipTextAtModel(int modelIndex) {
        return ((TabExtendedEntry)this._extEntry.get(modelIndex))._toolTip;
    }

    public Component getComponentAtModel(int modelIndex) {
        return ((TabExtendedEntry)this._extEntry.get(modelIndex))._comp;
    }

    public void setForegroundAtModel(int modelIndex, Color color) {
        TabExtendedEntry xe = this.getModelExtendedEntry(modelIndex);
        if (xe == null) {
            return;
        }
        if (!xe._isVisible) {
            return;
        }
        this.setForegroundAt(xe._tabIndex, color);
    }

    public Color getForegroundAtModel(int modelIndex) {
        TabExtendedEntry xe = this.getModelExtendedEntry(modelIndex);
        if (xe == null) {
            throw new RuntimeException("TabExtendedEntry was null for model index " + modelIndex);
        }
        if (!xe._isVisible) {
            return xe.getBackground();
        }
        return this.getForegroundAt(xe._tabIndex);
    }

    public int modelIndexOfComponent(Component comp) {
        if (comp != null) {
            for (int m = 0; m < this._extEntry.size(); ++m) {
                if (!comp.equals(((TabExtendedEntry)this._extEntry.get(m))._comp)) continue;
                return m;
            }
        }
        return -1;
    }

    public List<String> getModelTabOrder() {
        ArrayList<String> tabOrder = new ArrayList<String>();
        for (int t = 0; t < this.getModelTabCount(); ++t) {
            tabOrder.add(this.getTitleAtModel(t));
        }
        return tabOrder;
    }

    public List<String> getTabOrder() {
        return this.getTabOrder(false);
    }

    public List<String> getTabOrder(boolean includeNonVisible) {
        int t;
        ArrayList<String> tabOrder = new ArrayList<String>();
        for (t = 0; t < this.getTabCount(); ++t) {
            tabOrder.add(this.getTitleAt(t));
        }
        if (includeNonVisible) {
            for (t = 0; t < this.getModelTabCount(); ++t) {
                TabExtendedEntry xe = this.getModelExtendedEntry(t);
                if (xe == null || xe._isVisible) continue;
                int atIndex = this.getInvisibleTabInsertionPoint(tabOrder, xe);
                tabOrder.add(atIndex, this.getTitleAtModel(t));
            }
        }
        return tabOrder;
    }

    public void setTabOrder(String[] newTabOrder) {
        ArrayList<String> newTabOrderList = new ArrayList<String>();
        for (String str : newTabOrder) {
            newTabOrderList.add(str);
        }
        this.setTabOrder(newTabOrderList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTabOrder(List<String> newTabOrder) {
        ChangeListener[] saveListeners;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("New tab order START: " + newTabOrder));
        }
        List<String> currentTabOrder = this.getTabOrder();
        currentTabOrder.removeAll(newTabOrder);
        newTabOrder.addAll(currentTabOrder);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("New tab order FIXED: " + newTabOrder));
        }
        for (ChangeListener cl : saveListeners = this.getChangeListeners()) {
            this.removeChangeListener(cl);
        }
        try {
            int tabCount = this.getTabCount();
            while (tabCount-- > 0) {
                super.removeTabAt(tabCount);
            }
            int newIndex = 0;
            for (String tabName : newTabOrder) {
                TabExtendedEntry xe = this.getExtendedEntry(tabName);
                if (xe == null) {
                    _logger.info((Object)("Can't find tab named '" + tabName + "' in the current tab pane, skipping this one when setting tab order."));
                    continue;
                }
                if (!xe._isVisible) continue;
                super.insertTab(xe._tabName, xe._icon, xe._comp, xe._toolTip, newIndex++);
            }
            this.fixTabExtendedEntry();
        }
        catch (Throwable t) {
            _logger.warn((Object)("While remove/restoring all the tabs an Exception occurred, which will be discarded. Now I will restore all ChangeListeners. Caught: " + t), t);
        }
        finally {
            for (ChangeListener cl : saveListeners) {
                this.addChangeListener(cl);
            }
        }
    }

    public void setTabOrderAndVisibility(String entries) {
        if (entries == null) {
            return;
        }
        ArrayList<String> listEntries = new ArrayList<String>();
        String[] sa = entries.split(",");
        for (int i = 0; i < sa.length; ++i) {
            listEntries.add(sa[i].trim());
        }
        this.setTabOrderAndVisibility(listEntries);
    }

    public void setTabOrderAndVisibility(String[] entries) {
        if (entries == null) {
            return;
        }
        ArrayList<String> entryList = new ArrayList<String>();
        for (String str : entries) {
            entryList.add(str);
        }
        this.setTabOrderAndVisibility(entryList);
    }

    public void setTabOrderAndVisibility(List<String> entryList) {
        if (entryList == null) {
            return;
        }
        ArrayList<String> tabOrder = new ArrayList<String>();
        ArrayList<String> showTabs = new ArrayList<String>();
        ArrayList<String> hideTabs = new ArrayList<String>();
        showTabs.addAll(this.getTabOrder(true));
        for (String entry : entryList) {
            String[] sa = entry.split("=");
            String tabName = sa[0].trim();
            String tabOpt = "true";
            if (sa.length >= 2) {
                tabOpt = sa[1].trim();
            }
            tabOrder.add(tabName);
            if (!tabOpt.equalsIgnoreCase("false")) continue;
            showTabs.remove(tabName);
            hideTabs.add(tabName);
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)("setTabOrderAndVisibility(List): showTabs=" + showTabs));
            _logger.trace((Object)("setTabOrderAndVisibility(List): tabOrder=" + tabOrder));
            _logger.trace((Object)("setTabOrderAndVisibility(List): hideTabs=" + hideTabs));
        }
        this.setVisibleAtModel(showTabs, true);
        this.setTabOrder(tabOrder);
        this.setVisibleAtModel(hideTabs, false);
    }

    public String getTabOrderAndVisibility() {
        List<String> tabOrderList = this.getTabOrder(true);
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = tabOrderList.iterator();
        while (it.hasNext()) {
            String tabName = it.next();
            sb.append(tabName).append("=").append(this.isVisibleAtModel(tabName));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public void setTabLayoutPolicy(int policy) {
        GTabbedPane.setTabLayoutPolicy(this, policy);
    }

    public void super_setTabLayoutPolicy(int policy) {
        super.setTabLayoutPolicy(policy);
    }

    private static void setTabLayoutPolicy(GTabbedPane tp, int policy) {
        Configuration conf;
        String name;
        JMenuItem wrap = tp.getMenuItemNamed("WRAP");
        JMenuItem scroll = tp.getMenuItemNamed("SCROLL");
        if (wrap != null && wrap instanceof JRadioButtonMenuItem) {
            ((JRadioButtonMenuItem)wrap).setSelected(policy == 0);
        }
        if (scroll != null && scroll instanceof JRadioButtonMenuItem) {
            ((JRadioButtonMenuItem)scroll).setSelected(policy == 1);
        }
        tp.super_setTabLayoutPolicy(policy);
        if (tp._initialized) {
            for (int t = 0; t < tp.getTabCount(); ++t) {
                Component comp = tp.getComponentAt(t);
                if (!(comp instanceof GTabbedPane)) continue;
                GTabbedPane.setTabLayoutPolicy((GTabbedPane)comp, policy);
            }
        }
        if (tp._initialized && !StringUtil.isNullOrBlank(name = tp.getName()) && (conf = Configuration.getInstance("USER_TEMP")) != null) {
            String base = "GTabbedPane." + name + ".";
            conf.setProperty(base + "TabLayoutPolicy", policy);
            conf.save();
        }
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        GTabbedPaneWindowProps wp;
        TabExtendedEntry xe;
        _logger.trace((Object)("insertTab(title, icon, comp, tip, index): index=" + index + ", title=" + title + ", icon='" + icon + "', component=" + component + ", tip=" + tip));
        boolean newComponent = false;
        if (component instanceof UndockedTabHolder) {
            this._extEntry.insertElementAt(component, index);
        } else if (component instanceof TabExtendedEntry) {
            xe = (TabExtendedEntry)component;
            component = xe._comp;
            this._extEntry.set(index, xe);
        } else {
            JButton button;
            xe = new TabExtendedEntry();
            this._extEntry.insertElementAt(xe, index);
            newComponent = true;
            xe._isDocked = true;
            xe._tabIndex = index;
            xe._tabName = title;
            xe._icon = icon;
            xe._toolTip = tip;
            xe._comp = component;
            xe._undockedFrame = null;
            xe._isVisible = true;
            xe._rmBeforeTab = null;
            xe._modelIndex = index;
            xe._winOpenCloseButton = this.createDockOrUndockButton();
            if (xe._winOpenCloseButton != null) {
                this.setDockOrUndockButton(index, xe._winOpenCloseButton, true);
            }
            if (component instanceof DockUndockManagement && (button = ((DockUndockManagement)((Object)component)).getDockUndockButton()) != null) {
                this.setDockOrUndockButton(index, button, true);
            }
        }
        if (component instanceof JTabbedPane) {
            JTabbedPane tp = (JTabbedPane)component;
            for (ChangeListener l : this._localChangeListeners) {
                tp.addChangeListener(l);
            }
        }
        super.insertTab(title, icon, component, tip, index);
        this.fixTabExtendedEntry();
        if (newComponent && component instanceof DockUndockManagement && (wp = ((DockUndockManagement)((Object)component)).getWindowProps()) != null && wp.undocked) {
            this.windowOpenClose(index);
        }
    }

    @Override
    public void removeTabAt(int viewIndex) {
        _logger.trace((Object)("removeTabAt(index): viewIndex=" + viewIndex));
        Component component = this.getComponentAt(viewIndex);
        if (!(component instanceof UndockedTabHolder) && !(component instanceof TabExtendedEntry)) {
            _logger.trace((Object)("removeTabAt(index): viewIndex=" + viewIndex + ", comp='" + component.getClass().getName() + "', REMOVING TabExtendedEntry."));
            this._extEntry.removeElementAt(viewIndex);
            this.fixTabExtendedEntry();
        }
        super.removeTabAt(viewIndex);
    }

    @Override
    public void setIconAt(int viewIndex, Icon icon) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe != null) {
            xe._icon = icon;
        }
        super.setIconAt(viewIndex, icon);
    }

    @Override
    public void setToolTipTextAt(int viewIndex, String toolTipText) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe != null) {
            xe._toolTip = toolTipText;
        }
        super.setToolTipTextAt(viewIndex, toolTipText);
    }

    @Override
    public void setComponentAt(int viewIndex, Component component) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe != null) {
            xe._comp = component;
        }
        super.setComponentAt(viewIndex, component);
    }

    @Override
    public void setTitleAt(int viewIndex, String title) {
        TabExtendedEntry xe = this.getViewExtendedEntry(viewIndex);
        if (xe != null) {
            xe._tabName = title;
        }
        super.setTitleAt(viewIndex, title);
    }

    public void setIconAtTitle(String title, Icon icon) {
        GTabbedPane.setIconAtTitle(this, title, icon);
    }

    private static boolean setIconAtTitle(JTabbedPane tp, String title, Icon icon) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            String titleName = tp.getTitleAt(t);
            Component comp = tp.getComponentAt(t);
            if (title.equals(titleName)) {
                tp.setIconAt(t, icon);
                return true;
            }
            if (!(comp instanceof JTabbedPane) || !GTabbedPane.setIconAtTitle((JTabbedPane)comp, title, icon)) continue;
            return true;
        }
        return false;
    }

    public Icon getIconAtTitle(String title) {
        return GTabbedPane.getIconAtTitle(this, title, true);
    }

    public Icon getIconAtTitle(String title, boolean doSubLevels) {
        return GTabbedPane.getIconAtTitle(this, title, doSubLevels);
    }

    private static Icon getIconAtTitle(JTabbedPane tp, String title, boolean doSubLevels) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            Icon icon;
            String titleName = tp.getTitleAt(t);
            Component comp = tp.getComponentAt(t);
            if (title.equals(titleName)) {
                return tp.getIconAt(t);
            }
            if (!(comp instanceof JTabbedPane) || !doSubLevels || (icon = GTabbedPane.getIconAtTitle((JTabbedPane)comp, title, doSubLevels)) == null) continue;
            return icon;
        }
        return null;
    }

    public void setToolTipTextAtTitle(String title, String toolTipText) {
        GTabbedPane.setToolTipTextAtTitle(this, title, toolTipText);
    }

    private static boolean setToolTipTextAtTitle(JTabbedPane tp, String title, String toolTipText) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            String titleName = tp.getTitleAt(t);
            Component comp = tp.getComponentAt(t);
            if (title.equals(titleName)) {
                tp.setToolTipTextAt(t, toolTipText);
                return true;
            }
            if (!(comp instanceof JTabbedPane) || !GTabbedPane.setToolTipTextAtTitle((JTabbedPane)comp, title, toolTipText)) continue;
            return true;
        }
        return false;
    }

    public String getToolTipTextAtTitle(String title) {
        return GTabbedPane.getToolTipTextAtTitle(this, title, true);
    }

    public String getToolTipTextAtTitle(String title, boolean doSubLevels) {
        return GTabbedPane.getToolTipTextAtTitle(this, title, doSubLevels);
    }

    private static String getToolTipTextAtTitle(JTabbedPane tp, String title, boolean doSubLevels) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            String tt;
            String titleName = tp.getTitleAt(t);
            Component comp = tp.getComponentAt(t);
            if (title.equals(titleName)) {
                return tp.getToolTipTextAt(t);
            }
            if (!(comp instanceof JTabbedPane) || !doSubLevels || (tt = GTabbedPane.getToolTipTextAtTitle((JTabbedPane)comp, title, doSubLevels)) == null) continue;
            return tt;
        }
        return null;
    }

    public void setComponentAtTitle(String title, Component component) {
        GTabbedPane.setComponentAtTitle(this, title, component);
    }

    private static boolean setComponentAtTitle(JTabbedPane tp, String title, Component component) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            String titleName = tp.getTitleAt(t);
            Component comp = tp.getComponentAt(t);
            if (title.equals(titleName)) {
                tp.setComponentAt(t, component);
                return true;
            }
            if (!(comp instanceof JTabbedPane) || !GTabbedPane.setComponentAtTitle((JTabbedPane)comp, title, component)) continue;
            return true;
        }
        return false;
    }

    public Component getComponentAtTitle(String title) {
        return GTabbedPane.getComponentAtTitle(this, title, true);
    }

    public Component getComponentAtTitle(String title, boolean doSubLevels) {
        return GTabbedPane.getComponentAtTitle(this, title, doSubLevels);
    }

    private static Component getComponentAtTitle(JTabbedPane tp, String title, boolean doSubLevels) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            Component c;
            String titleName = tp.getTitleAt(t);
            Component comp = tp.getComponentAt(t);
            if (title.equals(titleName)) {
                return comp;
            }
            if (!(comp instanceof JTabbedPane) || !doSubLevels || (c = GTabbedPane.getComponentAtTitle((JTabbedPane)comp, title, doSubLevels)) == null) continue;
            return c;
        }
        return null;
    }

    public void setTitleAtTitle(String title, String newTitle) {
        GTabbedPane.setTitleAtTitle(this, title, newTitle);
    }

    private static boolean setTitleAtTitle(JTabbedPane tp, String title, String newTitle) {
        for (int t = 0; t < tp.getTabCount(); ++t) {
            String titleName = tp.getTitleAt(t);
            Component comp = tp.getComponentAt(t);
            if (title.equals(titleName)) {
                tp.setTitleAt(t, newTitle);
                return true;
            }
            if (!(comp instanceof JTabbedPane) || !GTabbedPane.setTitleAtTitle((JTabbedPane)comp, title, newTitle)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String tabName = null;
        Component tabComp = null;
        int tabIndex = -1;
        Point p = e.getPoint();
        tabIndex = this.indexAtLocation(p.x, p.y);
        if (tabIndex != -1) {
            tabName = this.getTitleAt(tabIndex);
            tabComp = this.getComponentAt(tabIndex);
        }
        this._lastMouseClickAtTabIndex = tabIndex;
        if (SwingUtilities.isRightMouseButton(e)) {
            if (e.getClickCount() == 1) {
                _logger.debug((Object)"SINGLE-RIGHT-CLICK");
                JPopupMenu tabMenu = this.getTabPopupMenu();
                if (tabMenu != null) {
                    JMenu showHideMenu;
                    JMenuItem dock = this.getMenuItemNamed("DOCK");
                    JMenuItem undock = this.getMenuItemNamed("UNDOCK");
                    JMenuItem ontop = this.getMenuItemNamed("ONTOP");
                    JMenuItem props = this.getMenuItemNamed("PROPS");
                    if (tabIndex == -1) {
                        _logger.debug((Object)"SINGLE-RIGHT-CLICK: NOT OVER TAB: Disables menu items 'dock, undock, show'");
                        this.setEnabledX(dock, false);
                        this.setEnabledX(undock, false);
                        this.setEnabledX(ontop, false);
                    } else {
                        if (this.isEnabledAt(tabIndex)) {
                            _logger.debug((Object)("SINGLE-RIGHT-CLICK: OVER ENABLED TAB: " + tabName));
                            this.setEnabledX(dock, false);
                            this.setEnabledX(undock, true);
                            this.setEnabledX(ontop, false);
                        } else {
                            _logger.debug((Object)("SINGLE-RIGHT-CLICK: OVER UN-ENABLED TAB: " + tabName));
                            this.setEnabledX(dock, true);
                            this.setEnabledX(undock, false);
                            this.setEnabledX(ontop, true);
                        }
                        if (tabComp instanceof ShowProperties) {
                            this.setEnabledX(props, true);
                        } else {
                            this.setEnabledX(props, false);
                        }
                    }
                    JMenu gotoMenu = this.getMenuNamed("GOTO");
                    if (gotoMenu != null) {
                        gotoMenu.removeAll();
                        for (int i = 0; i < this.getTabCount(); ++i) {
                            JMenuItem mi = new JMenuItem(this.getTitleAt(i), this.getIconAt(i));
                            mi.putClientProperty("tabIndex", new Integer(i));
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Object o = e.getSource();
                                    if (o instanceof JMenuItem) {
                                        JMenuItem mi = (JMenuItem)o;
                                        Object cp = mi.getClientProperty("tabIndex");
                                        if (cp != null && cp instanceof Integer) {
                                            int viewIndex = (Integer)cp;
                                            if (GTabbedPane.this.isEnabledAt(viewIndex)) {
                                                GTabbedPane.this.setSelectedIndex(viewIndex);
                                            } else {
                                                TabExtendedEntry xe = GTabbedPane.this.getViewExtendedEntry(viewIndex);
                                                if (xe == null) {
                                                    return;
                                                }
                                                if (xe._undockedFrame != null && !xe._isDocked) {
                                                    xe._undockedFrame.setVisible(true);
                                                }
                                            }
                                        }
                                        _logger.debug((Object)("GOTO: " + mi.getText()));
                                    }
                                }
                            });
                            gotoMenu.add(mi);
                        }
                    }
                    if ((showHideMenu = this.getMenuNamed("SHOW_OR_HIDE")) != null) {
                        showHideMenu.removeAll();
                        for (int modelIndex = 0; modelIndex < this.getModelTabCount(); ++modelIndex) {
                            TabExtendedEntry xe = this.getModelExtendedEntry(modelIndex);
                            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(xe._tabName, xe._icon, xe._isVisible);
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Object o = e.getSource();
                                    if (o instanceof JCheckBoxMenuItem) {
                                        JCheckBoxMenuItem cmi = (JCheckBoxMenuItem)o;
                                        TabExtendedEntry xei = GTabbedPane.this.getExtendedEntry(cmi.getText());
                                        GTabbedPane.this.setVisibleAtModel(xei._modelIndex, cmi.isSelected());
                                    }
                                }
                            });
                            showHideMenu.add(mi);
                        }
                    }
                    tabMenu.show(e.getComponent(), e.getX(), e.getY() - 10);
                }
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getClickCount() == 1) {
                _logger.debug((Object)("GTabbedPane.MouseListener: SINGLE-Click on index=" + tabIndex + ", name='" + tabName + "', tabComp=" + tabComp));
                if (tabComp instanceof UndockedTabHolder) {
                    UndockedTabHolder undocked = (UndockedTabHolder)tabComp;
                    TabExtendedEntry xe = undocked._xe;
                    if (xe._undockedFrame != null) {
                        xe._undockedFrame.setVisible(true);
                    }
                    return;
                }
            } else {
                if (_logger.isDebugEnabled()) {
                    String className = "";
                    if (tabComp != null) {
                        className = tabComp.getClass().getName();
                    }
                    _logger.debug((Object)("GTabbedPane.MouseListener: DOUBLE-Click on index=" + tabIndex + ", name='" + tabName + "', tabCompClassName='" + className + "', tabComp=" + tabComp));
                }
                if (tabComp instanceof UndockedTabHolder) {
                    this.windowOpenClose(tabIndex);
                    return;
                }
                if (tabComp instanceof JPanel) {
                    this.windowOpenClose(tabIndex);
                    return;
                }
                if (tabComp instanceof GTabbedPane) {
                    this.windowOpenClose(tabIndex);
                    return;
                }
                if (tabComp instanceof TabExtendedEntry) {
                    TabExtendedEntry xe = (TabExtendedEntry)tabComp;
                    this.windowOpenClose(xe._tabIndex);
                    return;
                }
                if (tabName != null) {
                    JOptionPane.showMessageDialog(this, "The tab named '" + tabName + "' Can't be UnDocked.\nIt needs to be a JPanel or implements the interface 'DockUndockManagement'.", "UnDock", 0);
                    return;
                }
                return;
            }
        }
    }

    private void setEnabledX(JComponent comp, boolean enable) {
        if (comp != null) {
            comp.setEnabled(enable);
        }
    }

    public void setTabOrderAndVisibilityListener(TabOrderAndVisibilityListener listener) {
        this._tabOrderAndVisibilityListener = listener;
    }

    public TabOrderAndVisibilityListener getTabOrderAndVisibilityListener() {
        return this._tabOrderAndVisibilityListener;
    }

    public void removeTabOrderAndVisibility() {
        if (this._tabOrderAndVisibilityListener == null) {
            _logger.warn((Object)"The 'removeTabOrderAndVisibilityListener' has not been set, can't do this action. at removeTabOrderAndVisibility()");
            return;
        }
        this._tabOrderAndVisibilityListener.removeTabOrderAndVisibility();
    }

    public void saveTabOrderAndVisibility() {
        if (this._tabOrderAndVisibilityListener == null) {
            _logger.warn((Object)"The 'tabOrderAndVisibilityListener' has not been set, can't do this action. at saveTabOrderAndVisibility()");
            return;
        }
        this._tabOrderAndVisibilityListener.saveTabOrderAndVisibility(this.getTabOrderAndVisibility());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintSpecial();
    }

    protected void paintSpecial() {
        int tabCount = this.getTabCount();
        for (int tabIndex = 0; tabIndex < tabCount; ++tabIndex) {
            Component tabComp = this.getComponentAt(tabIndex);
            if (!(tabComp instanceof SpecialTabPainter)) continue;
            SpecialTabPainter stp = (SpecialTabPainter)((Object)tabComp);
            Rectangle r = this.getUI().getTabBounds(this, tabIndex);
            if (r == null) {
                r = new Rectangle(0, 0, 16, 16);
            }
            Graphics g = this.getGraphics().create(r.x, r.y, r.width, r.height);
            stp.paintTabHeader((Graphics2D)g);
        }
        if (this._watermark != null) {
            if (tabCount == 0) {
                this._watermark.setWatermarkText(this.getEmptyTabMessage());
            } else {
                this._watermark.setWatermarkText(null);
            }
        }
    }

    public String getEmptyTabMessage() {
        return this._noComponentsStr;
    }

    public void setEmptyTabMessage(String str) {
        this._noComponentsStr = str;
    }

    public void setWatermarkText(String str) {
        _logger.debug((Object)(this.getName() + ".setWatermarkText('" + str + "')"));
        if (this._watermark != null) {
            this._watermark.setWatermarkText(str);
        }
    }

    public void setWatermarkAnchor(JComponent comp) {
        this._watermark = new Watermark(comp, "");
    }

    @Override
    public JButton getDockUndockButton() {
        return null;
    }

    @Override
    public boolean beforeDock() {
        return true;
    }

    @Override
    public boolean beforeUndock() {
        return true;
    }

    @Override
    public void afterDock() {
    }

    @Override
    public void afterUndock() {
    }

    @Override
    public void saveWindowProps(GTabbedPaneWindowProps wp) {
        String name = this.getName();
        if (StringUtil.isNullOrBlank(name)) {
            return;
        }
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            return;
        }
        _logger.trace((Object)(name + ": saveWindowProps(wp): " + wp));
        String base = "GTabbedPane." + name + ".";
        conf.setProperty(base + "window.active", wp.undocked);
        if (wp.width > 0) {
            conf.setProperty(base + "window.width", wp.width);
        }
        if (wp.height > 0) {
            conf.setProperty(base + "window.height", wp.height);
        }
        if (wp.posX > 0) {
            conf.setProperty(base + "window.pos.x", wp.posX);
        }
        if (wp.posY > 0) {
            conf.setProperty(base + "window.pos.y", wp.posY);
        }
        conf.save();
    }

    @Override
    public GTabbedPaneWindowProps getWindowProps() {
        String name = this.getName();
        if (StringUtil.isNullOrBlank(name)) {
            return null;
        }
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            return null;
        }
        GTabbedPaneWindowProps wp = new GTabbedPaneWindowProps();
        String base = "GTabbedPane." + this.getName() + ".";
        wp.undocked = conf.getBooleanProperty(base + "window.active", false);
        wp.width = conf.getIntProperty(base + "window.width", -1);
        wp.height = conf.getIntProperty(base + "window.height", -1);
        wp.posX = conf.getIntProperty(base + "window.pos.x", -1);
        wp.posY = conf.getIntProperty(base + "window.pos.y", -1);
        _logger.trace((Object)(name + ": getWindowProps(): return " + wp));
        return wp;
    }

    private class Watermark
    extends AbstractComponentDecorator {
        private String _restartText1;
        private String _restartText2;
        private String[] _textBr;
        private String _textSave;
        private Graphics2D g;
        private Rectangle r;

        public Watermark(JComponent target, String text) {
            super(target);
            this._restartText1 = "Note: use Menu -> Tools -> Configure ASE for Monitoring: to reconfigure ASE.";
            this._restartText2 = "    or: Reconnect to ASE after you have enabled the configuration using isql.";
            this._textBr = null;
            this._textSave = null;
            this.g = null;
            this.r = null;
            if (text == null) {
                text = "";
            }
            this._textSave = text;
            this._textBr = text.split("\n");
        }

        @Override
        public void paint(Graphics graphics) {
            if (this._textBr == null || this._textBr != null && this._textBr.length < 0) {
                return;
            }
            this.r = this.getDecorationBounds();
            this.g = (Graphics2D)graphics;
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font f = this.g.getFont();
            this.g.setFont(f.deriveFont(1, (float)f.getSize() * 2.0f));
            this.g.setColor(new Color(128, 128, 128, 128));
            FontMetrics fm = this.g.getFontMetrics();
            int maxStrWidth = 0;
            int maxStrHeight = fm.getHeight();
            for (int i = 0; i < this._textBr.length; ++i) {
                int CurLineStrWidth = fm.stringWidth(this._textBr[i]);
                maxStrWidth = Math.max(maxStrWidth, CurLineStrWidth);
            }
            int xPos = (this.r.width - maxStrWidth) / 2;
            int yPos = (int)((double)this.r.height - (double)((this.r.height - fm.getHeight()) / 2) * 1.3);
            int spConfigureCount = 0;
            for (int i = 0; i < this._textBr.length; ++i) {
                this.g.drawString(this._textBr[i], xPos, yPos + maxStrHeight * i);
                if (!this._textBr[i].startsWith("sp_configure")) continue;
                ++spConfigureCount;
            }
            if (spConfigureCount > 0) {
                int yPosRestartText = yPos + maxStrHeight * (this._textBr.length + 1);
                this.g.drawString(this._restartText1, xPos, yPosRestartText);
                this.g.drawString(this._restartText2, xPos, yPosRestartText + 25);
            }
        }

        public void setWatermarkText(String text) {
            if (text == null) {
                text = "";
            }
            if (text.equals(this._textSave)) {
                return;
            }
            this._textSave = text;
            this._textBr = text.split("\n");
            _logger.debug((Object)("setWatermarkText: to '" + text + "'."));
            this.repaint();
        }
    }

    public static interface SpecialTabPainter {
        public void paintTabHeader(Graphics2D var1);
    }

    public static interface TabOrderAndVisibilityListener {
        public void saveTabOrderAndVisibility(String var1);

        public void removeTabOrderAndVisibility();
    }

    public static interface ShowProperties {
        public void showProperties();
    }

    private class UndockedTabHolder
    extends JComponent {
        private static final long serialVersionUID = 1L;
        TabExtendedEntry _xe = null;

        private UndockedTabHolder(TabExtendedEntry xe) {
            this._xe = xe;
        }
    }

    private class TabExtendedEntry
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private JFrame _undockedFrame = null;
        private boolean _isDocked = true;
        private int _tabIndex = -1;
        private String _tabName = null;
        private Icon _icon = null;
        private String _toolTip = null;
        private Component _comp = null;
        private int _modelIndex = -1;
        private String _rmBeforeTab = null;
        private boolean _isVisible = true;
        private JButton _winOpenCloseButton = null;

        private TabExtendedEntry() {
        }

        @Override
        public String getText() {
            return "The content for the tab '" + this._tabName + "' is undocked.";
        }

        @Override
        public String toString() {
            return "_tabIndex=" + this._tabIndex + ", _modelIndex=" + this._modelIndex + ", _rmBeforeTab=" + this._rmBeforeTab + ", _isVisible=" + this._isVisible + ", _isDocked=" + this._isDocked + ", _tabName='" + this._tabName + "', _icon='" + this._icon + "', _comp=" + this._comp;
        }
    }
}

