/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.ui.AbstractComponentDecorator;
import com.sap.dbmtk.demo.ui.ColumnHeaderPropsEntry;
import com.sap.dbmtk.demo.ui.GTableHeaderPropertiesDialog;
import com.sap.dbmtk.demo.ui.MultiSortTableCellHeaderRenderer;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.ui.focusabletip.FocusableTip;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class GTable
extends JXTable {
    private static Logger _logger = Logger.getLogger(GTable.class);
    private static final long serialVersionUID = 1L;
    private int _lastMousePressedAtViewHeaderCol = -1;
    private int _lastMousePressedAtModelCol = -1;
    private int _lastMousePressedAtModelRow = -1;
    private boolean _tableStructureChangedFlag = true;
    private FocusableTip _focusableTip;
    protected Timer _columnLayoutTimer = null;
    private boolean _inPrivateTableChanged = false;
    private String _lastSelectedModelPk = null;
    private int _lastSelectedModelRow = -1;
    private Watermark _watermark = null;

    public GTable() {
        this.init();
    }

    public GTable(TableModel tm) {
        super(tm);
        this.init();
    }

    public int getLastMousePressedAtViewHeaderCol() {
        return this._lastMousePressedAtViewHeaderCol;
    }

    public int getLastMousePressedAtModelCol() {
        return this._lastMousePressedAtModelCol;
    }

    public int getLastMousePressedAtModelRow() {
        return this._lastMousePressedAtModelRow;
    }

    public boolean isLastMousePressedAtModelRowColValid() {
        return this._lastMousePressedAtModelRow >= 0 && this._lastMousePressedAtModelCol >= 0;
    }

    public void setModel(TableModel newModel) {
        this.setModelInternal(newModel, 0);
    }

    private void setModelInternal(TableModel newModel, int neastLevel) {
        try {
            super.setModel(newModel);
            this.loadColumnLayout();
        }
        catch (IndexOutOfBoundsException ex) {
            if (neastLevel == 0) {
                _logger.info((Object)("Problems setting GTable.setModel(). (first time call) Table/Component name='" + this.getName() + "'. TableModel=(class=" + (newModel == null ? "null" : newModel.getClass().getName()) + ", toString='" + newModel + "'). I guess this is a bug in JXTable, which doesn't take into account that we have hidden columns... Caught: " + ex));
                this.setModelInternal(newModel, neastLevel++);
            } else {
                _logger.warn((Object)("Problems setting GTable.setModel(). (second time call) Table/Component name='" + this.getName() + "'. TableModel=(class=" + (newModel == null ? "null" : newModel.getClass().getName()) + ", toString='" + newModel + "'). I guess this is a bug in JXTable, which doesn't take into account that we have hidden columns... Caught: " + ex), (Throwable)ex);
            }
        }
        catch (Throwable ex) {
            _logger.warn((Object)("Problems setting GTable.setModel(). Table/Component name='" + this.getName() + "'. TableModel=(class=" + (newModel == null ? "null" : newModel.getClass().getName()) + ", toString='" + newModel + "')."), ex);
        }
    }

    private void init() {
        this._columnLayoutTimer = new Timer(1000, new ColumnLayoutTimerAction(this));
        StringValue sv = new StringValue(){
            NumberFormat nf = null;
            {
                try {
                    this.nf = new DecimalFormat();
                    this.nf.setMinimumFractionDigits(1);
                }
                catch (Throwable t) {
                    this.nf = NumberFormat.getInstance();
                }
            }

            public String getString(Object value) {
                if (!(value instanceof BigDecimal)) {
                    return StringValues.TO_STRING.getString(value);
                }
                return this.nf.format(value);
            }
        };
        this.setDefaultRenderer(BigDecimal.class, (TableCellRenderer)new DefaultTableRenderer(sv, 4));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GTable.this._lastMousePressedAtModelCol = -1;
                GTable.this._lastMousePressedAtModelRow = -1;
                Point p = new Point(e.getX(), e.getY());
                int col = GTable.this.columnAtPoint(p);
                int row = GTable.this.rowAtPoint(p);
                if (row >= 0 && col >= 0) {
                    GTable.this._lastMousePressedAtModelCol = GTable.this.convertColumnIndexToModel(col);
                    GTable.this._lastMousePressedAtModelRow = GTable.this.convertRowIndexToModel(row);
                }
            }
        });
        TableColumnModelExtListener columnModelListener = new TableColumnModelExtListener(){

            public void columnPropertyChange(PropertyChangeEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
                this.columnMovedOrRemoved(null);
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            public void columnAdded(TableColumnModelEvent e) {
                if (GTable.this._tableStructureChangedFlag && GTable.this.getModel().getColumnCount() - 1 == e.getToIndex()) {
                    _logger.debug((Object)("columnAdded(): tabName='" + GTable.this.getName() + "', TIME TO LOAD COL ORDER."));
                    GTable.this._tableStructureChangedFlag = false;
                    GTable.this.loadColumnLayout();
                }
            }

            public void columnRemoved(TableColumnModelEvent e) {
                this.columnMovedOrRemoved(e);
            }

            public void columnMoved(TableColumnModelEvent e) {
                this.columnMovedOrRemoved(e);
            }

            private void columnMovedOrRemoved(TableColumnModelEvent e) {
                if (GTable.this._columnLayoutTimer.isRunning()) {
                    GTable.this._columnLayoutTimer.restart();
                } else {
                    GTable.this._columnLayoutTimer.start();
                }
            }
        };
        this.getColumnModel().addColumnModelListener((TableColumnModelListener)columnModelListener);
        this.getTableHeader().addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                GTable.this.columnHeaderMouseActivity(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GTable.this.columnHeaderMouseActivity(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                GTable.this.columnHeaderMouseActivity(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                GTable.this.columnHeaderMouseActivity(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GTable.this.columnHeaderMouseActivity(e);
            }
        });
        this.getTableHeader().setDefaultRenderer(new MultiSortTableCellHeaderRenderer());
        this.getTableHeader().setComponentPopupMenu(this.createTableHeaderPopupMenu());
        this.setSortOrderCycle(new SortOrder[]{SortOrder.DESCENDING, SortOrder.ASCENDING, SortOrder.UNSORTED});
    }

    private void columnHeaderMouseActivity(MouseEvent e) {
        this._lastMousePressedAtViewHeaderCol = -1;
        Point p = new Point(e.getX(), e.getY());
        int col = this.columnAtPoint(p);
        if (col >= 0) {
            this._lastMousePressedAtViewHeaderCol = col;
        }
    }

    public JPopupMenu createTableHeaderPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JPopupMenu p = (JPopupMenu)e.getSource();
                p.removeAll();
                if (GTable.this.isColumnControlVisible()) {
                    JMenuItem mi = new JMenuItem("Reset to Original Column Layout");
                    p.add(mi);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GTable.this.setOriginalColumnLayout();
                        }
                    });
                    mi = new JMenuItem("Adjust Column Width");
                    p.add(mi);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GTable.this.packAll();
                        }
                    });
                    mi = new JMenuItem("Hide/View Column Dialog...");
                    p.add(mi);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int ret = GTableHeaderPropertiesDialog.showDialog(null, GTable.this);
                            if (ret == 0) {
                                // empty if block
                            }
                        }
                    });
                    if (GTable.this.getLastMousePressedAtViewHeaderCol() >= 0) {
                        final TableColumnExt tcx = (TableColumnExt)GTable.this.getColumnModel().getColumn(GTable.this.getLastMousePressedAtViewHeaderCol());
                        mi = new JMenuItem("Hide this column '" + tcx.getHeaderValue() + "'");
                        p.add(mi);
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                tcx.setVisible(false);
                            }
                        });
                    }
                    p.add(new JSeparator());
                    for (TableColumn tc : GTable.this.getColumns(true)) {
                        final TableColumnExt tcx = (TableColumnExt)tc;
                        String colName = tcx.getHeaderValue() + "";
                        boolean colIsVisible = tcx.isVisible();
                        mi = new JCheckBoxMenuItem();
                        mi.setText(colName);
                        mi.setSelected(colIsVisible);
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JCheckBoxMenuItem mi = (JCheckBoxMenuItem)e.getSource();
                                try {
                                    try {
                                        tcx.setVisible(mi.isSelected());
                                    }
                                    catch (IndexOutOfBoundsException ex) {
                                        _logger.info((Object)("Problems setting TableColumnExt.setVisible(). (first time exec) Table/Component name='" + GTable.this.getName() + "'. I guess this is a bug in JXTable, which doesn't take into account that we have hidden columns... Caught: " + ex));
                                        tcx.setVisible(mi.isSelected());
                                    }
                                }
                                catch (IndexOutOfBoundsException ex) {
                                    _logger.warn((Object)("Problems setting TableColumnExt.setVisible(). (second time exec) Table/Component name='" + GTable.this.getName() + "'. I guess this is a bug in JXTable, which doesn't take into account that we have hidden columns... Caught: " + ex));
                                }
                                catch (Throwable ex) {
                                    _logger.warn((Object)("Problems setting TableColumnExt.setVisible(). Table/Component name='" + GTable.this.getName() + "'. I guess this is a bug in JXTable, which doesn't take into account that we have hidden columns... Caught: " + ex), ex);
                                }
                            }
                        });
                        p.add(mi);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        return popup;
    }

    public int findViewColumn(String colName) {
        return this.findViewColumn(colName, true);
    }

    public int findViewColumn(String colName, boolean caseSensitive) {
        int viewColPos = -1;
        int modelColPos = -1;
        TableModel tm = this.getModel();
        for (int c = 0; c < tm.getColumnCount(); ++c) {
            if (!(caseSensitive ? colName.equals(tm.getColumnName(c)) : colName.equalsIgnoreCase(tm.getColumnName(c)))) continue;
            modelColPos = c;
            break;
        }
        if (modelColPos < 0) {
            return -1;
        }
        viewColPos = this.convertColumnIndexToView(modelColPos);
        if (viewColPos < 0) {
            _logger.debug((Object)(this.getName() + ": findViewColumn('" + colName + "'): modelIndex=" + modelColPos + ", viewIndex=" + viewColPos + ", the column must be hidden in the view."));
            return -2;
        }
        return viewColPos;
    }

    public void printColumnLayout(String prefix) {
        if (this.getColumnCount() == 0) {
            return;
        }
        String cmName = this.getName();
        if (cmName == null) {
            _logger.debug((Object)"Can't print Column Layout, because the JTable has not been assigned a name. getName() on the JTable is null.");
            return;
        }
        TableColumnModel tcm = this.getColumnModel();
        for (TableColumn tc : this.getColumns(true)) {
            TableColumnExt tcx = (TableColumnExt)tc;
            String colName = tc.getHeaderValue().toString();
            boolean colIsVisible = tcx.isVisible();
            SortOrder colSort = this.getSortOrder(colName);
            int colModelPos = tcx.getModelIndex();
            int colViewPos = -1;
            try {
                colViewPos = tcm.getColumnIndex(colName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            System.out.println(prefix + "printColumnLayout() cm='" + cmName + "': colName=" + StringUtil.left(colName, 30) + ", modelPos=" + colModelPos + ", viewPos=" + colViewPos + ", isVisible=" + colIsVisible + ", sort=" + (Object)((Object)colSort) + ", identifier='" + tcx.getIdentifier() + "', toString=" + tc);
        }
    }

    public void loadColumnLayout() {
        int i;
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf == null) {
            return;
        }
        if (this.getColumnCount() == 0) {
            return;
        }
        String cmName = this.getName();
        if (StringUtil.isNullOrBlank(cmName)) {
            _logger.debug((Object)"Can't load Column Layout, because the JTable has not been assigned a name. getName() on the JTable is null.");
            return;
        }
        int srvVersion = 0;
        String confKey = cmName + ".gui.column.header.props." + srvVersion;
        String confVal = conf.getProperty(confKey);
        if (confVal == null) {
            confKey = cmName + ".gui.column.header.props";
            confVal = conf.getProperty(confKey);
        }
        if (confVal == null) {
            return;
        }
        LinkedHashMap<String, ColumnHeaderPropsEntry> colProps = new LinkedHashMap<String, ColumnHeaderPropsEntry>();
        String[] strArr = confVal.split("; ");
        for (i = 0; i < strArr.length; ++i) {
            try {
                ColumnHeaderPropsEntry chpe = ColumnHeaderPropsEntry.parseKeyValue(strArr[i]);
                colProps.put(chpe._colName, chpe);
                continue;
            }
            catch (ParseException e) {
                _logger.info((Object)("Problems parsing '" + confKey + "' with string '" + strArr[i] + "'. Caught: " + e));
            }
        }
        if (colProps.size() != this.getModel().getColumnCount()) {
            _logger.info((Object)(confKey + " has '" + colProps.size() + "' values and the table model has '" + this.getModel().getColumnCount() + "' columns. I will skip moving columns around, the original column layout will be used."));
            return;
        }
        for (i = 0; i < colProps.size() && this.loadColumnLayout(colProps) != 0; ++i) {
        }
        int maxSortOrderPos = -1;
        for (ColumnHeaderPropsEntry chpe : colProps.values()) {
            maxSortOrderPos = Math.max(maxSortOrderPos, chpe._sortOrderPos);
        }
        for (int i2 = maxSortOrderPos; i2 > 0; --i2) {
            for (ColumnHeaderPropsEntry chpe : colProps.values()) {
                if (chpe._sortOrderPos != i2) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)(i2 + ": Setting '" + StringUtil.left(chpe._colName, 20) + "', viewPos=" + chpe._viewPos + ",  to " + (Object)((Object)chpe._sortOrder) + ", sortOrderPos=" + chpe._sortOrderPos + ", ModelColumnCount=" + this.getModel().getColumnCount() + ", RowSorterModelColumnCount=" + ((TableModel)this.getRowSorter().getModel()).getColumnCount() + ", name=" + this.getName()));
                }
                if (chpe._viewPos < ((TableModel)this.getRowSorter().getModel()).getColumnCount()) {
                    this.setSortOrder(chpe._viewPos, chpe._sortOrder);
                    continue;
                }
                _logger.debug((Object)("Can't set the sort order for column '" + chpe._colName + "'. viewPos < RowSorterModelColumnCount, this will be retried later? Info RowSorterModelColumnCount=" + ((TableModel)this.getRowSorter().getModel()).getColumnCount() + ", TableModelColumnCount=" + this.getModel().getColumnCount() + ", viewPos=" + chpe._viewPos + ", TableName=" + this.getName()));
            }
        }
    }

    protected int loadColumnLayout(Map<String, ColumnHeaderPropsEntry> colProps) {
        int fixCount = 0;
        TableColumnModelExt tcmx = (TableColumnModelExt)this.getColumnModel();
        for (Map.Entry<String, ColumnHeaderPropsEntry> entry : colProps.entrySet()) {
            int colWidth;
            String colName = entry.getKey();
            ColumnHeaderPropsEntry chpe = entry.getValue();
            TableColumnExt tcx = tcmx.getColumnExt((Object)colName);
            if (tcx != null) {
                if (!chpe._isVisible && tcx.isVisible()) {
                    _logger.trace((Object)("loadColumnLayout() cm='" + this.getName() + "': ACTION -> HIDE '" + colName + "'."));
                    tcx.setVisible(false);
                    ++fixCount;
                }
                if (chpe._isVisible && !tcx.isVisible()) {
                    _logger.trace((Object)("loadColumnLayout() cm='" + this.getName() + "': ACTION -> SHOW '" + colName + "'."));
                    tcx.setVisible(true);
                    ++fixCount;
                }
            }
            int colViewPos = -1;
            try {
                colViewPos = tcmx.getColumnIndex((Object)colName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            int propViewPos = chpe._viewPos;
            _logger.trace((Object)("loadColumnLayout() cm='" + this.getName() + "': info '" + StringUtil.left(colName, 30) + "' colViewPos(from)='" + colViewPos + "', chpe._viewPos(to)='" + chpe._viewPos + "'."));
            if (colViewPos >= 0 && propViewPos >= 0 && colViewPos != propViewPos) {
                _logger.trace((Object)("loadColumnLayout() cm='" + this.getName() + "': ACTION -> MOVE '" + colName + "' from '" + colViewPos + "' -> '" + propViewPos + "'."));
                try {
                    tcmx.moveColumn(colViewPos, propViewPos);
                }
                catch (Throwable t) {
                    _logger.info((Object)("loadColumnLayout() problems when calling tcmx.moveColumn(colViewPos, propViewPos): (to get stacktrace enable debug loggin) Caught: " + t));
                    _logger.debug((Object)("loadColumnLayout() problems when calling tcmx.moveColumn(colViewPos, propViewPos): Caught: " + t), t);
                }
                ++fixCount;
            }
            if ((colWidth = chpe._width) > 0 && tcx != null) {
                tcx.setPreferredWidth(colWidth);
                tcx.setWidth(colWidth);
            }
            if (colViewPos < 0 || this.getSortOrder(colViewPos) == SortOrder.UNSORTED) continue;
            this.setSortOrder(colViewPos, SortOrder.UNSORTED);
        }
        return fixCount;
    }

    public void saveColumnLayout() {
        this.saveColumnLayout(false);
    }

    public void saveColumnLayout(boolean toOriginalLayout) {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf == null) {
            return;
        }
        if (this.getColumnCount() == 0) {
            return;
        }
        String cmName = this.getName();
        if (StringUtil.isNullOrBlank(cmName)) {
            _logger.debug((Object)"Can't load Column Layout, because the JTable has not been assigned a name. getName() on the JTable is null.");
            return;
        }
        int srvVersion = 0;
        String confKeyBase = cmName + ".gui.column.header.props";
        String confKeyVersion = cmName + ".gui.column.header.props." + srvVersion;
        String confVal = "";
        TableColumnModel tcm = this.getColumnModel();
        for (TableColumn tc : this.getColumns(true)) {
            TableColumnExt tcx = (TableColumnExt)tc;
            String colName = tc.getHeaderValue().toString();
            boolean colIsVisible = tcx.isVisible();
            int colModelPos = tcx.getModelIndex();
            int colViewPos = -1;
            try {
                colViewPos = tcm.getColumnIndex(colName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            int colWidth = tc.getWidth();
            SortOrder colSort = this.getSortOrder(colName);
            int colSortPos = this.getSortOrderIndex(colName);
            _logger.debug((Object)("saveColumnLayout() cm='" + cmName + "': colName=" + StringUtil.left(colName, 30) + ", modelPos=" + colModelPos + ", viewPos=" + colViewPos + ", isVisible=" + colIsVisible + ", sort=" + (Object)((Object)colSort) + ", sortPos=" + colSortPos + ", identifier='" + tcx.getIdentifier() + "', width=" + colWidth + ", toString=" + tc));
            ColumnHeaderPropsEntry chpe = new ColumnHeaderPropsEntry(colName, colModelPos, colViewPos, colIsVisible, colSort, colSortPos, colWidth);
            if (toOriginalLayout) {
                chpe._viewPos = colModelPos;
                chpe._isVisible = true;
                chpe._sortOrder = SortOrder.UNSORTED;
                chpe._sortOrderPos = 0;
                chpe._width = -1;
            }
            confVal = confVal + chpe + "; ";
        }
        confVal = confVal.substring(0, confVal.length() - 2);
        _logger.debug((Object)("saveColumnLayout() SAVE PROPERTY: " + confKeyBase + "=" + confVal));
        _logger.debug((Object)("saveColumnLayout() SAVE PROPERTY: " + confKeyVersion + "=" + confVal));
        conf.setProperty(confKeyBase, confVal);
        conf.setProperty(confKeyVersion, confVal);
        conf.save();
    }

    public void setOriginalColumnLayout() {
        this.saveColumnLayout(true);
        this.loadColumnLayout();
    }

    public int getSortOrderIndex(int colModelIndex) {
        List<RowSorter.SortKey> sortKeys = this.getRowSorter().getSortKeys();
        if (sortKeys == null || sortKeys.size() == 0) {
            return -1;
        }
        int sortIndex = 1;
        for (RowSorter.SortKey sortKey : sortKeys) {
            if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
            if (sortKey.getColumn() == colModelIndex) {
                return sortIndex;
            }
            ++sortIndex;
        }
        return -1;
    }

    public int getSortOrderIndex(String colName) {
        try {
            int colModelIndex = this.getColumn(colName).getModelIndex();
            return this.getSortOrderIndex(colModelIndex);
        }
        catch (IllegalArgumentException ignore) {
            return -1;
        }
    }

    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        _logger.debug((Object)("changeSelection(row=" + row + ", column=" + column + ", toggle=" + toggle + ", extend=" + extend + "), getSelectedRow()=" + this.getSelectedRow() + ", getSelectedColumn()=" + this.getSelectedColumn()));
        if (row == this.getSelectedRow() && (column == this.getSelectedColumn() || this.getSelectedColumn() < 0)) {
            toggle = true;
            _logger.debug((Object)("changeSelection(): change toggle to " + toggle + "."));
        }
        super.changeSelection(row, column, toggle, extend);
    }

    public void tableChanged(final TableModelEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GTable.this.privateTableChanged(e);
                    }
                });
            }
            catch (InterruptedException e1) {
                _logger.info((Object)("SwingUtilities.invokeAndWait(privateTableChanged), Caught: " + e1));
            }
            catch (InvocationTargetException e1) {
                _logger.info((Object)("SwingUtilities.invokeAndWait(privateTableChanged), threw exception: " + e1), (Throwable)e1);
            }
        } else {
            this.privateTableChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privateTableChanged(TableModelEvent e) {
        try {
            block11: {
                this._inPrivateTableChanged = true;
                try {
                    super.tableChanged(e);
                }
                catch (Throwable t) {
                    int mcols = this.getModel().getColumnCount();
                    int vcols = this.getColumnCount();
                    if (mcols > vcols) break block11;
                    _logger.info((Object)("GTable='" + this.getName() + "', Problems when calling super.tableChanged(e). (enable debug mode to see stacktrace) Caught: " + t));
                    _logger.debug((Object)("GTable='" + this.getName() + "', Problems when calling super.tableChanged(e). Caught: " + t), t);
                }
            }
            try {
                int viewRowNow;
                if (this._lastSelectedModelPk != null) {
                    TableModel t = this.getModel();
                } else if (this._lastSelectedModelRow >= 0 && this.getRowCount() > 0 && this._lastSelectedModelRow < this.getRowCount() && (viewRowNow = this.convertRowIndexToView(this._lastSelectedModelRow)) >= 0 && viewRowNow < this.getRowCount()) {
                    this.getSelectionModel().setSelectionInterval(viewRowNow, viewRowNow);
                }
            }
            catch (Throwable t) {
                _logger.warn((Object)("GTable='" + this.getName() + "', Problems when restoring selected row. Caught: " + t), t);
            }
            if (SwingUtils.isStructureChanged(e)) {
                this._tableStructureChangedFlag = true;
                this.loadColumnLayout();
            }
        }
        finally {
            this._inPrivateTableChanged = false;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (this._inPrivateTableChanged) {
            return;
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        this._lastSelectedModelPk = null;
        this._lastSelectedModelRow = -1;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int viewRow = this.getSelectedRow();
        if (viewRow >= 0) {
            this._lastSelectedModelRow = this.convertRowIndexToModel(viewRow);
        }
        if (this._lastSelectedModelRow >= 0) {
            TableModel tableModel = this.getModel();
        }
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JXTableHeader(this.getColumnModel()){
            private static final long serialVersionUID = -4987530843165661043L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.getColumnModel().getColumnIndexAtX(p.x);
                if (index < 0) {
                    return null;
                }
                Object colNameObj = this.getColumnModel().getColumn(index).getHeaderValue();
                String toolTip = null;
                if (colNameObj instanceof String) {
                    String colName = (String)colNameObj;
                    TableModel tm = GTable.this.getModel();
                    if (tm instanceof ITableTooltip) {
                        ITableTooltip tt = (ITableTooltip)((Object)tm);
                        toolTip = tt.getToolTipTextOnTableColumnHeader(colName);
                    }
                }
                return toolTip;
            }
        };
    }

    public String getToolTipTextForColumn(String colname) {
        String toolTip = "";
        TableModel tm = this.getModel();
        if (tm instanceof ITableTooltip) {
            ITableTooltip tt = (ITableTooltip)((Object)tm);
            toolTip = tt.getToolTipTextOnTableColumnHeader(colname);
        }
        return toolTip;
    }

    public String getToolTipText(MouseEvent e) {
        String tip = null;
        Point p = e.getPoint();
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        if (row >= 0 && col >= 0) {
            col = super.convertColumnIndexToModel(col);
            row = super.convertRowIndexToModel(row);
            TableModel model = this.getModel();
            String colName = model.getColumnName(col);
            Object cellValue = model.getValueAt(row, col);
            if (model instanceof ITableTooltip) {
                ITableTooltip tt = (ITableTooltip)((Object)model);
                tip = tt.getToolTipTextOnTableCell(e, colName, cellValue, row, col);
                if (tip != null) {
                    if (this._focusableTip == null) {
                        this._focusableTip = new FocusableTip((JComponent)((Object)this));
                    }
                    this._focusableTip.toolTipRequested(e, tip);
                } else if (this._focusableTip != null) {
                    this._focusableTip.possiblyDisposeOfTipWindow();
                }
                return null;
            }
        }
        return this.getToolTipText();
    }

    public List<String> getOriginColumnOrderStrList() {
        ArrayList<String> list = new ArrayList<String>();
        TableModel tm = this.getModel();
        int modelCols = tm.getColumnCount();
        for (int c = 0; c < modelCols; ++c) {
            list.add(tm.getColumnName(c));
        }
        return list;
    }

    public List<String> getCurrentColumnOrderStrList() {
        ArrayList<String> list = new ArrayList<String>();
        for (TableColumn tc : this.getColumns()) {
            String colName = tc.getHeaderValue() + "";
            list.add(colName);
        }
        for (TableColumn tc : this.getColumns(true)) {
            TableColumnExt tcx = (TableColumnExt)tc;
            String colName = tcx.getHeaderValue() + "";
            boolean colIsVisible = tcx.isVisible();
            if (colIsVisible) continue;
            list.add(colName);
        }
        return list;
    }

    public String getValueAsString(int vrow, String colName) {
        return this.getValueAsString(vrow, colName, true);
    }

    public String getValueAsString(int vrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(vrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Short getValueAsShort(int vrow, String colName) {
        return this.getValueAsShort(vrow, colName, true);
    }

    public Short getValueAsShort(int vrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(vrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        try {
            return Short.parseShort(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading Short value for vrow=" + vrow + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Integer getValueAsInteger(int vrow, String colName) {
        return this.getValueAsInteger(vrow, colName, true);
    }

    public Integer getValueAsInteger(int vrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(vrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading Integer value for vrow=" + vrow + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Long getValueAsLong(int vrow, String colName) {
        return this.getValueAsLong(vrow, colName, true);
    }

    public Long getValueAsLong(int vrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(vrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading Long value for vrow=" + vrow + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Timestamp getValueAsTimestamp(int vrow, String colName) {
        return this.getValueAsTimestamp(vrow, colName, true);
    }

    public Timestamp getValueAsTimestamp(int vrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(vrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            Date date = sdf.parse(o.toString());
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            _logger.warn((Object)("Problem reading Timestamp value for vrow=" + vrow + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public BigDecimal getValueAsBigDecimal(int vrow, String colName) {
        return this.getValueAsBigDecimal(vrow, colName, true);
    }

    public BigDecimal getValueAsBigDecimal(int vrow, String colName, boolean caseSensitive) {
        Object o = this.getValueAsObject(vrow, colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        try {
            return new BigDecimal(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading BigDecimal value for vrow=" + vrow + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Object getValueAsObject(int vrow, String colName) {
        return this.getValueAsObject(vrow, colName, true);
    }

    public Object getValueAsObject(int vrow, String colName, boolean caseSensitive) {
        TableModel tm = this.getModel();
        int mrow = this.convertRowIndexToModel(vrow);
        int mcol = -1;
        for (int c = 0; c < tm.getColumnCount(); ++c) {
            if (!(caseSensitive ? colName.equals(tm.getColumnName(c)) : colName.equalsIgnoreCase(tm.getColumnName(c)))) continue;
            mcol = c;
            break;
        }
        if (mcol < 0) {
            throw new RuntimeException("Can't find column '" + colName + "' in JTable named '" + this.getName() + "'.");
        }
        Object o = tm.getValueAt(mrow, mcol);
        if (tm instanceof ResultSetTableModel && o != null && o instanceof String && "(NULL)".equals(o)) {
            return null;
        }
        return o;
    }

    public String getSelectedValuesAsString(String colName) {
        return this.getSelectedValuesAsString(colName, true);
    }

    public String getSelectedValuesAsString(String colName, boolean caseSensitive) {
        Object o = this.getSelectedValuesAsObject(colName, caseSensitive);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Short getSelectedValuesAsShort(String colName) {
        return this.getSelectedValuesAsShort(colName, true);
    }

    public Short getSelectedValuesAsShort(String colName, boolean caseSensitive) {
        Object o = this.getSelectedValuesAsObject(colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        try {
            return Short.parseShort(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading Short value for vrow=" + this.getSelectedRow() + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Integer getSelectedValuesAsInteger(String colName) {
        return this.getSelectedValuesAsInteger(colName, true);
    }

    public Integer getSelectedValuesAsInteger(String colName, boolean caseSensitive) {
        Object o = this.getSelectedValuesAsObject(colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading Integer value for vrow=" + this.getSelectedRow() + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Long getSelectedValuesAsLong(String colName) {
        return this.getSelectedValuesAsLong(colName, true);
    }

    public Long getSelectedValuesAsLong(String colName, boolean caseSensitive) {
        Object o = this.getSelectedValuesAsObject(colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading Long value for vrow=" + this.getSelectedRow() + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Timestamp getSelectedValuesAsTimestamp(String colName) {
        return this.getSelectedValuesAsTimestamp(colName, true);
    }

    public Timestamp getSelectedValuesAsTimestamp(String colName, boolean caseSensitive) {
        Object o = this.getSelectedValuesAsObject(colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            Date date = sdf.parse(o.toString());
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            _logger.warn((Object)("Problem reading Timestamp value for vrow=" + this.getSelectedRow() + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public BigDecimal getSelectedValuesAsBigDecimal(String colName) {
        return this.getSelectedValuesAsBigDecimal(colName, true);
    }

    public BigDecimal getSelectedValuesAsBigDecimal(String colName, boolean caseSensitive) {
        Object o = this.getSelectedValuesAsObject(colName, caseSensitive);
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        try {
            return new BigDecimal(o.toString());
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("Problem reading BigDecimal value for vrow=" + this.getSelectedRow() + ", column='" + colName + "', tableName='" + this.getName() + "', returning null. Caught: " + e));
            return null;
        }
    }

    public Object getSelectedValuesAsObject(String colName) {
        return this.getSelectedValuesAsObject(colName, true);
    }

    public Object getSelectedValuesAsObject(String colName, boolean caseSensitive) {
        int vrow = this.getSelectedRow();
        if (vrow == -1) {
            return null;
        }
        TableModel tm = this.getModel();
        int mrow = this.convertRowIndexToModel(vrow);
        int mcol = -1;
        for (int c = 0; c < tm.getColumnCount(); ++c) {
            if (!(caseSensitive ? colName.equals(tm.getColumnName(c)) : colName.equalsIgnoreCase(tm.getColumnName(c)))) continue;
            mcol = c;
            break;
        }
        if (mcol < 0) {
            throw new RuntimeException("Can't find column '" + colName + "' in JTable named '" + this.getName() + "'.");
        }
        Object o = tm.getValueAt(mrow, mcol);
        if (tm instanceof ResultSetTableModel && o != null && o instanceof String && "(NULL)".equals(o)) {
            return null;
        }
        return o;
    }

    public void setWatermarkText(String str) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this.getName() + ".setWatermarkText('" + str + "')"));
        }
        if (this._watermark != null) {
            this._watermark.setWatermarkText(str);
        }
    }

    public void setWatermarkAnchor(JComponent comp) {
        this._watermark = new Watermark(comp, "");
    }

    private class Watermark
    extends AbstractComponentDecorator {
        private String _restartText1;
        private String _restartText2;
        private String[] _textBr;
        private String _textSave;
        private Graphics2D g;
        private Rectangle r;

        public Watermark(JComponent target, String text) {
            super(target);
            this._restartText1 = "Note: use Menu -> Tools -> Configure ASE for Monitoring: to reconfigure ASE.";
            this._restartText2 = "    or: Reconnect to ASE after you have enabled the configuration using isql.";
            this._textBr = null;
            this._textSave = null;
            this.g = null;
            this.r = null;
            if (text == null) {
                text = "";
            }
            this._textSave = text;
            this._textBr = text.split("\n");
        }

        @Override
        public void paint(Graphics graphics) {
            if (this._textBr == null || this._textBr != null && this._textBr.length < 0) {
                return;
            }
            this.r = this.getDecorationBounds();
            this.g = (Graphics2D)graphics;
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font f = this.g.getFont();
            this.g.setFont(f.deriveFont(1, (float)f.getSize() * 2.0f));
            this.g.setColor(new Color(128, 128, 128, 128));
            FontMetrics fm = this.g.getFontMetrics();
            int maxStrWidth = 0;
            int maxStrHeight = fm.getHeight();
            for (int i = 0; i < this._textBr.length; ++i) {
                int CurLineStrWidth = fm.stringWidth(this._textBr[i]);
                maxStrWidth = Math.max(maxStrWidth, CurLineStrWidth);
            }
            int xPos = (this.r.width - maxStrWidth) / 2;
            int yPos = (int)((double)this.r.height - (double)((this.r.height - fm.getHeight()) / 2) * 1.3);
            int spConfigureCount = 0;
            for (int i = 0; i < this._textBr.length; ++i) {
                this.g.drawString(this._textBr[i], xPos, yPos + maxStrHeight * i);
                if (!this._textBr[i].startsWith("sp_configure")) continue;
                ++spConfigureCount;
            }
            if (spConfigureCount > 0) {
                int yPosRestartText = yPos + maxStrHeight * (this._textBr.length + 1);
                this.g.drawString(this._restartText1, xPos, yPosRestartText);
                this.g.drawString(this._restartText2, xPos, yPosRestartText + 25);
            }
        }

        public void setWatermarkText(String text) {
            if (text == null) {
                text = "";
            }
            if (text.equals(this._textSave)) {
                return;
            }
            this._textSave = text;
            this._textBr = text.split("\n");
            _logger.debug((Object)("setWatermarkText: to '" + text + "'."));
            this.repaint();
        }
    }

    private class ColumnLayoutTimerAction
    implements ActionListener {
        private GTable _tab = null;

        ColumnLayoutTimerAction(GTable tab) {
            this._tab = tab;
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            this._tab.saveColumnLayout();
            this._tab._columnLayoutTimer.stop();
        }
    }

    public static interface ITableTooltip {
        public String getToolTipTextOnTableColumnHeader(String var1);

        public String getToolTipTextOnTableCell(MouseEvent var1, String var2, Object var3, int var4, int var5);
    }
}

