/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.Version;
import com.sap.dbmtk.demo.ui.ColumnHeaderPropsEntry;
import com.sap.dbmtk.demo.ui.GTable;
import com.sap.dbmtk.demo.ui.MultiLineLabel;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class GTableHeaderPropertiesDialog
extends JDialog
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon _iconUp = new ImageIcon(Version.class.getResource("images/up.png"));
    private ImageIcon _iconDown = new ImageIcon(Version.class.getResource("images/down.png"));
    private MultiLineLabel _description1 = new MultiLineLabel("Choose in what order the Columns will be arranged.");
    private MultiLineLabel _description2 = new MultiLineLabel("You can also enable or disable Columns from here.");
    private JButton _up = new JButton();
    private JButton _down = new JButton();
    private JButton _toStartOrder = new JButton("To Start Order");
    private JButton _toOriginOrder = new JButton("To Original Order");
    private JButton _rmOrderAndVis = new JButton("Clear saved info");
    private DefaultTableModel _tableModel = null;
    private JXTable _table = null;
    private GTable _originTable = null;
    private List<String> _originOrder = new ArrayList<String>();
    private List<String> _orderAtStart = new ArrayList<String>();
    private DefaultTableModel _tableModelAtStart = null;
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private JButton _apply = new JButton("Apply");
    private int _dialogReturnSt = 2;
    private String[] _tabHeadArr = new String[]{"Visible", "Column Name", "ToolTip Description"};

    private GTableHeaderPropertiesDialog(Frame owner, GTable table) {
        super(owner, "Change Column Order and Visibility", true);
        this._originTable = table;
        this._originOrder = this._originTable.getOriginColumnOrderStrList();
        this._orderAtStart = this._originTable.getCurrentColumnOrderStrList();
        this.initComponents();
        this._tableModelAtStart = SwingUtils.copyTableModel(this._tableModel);
        this.pack();
        Dimension size = this.getSize();
        size.height += (this._table.getRowCount() - 6) * 18;
        size.width = Math.min(size.width, 645);
        this.setSize(size);
        SwingUtils.setSizeWithingScreenLimit(this, 5);
        SwingUtils.installEscapeButton(this, this._cancel);
        SwingUtils.setFocus(this._ok);
    }

    public static int showDialog(Frame owner, GTable table) {
        GTableHeaderPropertiesDialog dialog = new GTableHeaderPropertiesDialog(owner, table);
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        dialog.dispose();
        return dialog._dialogReturnSt;
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add((Component)this._description1, "grow, wrap");
        panel.add((Component)this._description2, "grow, wrap 10");
        this._table = this.createTable();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._table);
        panel.add((Component)jScrollPane, "span, grow, height 100%, push, wrap");
        panel.add((Component)this._up, "tag left, span, split");
        panel.add((Component)this._down, "tag left");
        panel.add((Component)this._toStartOrder, "tag left");
        panel.add((Component)this._toOriginOrder, "tag left");
        panel.add((Component)this._rmOrderAndVis, "tag right, wrap push");
        panel.add((Component)this.createOkPanel(), "gap top 20, right");
        this._apply.setEnabled(false);
        this.setContentPane(panel);
        this._up.addActionListener(this);
        this._down.addActionListener(this);
        this._toStartOrder.addActionListener(this);
        this._toOriginOrder.addActionListener(this);
        this._rmOrderAndVis.addActionListener(this);
        this._up.setToolTipText("Move the Column up");
        this._down.setToolTipText("Move the Column down)");
        this._toStartOrder.setToolTipText("Restore the Columns to the order it had when this dialog was opened.");
        this._toOriginOrder.setToolTipText("Restore the Columns to the order it originally was created as (restore to factory setting).");
        this._rmOrderAndVis.setToolTipText("<html>Remove/clear the persisted values for Column order and the visibility.<br>This is usually stored in the configuration or properties file.</html>");
        this._up.setIcon(this._iconUp);
        this._down.setIcon(this._iconDown);
        if (this._up.getIcon() == null) {
            this._up.setText("Move Up");
        }
        if (this._down.getIcon() == null) {
            this._down.setText("Move Down");
        }
        this.pack();
    }

    JPanel createOkPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0 0", "", ""));
        panel.add((Component)this._ok, "tag ok");
        panel.add((Component)this._cancel, "tag cancel");
        panel.add((Component)this._apply, "tag apply");
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this._apply.addActionListener(this);
        return panel;
    }

    private void apply() {
        this._table.clearSelection();
        LinkedHashMap<String, ColumnHeaderPropsEntry> newOrder = new LinkedHashMap<String, ColumnHeaderPropsEntry>();
        for (int r = 0; r < this._table.getRowCount(); ++r) {
            String colName = (String)this._table.getValueAt(r, TabPos.ColumnName.ordinal());
            Boolean visible = (Boolean)this._table.getValueAt(r, TabPos.isVisible.ordinal());
            newOrder.put(colName, new ColumnHeaderPropsEntry(colName, -1, r, visible, SortOrder.UNSORTED, -1, -1));
        }
        this._originTable.loadColumnLayout(newOrder);
        this._originTable.saveColumnLayout();
        this._apply.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultTableModel dtm;
        int toRow;
        int row;
        Object source = e.getSource();
        if (this._up.equals(source)) {
            row = this._table.getSelectedRow();
            if (row < 0) {
                SwingUtils.showInfoMessage(this, "Select a row", "No row in the table is selected.");
                return;
            }
            toRow = row - 1;
            dtm = (DefaultTableModel)this._table.getModel();
            if (toRow >= 0) {
                dtm.moveRow(row, row, toRow);
                this._table.getSelectionModel().setSelectionInterval(toRow, toRow);
            }
        }
        if (this._down.equals(source)) {
            row = this._table.getSelectedRow();
            if (row < 0) {
                SwingUtils.showInfoMessage(this, "Select a row", "No row in the table is selected.");
                return;
            }
            toRow = row + 1;
            dtm = (DefaultTableModel)this._table.getModel();
            if (toRow < dtm.getRowCount()) {
                dtm.moveRow(row, row, toRow);
                this._table.getSelectionModel().setSelectionInterval(toRow, toRow);
            }
        }
        if (this._toStartOrder.equals(source)) {
            this.toColumnOrder(this._tableModel, this._orderAtStart);
        }
        if (this._toOriginOrder.equals(source)) {
            this.toColumnOrder(this._tableModel, this._originOrder);
        }
        if (this._rmOrderAndVis.equals(source)) {
            this._originTable.setOriginalColumnLayout();
        }
        if (this._ok.equals(source)) {
            this.apply();
            this._dialogReturnSt = 0;
            this.setVisible(false);
        }
        if (this._cancel.equals(source)) {
            this._dialogReturnSt = 2;
            this.setVisible(false);
        }
        if (this._apply.equals(source)) {
            this.apply();
        }
    }

    private void toColumnOrder(DefaultTableModel tm, List<String> originColumnOrder) {
        for (int oi = 0; oi < originColumnOrder.size(); ++oi) {
            String columnhName = originColumnOrder.get(oi);
            int moveRow = -1;
            for (int tr = 0; tr < tm.getRowCount(); ++tr) {
                if (!columnhName.equals(tm.getValueAt(tr, TabPos.ColumnName.ordinal()))) continue;
                moveRow = tr;
                break;
            }
            if (moveRow < 0 || oi == moveRow) continue;
            tm.moveRow(moveRow, moveRow, oi);
        }
    }

    private void checkForChanges() {
        boolean enabled = false;
        for (int r = 0; r < this._table.getRowCount(); ++r) {
            String rowColName = (String)this._table.getValueAt(r, TabPos.ColumnName.ordinal());
            Boolean rowVisible = (Boolean)this._table.getValueAt(r, TabPos.isVisible.ordinal());
            String startColName = (String)this._tableModelAtStart.getValueAt(r, TabPos.ColumnName.ordinal());
            Boolean startVisible = (Boolean)this._tableModelAtStart.getValueAt(r, TabPos.isVisible.ordinal());
            if (!rowColName.equals(startColName)) {
                enabled = true;
            }
            if (!rowVisible.equals(startVisible)) {
                enabled = true;
            }
            if (enabled) break;
        }
        this._apply.setEnabled(enabled);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.checkForChanges();
    }

    public JXTable createTable() {
        Vector<String> tabHead = new Vector<String>();
        tabHead.setSize(TabPos.values().length);
        tabHead.set(TabPos.isVisible.ordinal(), this._tabHeadArr[TabPos.isVisible.ordinal()]);
        tabHead.set(TabPos.ColumnName.ordinal(), this._tabHeadArr[TabPos.ColumnName.ordinal()]);
        tabHead.set(TabPos.ColumnToolTip.ordinal(), this._tabHeadArr[TabPos.ColumnToolTip.ordinal()]);
        Vector<Vector<Object>> tabData = this.populateTable();
        this._tableModel = new DefaultTableModel(tabData, tabHead){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == TabPos.isVisible.ordinal()) {
                    return Boolean.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == TabPos.isVisible.ordinal();
            }
        };
        this.toColumnOrder(this._tableModel, this._orderAtStart);
        this._tableModel.addTableModelListener(this);
        JXTable table = new JXTable((TableModel)this._tableModel);
        table.setSortable(false);
        table.setAutoResizeMode(0);
        table.setShowGrid(false);
        table.setSelectionMode(0);
        SwingUtils.calcColumnWidths((JTable)table);
        return table;
    }

    private Vector<Vector<Object>> populateTable() {
        Vector<Vector<Object>> tab = new Vector<Vector<Object>>();
        Vector<Object> row = new Vector<Object>();
        for (TableColumn tc : this._originTable.getColumns(true)) {
            TableColumnExt tcx = (TableColumnExt)tc;
            boolean colIsVisible = tcx.isVisible();
            String columnName = tcx.getHeaderValue() + "";
            String toolTip = StringUtil.stripHtml(this._originTable.getToolTipTextForColumn(columnName));
            row = new Vector();
            row.setSize(TabPos.values().length);
            row.set(TabPos.isVisible.ordinal(), colIsVisible);
            row.set(TabPos.ColumnName.ordinal(), columnName);
            row.set(TabPos.ColumnToolTip.ordinal(), toolTip);
            tab.add(row);
        }
        return tab;
    }

    private static enum TabPos {
        isVisible,
        ColumnName,
        ColumnToolTip;

    }
}

