/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SortOrder;
import javax.swing.SwingConstants;
import javax.swing.plaf.basic.BasicArrowButton;

class SortIcon
implements Icon,
SwingConstants {
    private int baseSize;
    private int size;
    private int direction;
    private BasicArrowButton iconRenderer;
    private double[] sizePercentages = new double[]{0.55, 0.55, 0.55, 0.55, 0.55, 0.55, 0.55};
    private int _priority = 0;

    public SortIcon(int size) {
        this.baseSize = this.size = size;
        this.iconRenderer = new BasicArrowButton(this.direction);
    }

    public void setPriority(int priority) {
        this._priority = priority;
        this.size = (int)((double)this.baseSize * this.sizePercentages[priority]);
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.direction = sortOrder == SortOrder.ASCENDING ? 1 : 5;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.iconRenderer.paintTriangle(g, x, y - 4, this.size, this.direction, true);
        Font f = g.getFont();
        g.setFont(new Font("DialogInput", 0, 10));
        g.drawString(Integer.toString(this._priority + 1), x + 5, y + 1);
        g.setFont(f);
    }

    @Override
    public int getIconWidth() {
        return this.size + 5;
    }

    @Override
    public int getIconHeight() {
        return this.size / 2;
    }
}

