/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui;

import com.sap.dbmtk.demo.utils.AseConnectionUtils;
import com.sap.dbmtk.demo.utils.StringUtil;
import com.sap.dbmtk.demo.utils.SwingUtils;
import com.sap.dbmtk.demo.utils.TimeUtils;
import com.sybase.jdbcx.SybConnection;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

public class SqlProgressDialog
extends JDialog
implements PropertyChangeListener,
ActionListener {
    private static Logger _logger = Logger.getLogger(SqlProgressDialog.class);
    private static final long serialVersionUID = 1L;
    private JLabel _allSql_lbl = new JLabel("Executing SQL at Server", 0);
    private JLabel _msg_lbl = new JLabel("Messages for current SQL Batch", 0);
    private Connection _conn = null;
    private Statement _stmnt = null;
    private JLabel _state_lbl = new JLabel();
    private boolean _markSql = false;
    private RSyntaxTextArea _allSql_txt = new RSyntaxTextArea();
    private RTextScrollPane _allSql_sroll = new RTextScrollPane((Component)this._allSql_txt);
    private RSyntaxTextArea _msg_txt = new RSyntaxTextArea();
    private RTextScrollPane _msg_sroll = new RTextScrollPane((Component)this._msg_txt);
    private JButton _cancel = new JButton("Cancel");
    private Timer _execSqlTimer = new Timer(100, new ExecSqlTimerAction());
    private String _currentExecSql = null;
    private boolean _firstExec = true;
    private long _totalExecStartTime = 0L;
    private long _batchExecStartTime = 0L;
    private int _currentExecCounter = 0;
    private int _totalExecCount = 0;
    private JLabel _totalExecTimeDesc_lbl = new JLabel("Total Exec Time: ");
    private JLabel _totalExecTimeVal_lbl = new JLabel("-");
    private JLabel _batchExecTimeDesc_lbl = new JLabel("Batch Exec Time: ");
    private JLabel _batchExecTimeVal_lbl = new JLabel("-");
    private boolean _firstMsgWasReceived = false;
    private List<SQLException> _msgList = new ArrayList<SQLException>();
    private boolean _cancelled = false;
    private Window _owner = null;

    public SqlProgressDialog(Window owner, Connection conn, String sql) {
        super(owner, "Waiting for server...", Dialog.ModalityType.DOCUMENT_MODAL);
        this.setLayout((LayoutManager)new MigLayout());
        this._owner = owner;
        this._conn = conn;
        Font f = this._totalExecTimeDesc_lbl.getFont();
        this._allSql_lbl.setFont(new Font("Dialog", 1, 16));
        this._totalExecTimeVal_lbl.setFont(f.deriveFont(f.getStyle() | 1));
        this._batchExecTimeVal_lbl.setFont(f.deriveFont(f.getStyle() | 1));
        this._cancel.setToolTipText("Send a CANCEL request to the server.");
        this._allSql_txt.setSyntaxEditingStyle("text/sql");
        this._allSql_txt.setHighlightCurrentLine(true);
        this._allSql_txt.setText(sql);
        this._allSql_txt.setCaretPosition(0);
        this._allSql_txt.setEditable(false);
        this._msg_txt.setHighlightCurrentLine(false);
        this._msg_txt.setEditable(false);
        this.add((Component)this._allSql_lbl, "pushx, growx, wrap");
        this.add((Component)this._state_lbl, "wrap");
        this.add((Component)this._totalExecTimeDesc_lbl, "split, width 85");
        this.add((Component)this._totalExecTimeVal_lbl, "wrap");
        this.add((Component)this._batchExecTimeDesc_lbl, "split, width 85, hidemode 3");
        this.add((Component)this._batchExecTimeVal_lbl, "wrap");
        this.add((Component)this._allSql_sroll, "push, grow, wrap");
        this.add((Component)this._msg_lbl, "pushx, growx, wrap, hidemode 3");
        this.add((Component)this._msg_sroll, "hmin 150, push, grow, wrap, hidemode 3");
        this.add((Component)this._cancel, "center");
        this._msg_lbl.setVisible(false);
        this._msg_sroll.setVisible(false);
        this._cancel.addActionListener(this);
        this.pack();
        this.setSize(this.getSize().width + 100, this.getSize().height + 70);
        SwingUtils.setSizeWithingScreenLimit(this, 200);
        this.setLocationRelativeTo(owner);
    }

    public void setCurrentSqlText(String sql, int batchCount, int totalExecCount) {
        boolean showBatchLabels;
        boolean markSql = batchCount > 1;
        boolean bl = showBatchLabels = batchCount > 1 || totalExecCount > 1;
        if (!showBatchLabels) {
            this._batchExecTimeDesc_lbl.setVisible(false);
            this._batchExecTimeVal_lbl.setVisible(false);
        }
        this._totalExecCount = totalExecCount;
        this._markSql = markSql;
        if (this._firstExec) {
            this._firstExec = false;
            this._totalExecStartTime = System.currentTimeMillis();
            this._execSqlTimer.start();
        }
        this.setCurrentBatchStartTime(0);
        this._currentExecSql = sql;
        this._execSqlTimer.restart();
    }

    public void setCurrentBatchStartTime(int currentBatchNumber) {
        this._batchExecStartTime = System.currentTimeMillis();
        this._currentExecCounter = currentBatchNumber;
    }

    private void deferredTimerAction(String sql) {
        this._totalExecTimeVal_lbl.setText(TimeUtils.msToTimeStr("%MM:%SS.%ms", System.currentTimeMillis() - this._totalExecStartTime));
        if (this._totalExecCount > 1) {
            this._batchExecTimeVal_lbl.setText(TimeUtils.msToTimeStr("%MM:%SS.%ms", System.currentTimeMillis() - this._batchExecStartTime) + " (go # " + (this._currentExecCounter + 1) + " of " + this._totalExecCount + ")");
        } else {
            this._batchExecTimeVal_lbl.setText(TimeUtils.msToTimeStr("%MM:%SS.%ms", System.currentTimeMillis() - this._batchExecStartTime));
        }
        this._currentExecSql = null;
        if (StringUtil.isNullOrBlank(sql) && this._msgList.size() > 0) {
            return;
        }
        if (!StringUtil.isNullOrBlank(sql) && this._markSql) {
            try {
                this._msg_txt.setText("");
                SearchContext sc = new SearchContext();
                sc.setSearchFor(sql);
                sc.setMatchCase(true);
                sc.setWholeWord(false);
                sc.setRegularExpression(false);
                SearchEngine.find((JTextArea)this._allSql_txt, (SearchContext)sc);
            }
            catch (Throwable t) {
                _logger.warn((Object)"Problems updating current executing SQL Statement, but will continue anyway...", t);
            }
        }
        if (this._msgList.size() > 0) {
            ArrayList<SQLException> oldMsgList = new ArrayList<SQLException>(this._msgList);
            this._msgList = new ArrayList<SQLException>();
            for (SQLException sqle : oldMsgList) {
                try {
                    if (!this._firstMsgWasReceived) {
                        Dimension dimW = this.getSize();
                        dimW.height += 150;
                        this.setSize(dimW);
                        SwingUtils.setSizeWithingScreenLimit(this, 0);
                    }
                    this._firstMsgWasReceived = true;
                    this._msg_lbl.setVisible(true);
                    this._msg_sroll.setVisible(true);
                    String msg = AseConnectionUtils.getSqlWarningMsgs(sqle);
                    this._msg_txt.append(msg);
                    this._msg_txt.setCaretPosition(this._msg_txt.getText().length());
                }
                catch (Throwable t) {
                    _logger.warn((Object)"Problems adding a message to the progress dialog, but will continue anyway...", t);
                }
            }
        }
    }

    public void setState(String string) {
        this._state_lbl.setText(string);
    }

    public String getState() {
        return this._state_lbl.getText();
    }

    public void addMessage(SQLException sqle) {
        this._msgList.add(sqle);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._cancel.equals(source)) {
            this._cancelled = true;
            if (this._conn != null) {
                if (this._conn instanceof SybConnection) {
                    try {
                        ((SybConnection)this._conn).cancel();
                    }
                    catch (SQLException ex) {
                        SwingUtils.showErrorMessage(this._owner, "Cancel", "Problems sending cancel to Server: " + ex, ex);
                    }
                } else if (this._stmnt != null) {
                    try {
                        this._stmnt.cancel();
                    }
                    catch (SQLException ex) {
                        SwingUtils.showErrorMessage(this._owner, "Cancel", "Problems doing cancel to on the Statement level: " + ex, ex);
                    }
                }
            }
        }
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void setSqlStatement(Statement stmnt) {
        this._stmnt = stmnt;
    }

    public void waitForExec(SwingWorker<String, Object> doBgThread, int graceTime) {
        this._execSqlTimer.start();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)graceTime && !doBgThread.isDone()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
                break;
            }
        }
        if (!doBgThread.isDone()) {
            this.setVisible(true);
        }
        this._execSqlTimer.stop();
    }

    private class ExecSqlTimerAction
    implements ActionListener {
        private ExecSqlTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            SqlProgressDialog.this.deferredTimerAction(SqlProgressDialog.this._currentExecSql);
        }
    }
}

