/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui.focusabletip;

import com.sap.dbmtk.demo.ui.focusabletip.TipUtil;
import com.sap.dbmtk.demo.ui.focusabletip.TipWindow;
import com.sap.dbmtk.demo.ui.focusabletip.ToolTipHyperlinkResolver;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;

public class FocusableTip {
    private JComponent _comp;
    private TipWindow tipWindow;
    private URL imageBase;
    private TextAreaListener textAreaListener;
    private HyperlinkListener hyperlinkListener;
    private ToolTipHyperlinkResolver hyperlinkResolver;
    private String lastText;
    private Rectangle tipVisibleBounds;
    private static final int X_MARGIN = 0;
    private static final int Y_MARGIN = 12;

    public FocusableTip(JComponent comp, HyperlinkListener listener, ToolTipHyperlinkResolver hyperlinkResolver) {
        this.setComponentArea(comp);
        this.hyperlinkListener = listener;
        this.hyperlinkResolver = hyperlinkResolver;
        this.textAreaListener = new TextAreaListener();
        this.tipVisibleBounds = new Rectangle();
    }

    public FocusableTip(JComponent comp, HyperlinkListener listener) {
        this(comp, listener, null);
    }

    public FocusableTip(JComponent comp) {
        this(comp, null, null);
    }

    private void computeTipVisibleBounds() {
        Rectangle r = this.tipWindow.getBounds();
        Point p = r.getLocation();
        SwingUtilities.convertPointFromScreen(p, this._comp);
        r.setLocation(p);
        this.tipVisibleBounds.setBounds(r.x, r.y - 15, r.width, r.height + 30);
    }

    private void createAndShowTipWindow(final MouseEvent e, final String text) {
        Window owner = SwingUtilities.getWindowAncestor(this._comp);
        this.tipWindow = new TipWindow(owner, this, text);
        this.tipWindow.setHyperlinkListener(this.hyperlinkListener);
        this.tipWindow.setHyperlinkResolver(this.hyperlinkResolver);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FocusableTip.this.tipWindow == null) {
                    return;
                }
                FocusableTip.this.tipWindow.fixSize();
                ComponentOrientation o = FocusableTip.this._comp.getComponentOrientation();
                Point p = e.getPoint();
                SwingUtilities.convertPointToScreen(p, FocusableTip.this._comp);
                Rectangle sb = TipUtil.getScreenBoundsForPoint(p.x, p.y);
                int y = p.y + 12;
                if (y + FocusableTip.this.tipWindow.getHeight() >= sb.y + sb.height) {
                    y = p.y - 12 - FocusableTip.this.tipWindow.getHeight();
                }
                int x = p.x - 0;
                if (!o.isLeftToRight()) {
                    x = p.x - FocusableTip.this.tipWindow.getWidth() + 0;
                }
                if (x < sb.x) {
                    x = sb.x;
                } else if (x + FocusableTip.this.tipWindow.getWidth() > sb.x + sb.width) {
                    x = sb.x + sb.width - FocusableTip.this.tipWindow.getWidth();
                }
                if (y < 0) {
                    y = 10;
                }
                FocusableTip.this.tipWindow.setLocation(x, y);
                FocusableTip.this.tipWindow.setVisible(true);
                FocusableTip.this.computeTipVisibleBounds();
                FocusableTip.this.textAreaListener.install(FocusableTip.this._comp);
                FocusableTip.this.lastText = text;
            }
        });
    }

    public URL getImageBase() {
        return this.imageBase;
    }

    static String getString(String key) {
        if ("FocusHotkey".equals(key)) {
            return "Press 'F2' for focus";
        }
        return null;
    }

    public void possiblyDisposeOfTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.dispose();
            this.tipWindow = null;
            this.textAreaListener.uninstall();
            this.tipVisibleBounds.setBounds(-1, -1, 0, 0);
            this.lastText = null;
            this._comp.requestFocus();
        }
    }

    void removeListeners() {
        this.textAreaListener.uninstall();
    }

    public void setImageBase(URL url) {
        this.imageBase = url;
    }

    private void setComponentArea(JComponent comp) {
        this._comp = comp;
        ToolTipManager.sharedInstance().registerComponent(comp);
    }

    public void toolTipRequested(MouseEvent e, String text) {
        if (text == null || text.length() == 0) {
            this.possiblyDisposeOfTipWindow();
            this.lastText = text;
            return;
        }
        if (this.lastText == null || text.length() != this.lastText.length() || !text.equals(this.lastText)) {
            this.possiblyDisposeOfTipWindow();
            this.createAndShowTipWindow(e, text);
        }
    }

    private class TextAreaListener
    extends MouseInputAdapter
    implements CaretListener,
    ComponentListener,
    FocusListener,
    KeyListener {
        private TextAreaListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            Object source = e.getSource();
            if (source == FocusableTip.this._comp) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            boolean tipClicked;
            Component c = e.getOppositeComponent();
            boolean bl = tipClicked = c instanceof TipWindow || c != null && SwingUtilities.getWindowAncestor(c) instanceof TipWindow;
            if (!tipClicked) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        private void handleComponentEvent(ComponentEvent e) {
            FocusableTip.this.possiblyDisposeOfTipWindow();
        }

        public void install(JComponent textArea) {
            textArea.addComponentListener(this);
            textArea.addFocusListener(this);
            textArea.addKeyListener(this);
            textArea.addMouseListener(this);
            textArea.addMouseMotionListener(this);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            } else if (e.getKeyCode() == 113 && FocusableTip.this.tipWindow != null && !FocusableTip.this.tipWindow.getFocusableWindowState()) {
                FocusableTip.this.tipWindow.actionPerformed(null);
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (FocusableTip.this.tipVisibleBounds == null || !FocusableTip.this.tipVisibleBounds.contains(e.getPoint())) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        public void uninstall() {
            FocusableTip.this._comp.removeComponentListener(this);
            FocusableTip.this._comp.removeFocusListener(this);
            FocusableTip.this._comp.removeKeyListener(this);
            FocusableTip.this._comp.removeMouseListener(this);
            FocusableTip.this._comp.removeMouseMotionListener(this);
        }
    }
}

