/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.ui.focusabletip;

import com.sap.dbmtk.demo.ui.focusabletip.FocusableTip;
import com.sap.dbmtk.demo.ui.focusabletip.ResolverReturn;
import com.sap.dbmtk.demo.ui.focusabletip.SizeGrip;
import com.sap.dbmtk.demo.ui.focusabletip.TipUtil;
import com.sap.dbmtk.demo.ui.focusabletip.ToolTipHyperlinkResolver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;

class TipWindow
extends JWindow
implements ActionListener,
HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private FocusableTip ft;
    private JEditorPane textArea;
    private String text;
    private TipListener tipListener;
    private HyperlinkListener userHyperlinkListener;
    private ToolTipHyperlinkResolver userHyperlinkResolver;
    private static TipWindow visibleInstance;
    private ArrayList<String> historyList = new ArrayList();
    private int historyIndex = -1;
    private static final String PRIMARY_JEditorPane_class;
    private JButton backButton = new JButton("<");
    private JButton forwardButton = new JButton(">");
    private JButton openInBrowser = new JButton();
    private JTextField locationText = new JTextField(40);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipWindow(Window owner, FocusableTip ft, String msg) {
        super(owner);
        this.ft = ft;
        this.text = msg;
        this.tipListener = new TipListener();
        JPanel cp = new JPanel(new BorderLayout());
        cp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder()));
        cp.setBackground(TipUtil.getToolTipBackground());
        try {
            if (!PRIMARY_JEditorPane_class.trim().equals("")) {
                Class<?> clazz = Class.forName(PRIMARY_JEditorPane_class);
                this.textArea = (JEditorPane)clazz.newInstance();
            }
        }
        catch (Exception e) {
            System.out.println("Problems loading HTML Browser replacement/plugin class '" + PRIMARY_JEditorPane_class + "'. Falling back to use the default 'javax.swing.JEditorPane'. Caught: " + e);
        }
        finally {
            if (this.textArea == null) {
                this.textArea = new JEditorPane();
                this.textArea.setContentType("text/html");
            }
        }
        this.textArea.setEditable(false);
        this.showPage(this.text);
        TipUtil.tweakTipEditorPane(this.textArea);
        if (ft.getImageBase() != null && this.textArea.getDocument() instanceof HTMLDocument) {
            ((HTMLDocument)this.textArea.getDocument()).setBase(ft.getImageBase());
        }
        this.textArea.addMouseListener(this.tipListener);
        this.textArea.addHyperlinkListener(this);
        cp.add(this.textArea);
        this.setFocusableWindowState(false);
        this.setContentPane(cp);
        this.setBottomPanel();
        this.pack();
        KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            }
        };
        this.addKeyListener(ka);
        this.textArea.addKeyListener(ka);
        Class<TipWindow> clazz = TipWindow.class;
        synchronized (TipWindow.class) {
            if (visibleInstance != null) {
                visibleInstance.dispose();
            }
            visibleInstance = this;
            // ** MonitorExit[var6_8] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.getFocusableWindowState()) {
            this.setFocusableWindowState(true);
            this.setBottomPanel();
            this.textArea.removeMouseListener(this.tipListener);
            this.pack();
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            });
            this.ft.removeListeners();
            if (e == null) {
                this.requestFocus();
            }
        }
    }

    @Override
    public void dispose() {
        Container cp = this.getContentPane();
        for (int i = 0; i < cp.getComponentCount(); ++i) {
            cp.getComponent(i).removeMouseListener(this.tipListener);
        }
        this.ft.removeListeners();
        super.dispose();
    }

    void fixSize() {
        Dimension d = this.textArea.getPreferredSize();
        Rectangle r = null;
        try {
            int docLength = this.textArea.getDocument().getLength() - 1;
            if (docLength < 0) {
                docLength = 0;
            }
            r = this.textArea.modelToView(docLength);
            d.height = r.y + r.height;
            d = this.textArea.getPreferredSize();
            Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            if (d.height > screenSize.height - 80) {
                d.height = screenSize.height - 80;
            }
            if (d.width > screenSize.width - 100) {
                d.width = screenSize.width - 100;
            }
            this.textArea.setPreferredSize(d);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.pack();
    }

    public String getText() {
        return this.text;
    }

    private void setBottomPanel() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JSeparator(), "North");
        boolean focusable = this.getFocusableWindowState();
        if (focusable) {
            panel.add((Component)this.createNavigationPanel(), "Before");
            SizeGrip sg = new SizeGrip();
            sg.applyComponentOrientation(sg.getComponentOrientation());
            panel.add((Component)sg, "After");
            MouseInputAdapter adapter = new MouseInputAdapter(){
                private Point lastPoint;

                @Override
                public void mouseDragged(MouseEvent e) {
                    Point p = e.getPoint();
                    SwingUtilities.convertPointToScreen(p, panel);
                    if (this.lastPoint == null) {
                        this.lastPoint = p;
                    } else {
                        int dx = p.x - this.lastPoint.x;
                        int dy = p.y - this.lastPoint.y;
                        TipWindow.this.setLocation(TipWindow.this.getX() + dx, TipWindow.this.getY() + dy);
                        this.lastPoint = p;
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.lastPoint = e.getPoint();
                    SwingUtilities.convertPointToScreen(this.lastPoint, panel);
                }
            };
            panel.addMouseListener(adapter);
            panel.addMouseMotionListener(adapter);
        } else {
            panel.setOpaque(false);
            JLabel label = new JLabel(FocusableTip.getString("FocusHotkey"));
            Color fg = UIManager.getColor("Label.disabledForeground");
            Font font = this.textArea.getFont();
            font = font.deriveFont(font.getSize2D() - 1.0f);
            label.setFont(font);
            if (fg == null) {
                fg = Color.GRAY;
            }
            label.setOpaque(true);
            Color bg = TipUtil.getToolTipBackground();
            label.setBackground(bg);
            label.setForeground(fg);
            label.setHorizontalAlignment(11);
            label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            panel.add(label);
            panel.addMouseListener(this.tipListener);
        }
        Container cp = this.getContentPane();
        if (cp.getComponentCount() == 2) {
            Component comp = cp.getComponent(0);
            cp.remove(0);
            JScrollPane sp = new JScrollPane(comp);
            sp.setViewportBorder(BorderFactory.createEmptyBorder());
            sp.setBackground(this.textArea.getBackground());
            sp.getViewport().setBackground(this.textArea.getBackground());
            cp.add(sp);
            cp.getComponent(0).removeMouseListener(this.tipListener);
            cp.remove(0);
        }
        cp.add((Component)panel, "South");
    }

    public void setHyperlinkListener(HyperlinkListener listener) {
        if (this.userHyperlinkListener != null) {
            this.textArea.removeHyperlinkListener(this.userHyperlinkListener);
        }
        this.userHyperlinkListener = listener;
        if (this.userHyperlinkListener != null) {
            this.textArea.addHyperlinkListener(this.userHyperlinkListener);
        }
    }

    public void setHyperlinkResolver(ToolTipHyperlinkResolver resolver) {
        this.userHyperlinkResolver = resolver;
    }

    public void showNextPage() {
        this.showPage(null, null, 1);
    }

    public void showPrevPage() {
        this.showPage(null, null, -1);
    }

    public void showPage(String htmlText) {
        this.showPage(null, htmlText, 0);
    }

    public void showPage(URL pageUrl) {
        this.showPage(pageUrl, null, 0);
    }

    private void showPage(URL pageUrl, String htmlText, int nextPrevPage) {
        String listObject;
        if (nextPrevPage == 0 && pageUrl == null && htmlText == null) {
            throw new RuntimeException("showPage: both pageUrl and htmlText can't be null");
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string = listObject = pageUrl != null ? pageUrl.toString() : htmlText;
        if (nextPrevPage == 0) {
            if (this.historyIndex < this.historyList.size() - 1) {
                for (int i = this.historyIndex + 1; i < this.historyList.size(); ++i) {
                    this.historyList.remove(i);
                }
            }
            this.historyList.add(listObject);
            ++this.historyIndex;
        }
        if (nextPrevPage > 0 && this.historyIndex < this.historyList.size()) {
            ++this.historyIndex;
            String entry = this.historyList.get(this.historyIndex);
            pageUrl = this.toUrlEntry(entry);
            if (pageUrl == null) {
                htmlText = entry;
            }
        }
        if (nextPrevPage < 0 && this.historyIndex >= 1) {
            --this.historyIndex;
            String entry = this.historyList.get(this.historyIndex);
            pageUrl = this.toUrlEntry(entry);
            if (pageUrl == null) {
                htmlText = entry;
            }
        }
        if (htmlText != null) {
            this.textArea.setText(htmlText);
            TipUtil.tweakTipEditorPane(this.textArea);
            this.setLocationText(null);
        } else if (pageUrl != null) {
            URL newUrl = null;
            try {
                this.textArea.setPage(pageUrl);
                newUrl = this.textArea.getPage();
                this.setLocationText(newUrl);
            }
            catch (Exception e) {
                this.historyList.remove(listObject);
                if (nextPrevPage == 0) {
                    --this.historyIndex;
                }
                this.showError("Unable to load page '" + newUrl + "'", e);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.updateButtons();
    }

    private URL toUrlEntry(String entry) {
        try {
            URL url = new URL(entry);
            if ((url + "").startsWith("data:text/html")) {
                return null;
            }
            return url;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void showError(String errorMessage, Exception e) {
        if (e != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String stackTrace = sw.toString();
            errorMessage = errorMessage + "\n\n" + stackTrace;
        }
        JOptionPane.showMessageDialog(this, errorMessage, "Error", 0);
    }

    private void updateButtons() {
        if (this.historyList.size() > 1) {
            this.backButton.setEnabled(this.historyIndex > 0);
            this.forwardButton.setEnabled(this.historyIndex < this.historyList.size() - 1);
        } else {
            this.backButton.setEnabled(false);
            this.forwardButton.setEnabled(false);
        }
        this.openInBrowser.setEnabled(!this.locationText.getText().trim().equals(""));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        HyperlinkEvent.EventType eventType = event.getEventType();
        if (eventType == HyperlinkEvent.EventType.ENTERED) {
            this.setLocationText(event.getURL());
            return;
        }
        if (eventType == HyperlinkEvent.EventType.EXITED) {
            this.setLocationText(this.textArea.getPage());
            return;
        }
        if (eventType != HyperlinkEvent.EventType.ACTIVATED) return;
        if (this.userHyperlinkResolver != null) {
            ResolverReturn rr = this.userHyperlinkResolver.hyperlinkResolv(event);
            if (rr == null) {
                return;
            }
            if (rr.getType() == ResolverReturn.Type.OPEN_URL_IN_EXTERNAL_BROWSER) {
                Desktop desktop;
                if (!Desktop.isDesktopSupported() || !(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) return;
                try {
                    desktop.browse(rr.getUrl().toURI());
                    return;
                }
                catch (Exception ex) {
                    this.showError("Problems when open the URL '" + this.locationText.getText() + "'. Caught: " + ex, ex);
                }
                return;
            }
            if (rr.hasUrl()) {
                this.showPage(rr.getUrl());
                return;
            } else {
                if (!rr.hasHtmlText()) throw new RuntimeException("ToolTipHyperlinkResolver did not have URL nor, HTML Text, not sure what to do here");
                this.showPage(rr.getHtmlText());
            }
            return;
        }
        this.showPage(event.getURL());
    }

    private void setLocationText(URL url) {
        if (url == null) {
            this.locationText.setText("");
        } else if (url != null) {
            this.locationText.setText(url.toString());
        }
    }

    public static ImageIcon readImageIcon(Class<?> clazz, String filename) {
        URL url = clazz.getResource(filename);
        if (url == null) {
            System.out.println("Can't find the resource for class='" + clazz + "', filename='" + filename + "'.");
            return null;
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
    }

    private JPanel createNavigationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TipWindow.this.showPrevPage();
            }
        });
        this.backButton.setEnabled(false);
        this.backButton.setText("");
        this.backButton.setToolTipText("Back");
        this.backButton.setIcon(TipWindow.readImageIcon(TipWindow.class, "left.png"));
        this.backButton.setContentAreaFilled(false);
        this.backButton.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 0;
        panel.add((Component)this.backButton, gbc);
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TipWindow.this.showNextPage();
            }
        });
        this.forwardButton.setEnabled(false);
        this.forwardButton.setText("");
        this.forwardButton.setToolTipText("Forward");
        this.forwardButton.setIcon(TipWindow.readImageIcon(TipWindow.class, "right.png"));
        this.forwardButton.setContentAreaFilled(false);
        this.forwardButton.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 1;
        panel.add((Component)this.forwardButton, gbc);
        this.openInBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop;
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(new URI(TipWindow.this.locationText.getText()));
                    }
                    catch (Exception ex) {
                        TipWindow.this.showError("Problems when open the URL '" + TipWindow.this.locationText.getText() + "'. Caught: " + ex, ex);
                    }
                }
            }
        });
        this.openInBrowser.setEnabled(false);
        this.openInBrowser.setText("");
        this.openInBrowser.setToolTipText("Open in External Browser");
        this.openInBrowser.setIcon(TipWindow.readImageIcon(TipWindow.class, "external_browser.png"));
        this.openInBrowser.setContentAreaFilled(false);
        this.openInBrowser.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 2;
        panel.add((Component)this.openInBrowser, gbc);
        this.locationText.setToolTipText("Current URL, or what URL you have the mouse over.");
        this.locationText.setEditable(false);
        this.locationText.setBackground(panel.getBackground());
        this.locationText.setBorder(null);
        gbc.gridx = 3;
        gbc.fill = 2;
        panel.add((Component)this.locationText, gbc);
        return panel;
    }

    static {
        PRIMARY_JEditorPane_class = System.getProperty("TipWindow.JEditorPane.replacement", "");
    }

    private class TipListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            TipWindow.this.actionPerformed(null);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component source = (Component)e.getSource();
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, source);
            if (!TipWindow.this.getBounds().contains(p)) {
                TipWindow.this.ft.possiblyDisposeOfTipWindow();
            }
        }
    }
}

