/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class StringUtil {
    private static Logger _logger = Logger.getLogger(StringUtil.class);
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("<[^>]*>");

    public static String toCommaStr(boolean[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(byte[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(char[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(double[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(float[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(int[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(long[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(short[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static <T> String toCommaStr(Collection<T> list) {
        return StringUtil.toCommaStr(list, ", ");
    }

    public static <T> String toCommaStr(Collection<T> list, String entrySep) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            T val = it.next();
            sb.append(val);
            if (!it.hasNext()) continue;
            sb.append(entrySep);
        }
        return sb.toString();
    }

    public static <K, V> String toCommaStr(Map<K, V> map) {
        return StringUtil.toCommaStr(map, "=", ", ");
    }

    public static <K, V> String toCommaStrKey(Map<K, V> map) {
        return StringUtil.toCommaStr(map, "=", ", ", true, false);
    }

    public static <K, V> String toCommaStrKey(Map<K, V> map, String entrySep) {
        return StringUtil.toCommaStr(map, "=", entrySep, true, false);
    }

    public static <K, V> String toCommaStrVal(Map<K, V> map) {
        return StringUtil.toCommaStr(map, "=", ", ", false, true);
    }

    public static <K, V> String toCommaStrVal(Map<K, V> map, String entrySep) {
        return StringUtil.toCommaStr(map, "=", entrySep, false, true);
    }

    public static <K, V> String toCommaStr(Map<K, V> map, String keyValSep, String entrySep) {
        return StringUtil.toCommaStr(map, keyValSep, entrySep, true, true);
    }

    public static <K, V> String toCommaStr(Map<K, V> map, String keyValSep, String entrySep, boolean useKey, boolean useValue) {
        if (map == null) {
            return "";
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<K> it = map.keySet().iterator();
        while (it.hasNext()) {
            K key = it.next();
            V val = map.get(key);
            if (useKey) {
                sb.append(key);
            }
            if (useKey && useValue) {
                sb.append(keyValSep);
            }
            if (useValue) {
                sb.append(val);
            }
            if (!it.hasNext()) continue;
            sb.append(entrySep);
        }
        return sb.toString();
    }

    public static String toCommaStrMultiMap(Map<String, List<String>> map) {
        return StringUtil.toCommaStrMultiMap(map, "=", ", ");
    }

    public static String toCommaStrMultiMapKey(Map<String, List<String>> map) {
        return StringUtil.toCommaStrMultiMap(map, "=", ", ", true, false);
    }

    public static String toCommaStrMultiMapKey(Map<String, List<String>> map, String entrySep) {
        return StringUtil.toCommaStrMultiMap(map, "=", entrySep, true, false);
    }

    public static String toCommaStrMultiMapVal(Map<String, List<String>> map) {
        return StringUtil.toCommaStrMultiMap(map, "=", ", ", false, true);
    }

    public static String toCommaStrMultiMapVal(Map<String, List<String>> map, String entrySep) {
        return StringUtil.toCommaStrMultiMap(map, "=", entrySep, false, true);
    }

    public static String toCommaStrMultiMap(Map<String, List<String>> map, String keyValSep, String entrySep) {
        return StringUtil.toCommaStrMultiMap(map, keyValSep, entrySep, true, true);
    }

    public static String toCommaStrMultiMap(Map<String, List<String>> map, String keyValSep, String entrySep, boolean useKey, boolean useValue) {
        if (map == null) {
            return "";
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            List<String> list = map.get(key);
            Iterator<String> listIt = list.iterator();
            while (listIt.hasNext()) {
                String listVal = listIt.next();
                if (useKey) {
                    sb.append(key);
                }
                if (useKey && useValue) {
                    sb.append(keyValSep);
                }
                if (useValue) {
                    sb.append(listVal);
                }
                if (!listIt.hasNext()) continue;
                sb.append(entrySep);
            }
            if (!it.hasNext()) continue;
            sb.append(entrySep);
        }
        return sb.toString();
    }

    public static List<String> parseCommaStrToList(String str) {
        String[] sa;
        ArrayList<String> list = new ArrayList<String>();
        if (str == null) {
            return list;
        }
        for (String se : sa = str.split(",")) {
            list.add(se.trim());
        }
        return list;
    }

    public static Set<String> parseCommaStrToSet(String str) {
        String[] sa;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (str == null) {
            return set;
        }
        for (String se : sa = str.split(",")) {
            set.add(se.trim());
        }
        return set;
    }

    public static Map<String, String> parseCommaStrToMap(String source) {
        return StringUtil.parseCommaStrToMap(source, "=", ",");
    }

    public static Map<String, String> parseCommaStrToMap(String source, String keyValSep, String entrySep) {
        if (source == null) {
            return new LinkedHashMap<String, String>();
        }
        if ((source = source.trim()).startsWith("{") && source.endsWith("}")) {
            source = source.substring(1, source.length() - 1);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Scanner parser = new Scanner(source);
        parser.useDelimiter(entrySep);
        while (parser.hasNext()) {
            String val;
            String key;
            String oldVal;
            String keyVal = parser.next().trim();
            String[] sa = StringUtil.split(keyValSep, keyVal);
            if (sa.length != 2 || (oldVal = map.put(key = sa[0], val = sa[1])) == null) continue;
            _logger.warn((Object)("Found an already existing value for the key '" + key + "'. The existing value '" + oldVal + "' is replaced with the new value '" + val + "'."));
        }
        return map;
    }

    public static Map<String, List<String>> parseCommaStrToMultiMap(String source) {
        return StringUtil.parseCommaStrToMultiMap(source, "=", ",");
    }

    public static Map<String, List<String>> parseCommaStrToMultiMap(String source, String keyValSep, String entrySep) {
        if (source == null) {
            return new LinkedHashMap<String, List<String>>();
        }
        if ((source = source.trim()).startsWith("{") && source.endsWith("}")) {
            source = source.substring(1, source.length() - 1);
        }
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        Scanner parser = new Scanner(source);
        parser.useDelimiter(entrySep);
        while (parser.hasNext()) {
            String keyVal = parser.next().trim();
            String[] sa = StringUtil.split(keyValSep, keyVal);
            if (sa.length != 2) continue;
            String key = sa[0];
            String val = sa[1];
            List<String> list = map.get(key);
            if (list == null) {
                list = new LinkedList<String>();
            }
            list.add(val);
            map.put(key, list);
        }
        return map;
    }

    public static String toCommaStr(Object[] oa) {
        return StringUtil.toCommaStr(oa, ", ");
    }

    public static String toCommaStr(Object[] oa, String sep) {
        StringBuffer sb = new StringBuffer();
        if (oa == null) {
            return "";
        }
        for (int i = 0; i < oa.length; ++i) {
            sb.append(oa[i]);
            if (i >= oa.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String[] commaStrToArray(String str) {
        if (str == null) {
            return new String[0];
        }
        String[] sa = str.split(",");
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = sa[i].trim();
        }
        return sa;
    }

    public static Set<String> commaStrToSet(String str) {
        String[] sa = StringUtil.commaStrToArray(str);
        LinkedHashSet<String> retSet = new LinkedHashSet<String>();
        for (String s : sa) {
            retSet.add(s);
        }
        return retSet;
    }

    public static List<String> commaStrToList(String str) {
        String[] sa = StringUtil.commaStrToArray(str);
        ArrayList<String> retList = new ArrayList<String>();
        for (String s : sa) {
            retList.add(s);
        }
        return retList;
    }

    public static boolean arrayContains(Object[] oa, Object o) {
        if (oa == null) {
            return false;
        }
        for (int i = 0; i < oa.length; ++i) {
            if (!oa[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public static int count(String occurs, String s) {
        int count = 0;
        int current = -1;
        int next = 0;
        next = s.indexOf(occurs);
        while (next > -1) {
            ++count;
            current = next;
            next = s.indexOf(occurs, current + 1);
        }
        return count;
    }

    public static String[] split(String splitAt, String s) {
        int noOfLines = StringUtil.count(splitAt, s) + 1;
        String[] stringArray = new String[noOfLines];
        String remaining = s;
        int splitLen = splitAt.length();
        for (int i = 0; i < noOfLines - 1; ++i) {
            int pos = remaining.indexOf(splitAt);
            stringArray[i] = remaining.substring(0, pos);
            remaining = remaining.substring(pos + splitLen, remaining.length());
        }
        stringArray[noOfLines - 1] = remaining;
        return stringArray;
    }

    public static String word(String str, int number) {
        String[] stra = str.split("[ \t\n\f\r]");
        if (stra.length <= number) {
            return null;
        }
        return stra[number];
    }

    public static String lastWord(String str) {
        String[] stra = str.split("[ \t\n\f\r]");
        return stra[stra.length - 1];
    }

    public static String left(String str, int expandToSize) {
        return StringUtil.left(str, expandToSize, true);
    }

    public static String left(String str, int expandToSize, boolean allowGrow) {
        return StringUtil.left(str, expandToSize, true, "", "");
    }

    public static String left(String str, int expandToSize, boolean allowGrow, String quoteStr) {
        return StringUtil.left(str, expandToSize, true, quoteStr, quoteStr);
    }

    public static String left(String str, int expandToSize, boolean allowGrow, String quoteStrLeft, String quoteStrRight) {
        int maxSize = 131072;
        if (!StringUtil.isNullOrBlank(quoteStrLeft)) {
            str = quoteStrLeft + str;
        }
        if (!StringUtil.isNullOrBlank(quoteStrRight)) {
            str = str + quoteStrRight;
        }
        if (allowGrow && str.length() > expandToSize) {
            expandToSize = str.length();
        }
        if (expandToSize > maxSize) {
            _logger.warn((Object)("StringUtils.left(): expandToSize can't be above " + maxSize + ", using this value. expandToSize=" + expandToSize + ", inStr.length()=" + str.length()));
            expandToSize = maxSize;
        }
        int maxPadSize = expandToSize - str.length();
        String space = "                                                                                                                                                                                                                                                               ";
        while (space.length() < maxPadSize) {
            space = space + "                                                                                                                                                                                                                                                               ";
        }
        return (str + space).substring(0, expandToSize);
    }

    public static String right(String str, int num) {
        int len = num - str.length();
        if (len < 0) {
            len = 0;
        }
        String space = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ";
        return (space.substring(0, len) + str).substring(0, num);
    }

    public static String envVariableSubstitution(String val) {
        Pattern compiledRegex = Pattern.compile("\\$\\{.*\\}");
        while (compiledRegex.matcher(val).find()) {
            String envName;
            String envVal;
            block4: {
                envVal = null;
                envName = val.substring(val.indexOf("${") + 2, val.indexOf("}"));
                try {
                    envVal = System.getenv(envName);
                }
                catch (Throwable t) {
                    envVal = System.getProperty(envName);
                    if (envVal != null) break block4;
                    System.out.println("System.getenv(): Is not supported on this platform or version of Java. Please pass '-D" + envName + "=value' when starting the JVM.");
                }
            }
            if (envVal == null) {
                System.out.println("The Environment variable '" + envName + "' cant be found, replacing it with an empty string ''.");
                envVal = "";
            }
            envVal = envVal.replace('\\', '/');
            val = val.replaceFirst("\\$\\{" + envName + "\\}", envVal);
        }
        return val;
    }

    public static String replicate(String str, int size) {
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String fill(String str, int fill) {
        if (str.length() >= fill) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() < fill) {
            sb.append("                                                           ");
        }
        return sb.substring(0, fill);
    }

    public static String stripHtml(String in) {
        if (in == null) {
            return null;
        }
        return HTML_TAG_PATTERN.matcher(in).replaceAll("");
    }

    public static String stripNewLine(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(10) >= 0) {
            str = str.replace("\n", "");
        }
        if (str.indexOf(13) >= 0) {
            str = str.replace("\r", "");
        }
        return str.trim();
    }

    public static String makeApproxLineBreak(String str, int rowLength, int wordCountHysteresis, String lineBreak) {
        if (str.length() <= rowLength) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        char[] ca = str.toCharArray();
        int c = 0;
        int car = 0;
        while (c < ca.length) {
            sb.append(ca[c]);
            car = ca[c] == '\n' ? 0 : ++car;
            ++c;
            if (car < rowLength) continue;
            int nextSpacePos = str.substring(c).trim().indexOf(32);
            if (nextSpacePos > 0 && nextSpacePos < Math.max(15, rowLength / 4)) {
                while (c < ca.length && ca[c] != ' ') {
                    sb.append(ca[c]);
                    ++c;
                }
                if (str.substring(c).split("\\s", wordCountHysteresis + 1).length <= wordCountHysteresis) {
                    while (c < ca.length) {
                        sb.append(ca[c]);
                        ++c;
                    }
                } else {
                    sb.append(lineBreak);
                }
            } else {
                sb.append(lineBreak);
            }
            car = 0;
        }
        return sb.toString();
    }

    public static String getHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            return hostname;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean isNullOrBlank(String str) {
        if (str == null) {
            return true;
        }
        if (str.equals("")) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasValue(String str) {
        return !StringUtil.isNullOrBlank(str);
    }

    public static boolean matchesRegexArr(String inStr, String[] regexArr) {
        for (String str : regexArr) {
            if (!inStr.matches(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesRegexSet(String inStr, Set<String> regexSet) {
        for (String str : regexSet) {
            if (!inStr.matches(str)) continue;
            return true;
        }
        return false;
    }

    public static String removeLastComma(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).endsWith(",")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String removeLastNewLine(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).endsWith("\n")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.endsWith("\r")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static boolean hasSemicolonAtEnd(String row) {
        if (StringUtil.isNullOrBlank(row)) {
            return false;
        }
        if (row.endsWith(";")) {
            return true;
        }
        for (int i = row.length() - 1; i > 0; --i) {
            char ch = row.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return ch == ';';
        }
        return false;
    }

    public static String removeSemicolonAtEnd(String row) {
        if (StringUtil.hasSemicolonAtEnd(row)) {
            return row.substring(0, row.lastIndexOf(59));
        }
        return row;
    }

    public static int charCount(String str, char ch) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    public static int countLines(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int lines = 1;
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 >= len || str.charAt(pos + 1) != '\n') continue;
                ++pos;
                continue;
            }
            if (c != '\n') continue;
            ++lines;
        }
        return lines;
    }

    public static int indexOfEndBrace(String searchStr, int startPos, char endChar) {
        char beginChar = ' ';
        if (endChar == '}') {
            beginChar = '{';
        } else if (endChar == ']') {
            beginChar = '[';
        } else if (endChar == ')') {
            beginChar = '(';
        }
        int matchCount = 1;
        char[] search = searchStr.toCharArray();
        for (int i = startPos; i < search.length; ++i) {
            char c = search[i];
            if (c == beginChar) {
                ++matchCount;
            }
            if (c == endChar) {
                --matchCount;
            }
            if (matchCount != 0) continue;
            return i;
        }
        return -1;
    }

    public static int parseInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String xmlSafe(String inStr) {
        if (inStr == null) {
            return null;
        }
        if (inStr.indexOf(38) >= 0 || inStr.indexOf(60) >= 0) {
            return "<![CDATA[" + inStr + "]]>";
        }
        return inStr;
    }

    public static StringBuilder xmlAddAttributes(StringBuilder sb, Map<String, String> attributes) {
        if (attributes == null || attributes != null && attributes.size() == 0) {
            return sb;
        }
        for (String key : attributes.keySet()) {
            String val = attributes.get(key);
            sb.append(" ").append(key).append("=\"").append(val).append("\"");
        }
        return sb;
    }

    private static StringBuilder xmlAddAttributes(StringBuilder sb, String[] attributes) {
        if (attributes == null || attributes != null && attributes.length == 0) {
            return sb;
        }
        if (attributes != null && attributes.length % 2 != 0) {
            throw new IllegalArgumentException("Input parameter attributes must be a multiple of 2: key1, val1, key2, val2");
        }
        for (int i = 0; i < attributes.length; i += 2) {
            String key = attributes[i];
            String val = attributes[i + 1];
            sb.append(" ").append(key).append("=\"").append(val).append("\"");
        }
        return sb;
    }

    public static StringBuilder xmlBeginTag(StringBuilder sb, int preSpaces, String tagName) {
        return StringUtil.xmlBeginTag(sb, preSpaces, tagName, (String[])null);
    }

    public static StringBuilder xmlBeginTag(StringBuilder sb, int preSpaces, String tagName, Map<String, String> attributes) {
        for (int i = 0; i < preSpaces; ++i) {
            sb.append(" ");
        }
        sb.append("<").append(tagName);
        if (attributes != null && attributes.size() > 0) {
            StringUtil.xmlAddAttributes(sb, attributes);
        }
        sb.append(">\n");
        return sb;
    }

    public static StringBuilder xmlBeginTag(StringBuilder sb, int preSpaces, String tagName, String ... attributes) {
        if (attributes != null && attributes.length % 2 != 0) {
            throw new IllegalArgumentException("Input parameter attributes must be a multiple of 2: key1, val1, key2, val2");
        }
        for (int i = 0; i < preSpaces; ++i) {
            sb.append(" ");
        }
        sb.append("<").append(tagName);
        if (attributes != null && attributes.length > 0) {
            StringUtil.xmlAddAttributes(sb, attributes);
        }
        sb.append(">\n");
        return sb;
    }

    public static StringBuilder xmlEndTag(StringBuilder sb, int preSpaces, String tagName) {
        for (int i = 0; i < preSpaces; ++i) {
            sb.append(" ");
        }
        return sb.append("</").append(tagName).append(">\n");
    }

    public static StringBuilder xmlTag(StringBuilder sb, int preSpaces, String tagName, boolean value) {
        return StringUtil.xmlTag(sb, preSpaces, tagName, Boolean.toString(value));
    }

    public static StringBuilder xmlTag(StringBuilder sb, int preSpaces, String tagName, int value) {
        return StringUtil.xmlTag(sb, preSpaces, tagName, Integer.toString(value));
    }

    public static StringBuilder xmlTag(StringBuilder sb, int preSpaces, String tagName, String value) {
        return StringUtil.xmlTag(sb, preSpaces, tagName, value, false);
    }

    public static StringBuilder xmlTag(StringBuilder sb, int preSpaces, String tagName, String value, boolean addNullOrBlankValues) {
        if (StringUtil.isNullOrBlank(value) && !addNullOrBlankValues) {
            return sb;
        }
        for (int i = 0; i < preSpaces; ++i) {
            sb.append(" ");
        }
        if ((value = StringUtil.xmlSafe(value)) == null) {
            value = "";
        }
        return sb.append("<").append(tagName).append(">").append(value).append("</").append(tagName).append(">\n");
    }

    public static String escapeControlChars(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("\t", "\\t");
        str = str.replace("\f", "\\f");
        str = str.replace("\n", "\\n");
        str = str.replace("\r", "\\r");
        return str;
    }

    public static String unEscapeControlChars(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("\\t", "\t");
        str = str.replace("\\f", "\f");
        str = str.replace("\\n", "\n");
        str = str.replace("\\r", "\r");
        return str;
    }

    public static String markTextAtLine(String text, int line, boolean markUsingHtml) {
        if (text == null || line <= 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(text);
        int rowNumber = 0;
        while (scanner.hasNextLine()) {
            String lineStr = scanner.nextLine();
            if (line == ++rowNumber) {
                if (markUsingHtml) {
                    sb.append("<b><font color=\"red\">").append(rowNumber).append("> ").append(lineStr).append("</font></b>");
                } else {
                    sb.append("**** ").append(rowNumber).append("> ").append(lineStr);
                }
            } else {
                sb.append(rowNumber).append("> ").append(lineStr);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static int indexOf(String str, int fromIndex, char ... charsToLookfor) {
        if (str == null) {
            return -1;
        }
        int len = str.length();
        for (int i = fromIndex; i < len; ++i) {
            char c = str.charAt(i);
            for (int j = 0; j < charsToLookfor.length; ++j) {
                if (c != charsToLookfor[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstInputLine(String str) {
        if (StringUtil.isNullOrBlank(str)) {
            return 0;
        }
        int line = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\r' || ch == '\n') {
                ++line;
                if (ch != '\r' || i + 1 >= len || str.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            if (!Character.isWhitespace(ch)) break;
        }
        return line;
    }

    public static String getSelectedItemString(JComboBox combo) {
        if (combo == null) {
            return null;
        }
        Object o = combo.getSelectedItem();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static String bytesToHex(String prefix, byte[] bytes) {
        return StringUtil.bytesToHex(prefix, bytes, false, Integer.MAX_VALUE);
    }

    public static String bytesToHex(String prefix, byte[] bytes, boolean toUpper) {
        return StringUtil.bytesToHex(prefix, bytes, toUpper, Integer.MAX_VALUE);
    }

    public static String bytesToHex(String prefix, byte[] bytes, boolean toUpper, int max) {
        if (bytes == null) {
            return null;
        }
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length && i < max; ++i) {
            if (toUpper) {
                sb.append(String.format("%02X", bytes[i]));
                continue;
            }
            sb.append(String.format("%02x", bytes[i]));
        }
        if (prefix != null) {
            sb.insert(0, prefix);
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String hexStr) {
        if (hexStr.startsWith("0x")) {
            hexStr = hexStr.substring(2);
        }
        int len = hexStr.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexStr.charAt(i), 16) << 4) + Character.digit(hexStr.charAt(i + 1), 16));
        }
        return data;
    }

    public static List<String> splitOnCommasAllowQuotes(String input, boolean trim) {
        ArrayList<String> tokensList = new ArrayList<String>();
        if (input == null) {
            return tokensList;
        }
        char startQuoteChar = '\u0000';
        boolean inQuotes = false;
        StringBuilder b = new StringBuilder();
        char[] ca = input.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            char nc;
            char c = ca[i];
            char pc = i == 0 ? (char)'\u0000' : ca[i - 1];
            char c2 = nc = i + 1 < ca.length ? ca[i + 1] : (char)'\u0000';
            if (c == '\"' || c == '\'') {
                if (!inQuotes) {
                    inQuotes = true;
                    startQuoteChar = c;
                } else {
                    if (pc == startQuoteChar) {
                        inQuotes = false;
                    }
                    if (c == startQuoteChar && nc != startQuoteChar && pc != startQuoteChar) {
                        inQuotes = false;
                    }
                }
                b.append(c);
                continue;
            }
            if (c == ',') {
                if (inQuotes) {
                    b.append(c);
                    continue;
                }
                tokensList.add(trim ? b.toString().trim() : b.toString());
                b = new StringBuilder();
                continue;
            }
            b.append(c);
        }
        tokensList.add(trim ? b.toString().trim() : b.toString());
        return tokensList;
    }

    public static String unquote(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).charAt(0) != '\'' && str.charAt(0) != '\"') {
            return str;
        }
        StringBuilder b = new StringBuilder();
        char[] ca = str.toCharArray();
        char startQuoteChar = ca[0];
        boolean justSkippedDoubleQuote = false;
        for (int i = 1; i < ca.length - 1; ++i) {
            char pc;
            char c = ca[i];
            char c2 = pc = i <= 1 ? (char)'\u0000' : ca[i - 1];
            if (c == startQuoteChar && pc == startQuoteChar && !justSkippedDoubleQuote) {
                justSkippedDoubleQuote = true;
                continue;
            }
            justSkippedDoubleQuote = false;
            b.append(c);
        }
        return b.toString();
    }

    public static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add(current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + toProcess);
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    public static String bytesToHuman(long size) {
        return StringUtil.bytesToHuman(size, null);
    }

    public static String bytesToHuman(long size, String fmt) {
        if (fmt == null) {
            fmt = "#.##";
        }
        long Kb = 1024L;
        long Mb = Kb * 1024L;
        long Gb = Mb * 1024L;
        long Tb = Gb * 1024L;
        long Pb = Tb * 1024L;
        long Eb = Pb * 1024L;
        if (size < Kb) {
            return new DecimalFormat(fmt).format(size) + " byte";
        }
        if (size >= Kb && size < Mb) {
            return new DecimalFormat(fmt).format((double)size / (double)Kb) + " KB";
        }
        if (size >= Mb && size < Gb) {
            return new DecimalFormat(fmt).format((double)size / (double)Mb) + " MB";
        }
        if (size >= Gb && size < Tb) {
            return new DecimalFormat(fmt).format((double)size / (double)Gb) + " GB";
        }
        if (size >= Tb && size < Pb) {
            return new DecimalFormat(fmt).format((double)size / (double)Tb) + " TB";
        }
        if (size >= Pb && size < Eb) {
            return new DecimalFormat(fmt).format((double)size / (double)Pb) + " PB";
        }
        if (size >= Eb) {
            return new DecimalFormat(fmt).format((double)size / (double)Eb) + " EB";
        }
        return "???";
    }

    public static void main(String[] args) {
        String[] str;
        String[] htmlStrArr;
        System.out.println("splitOnCommasAllowQuotes(): " + StringUtil.toCommaStr(StringUtil.splitOnCommasAllowQuotes("string='',str='x,y',str3='''', int=99,int=null", true), "|"));
        System.out.println("splitOnCommasAllowQuotes(): " + StringUtil.toCommaStr(StringUtil.splitOnCommasAllowQuotes("1,2,'a,b,c', 'it''s true 2sq'''''", true), "|"));
        System.out.println("unquote(): " + StringUtil.unquote("'it''s 2 single-quotes'''''"));
        System.exit(0);
        System.out.println("countLines():" + StringUtil.countLines("one"));
        System.out.println("countLines():" + StringUtil.countLines("1 \n 2 \r\n 3 \r 4 \n 5"));
        System.exit(0);
        System.out.println("TEST 1-1: " + (StringUtil.indexOfEndBrace("abc ( 123 4 5 6 7 ) xxx", 0, ')') == -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-2: " + (StringUtil.indexOfEndBrace("abc ( 123 4 5 6 7 ) xxx", 5, ')') != -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-3: " + (StringUtil.indexOfEndBrace("abc ( 123 4 5 6 7 ] xxx", 5, ')') == -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-4: " + (StringUtil.indexOfEndBrace("abc ( 123 4 5 ( 6 7 ) xxx", 5, ')') == -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-5: " + (StringUtil.indexOfEndBrace("abc 123 4 5 6 7 ) xxx", 0, ')') != -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-6: " + (StringUtil.indexOfEndBrace("abc)", 0, ')') == 3 ? "OK" : "FAIL"));
        System.exit(0);
        for (String s : htmlStrArr = new String[]{"a<>bc", "<html>a<b>b</b>c</html>", "abc,"}) {
            System.out.println("str1='" + StringUtil.stripHtml(s) + "'.");
        }
        System.exit(0);
        for (String s : str = new String[]{"abc", "abc ", "abc,", "abc, ", "abc,\t", "abc,\n", "abc,\t\t", "abc,\n\n", "abc,\t\n"}) {
            System.out.println("str1='" + StringUtil.removeLastComma(s) + "'.");
        }
        System.exit(0);
        String[] strArr = StringUtil.commaStrToArray("");
        System.out.println("length=" + strArr.length);
        for (int i = 0; i < strArr.length; ++i) {
            System.out.println("arr[" + i + "]='" + strArr[i] + "'.");
        }
        System.exit(0);
        System.out.println("MAP=|" + StringUtil.parseCommaStrToMap("aaa=11\\,11,bbbbb=2222, cccc=3333") + "|.");
        System.out.println("MAP=|" + StringUtil.parseCommaStrToMap("{aaa=1111,bbbbb=2222, cccc=3333}") + "|.");
        System.out.println("MAP=|" + StringUtil.parseCommaStrToMap("{aaa=1111, bbbbb=2222, cccc=3333,}") + "|.");
        String t1Str = "{aaa=1111, bbb=2222, bbb=3333,}";
        Map<String, List<String>> t1Map = StringUtil.parseCommaStrToMultiMap(t1Str);
        System.out.println("MMAP=|" + t1Map + "|.");
        System.out.println("MMAP.toCommaStrMultiMap=|" + StringUtil.toCommaStrMultiMap(t1Map) + "|.");
        System.out.println("MMAP.toCommaStrMultiMap(useKey)=|" + StringUtil.toCommaStrMultiMap(t1Map, "=", ",", true, false) + "|.");
        System.out.println("MMAP.toCommaStrMultiMap(useVal)=|" + StringUtil.toCommaStrMultiMap(t1Map, "=", ",", false, true) + "|.");
        System.out.println("MMAP.toCommaStrMultiMapKey=|" + StringUtil.toCommaStrMultiMapKey(t1Map) + "|.");
        System.out.println("MMAP.toCommaStrMultiMapVal=|" + StringUtil.toCommaStrMultiMapVal(t1Map) + "|.");
        System.out.println("TEST: StringUtil BEGIN.");
        if (!StringUtil.lastWord(" 1 2 3 ").equals("3")) {
            System.out.println("FAILED:  test-1: StringUtil.lastWord()");
        }
        if (!StringUtil.lastWord("").equals("")) {
            System.out.println("FAILED:  test-2: StringUtil.lastWord()");
        }
        if (!StringUtil.lastWord(" 1 2\t 3 ").equals("3")) {
            System.out.println("FAILED:  test-3: StringUtil.lastWord()");
        }
        if (!StringUtil.lastWord(" 1 2 \n3").equals("3")) {
            System.out.println("FAILED:  test-4: StringUtil.lastWord()");
        }
        if (!StringUtil.left("123", 5).equals("123  ")) {
            System.out.println("FAILED:  test-1: StringUtil.left()");
        }
        if (!StringUtil.right("  123", 5).equals("  123")) {
            System.out.println("FAILED:  test-1: StringUtil.right()");
        }
        if (StringUtil.fill("123", 1).length() != 3) {
            System.out.println("FAILED:  test-1: StringUtil.fill()");
        }
        if (StringUtil.fill("123", 50).length() != 50) {
            System.out.println("FAILED:  test-2: StringUtil.fill(\"123\", 50)");
        }
        if (StringUtil.fill("123", 5000).length() != 5000) {
            System.out.println("FAILED:  test-3: StringUtil.fill(\"123\", 5000)");
        }
        if (StringUtil.stripHtml("123<html>-<b>B</b>.<xml xx=xxx, z=z>").indexOf("<") != -1) {
            System.out.println("FAILED:  test-1: StringUtil.stripHtml()");
        }
        System.out.println("TEST: StringUtil END.");
    }
}

