/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbmtk.demo.utils;

import com.sap.dbmtk.demo.utils.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

public class SwingUtils {
    private static Logger _logger = Logger.getLogger(SwingUtils.class);
    private static String REGEXP_NEW_LINE = "\\r?\\n|\\r";

    public static void printComponents(JComponent c, String text) {
        Component[] comp = c.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            System.out.println(text + ".comp[" + i + "].type=" + comp[i].getClass().getName());
        }
    }

    public static void printParents(Component c, String text) {
        int i = 0;
        while (c != null) {
            Container parent = c.getParent();
            if (parent != null) {
                System.out.println(text + " .depth[" + i + "].parentClassName=" + parent.getClass().getName());
            }
            c = parent;
            ++i;
        }
    }

    public static void hideMenuIfNoneIsVisible(JMenu menu) {
        if (menu == null) {
            return;
        }
        boolean hasVisibleItems = false;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem mi = menu.getItem(i);
            if (!mi.isVisible()) continue;
            hasVisibleItems = true;
            break;
        }
        menu.setVisible(hasVisibleItems);
    }

    public static String getClipboardContents() {
        boolean hasTransferableText;
        String result = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                _logger.error((Object)("getClipboardContents(): " + ex), (Throwable)ex);
            }
            catch (IOException ex) {
                _logger.error((Object)("getClipboardContents(): " + ex), (Throwable)ex);
            }
        }
        return result;
    }

    public static void setClipboardContents(String s) {
        StringSelection selection = new StringSelection(s);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    private static String escapeXml(String input) {
        String s = input == null ? "" : input.replace("&", "&amp;");
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        return s;
    }

    private static String getDetailsAsHTML(ErrorInfo errorInfo) {
        if (errorInfo.getErrorException() != null) {
            StringBuffer html = new StringBuffer("<html>");
            html.append("<h2>" + SwingUtils.escapeXml(errorInfo.getTitle()) + "</h2>");
            html.append("<HR size='1' noshade>");
            html.append("<div></div>");
            html.append("<b>Message:</b>");
            html.append("<pre>");
            html.append("    " + SwingUtils.escapeXml(errorInfo.getErrorException().toString()));
            html.append("</pre>");
            html.append("<b>Level:</b>");
            html.append("<pre>");
            html.append("    " + errorInfo.getErrorLevel());
            html.append("</pre>");
            html.append("<b>Stack Trace:</b>");
            for (Throwable ex = errorInfo.getErrorException(); ex != null; ex = ex.getCause()) {
                html.append("<h4>" + ex.getMessage() + "</h4>");
                html.append("<pre>");
                for (StackTraceElement el : ex.getStackTrace()) {
                    html.append("    " + el.toString().replace("<init>", "&lt;init&gt;") + "\n");
                }
                html.append("</pre>");
            }
            html.append("</html>");
            return html.toString();
        }
        return null;
    }

    public static void showInfoMessageExt(Component owner, String title, String msg, JCheckBox chkbox, Throwable throwable) {
        SwingUtils.showMessageExt(Level.INFO, owner, title, msg, chkbox, throwable);
    }

    public static void showWarnMessageExt(Component owner, String title, String msg, JCheckBox chkbox, Throwable throwable) {
        SwingUtils.showMessageExt(Level.WARNING, owner, title, msg, chkbox, throwable);
    }

    public static void showErrorMessageExt(Component owner, String title, String msg, JCheckBox chkbox, Throwable throwable) {
        SwingUtils.showMessageExt(Level.SEVERE, owner, title, msg, chkbox, throwable);
    }

    private static void showMessageExt(Level errorLevel, Component owner, String title, String msg, JCheckBox chkbox, Throwable throwable) {
        JXEditorPane details = new JXEditorPane();
        details.setContentType("text/html");
        JScrollPane detailsScrollPane = new JScrollPane((Component)details);
        detailsScrollPane.setPreferredSize(new Dimension(10, 250));
        details.setEditable(false);
        ErrorInfo info = new ErrorInfo(title, msg, null, null, throwable, errorLevel, null);
        String htmlText = SwingUtils.getDetailsAsHTML(info);
        details.setText(htmlText);
        details.setCaretPosition(0);
        JPanel stackTracePanel = new JPanel();
        stackTracePanel.setLayout((LayoutManager)new MigLayout());
        stackTracePanel.add((Component)detailsScrollPane, "push, grow");
        SwingUtils.showMessageExt(errorLevel, owner, title, msg, chkbox, stackTracePanel);
    }

    public static void showInfoMessageExt(Component owner, String title, String msg, JCheckBox chkbox, JPanel userPanel) {
        SwingUtils.showMessageExt(Level.INFO, owner, title, msg, chkbox, userPanel);
    }

    public static void showWarnMessageExt(Component owner, String title, String msg, JCheckBox chkbox, JPanel userPanel) {
        SwingUtils.showMessageExt(Level.WARNING, owner, title, msg, chkbox, userPanel);
    }

    public static void showErrorMessageExt(Component owner, String title, String msg, JCheckBox chkbox, JPanel userPanel) {
        SwingUtils.showMessageExt(Level.SEVERE, owner, title, msg, chkbox, userPanel);
    }

    private static void showMessageExt(final Level errorLevel, final Component owner, final String title, final String msg, final JCheckBox chkbox, final JPanel userPanel) {
        if (!SwingUtils.isEventQueueThread()) {
            Runnable doRun = new Runnable(){

                @Override
                public void run() {
                    SwingUtils.showMessageExt(errorLevel, owner, title, msg, chkbox, userPanel);
                }
            };
            try {
                SwingUtilities.invokeAndWait(doRun);
            }
            catch (Exception e) {
                _logger.error((Object)"Problems doing 'showMessageExt'.", (Throwable)e);
            }
            return;
        }
        final JDialog dialog = owner instanceof Dialog ? new JDialog((Dialog)owner) : (owner instanceof Frame ? new JDialog((Frame)owner) : (owner instanceof Window ? new JDialog((Window)owner) : new JDialog()));
        JPanel msgPanel = new JPanel((LayoutManager)new MigLayout());
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout());
        JButton close_but = new JButton("Close");
        close_but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        String iconProp = errorLevel.equals(Level.INFO) ? "OptionPane.informationIcon" : (errorLevel.equals(Level.WARNING) ? "OptionPane.warningIcon" : "OptionPane.errorIcon");
        JLabel icon_lbl = new JLabel(UIManager.getIcon(iconProp));
        JEditorPane errorMessage = new JEditorPane(new HTMLEditorKit().getContentType(), msg);
        errorMessage.setText(msg);
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)errorMessage.getDocument()).getStyleSheet().addRule(bodyRule);
        errorMessage.setOpaque(false);
        errorMessage.setBorder(null);
        errorMessage.setEditable(false);
        msgPanel.add((Component)icon_lbl, "gap 20 20 20 20, top, left, split");
        JPanel dummyPanel = new JPanel(new BorderLayout());
        dummyPanel.add(errorMessage);
        msgPanel.add((Component)dummyPanel, "gap 20 20 20 0, grow, push, wrap");
        JComponent comp = chkbox;
        if (comp == null) {
            comp = new JLabel("");
        }
        bottomPanel.add((Component)comp, "split, grow, push");
        bottomPanel.add((Component)close_but, "tag right, wrap");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)msgPanel, "North");
        panel.add((Component)bottomPanel, "South");
        if (userPanel != null) {
            JPanel tmpPanel = new JPanel((LayoutManager)new MigLayout());
            tmpPanel.add((Component)userPanel, "gap 65 20, grow, push, wrap");
            panel.add((Component)tmpPanel, "Center");
        }
        dialog.setContentPane(panel);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle(title);
        dialog.setModal(true);
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
    }

    public static void showInfoMessage(String title, String msg) {
        SwingUtils.showMessage(null, Level.INFO, title, msg, null);
    }

    public static void showInfoMessage(Component owner, String title, String msg) {
        SwingUtils.showMessage(owner, Level.INFO, title, msg, null);
    }

    public static void showWarnMessage(String title, String msg, Throwable exception) {
        SwingUtils.showMessage(null, Level.WARNING, title, msg, exception);
    }

    public static void showWarnMessage(Component owner, String title, String msg, Throwable exception) {
        SwingUtils.showMessage(owner, Level.WARNING, title, msg, exception);
    }

    public static void showErrorMessage(String title, String msg, Throwable exception) {
        SwingUtils.showMessage(null, Level.SEVERE, title, msg, exception);
    }

    public static void showErrorMessage(Component owner, String title, String msg, Throwable exception) {
        SwingUtils.showMessage(owner, Level.SEVERE, title, msg, exception);
    }

    public static void showMessage(Component owner, final Level errorLevel, final String title, final String msg, final Throwable exception) {
        if (owner != null && !(owner instanceof JFrame)) {
            owner = JOptionPane.getFrameForComponent(owner);
        }
        final String category = errorLevel.equals(Level.INFO) ? "Information" : (errorLevel.equals(Level.WARNING) ? "Warning" : "Error");
        final Component finalOwner = owner;
        Runnable doRun = new Runnable(){

            @Override
            public void run() {
                JXErrorPane.setDefaultLocale((Locale)Locale.ENGLISH);
                JXErrorPane errorPane = new JXErrorPane();
                ErrorInfo info = new ErrorInfo(title, msg, null, category, exception, errorLevel, null);
                errorPane.setErrorInfo(info);
                final JDialog dialog = JXErrorPane.createDialog((Component)finalOwner, (JXErrorPane)errorPane);
                dialog.pack();
                dialog.setTitle(title);
                Runnable grabFocus = new Runnable(){

                    @Override
                    public void run() {
                        dialog.requestFocusInWindow();
                    }
                };
                SwingUtilities.invokeLater(grabFocus);
                dialog.setVisible(true);
            }
        };
        if (SwingUtils.isEventQueueThread()) {
            doRun.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(doRun);
            }
            catch (InterruptedException e) {
                _logger.error((Object)("Problems showing message. Caught: " + e), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                _logger.error((Object)("Problems showing message. Caught: " + e), (Throwable)e);
            }
        }
    }

    public static boolean isOutOfScreen(int winPosX, int winPosY) {
        return SwingUtils.isOutOfScreen(winPosX, winPosY, 0, 0);
    }

    public static boolean isOutOfScreen(int winPosX, int winPosY, int winWidth, int winHeight) {
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        return winPosX + winWidth < 0 || winPosX > screenSize.width || winPosY + winHeight < 0 || winPosY > screenSize.height;
    }

    public static void centerWindow(Component frame) {
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void setLocationNearTopLeft(Component parent, Component child) {
        SwingUtils.setLocationNearTopLeft(parent, child, 20, 40);
    }

    public static void setLocationNearTopLeft(Component parent, Component child, int x, int y) {
        if (parent != null) {
            Point p = parent.getLocationOnScreen();
            p.x += x;
            p.y += y;
            child.setLocation(p);
        } else {
            SwingUtils.centerWindow(child);
        }
    }

    public static void setLocationCenterParentWindow(Component parent, Component child) {
        SwingUtils.centerWindow(child);
    }

    public static JButton makeToolbarButton(Class<?> clazz, String imageName, String actionCommand, ActionListener al, String toolTipText, String altText) {
        String imgLocation = "images/" + imageName;
        URL imageURL = clazz.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        if (al != null) {
            button.addActionListener(al);
        }
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            button.setText(altText);
            _logger.error((Object)("Toolbar Resource not found '" + imgLocation + "', url='" + imageURL + "'."));
        }
        return button;
    }

    public static ImageIcon readImageIcon(Class<?> clazz, String filename) {
        if (StringUtil.isNullOrBlank(filename)) {
            return null;
        }
        URL url = clazz.getResource(filename);
        if (url == null) {
            _logger.error((Object)("Can't find the resource for class='" + clazz + "', filename='" + filename + "'."));
            return null;
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
    }

    public static JPanel createPanel(String title, boolean createBorder) {
        return SwingUtils.createPanel(title, createBorder, null);
    }

    public static JPanel createPanel(String title, boolean createBorder, LayoutManager layoutManager) {
        JPanel panel = new JPanel();
        if (layoutManager != null) {
            panel.setLayout(layoutManager);
        }
        if (createBorder) {
            TitledBorder border = BorderFactory.createTitledBorder(title);
            panel.setBorder(border);
        }
        return panel;
    }

    public static void calcColumnWidths(JTable table) {
        SwingUtils.calcColumnWidths(table, 0, false);
    }

    public static void calcColumnWidths(JTable table, int onlyXLastRows, boolean onlyIncreaseWith) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int margin = columns.getColumnMargin();
        int totalRowCount = data.getRowCount();
        int stopAtRow = 0;
        if (onlyXLastRows > 0) {
            stopAtRow = Math.max(stopAtRow, totalRowCount - onlyXLastRows);
        }
        int totalWidth = 0;
        for (int i = columns.getColumnCount() - 1; i >= 0; --i) {
            TableColumn column = columns.getColumn(i);
            int columnIndex = column.getModelIndex();
            int width = -1;
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            Component columnHeader = null;
            if (h != null) {
                columnHeader = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                width = columnHeader.getPreferredSize().width;
            }
            for (int row = totalRowCount - 1; row >= stopAtRow; --row) {
                TableCellRenderer r = table.getCellRenderer(row, i);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                width = Math.max(width, c.getPreferredSize().width);
            }
            if (width >= 0) {
                column.setPreferredWidth(width + margin);
            }
            totalWidth += column.getPreferredWidth();
        }
    }

    public static void setCaretToLineNumber(JTextArea text, int linenumber) {
        String s;
        text.setCaretPosition(0);
        if (linenumber < 2) {
            return;
        }
        StringTokenizer st = new StringTokenizer(text.getText(), "\n", true);
        int count = 0;
        int countRowAfter = 0;
        while (st.hasMoreTokens() & linenumber > 1) {
            s = st.nextToken();
            count += s.length();
            if (!s.equals("\n")) continue;
            --linenumber;
        }
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            countRowAfter = count + s.length();
        }
        text.setCaretPosition(count);
        text.select(count, countRowAfter);
    }

    public static boolean isEventQueueThread() {
        String threadName = Thread.currentThread().getName();
        return threadName.startsWith("AWT-EventQueue");
    }

    public static Color parseColor(String colorStr, Color defaultColor) {
        try {
            return SwingUtils.parseColor(colorStr);
        }
        catch (ParseException e) {
            _logger.debug((Object)e.toString());
            return defaultColor;
        }
    }

    public static Color parseColor(String colorStr) throws ParseException {
        if (colorStr == null) {
            throw new ParseException("Color string is null.", -1);
        }
        if ((colorStr = colorStr.trim()).equals("")) {
            throw new ParseException("Color string is empty.", -1);
        }
        try {
            int colorInt = Integer.parseInt(colorStr);
            return new Color(colorInt);
        }
        catch (NumberFormatException colorInt) {
            if (colorStr.indexOf(".") >= 0 || colorStr.indexOf(",") >= 0) {
                String[] sa = null;
                int[] ia = new int[4];
                sa = colorStr.indexOf(".") >= 0 ? colorStr.split("\\.") : colorStr.split(",");
                if (sa.length != 3 && sa.length != 4) {
                    throw new ParseException("Color string '" + colorStr + "' does not have two or three divider characters of '.' or ','", -1);
                }
                ia[3] = 255;
                for (int i = 0; i < sa.length; ++i) {
                    sa[i] = sa[i].trim();
                    try {
                        ia[i] = Integer.parseInt(sa[i]);
                    }
                    catch (NumberFormatException ignore) {
                        throw new ParseException("Color string '" + colorStr + "' has a non number in the " + (i + 1) + " field.", i);
                    }
                    if (ia[i] <= 255) continue;
                    throw new ParseException("Color string '" + colorStr + "' has a 'to big' number in the " + (i + 1) + " field. max is 255.", i);
                }
                return new Color(ia[0], ia[1], ia[2], ia[3]);
            }
            if (colorStr.startsWith("#") || colorStr.startsWith("0x")) {
                if ((colorStr = colorStr.startsWith("#") ? colorStr.substring(1) : colorStr.substring(2)).length() != 6 && colorStr.length() != 8) {
                    throw new ParseException("Color string '" + colorStr + "' has to be of the length 6 (or 8 if you want to have alpha).", -1);
                }
                try {
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    int a = 255;
                    r = Integer.parseInt(colorStr.substring(0, 2), 16);
                    g = Integer.parseInt(colorStr.substring(2, 4), 16);
                    b = Integer.parseInt(colorStr.substring(4, 6), 16);
                    if (colorStr.length() > 6) {
                        a = Integer.parseInt(colorStr.substring(6, 8), 16);
                    }
                    return new Color(r, g, b, a);
                }
                catch (NumberFormatException ignore) {
                    throw new ParseException("Color string '" + colorStr + "' has a non number in the field.", -1);
                }
            }
            if (colorStr.equalsIgnoreCase("WHITE")) {
                return Color.WHITE;
            }
            if (colorStr.equalsIgnoreCase("LIGHT_GRAY")) {
                return Color.LIGHT_GRAY;
            }
            if (colorStr.equalsIgnoreCase("GRAY")) {
                return Color.GRAY;
            }
            if (colorStr.equalsIgnoreCase("DARK_GRAY")) {
                return Color.DARK_GRAY;
            }
            if (colorStr.equalsIgnoreCase("BLACK")) {
                return Color.BLACK;
            }
            if (colorStr.equalsIgnoreCase("RED")) {
                return Color.RED;
            }
            if (colorStr.equalsIgnoreCase("PINK")) {
                return Color.PINK;
            }
            if (colorStr.equalsIgnoreCase("ORANGE")) {
                return Color.ORANGE;
            }
            if (colorStr.equalsIgnoreCase("YELLOW")) {
                return Color.YELLOW;
            }
            if (colorStr.equalsIgnoreCase("GREEN")) {
                return Color.GREEN;
            }
            if (colorStr.equalsIgnoreCase("MAGENTA")) {
                return Color.MAGENTA;
            }
            if (colorStr.equalsIgnoreCase("CYAN")) {
                return Color.CYAN;
            }
            if (colorStr.equalsIgnoreCase("BLUE")) {
                return Color.BLUE;
            }
            throw new ParseException("Color string '" + colorStr + "' can't be parsed. I tried 'int' & 'r,g,b[,a]|r.g.b[.a]' & '#rrggbb[aa]|0xrrggbb[aa]' & 'java colors' (out of parser implementations).", -1);
        }
    }

    public static String tableToString(JTable jtable, int[] justRowNumbers) {
        int firstRow = justRowNumbers[0];
        int lastRow = justRowNumbers[justRowNumbers.length - 1] + 1;
        return SwingUtils.tableToString(jtable, false, null, null, firstRow, lastRow, justRowNumbers);
    }

    public static String tableToString(JTable jtable, int justRowNumber) {
        return SwingUtils.tableToString(jtable, false, null, null, justRowNumber, justRowNumber + 1, null);
    }

    public static String tableToString(JTable jtable) {
        return SwingUtils.tableToString(jtable, false, null, null, -1, -1, null);
    }

    public static String tableToString(JTable jtable, boolean stripHtml, String[] prefixColName, Object[] prefixColData) {
        return SwingUtils.tableToString(jtable, stripHtml, prefixColName, prefixColData, -1, -1, null);
    }

    public static String tableToString(JTable jtable, boolean stripHtml, String[] prefixColName, Object[] prefixColData, int firstRow, int lastRow, int[] justRowNumbers) {
        String[] sa;
        String cellStr;
        Object cellObj;
        int c;
        int c2;
        String colSepOther = "+";
        String colSepData = "|";
        String lineSpace = "-";
        String newLine = "\n";
        ArrayList<String> tableHead = new ArrayList<String>();
        ArrayList tableData = new ArrayList();
        StringBuilder sb = new StringBuilder();
        boolean doPrefix = false;
        if (prefixColName != null && prefixColData != null) {
            if (prefixColName.length != prefixColData.length) {
                throw new IllegalArgumentException("tableToString(): prefixColName.length=" + prefixColName.length + " is NOT equal prefixColData.length=" + prefixColData.length);
            }
            doPrefix = true;
        }
        int cols = jtable.getColumnCount();
        if (firstRow < 0) {
            firstRow = 0;
        }
        if (lastRow < 0) {
            lastRow = jtable.getRowCount();
        }
        int copiedRows = 0;
        if (doPrefix) {
            for (c2 = 0; c2 < prefixColName.length; ++c2) {
                tableHead.add(prefixColName[c2]);
            }
        }
        for (c2 = 0; c2 < cols; ++c2) {
            tableHead.add(jtable.getColumnName(c2));
        }
        for (int r = firstRow; r < lastRow; ++r) {
            int c3;
            if (justRowNumbers != null) {
                boolean addThisRow = false;
                for (int a = 0; a < justRowNumbers.length; ++a) {
                    if (r != justRowNumbers[a]) continue;
                    addThisRow = true;
                    break;
                }
                if (!addThisRow) continue;
            }
            ArrayList<Object> row = new ArrayList<Object>();
            if (doPrefix) {
                for (c3 = 0; c3 < prefixColData.length; ++c3) {
                    row.add(prefixColData[c3]);
                }
            }
            for (c3 = 0; c3 < cols; ++c3) {
                Object obj = jtable.getValueAt(r, c3);
                if (obj != null && obj instanceof String) {
                    String str = (String)obj;
                    if (stripHtml) {
                        str = StringUtil.stripHtml(str);
                    }
                    while (str.endsWith("\r") || str.endsWith("\n")) {
                        str = str.substring(0, str.length() - 1);
                    }
                    if (str.indexOf(9) >= 0) {
                        str = str.replace("\t", "        ");
                    }
                    obj = str.indexOf(13) >= 0 || str.indexOf(10) >= 0 ? str.split(REGEXP_NEW_LINE) : str;
                }
                row.add(obj);
            }
            tableData.add(row);
            ++copiedRows;
        }
        if (doPrefix) {
            cols += prefixColName.length;
        }
        boolean tableHasMultiLineCells = false;
        int[] colLength = new int[cols];
        int[][] rowColCellLineCount = new int[copiedRows][cols];
        for (c = 0; c < cols; ++c) {
            int maxLen = 0;
            String cellName = (String)tableHead.get(c);
            maxLen = Math.max(maxLen, cellName.length());
            for (int r = 0; r < copiedRows; ++r) {
                cellObj = ((List)tableData.get(r)).get(c);
                cellStr = cellObj == null ? "" : cellObj.toString();
                rowColCellLineCount[r][c] = 0;
                if (cellObj instanceof String[]) {
                    sa = (String[])cellObj;
                    tableHasMultiLineCells = true;
                    rowColCellLineCount[r][c] = sa.length;
                    for (int l = 0; l < sa.length; ++l) {
                        maxLen = Math.max(maxLen, sa[l].length());
                    }
                    continue;
                }
                maxLen = Math.max(maxLen, cellStr.length());
            }
            colLength[c] = maxLen;
        }
        for (c = 0; c < cols; ++c) {
            String line = StringUtil.replicate(lineSpace, colLength[c]);
            sb.append(colSepOther).append(line);
        }
        sb.append(colSepOther).append(newLine);
        for (c = 0; c < cols; ++c) {
            String cellName = (String)tableHead.get(c);
            String data = StringUtil.fill(cellName, colLength[c]);
            sb.append(colSepData).append(data);
        }
        sb.append(colSepData).append(newLine);
        for (c = 0; c < cols; ++c) {
            String line = StringUtil.replicate(lineSpace, colLength[c]);
            sb.append(colSepOther).append(line);
        }
        sb.append(colSepOther).append(newLine);
        for (int r = 0; r < copiedRows; ++r) {
            int c4;
            int maxCellLineCountOnThisRow = 0;
            for (c4 = 0; c4 < cols; ++c4) {
                maxCellLineCountOnThisRow = Math.max(maxCellLineCountOnThisRow, rowColCellLineCount[r][c4]);
            }
            if (tableHasMultiLineCells && r > 0) {
                for (c4 = 0; c4 < cols; ++c4) {
                    String line = StringUtil.replicate(lineSpace, colLength[c4]);
                    sb.append(colSepOther).append(line);
                }
                sb.append(colSepOther).append(newLine);
            }
            if (maxCellLineCountOnThisRow == 0) {
                for (c4 = 0; c4 < cols; ++c4) {
                    Object cellObj2 = ((List)tableData.get(r)).get(c4);
                    String cellStr2 = cellObj2 == null ? "" : cellObj2.toString();
                    String data = StringUtil.fill(cellStr2, colLength[c4]);
                    sb.append(colSepData).append(data);
                }
                sb.append(colSepData).append(newLine);
                continue;
            }
            for (int l = 0; l < maxCellLineCountOnThisRow; ++l) {
                for (int c5 = 0; c5 < cols; ++c5) {
                    String data;
                    cellObj = ((List)tableData.get(r)).get(c5);
                    String string = cellStr = cellObj == null ? "" : cellObj.toString();
                    if (l == 0) {
                        if (cellObj instanceof String[]) {
                            sa = (String[])cellObj;
                            cellStr = sa[0];
                        }
                        data = StringUtil.fill(cellStr, colLength[c5]);
                        sb.append(colSepData).append(data);
                        continue;
                    }
                    if (cellObj instanceof String[]) {
                        sa = (String[])cellObj;
                        cellStr = "";
                        if (l < sa.length) {
                            cellStr = sa[l];
                        }
                    } else {
                        cellStr = "";
                    }
                    data = StringUtil.fill(cellStr, colLength[c5]);
                    sb.append(colSepData).append(data);
                }
                sb.append(colSepData).append(newLine);
            }
        }
        for (c = 0; c < cols; ++c) {
            String line = StringUtil.replicate(lineSpace, colLength[c]);
            sb.append(colSepOther).append(line);
        }
        sb.append(colSepOther).append(newLine);
        sb.append("Rows ").append(copiedRows).append(newLine);
        return sb.toString();
    }

    public static String tableToHtmlString(JTable table) {
        StringBuilder sb = new StringBuilder();
        int rows = table.getRowCount();
        int cols = table.getColumnCount();
        sb.append("<TABLE>\n");
        sb.append("  <TR>");
        for (int c = 0; c < cols; ++c) {
            sb.append(" <TH>").append(table.getColumnName(c)).append("</TH>");
        }
        sb.append(" </TR>\n");
        for (int r = 0; r < rows; ++r) {
            sb.append("  <TR>");
            for (int c = 0; c < cols; ++c) {
                sb.append(" <TD>").append(table.getValueAt(r, c)).append("</TD>");
            }
            sb.append(" </TR>\n");
        }
        sb.append("</TABLE>\n");
        return sb.toString();
    }

    public static String tableToCsvString(JTable table, boolean headers, String colSep, String rowSep, String tabNullValue, String outNullvalue) {
        StringBuilder sb = new StringBuilder();
        int rows = table.getRowCount();
        int cols = table.getColumnCount();
        if (headers) {
            for (int c = 0; c < cols; ++c) {
                sb.append(table.getColumnName(c));
                if (c + 1 >= cols) continue;
                sb.append(colSep);
            }
            sb.append(rowSep);
        }
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                Object obj = table.getValueAt(r, c);
                if (obj == null) {
                    obj = outNullvalue;
                } else if (obj.equals(tabNullValue)) {
                    obj = outNullvalue;
                }
                sb.append(obj);
                if (c + 1 >= cols) continue;
                sb.append(colSep);
            }
            sb.append(rowSep);
        }
        return sb.toString();
    }

    public static boolean isDataChanged(TableModelEvent e) {
        if (e == null) {
            return false;
        }
        return e.getType() == 0 && e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE;
    }

    public static boolean isUpdate(TableModelEvent e) {
        if (SwingUtils.isStructureChanged(e)) {
            return false;
        }
        return e.getType() == 0 && e.getLastRow() < Integer.MAX_VALUE;
    }

    public static boolean isStructureChanged(TableModelEvent e) {
        return e == null || e.getFirstRow() == -1;
    }

    public static DefaultTableModel copyTableModel(TableModel copyFrom) {
        if (copyFrom == null) {
            throw new RuntimeException("copyTableModel(), Input parameter copyFrom can't be null.");
        }
        DefaultTableModel newModel = new DefaultTableModel();
        newModel.setRowCount(copyFrom.getRowCount());
        newModel.setColumnCount(copyFrom.getColumnCount());
        Vector<String> colHeader = new Vector<String>();
        for (int c = 0; c < copyFrom.getColumnCount(); ++c) {
            colHeader.add(copyFrom.getColumnName(c));
        }
        newModel.setColumnIdentifiers(colHeader);
        for (int r = 0; r < copyFrom.getRowCount(); ++r) {
            for (int c = 0; c < copyFrom.getColumnCount(); ++c) {
                newModel.setValueAt(copyFrom.getValueAt(r, c), r, c);
            }
        }
        return newModel;
    }

    public static String getScreenResulutionAsString() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth();
        int height = gd.getDisplayMode().getHeight();
        return width + "x" + height;
    }

    public static Dimension getSizeWithingScreenLimit(int width, int height, int marginPixels) {
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int screenWidth = screenSize.width - marginPixels * 3;
        int screenHeight = screenSize.height - marginPixels * 2;
        return new Dimension(Math.min(width, screenWidth), Math.min(height, screenHeight));
    }

    public static void setSizeWithingScreenLimit(Component comp, int marginPixels) {
        Dimension size = comp.getSize();
        size = SwingUtils.getSizeWithingScreenLimit(size.width, size.height, marginPixels);
        comp.setSize(size);
    }

    public static void setWindowMinSize(JDialog dialog) {
        SwingUtils.setWindowMinSize(dialog, dialog.getContentPane());
    }

    public static void setWindowMinSize(JFrame frame) {
        SwingUtils.setWindowMinSize(frame, frame.getContentPane());
    }

    public static void setWindowMinSize(JWindow window) {
        SwingUtils.setWindowMinSize(window, window.getContentPane());
    }

    public static void setWindowMinSize(final Window win, final Container contentPane) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Insets ins = win.getInsets();
                int thisWinHeight = win.getHeight();
                int thisWinWidth = win.getWidth();
                int calcWinMinHeight = ins.top + ins.bottom + contentPane.getMinimumSize().height;
                int calcWinMinWidth = ins.left + ins.right + contentPane.getMinimumSize().width;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("setWindowMinSize(): actWinHeight=" + thisWinHeight + ", calcWinMinHeight=" + calcWinMinHeight + "."));
                    _logger.debug((Object)("setWindowMinSize(): actWinWidth =" + thisWinWidth + ", calcWinMinWidth =" + calcWinMinWidth + "."));
                }
                if (thisWinHeight < calcWinMinHeight) {
                    _logger.info((Object)("setWindowMinSize(): Adjusting minimum window HEIGHT from '" + thisWinHeight + "' to minimum '" + calcWinMinHeight + "'."));
                    win.setSize(win.getWidth(), calcWinMinHeight);
                }
                if (thisWinWidth < calcWinMinWidth) {
                    _logger.info((Object)("setWindowMinSize(): Adjusting minimum window WIDTH from '" + thisWinWidth + "' to minimum '" + calcWinMinWidth + "'."));
                    win.setSize(calcWinMinWidth, win.getHeight());
                }
            }
        });
    }

    public static void setEnabled(JPanel panel, boolean enable) {
        panel.setEnabled(enable);
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            Component comp = panel.getComponent(i);
            comp.setEnabled(enable);
            if (!(comp instanceof JPanel)) continue;
            SwingUtils.setEnabled((JPanel)comp, enable);
        }
    }

    public static void setEnabled(JPanel panel, boolean enable, Component ... disregard) {
        panel.setEnabled(enable);
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            Component comp = panel.getComponent(i);
            boolean doAction = true;
            if (disregard != null) {
                for (Component dc : disregard) {
                    if (!dc.equals(comp)) continue;
                    doAction = false;
                }
            }
            if (doAction) {
                comp.setEnabled(enable);
            }
            if (!(comp instanceof JPanel)) continue;
            SwingUtils.setEnabled((JPanel)comp, enable, disregard);
        }
    }

    public static void setFocus(final Component compToFocus) {
        Runnable deferredAction = new Runnable(){

            @Override
            public void run() {
                compToFocus.requestFocus();
            }
        };
        SwingUtilities.invokeLater(deferredAction);
    }

    public static void installEscapeButton(JDialog window, final JButton pressThisOnEscape) {
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (pressThisOnEscape != null) {
                    pressThisOnEscape.doClick(20);
                }
            }
        };
        InputMap iMap = window.getRootPane().getInputMap(1);
        iMap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        ActionMap aMap = window.getRootPane().getActionMap();
        aMap.put("escape", escAction);
    }

    public static Dimension getScaledDimension(Dimension originArea, Dimension boundary) {
        int originWidth = originArea.width;
        int originHight = originArea.height;
        int boundWidth = boundary.width;
        int boundHeight = boundary.height;
        int newWidth = originWidth;
        int newHeight = originHight;
        if (originWidth > boundWidth) {
            newWidth = boundWidth;
            newHeight = newWidth * originHight / originWidth;
        }
        if (newHeight > boundHeight) {
            newHeight = boundHeight;
            newWidth = newHeight * originWidth / originHight;
        }
        return new Dimension(newWidth, newHeight);
    }

    public static byte[] toBytArray(ImageIcon iconImage) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)SwingUtils.toBufferedImage(iconImage), "jpg", baos);
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static BufferedImage toBufferedImage(ImageIcon iconImage) {
        return SwingUtils.toBufferedImage(iconImage.getImage());
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, 0, 0, null);
        return bi;
    }

    public static void main(String[] args) {
        Object[] columnNames = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        Object[][] data = new Object[][]{{"row 1", "no newlines in this row", "Snowboarding", new Integer(5), new Boolean(false)}, {"row 2", "2-rows:Ro(ln)wing", "Ro\r\n\rwing", new Integer(3), new Boolean(true)}, {"row 3", "8-rows,after each char", "K\nn\ni\nt\nt\ni\nn\ng\n", new Integer(2), new Boolean(false)}, {"row 4", "2-rows:Speed(ln) reading", "Speed\n reading", new Integer(20), new Boolean(true)}, {"row 5", "Pool(ln)             xxx   -", "Pool\n             xxx   -", new Integer(10), new Boolean(false)}, {"row 6", "no newlines, 2 lead space", "  last Row .-.", new Integer(5), new Boolean(false)}};
        JTable jtable = new JTable(data, columnNames);
        String xxx = SwingUtils.tableToString(jtable);
        System.out.println("##################################");
        System.out.println(xxx);
        System.out.println("##################################");
    }
}

