/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ldap;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.SyASEServer;
import com.sybase.util.ds.ldap.SyServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class SyLDAPServer
extends SyServer
implements Comparable {
    public static final String DEFAULT_LDAP_PORT = "389";
    public static final String DEFAULT_LDAPS_PORT = "636";
    public static final String BIND_NAME = "bindname";
    private String _rootEntry;
    private String _initialContextName;
    private Hashtable<String, SyASEServer> _lookup = new Hashtable();
    private final String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private final String MY_FILTER = "(1.3.6.1.4.1.897.4.2.2=*)";
    private final String ATTRIBUTE_KEY_SYBASE_SERVER_NAME = "sybaseServername";
    private final String ATTRIBUTE_KEY_OBJECT_CLASS = "objectClass";
    private final String ATTRIBUTE_VALUE_OBJECT_CLASS = "sybaseServer";
    private final String ATTRIBUTE_KEY_SYBASE_ADDRESS = "sybaseAddress";
    private final String ATTRIBUTE_KEY_SYBASE_SERVICE = "sybaseService";
    private final String ATTRIBUTE_VALUE_SYBASE_SERVICE = "ASE";
    private final String ATTRIBUTE_KEY_SYBASE_VERSION = "sybaseVersion";
    private final String ATTRIBUTE_VALUE_SYBASE_VERSION = "1503";
    private final String ATTRIBUTE_KEY_SYBASE_STATUS = "sybaseStatus";
    private final String ATTRIBUTE_VALUE_SYBASE_STATUS = "4";
    private NamingEnumeration<SearchResult> _searchResults = null;
    private byte status = (byte)-1;

    public SyLDAPServer(String string, String string2, String string3, String string4) {
        this._serverName = string;
        this._hostName = string2;
        this._portNumber = string3 != null ? string3 : DEFAULT_LDAP_PORT;
        this._rootEntry = string4;
        if (string4 != null && string4.length() > 7 && string4.toLowerCase().startsWith("ldap")) {
            String string5 = "http" + string4.substring(4);
            try {
                URL uRL = new URL(string5);
                String string6 = uRL.getPath();
                this._initialContextName = string6.substring(1);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            int n = string4.indexOf(BIND_NAME);
            if (n != -1) {
                this._userName = string4.substring(n + BIND_NAME.length() + 1);
                n = this._userName.indexOf(63);
                if (n != -1) {
                    this._encryptedPw = Utils.encryptPassword(this._userName.substring(n + 1));
                    this._userName = this._userName.substring(0, n);
                }
            }
        }
    }

    @Override
    public String getHost() {
        return this._hostName;
    }

    @Override
    public String getPort() {
        return this._portNumber;
    }

    @Override
    public String getUserName() {
        return this._userName;
    }

    public String getRootEntry() {
        return this._rootEntry;
    }

    @Override
    public String getServerName() {
        return this._serverName;
    }

    private DirContext initConnection() throws NamingException {
        this._searchResults = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        if (this._portNumber == null || this._portNumber.length() == 0) {
            this._portNumber = this._rootEntry.indexOf("ldaps") != -1 ? DEFAULT_LDAPS_PORT : DEFAULT_LDAP_PORT;
        }
        if (this._rootEntry.indexOf("ldaps") != -1) {
            hashtable.put("java.naming.provider.url", "ldaps://" + Utils.getHostAndPort(this._hostName, this._portNumber));
        } else {
            hashtable.put("java.naming.provider.url", "ldap://" + Utils.getHostAndPort(this._hostName, this._portNumber));
        }
        if (this._userName != null) {
            hashtable.put("java.naming.security.principal", this._userName);
            hashtable.put("user", this._userName);
        }
        if (this._encryptedPw != null) {
            hashtable.put("java.naming.security.credentials", Utils.decryptPassword(this._encryptedPw));
            hashtable.put("password", Utils.decryptPassword(this._encryptedPw));
        }
        return new InitialDirContext(hashtable);
    }

    public void connectLDAP() {
        try {
            DirContext dirContext = this.initConnection();
            SearchControls searchControls = new SearchControls();
            searchControls.setCountLimit(0L);
            searchControls.setSearchScope(2);
            this._searchResults = dirContext.search(this._rootEntry, "(1.3.6.1.4.1.897.4.2.2=*)", searchControls);
            this.status = 1;
        }
        catch (NamingException namingException) {
            this.status = 0;
        }
    }

    public synchronized boolean connectLDAP(int n) {
        long l = n * 1000;
        Thread thread = new Thread(){

            @Override
            public void run() {
                SyLDAPServer.this.connectLDAP();
            }
        };
        thread.start();
        long l2 = 0L;
        while (l2 < l && this.status == -1) {
            try {
                Thread.sleep(3000L);
                l2 += 3000L;
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.status == 1;
    }

    public synchronized void modifyServiceToEntry(String string, Service service, Service service2) throws NamingException, IOException {
        this.deleteServiceFromEntry(string, service);
        this.addServiceToEntry(string, service2);
    }

    public synchronized void addServiceToEntry(String string, Service service) throws NamingException {
        DirContext dirContext = this.initConnection();
        String[] stringArray = new String[]{"sybaseAddress"};
        Attributes attributes = dirContext.getAttributes(this.getServerNameDN(string), stringArray);
        if (attributes == null) {
            return;
        }
        ModificationItem[] modificationItemArray = new ModificationItem[]{new ModificationItem(1, new BasicAttribute("sybaseAddress", this.getCannonicalForm(service)))};
        dirContext.modifyAttributes(this.getServerNameDN(string), modificationItemArray);
    }

    public synchronized void addEntry(SyInterfacesEntry syInterfacesEntry) throws NamingException {
        DirContext dirContext = this.initConnection();
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(new BasicAttribute("objectClass", "sybaseServer"));
        basicAttributes.put(new BasicAttribute("sybaseServername", syInterfacesEntry.getName()));
        basicAttributes.put(new BasicAttribute("sybaseService", "ASE"));
        basicAttributes.put(new BasicAttribute("sybaseVersion", "1503"));
        basicAttributes.put(new BasicAttribute("sybaseStatus", "4"));
        List<Service> list = syInterfacesEntry.getServices();
        if (list.size() > 0) {
            Service service = list.get(0);
            basicAttributes.put(new BasicAttribute("sybaseAddress", this.getCannonicalForm(service)));
        }
        dirContext.bind("sybaseServername=" + syInterfacesEntry.getName() + "," + this._initialContextName, null, (Attributes)basicAttributes);
        if (this.containsASEServerName(syInterfacesEntry.getName())) {
            this._lookup.put(syInterfacesEntry.getName() + " [" + syInterfacesEntry.getHost() + ":" + syInterfacesEntry.getPort() + "]", new SyASEServer(syInterfacesEntry));
        } else {
            this._lookup.put(syInterfacesEntry.getName(), new SyASEServer(syInterfacesEntry));
        }
        for (int i = 1; i < list.size(); ++i) {
            this.addServiceToEntry(syInterfacesEntry.getName(), list.get(i));
        }
    }

    public synchronized SyASEServer deleteEntry(String string) throws NamingException {
        DirContext dirContext = this.initConnection();
        dirContext.unbind(this.getServerNameDN(string));
        if (this.containsASEServerName(string)) {
            return this._lookup.remove(string);
        }
        return null;
    }

    public synchronized void deleteServiceFromEntry(String string, Service service) throws NamingException {
        DirContext dirContext = this.initConnection();
        String[] stringArray = new String[]{"sybaseAddress"};
        Attributes attributes = dirContext.getAttributes(this.getServerNameDN(string), stringArray);
        if (attributes == null) {
            return;
        }
        ModificationItem[] modificationItemArray = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("sybaseAddress", this.getCannonicalForm(service)))};
        dirContext.modifyAttributes(this.getServerNameDN(string), modificationItemArray);
    }

    public synchronized List<Service> getServicesForEntry(String string) throws NamingException {
        ArrayList<Service> arrayList = new ArrayList<Service>();
        DirContext dirContext = this.initConnection();
        String[] stringArray = new String[]{"sybaseAddress"};
        Attributes attributes = dirContext.getAttributes(this.getServerNameDN(string), stringArray);
        if (attributes == null) {
            return null;
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            BasicAttribute basicAttribute = (BasicAttribute)namingEnumeration.nextElement();
            NamingEnumeration<?> namingEnumeration2 = basicAttribute.getAll();
            while (namingEnumeration2.hasMoreElements()) {
                String string2 = (String)namingEnumeration2.nextElement();
                String[] stringArray2 = this.retrieveASEProperties(string2);
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                if (stringArray2 != null) {
                    if (stringArray2[0] == null || stringArray2[1] == null || stringArray2[2] == null) continue;
                    string6 = stringArray2[0];
                    string3 = stringArray2[1];
                    string4 = stringArray2[2];
                    string5 = stringArray2[3];
                }
                if (string6.length() <= 0 || string3.length() <= 0 || string4.length() <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer(string6);
                stringBuffer.append("," + string3 + "," + string4);
                if (string5 != null && string5.length() > 0) {
                    stringBuffer.append("," + string5);
                }
                String string7 = stringBuffer.toString();
                arrayList.add(new Service(1, string7));
            }
        }
        return arrayList;
    }

    public synchronized void initASEEntries() throws NamingException {
        while (this._searchResults != null && this._searchResults.hasMore()) {
            Attribute attribute;
            SearchResult searchResult = this._searchResults.next();
            String string = "";
            Attributes attributes = searchResult.getAttributes();
            Attribute attribute2 = attributes.get("sybaseServername");
            if (attribute2 == null && (attribute2 = attributes.get("sybaseServername".toLowerCase())) == null) continue;
            if (attribute2.size() > 0) {
                string = (String)attribute2.get(0);
            }
            if ((attribute = attributes.get("sybaseAddress")) == null && (attribute = attributes.get("sybaseAddress".toLowerCase())) == null) continue;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                SyInterfacesEntry syInterfacesEntry;
                Object object;
                String[] stringArray = this.retrieveASEProperties((String)namingEnumeration.nextElement());
                if (stringArray != null) {
                    if (stringArray[0] == null || stringArray[1] == null || stringArray[2] == null) continue;
                    string5 = stringArray[0];
                    string2 = stringArray[1];
                    string3 = stringArray[2];
                    string4 = stringArray[3];
                }
                if (string5.length() <= 0 || string.length() <= 0 || string2.length() <= 0 || string3.length() <= 0) continue;
                if (this.containsASEServerName(string)) {
                    object = this._lookup.get(string);
                    syInterfacesEntry = ((SyASEServer)object).getInterfacesEntry();
                } else {
                    syInterfacesEntry = new SyInterfacesEntry(string);
                }
                object = new StringBuffer(string5);
                ((StringBuffer)object).append("," + string2 + "," + string3);
                if (string4 != null && string4.length() > 0) {
                    ((StringBuffer)object).append("," + string4);
                }
                String string6 = ((StringBuffer)object).toString();
                Service service = new Service(1, string6);
                syInterfacesEntry.addService(service);
                SyASEServer syASEServer = new SyASEServer(syInterfacesEntry);
                this._lookup.put(string, syASEServer);
            }
        }
    }

    private synchronized String[] retrieveASEProperties(String string) {
        String[] stringArray = new String[4];
        int n = string.indexOf("#");
        if (n <= 0) {
            return stringArray;
        }
        stringArray[0] = string.substring(0, n);
        int n2 = string.lastIndexOf(35);
        if (n2 > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2 + 1));
            int n3 = stringTokenizer.countTokens();
            if (n3 < 2) {
                return stringArray;
            }
            int n4 = 1;
            while (stringTokenizer.hasMoreTokens() && n4 < 4) {
                stringArray[n4++] = stringTokenizer.nextToken().trim();
            }
        }
        return stringArray;
    }

    public synchronized Enumeration<String> getKeys() {
        return this._lookup.keys();
    }

    public synchronized String[] getASEServerNames() {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = this._lookup.keys();
        while (objectArray.hasMoreElements()) {
            vector.addElement(objectArray.nextElement());
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public synchronized Enumeration<SyASEServer> getElements() {
        return this._lookup.elements();
    }

    public Vector<SyASEServer> getASEServers() {
        Vector<SyASEServer> vector = new Vector<SyASEServer>();
        Enumeration<SyASEServer> enumeration = this._lookup.elements();
        while (enumeration.hasMoreElements()) {
            SyASEServer syASEServer = enumeration.nextElement();
            vector.addElement(syASEServer);
        }
        return vector;
    }

    public synchronized boolean contains(SyASEServer syASEServer) {
        if (syASEServer != null) {
            return this._lookup.contains(syASEServer);
        }
        return false;
    }

    public synchronized boolean containsASEServerName(String string) {
        if (string != null) {
            return this._lookup.containsKey(string);
        }
        return false;
    }

    public SyASEServer getASEServer(String string) {
        return this._lookup.get(string);
    }

    public SyASEServer getASEServerIgnoreCase(String string) {
        Enumeration<String> enumeration = this._lookup.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
            return this.getASEServer(string2);
        }
        return null;
    }

    public String toString() {
        String string = this.getHost() + ":" + this.getPort() + ":" + this.getRootEntry();
        return string;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public Hashtable<String, SyASEServer> getLookup() {
        return this._lookup;
    }

    private synchronized String getCannonicalForm(Service service) {
        if (service == null) {
            return "";
        }
        String string = "TCP#1#" + service.getHost() + " " + service.getPort();
        if (service.isSSL()) {
            string = string + " ssl;";
        }
        return string;
    }

    private synchronized String getServerNameDN(String string) {
        return "sybaseServername=" + string + "," + this._initialContextName;
    }
}

