/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.asa.ASABaseGridBagPanel;
import com.sybase.asa.ASACheckBox;
import com.sybase.asa.ASALabel;
import com.sybase.asa.ASAMultiLineLabel;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.ldap.LDAPSetting;
import com.sybase.util.ds.ldap.LibctlDriver;
import com.sybase.util.ds.ldap.SyLDAPServer;
import com.sybase.util.ds.ui.BasePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class LDAPPage
extends BasePanel {
    public ASAMultiLineLabel infoMultiLineLabel;
    public JTable ldapList;
    public ASACheckBox ldapCheckBox;
    public ASALabel timeoutLabel;
    public ASALabel timeoutValueLabel;
    public ASALabel secondsLabel;
    public JSlider timeoutSlider;
    private LDAPSetting _initSetting;

    public LDAPPage() {
        this.createGUI();
    }

    private void createGUI() {
        this.infoMultiLineLabel = new ASAMultiLineLabel(_res.get("LDAP_INFO"));
        this.ldapList = new JTable(new MyTableModel());
        this.ldapList.getTableHeader().setReorderingAllowed(false);
        this.ldapList.setShowVerticalLines(false);
        this.ldapList.setShowHorizontalLines(false);
        this.ldapList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.ldapList);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        jScrollPane.getViewport().setBackground(this.ldapList.getBackground());
        this.ldapCheckBox = new ASACheckBox(_res.get("RETRIEVE_LDAP"));
        this.timeoutLabel = new ASALabel(_res.get("LDAP_TIMEOUT"));
        this.timeoutValueLabel = new ASALabel();
        this.secondsLabel = new ASALabel(_res.get("SECONDS"));
        this.timeoutSlider = new JSlider();
        this.timeoutSlider.setValue(100);
        this.timeoutSlider.setMinimum(30);
        this.timeoutSlider.setMaximum(300);
        this.timeoutSlider.setOrientation(0);
        this.timeoutSlider.setMajorTickSpacing(90);
        this.timeoutSlider.setMinorTickSpacing(30);
        this.timeoutSlider.setPaintTicks(true);
        this.timeoutSlider.setPaintLabels(true);
        int n = 0;
        this.add((Component)this.infoMultiLineLabel, 0, n, 1, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add(jScrollPane, 0, ++n, 1, 1, 1.0, 1.0, 17, 1, INSETS, 0, 0);
        this.add((Component)this.ldapCheckBox, 0, ++n, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        ASABaseGridBagPanel aSABaseGridBagPanel = new ASABaseGridBagPanel();
        aSABaseGridBagPanel.add((Component)this.timeoutLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.timeoutValueLabel, 1, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.secondsLabel, 2, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)aSABaseGridBagPanel, 0, ++n, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add(this.timeoutSlider, 0, ++n, 1, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
    }

    public void init(ActionListener actionListener, ChangeListener changeListener) {
        this.ldapCheckBox.removeActionListener(actionListener);
        this.timeoutSlider.removeChangeListener(changeListener);
        this._initSetting = LDAPSetting.getLDAPSetting();
        this.ldapCheckBox.setSelected(this._initSetting.includeLDAP);
        this.timeoutSlider.setValue(this._initSetting.timeout);
        this.timeoutValueLabel.setText(String.valueOf(this.timeoutSlider.getValue()));
        try {
            LibctlDriver libctlDriver = new LibctlDriver();
            Vector<SyLDAPServer> vector = libctlDriver.getLDAPServers();
            ((MyTableModel)this.ldapList.getModel()).setDataArray(vector);
            Utils.setInitialColumnWidths(this.ldapList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enableComponents();
        this.ldapCheckBox.addActionListener(actionListener);
        this.timeoutSlider.addChangeListener(changeListener);
    }

    public void releaseResources(ActionListener actionListener, ChangeListener changeListener) {
        this.ldapCheckBox.removeActionListener(actionListener);
        this.timeoutSlider.removeChangeListener(changeListener);
    }

    public void enableComponents() {
        boolean bl = this.ldapList.getRowCount() > 0;
        this.ldapCheckBox.setEnabled(bl);
        boolean bl2 = this.ldapCheckBox.isSelected();
        this.timeoutLabel.setEnabled(bl2 && bl);
        this.timeoutValueLabel.setEnabled(bl2 && bl);
        this.secondsLabel.setEnabled(bl2 && bl);
        this.timeoutSlider.setEnabled(bl2 && bl);
    }

    public void handleActionPerformed() {
        this.enableComponents();
    }

    public void handleStateChanged() {
        this.timeoutValueLabel.setText(String.valueOf(this.timeoutSlider.getValue()));
    }

    public boolean getEnableSave() {
        return this._initSetting.includeLDAP != this.ldapCheckBox.isSelected() || this._initSetting.timeout != this.timeoutSlider.getValue();
    }

    public boolean saveSettings() {
        boolean bl = this.ldapCheckBox.isSelected();
        int n = this.timeoutSlider.getValue();
        if (this.getEnableSave()) {
            LDAPSetting lDAPSetting = new LDAPSetting(bl, n);
            lDAPSetting.save();
            return true;
        }
        return false;
    }

    static class MyTableModel
    extends AbstractTableModel {
        private String[] _columnNames;
        private List<SyLDAPServer> _data = new ArrayList<SyLDAPServer>();

        MyTableModel() {
            this._columnNames = new String[]{BasePanel._res.get("getHostName"), BasePanel._res.get("getPortNumber"), BasePanel._res.get("ROOT_ENTRY")};
        }

        void setDataArray(List<SyLDAPServer> list) {
            this._data = list;
            this.fireTableChanged(new TableModelEvent(this));
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        public SyLDAPServer getRowObject(int n) {
            return this._data.get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SyLDAPServer syLDAPServer = this.getRowObject(n);
            if (n2 == 0) {
                return syLDAPServer.getHost();
            }
            if (n2 == 1) {
                return syLDAPServer.getPort();
            }
            String string = syLDAPServer.getHost() + ":";
            int n3 = syLDAPServer.getRootEntry().indexOf(string);
            String string2 = "";
            string2 = n3 != -1 ? syLDAPServer.getRootEntry().substring(9 + syLDAPServer.getHost().length() + syLDAPServer.getPort().length()) : syLDAPServer.getRootEntry().substring(8 + syLDAPServer.getHost().length());
            return string2;
        }
    }
}

