package com.sap.dbmtk.demo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Types;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.sap.dbmtk.demo.AddOrChangeAbstract.OpType;
import com.sap.dbmtk.demo.SqlStatement.Type;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.SelectAllFocusListener;
import com.sap.dbmtk.demo.utils.SwingUtils;

import net.miginfocom.swing.MigLayout;


public class DataPanelOrders 
extends DataPanelAbstract
{
	private static final long serialVersionUID = 1L;
	public static final String NAME = "Orders";

	public DataPanelOrders(DemoApp owner)
	{
		super(owner, NAME, true);
	}

//	@Override public boolean showAddButton()    { return false; }
//	@Override public boolean showChangeButton() { return false; }
//	@Override public boolean showRemoveButton() { return false; }

	//----------------------------------------------------------------
	// BEGIN: DB filter stuff
	//----------------------------------------------------------------
	private JLabel     _storeName_lbl;
	private JTextField _storeName_txt;

	@Override
	public JPanel createDbSearchPanel()
	{
		_storeName_lbl = new JLabel("Store Name");
		_storeName_txt = new JTextField();

		JPanel p = SwingUtils.createPanel("DB/Server Filter", true, new MigLayout());		
		
		p.add(_storeName_lbl, "");
		p.add(_storeName_txt, "growx, pushx");

		p.add(_dbRowCount_lbl, "");

		// On return in some fields, press "refresh" button
		ActionListener al = new ActionListener()
		{
			@Override
			public void actionPerformed(ActionEvent e)
			{
				_refresh_but.doClick();
			}
		};
		_storeName_txt.addActionListener(al);

		_storeName_txt.addFocusListener(new SelectAllFocusListener());

		return p;
	}

	@Override
	public int getDbRowCount()
	{
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_orders_count(?)}");
		stmnt.addParam( SqlStatementParam.createOutParam("rcount", Types.INTEGER) );
		
		stmnt.execute(getConnectionProvider(), getOwner(), "Get rowcount");

		Integer rcount = (Integer) stmnt.getParameterValue("rcount");
		return rcount == null ? -1 : rcount;
	}

	@Override
	public void saveProps()
	{
		Configuration conf = Configuration.getInstance(Configuration.USER_TEMP);
		if (conf != null)
		{
			conf.setProperty(NAME+".field.storeName", _storeName_txt.getText());
		}
	}
	@Override
	public void loadProps()
	{
		Configuration conf = Configuration.getCombinedConfiguration();
		_storeName_txt.setText(conf.getProperty(NAME+".field.storeName", "books"));
	}
	//----------------------------------------------------------------
	// END: DB filter stuff
	//----------------------------------------------------------------

	/**
	 * Is called when the "New" button is pressed
	 */
	@Override
	public void actionAdd()
	{
		AddOrChangeAbstract dialog = new AddOrChangeOrder(_owner.getWindow(), getConnectionProvider(), OpType.INSERT);
		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}

	/**
	 * Is called when the "Change" button is pressed
	 */
	@Override
	public void actionChange()
	{
		AddOrChangeAbstract dialog = new AddOrChangeOrder(_owner.getWindow(), getConnectionProvider(), OpType.UPDATE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
			refreshTableData();
		dialog.dispose();
	}
	
	/**
	 * Is called when the "Remove" button is pressed
	 */
	@Override
	public void actionRemove()
	{
		AddOrChangeAbstract dialog = new AddOrChangeOrder(_owner.getWindow(), getConnectionProvider(), OpType.DELETE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}
	

	@Override
	public SqlStatement getTableDataSqlStatement()
	{
//		return new SqlStatement(Type.LANGUAGE, 
//				"select o.order_id, o.store_name, o.order_date \n"
//				+ "from orders o \n");

//		return new SqlStatement(Type.LANGUAGE, 
//			"select o.order_id, o.store_name, o.order_date, od.quantity, od.discount, t.title, t.isbn \n"
//			+ "from orders o, orderdetails od, titles t \n"
//			+ "where od.order_id = o.order_id \n"
//			+ "  and od.title_id = t.title_id \n");

		String storeName = null;
		if (isDbSearchPanelVisible())
		{
			storeName = _storeName_txt.getText();
		}

//		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_orders(?)}");
//		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );
		
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_orders(?, ?)}");
		stmnt.addParam( SqlStatementParam.createInParam("store_name", Types.VARCHAR, storeName) );
		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );

		return stmnt;
	}

}
