package com.sap.dbmtk.demo;

import java.awt.Dimension;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

import com.sap.dbmtk.demo.SqlStatement.Type;
import com.sap.dbmtk.demo.ui.GTable;
import com.sap.dbmtk.demo.ui.ResultSetTableModel;
import com.sap.dbmtk.demo.utils.StringUtil;


public class DataPanelAuthorTitles 
extends DataPanelAbstract
{
	private static final long serialVersionUID = 1L;
	public static final String NAME = "Titles by Authors(s)";
	
	private String[] _au_ids  = {};

	public DataPanelAuthorTitles(DemoApp owner)
	{
		super(owner, NAME, true);
	}

	@Override public boolean showAddButton()            { return false; }
	@Override public boolean showChangeButton()         { return false; }
	@Override public boolean showRemoveButton()         { return false; }
	@Override public boolean showTableToolTipCheckbox() { return true; }

	@Override
	public void onParentTableSelection(DataPanelAbstract parent)
	{
		// Authors
		if (DataPanelAuthors.NAME.equals(parent.getName()))
		{
			GTable tab = parent.getTable();
			
			int[] selectedRows = tab.getSelectedRows();
			
			// Allocate some strings for AU_ID
			_au_ids = new String[selectedRows.length];
			
			for (int r=0; r<selectedRows.length; r++)
			{
				String str = tab.getValueAsString(selectedRows[r], "au_id", false);
				if (str != null)
					_au_ids[r] = str;
			}
		}
		
		// Refresh the local table, which will call getTableDataSqlStatement() to get a SqlStatement to execute
		refreshTableData();
	}

	@Override
	public SqlStatement getTableDataSqlStatement()
	{
		String au_id_values = null;
		if (_au_ids.length > 0)
			au_id_values = StringUtil.toCommaStr(_au_ids, ",");
		
		if (StringUtil.isNullOrBlank(au_id_values))
			au_id_values = "-1";

//		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_titles(?, ?, ?)}");
//
//		stmnt.addParam( SqlStatementParam.createInParam("au_id_list",  Types.VARCHAR, au_id_values) );
//		stmnt.addParam( SqlStatementParam.createInParam("pub_id_list", Types.VARCHAR, null) );
//		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );

		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call ${PKG:titles_pkg}get_titles(?, ?, ?, ?, ?)}");

		stmnt.addParam( SqlStatementParam.createInParam("au_id_list",  Types.VARCHAR, au_id_values) );
		stmnt.addParam( SqlStatementParam.createInParam("pub_id_list", Types.VARCHAR, null) );
		stmnt.addParam( SqlStatementParam.createInParam("title_name",  Types.VARCHAR, null) );
		stmnt.addParam( SqlStatementParam.createInParam("has_picture", Types.INTEGER, null) );
		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );

		return stmnt;
	}

	@Override
	public List<String> getHiddenColumns()
	{
		List<String> hiddenCols = new ArrayList<String>();

//		hiddenCols.add("publisher_name");
		hiddenCols.add("author_name");

		hiddenCols.add("title_id");
		hiddenCols.add("au_id");
		hiddenCols.add("pub_id");
		
		return hiddenCols;
	}

	@Override
	public String getTableToolTipText(ResultSetTableModel rstm, int mrow, int mcol)
	{
		if ( ! isTableToolTipEnabled() )
			return null;
		
		return getTableToolTipTextWithPicture(rstm, mrow, mcol, "{call ${PKG:titles_pkg}get_title_picture(?,?)}", "title_id", AddOrChangeAuthor.NO_PICTURE, new Dimension(300, 400));
	}
}
