##===========================================================
## STOP ALL DbxTune and DbxCentral processes
##===========================================================

##----------------------------------------------
## Source environment
##----------------------------------------------
#$envFile = "$env:USERPROFILE\.dbxtune\DBXTUNE.env.bat"
$envFile = "$PWD\DBXTUNE.env.bat"
if (Test-Path $envFile) {
	## Run the batch file and capture the environment variables
	$cmdOutput = cmd /c "($envFile) && set"

	## Apply the changes to PowerShell's environment
	$cmdOutput | ForEach-Object {
		if ($_ -match '^(.*?)=(.*)$') {
			$envName  = $matches[1]
			$envValue = $matches[2]

			## Only set SOME environment variables for THIS Process
			if ($envName -match "^DBXTUNE" -or $envName -eq "SYBASE") {
				Write-Host " -------------->>>>>>>> setting env var: $envName = |$envValue|"
				[System.Environment]::SetEnvironmentVariable($envName, $envValue, "Process")
				Set-Variable -Name $envName -Value $envValue -Scope Global
			}
		}
	}
}

##----------------------------------------------
## Override some settings/environments
##----------------------------------------------
if (-not [string]::IsNullOrEmpty($env:DBXTUNE_CENTRAL_BASE)) {
	$dbxCentralBase = $env:DBXTUNE_CENTRAL_BASE
} else {
	$dbxCentralBase = "$env:USERPROFILE\.dbxtune\dbxc"
}



##-------------------------------------
## Check for ANY DbxTune and DbxCentral processes
##-------------------------------------
#$pidListDbxTune = @(Get-CimInstance -Class Win32_Process -Filter "Name LIKE 'java%'" | Where-Object { $_.CommandLine -match 'com\.dbxtune\..*Tune '                 -and $_.CommandLine -match '^"' } ) ## There are normally 2 processes one starts with 'java' the otherone starts with "C:\....\java.exe" ...'
#$pidListCentral = @(Get-CimInstance -Class Win32_Process -Filter "Name LIKE 'java%'" | Where-Object { $_.CommandLine -match 'com\.dbxtune\.central\.DbxTuneCentral' -and $_.CommandLine -match '^"' } ) ## There are normally 2 processes one starts with 'java' the otherone starts with "C:\....\java.exe" ...'
$pidListDbxTune    = @(Get-CimInstance -Class Win32_Process -Filter "Name LIKE 'java%'" | Where-Object { $_.CommandLine -match 'com\.gorans\.SleepServer'             -and $_.CommandLine -match '^"' } ) ## There are normally 2 processes one starts with 'java' the otherone starts with "C:\....\java.exe" ...'
$pidListCentral    = @(Get-CimInstance -Class Win32_Process -Filter "Name LIKE 'java%'" | Where-Object { $_.CommandLine -match 'com\.gorans\.central\.DbxTuneCentral' -and $_.CommandLine -match '^"' } ) ## There are normally 2 processes one starts with 'java' the otherone starts with "C:\....\java.exe" ...'
$svcAllDbxTune     = @(Get-Service -Include 'SleepServer*')
$svcRunningDbxTune = @(Get-Service -Include 'SleepServer*' | Where-Object {$_.Status -eq 'Running'})
#$serviceList    = @(Get-Service -Include 'Dbx*')

##-------------------------------------
## Check if we are in elevated mode
##-------------------------------------
$isElevated = (New-Object Security.Principal.WindowsPrincipal([Security.Principal.WindowsIdentity]::GetCurrent())).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)
if ($isElevated) {
	Write-Host ""
	Write-Host " * INFO: Running script in ELEVATED mode..."
} else {
	Write-Host ""
	Write-Host " * INFO: Running in NOT elevated mode... So Dbx Processes started by 'someone else' will NOT be visible..."
	Write-Host "         For examples Processes started as a Service wont be visible, just the service name"
}

Write-Host ""
if ($pidListDbxTune.Count -eq 0) {
	Write-Host " * No DbxTune COLLECTOR processes is running..."
	Write-Host ""
}

if ($pidListCentral.Count -eq 0) {
	Write-Host " * No DbxTune CENTRAL Server processes is running..."
	Write-Host ""
}

## If no pids, just exit
if ($pidListDbxTune.Count -eq 0 -and $pidListCentral.Count -eq 0) {
	exit 0
}


##-------------------------------------
## Stop all the services (if we have any)
##-------------------------------------
if ($serviceList.Count -gt 0) 
{
	$stopCount = 0

	foreach ($service in $serviceList) 
	{
		if ($service.Status -eq "Running") {
			$stopCount++
			Write-Host " >> Stopping service: $($service.Name)"
			Stop-Service -Name $service.Name
		}
	}

	if ($stopCount -gt 0) 
	{
		Write-Host " * Sleeping for 5 seconds, then refreshing the PID Lists, if any processes are still running, they will be killed..."
		Start-Sleep -Seconds 5
		Write-Host ""

		## Refresh the PID Lists (this will probably not work, since we cant see the CommanLine parameters...)
		$pidListDbxTune = @(Get-CimInstance -Class Win32_Process -Filter "Name LIKE 'java%'" | Where-Object { $_.CommandLine -match 'com\.dbxtune\..*Tune'                  -and $_.CommandLine -match '^java' } )
		$pidListCentral = @(Get-CimInstance -Class Win32_Process -Filter "Name LIKE 'java%'" | Where-Object { $_.CommandLine -match 'com\.dbxtune\.central\.DbxTuneCentral' -and $_.CommandLine -match '^java' } )
	}

	if ($pidListDbxTune.Count -eq 0 -and $pidListCentral.Count -eq 0) 
	{
		Write-Host " * No more DBX Processes was found, exiting."
		exit 0
	}
}

##-------------------------------------
## Kill DbxTune and DbxCentral processes
##-------------------------------------
#>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> TODO: AT START -- We should check if it's a SERVICE, and STOP the SERVICE INSTEAD (so it wont be restarted)
foreach ($dbxPid in $pidListDbxTune) 
{
	Write-Host "======================================================"
	$dbxPid | Format-Table -Wrap ProcessId, @{Name="StartTime";Expression={$_.CreationDate.ToString("yyyy-MM-dd HH:mm")}}, CommandLine
	Write-Host "------------------------------------------------------"
	Write-Host " >> Killing pid: $($dbxPid.ProcessId)"
	Stop-Process -Id $dbxPid.ProcessId
}

foreach ($dbxPid in $pidListCental) 
{
	Write-Host "======================================================"
	$dbxPid | Format-Table -Wrap ProcessId, @{Name="StartTime";Expression={$_.CreationDate.ToString("yyyy-MM-dd HH:mm")}}, CommandLine
	Write-Host "------------------------------------------------------"
	Write-Host " >> Killing pid: $($dbxPid.ProcessId)"
	Stop-Process -Id $dbxPid.ProcessId
}

Write-Host " * Sleeping for 5 seconds, then listing processes using: list_ALL.ps1"
Start-Sleep -Seconds 5
Write-Host ""


##----------------------------------------------
## Check for list_ALL.ps1
##----------------------------------------------
$listAll=".\list_ALL.ps1"
if (-not (Test-Path $listAll)) { $listAll = "$dbxCentralBase\bin\list_ALL.ps1" }
if (-not (Test-Path $listAll)) { $listAll = "$env:DBXTUNE_HOME\bin\dbxc_list_ALL.ps1" }
if (-not (Test-Path $listAll)) { $listAll = "" }


##----------------------------------------------
## Check that they are stopped
##----------------------------------------------
if (-not $listAll)
{
	Write-Host " **** Sorry I couldn't find the 'list_ALL.ps1' command."
	Write-Host " **** So I can NOT check for stopped servers."
	Write-Host ""
}
else
{
	while ($true) 
	{
		& $listAll --onlyRunning
		if ($LASTEXITCODE -eq 0)
		{
			Write-Host " All servers has now been stopped"
			Write-Host ""
			break
		}
		else 
		{
			Write-Host " **** There are still some servers up and running..."
			Write-Host " **** Sleeping 3 seconds and then testing again"
			Write-Host ""
			Start-Sleep -Seconds 3
		}
	}
}
