/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.Cursor;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.Escape;
import com.sybase.jdbc3.jdbc.EscapeTokenizer;
import com.sybase.jdbc3.jdbc.ParamManager;
import com.sybase.jdbc3.jdbc.Protocol;
import com.sybase.jdbc3.jdbc.ProtocolContext;
import com.sybase.jdbc3.jdbc.ProtocolResultSet;
import com.sybase.jdbc3.jdbc.ResultGetter;
import com.sybase.jdbc3.jdbc.SybBatchUpdateException;
import com.sybase.jdbc3.jdbc.SybConnection;
import com.sybase.jdbc3.jdbc.SybCursorResultSet;
import com.sybase.jdbc3.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc3.jdbc.SybPreparedStatement;
import com.sybase.jdbc3.jdbc.SybResultSet;
import com.sybase.jdbc3.jdbc.SybScrollCursorResultSet;
import com.sybase.jdbc3.tds.TdsProtocolContext;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SybStatement
implements com.sybase.jdbcx.SybStatement {
    private SQLWarning if = null;
    protected int _rsType = 1003;
    protected int _rsConcur = -9;
    private int new;
    protected int _rsFetchDir = 1000;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _statementManager;
    private int a = 0;
    protected boolean _doEscapes = true;
    protected String _rpcName = null;
    protected boolean _sendAsRpc = false;
    protected boolean _hasReturn = false;
    protected boolean _allowsOutputParms = false;
    protected boolean _returnHasBeenRegistered = false;
    protected boolean _closing = false;
    protected SybResultSet _currentRS = null;
    protected ResultGetter _resultGetter;
    protected Cursor _cursor = null;
    protected int _state = 1;
    private int for = -1;
    private boolean do = false;
    private int int;
    protected static final int NORESULTS = 1;
    protected static final int ONERESULT = 2;
    protected static final int MANYRESULTS = 3;
    protected int _currentQT = -1;
    protected static final String CALL_DELIMS = "(), \t\n\r";
    protected static final int OTHER = 0;
    protected static final int CALL = 1;
    protected static final int SELECT = 2;
    protected static final int DELETE = 4;
    protected static final int UPDATE = 8;
    protected static final int INSERT = 16;
    protected static final int VALID = 4096;
    protected int _type;
    protected int _setStart;
    protected int _setEnd;
    protected String _table;
    protected Vector _batchCmds = null;
    protected int _batchCmdsCount = 0;
    protected boolean _doneinproc = false;
    protected SybDatabaseMetaData _dbmda = null;
    protected Vector _rowFmtIdxList = null;
    protected Vector _paramNameList = null;
    protected boolean _retGeneratedKeys = false;
    protected SybResultSet _genKeysRS = null;
    protected Vector _currentOpenRS = null;

    protected SybStatement(ProtocolContext protocolContext) {
        this._context = protocolContext;
        this._context._batch = false;
        this._protocol = protocolContext._protocol;
        this._statementManager = new CacheManager(protocolContext._is);
        this._statementManager.setSetable(false);
        this._resultGetter = new ResultGetter(this);
        this._resultGetter.setManager(this._statementManager);
        this._statementManager.register(this._resultGetter);
        this.new = this._context._conn._rsHoldability;
        this._currentOpenRS = new Vector();
        this.setDoEscapes();
    }

    protected void setDoEscapes() {
        try {
            this._doEscapes = this._context._conn._props.getBoolean(46);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected int nextResult() throws SQLException {
        return this.nextResult(null);
    }

    protected int nextResult(ParamManager paramManager) throws SQLException {
        if (!this._retGeneratedKeys) {
            this.a();
        }
        while (true) {
            try {
                this.int = this._resultGetter.nextResult();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
                continue;
            }
            break;
        }
        switch (this.int) {
            case 1: {
                ProtocolResultSet protocolResultSet = this._protocol.resultSet(this._context);
                if (protocolResultSet != null) {
                    protocolResultSet.setType(this._retGeneratedKeys ? 1004 : this._rsType);
                }
                SybResultSet sybResultSet = new SybResultSet(this, protocolResultSet);
                try {
                    sybResultSet.setManager(this._statementManager);
                    this._statementManager.register(sybResultSet);
                    this._statementManager.open(sybResultSet);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this._retGeneratedKeys) {
                    this._genKeysRS = sybResultSet;
                    break;
                }
                this._currentRS = sybResultSet;
                break;
            }
            case 5: {
                this.setRowCount(this._protocol.count(this._context));
                break;
            }
            case 0: {
                this.setRowCount(-1);
                this._state = 1;
                break;
            }
            case 3: {
                if (!(this instanceof CallableStatement) && this.for == -1) {
                    this.setRowCount(0);
                }
                this.handleParam(paramManager);
                break;
            }
        }
        this.do = true;
        return this.int;
    }

    protected String processEscapes(String string) throws SQLException {
        if (string.length() == 0) {
            return string;
        }
        EscapeTokenizer escapeTokenizer = new EscapeTokenizer(this, string);
        StringBuffer stringBuffer = new StringBuffer();
        Object object = escapeTokenizer.next();
        while (object != null) {
            if (object instanceof String) {
                stringBuffer.append((String)object);
            } else {
                Escape escape = (Escape)object;
                switch (escape.getType()) {
                    case 4: {
                        String string2 = escape.getBody();
                        if (this._context._conn._props.getBoolean(52)) {
                            stringBuffer.append(string2);
                            break;
                        }
                        stringBuffer.append("'1970-1-1 ");
                        stringBuffer.append(string2.substring(1, string2.length()));
                        break;
                    }
                    case 3: {
                        String string3 = escape.getBody();
                        stringBuffer.append(string3.substring(0, string3.length() - 1));
                        stringBuffer.append(" 00:00:00'");
                        break;
                    }
                    case 5: {
                        String string4 = escape.getBody();
                        int n2 = string4.indexOf(".");
                        if (n2 > 0 && string4.length() - n2 > 4) {
                            stringBuffer.append(string4.substring(0, n2 + 4) + "'");
                            break;
                        }
                        stringBuffer.append(string4);
                        break;
                    }
                    case 2: {
                        this._hasReturn = true;
                        stringBuffer = new StringBuffer(this.handleCallBody(escape.getBody()));
                        break;
                    }
                    case 1: {
                        this._hasReturn = false;
                        stringBuffer = new StringBuffer(this.handleCallBody(escape.getBody()));
                        break;
                    }
                    case 7: {
                        stringBuffer.append(" ESCAPE " + escape.getBody());
                        break;
                    }
                    case 6: {
                        String string5 = this._protocol.getStringOption(this._context, 10, escape.functionName());
                        if (string5 == null) {
                            ErrorMessage.raiseError("JZ0SI", escape.functionName());
                        }
                        stringBuffer.append(escape.doMap(string5));
                        break;
                    }
                    case 8: {
                        if (((SybDatabaseMetaData)this._context._conn.getMetaData()).supportsOuterJoinEscapeSyntax()) {
                            stringBuffer.append(escape.getBody());
                            break;
                        }
                        ErrorMessage.raiseError("JZ0SK");
                        break;
                    }
                }
            }
            object = escapeTokenizer.next();
        }
        return stringBuffer.toString();
    }

    protected String doEscapeProcessing(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            ErrorMessage.raiseError("JZ0S4");
        }
        if (this._doEscapes) {
            return this.processEscapes(string);
        }
        return string;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        string = this.doEscapeProcessing(string);
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
        tdsProtocolContext.resetRowFmt();
        return this.executeQuery(string, null);
    }

    public int executeUpdate(String string) throws SQLException {
        string = this.doEscapeProcessing(string);
        return this.executeUpdate(string, (ParamManager)null);
    }

    public int executeUpdate(String string, int n2) throws SQLException {
        string = this.doEscapeProcessing(string);
        string = this.processGenKeysRequest(n2, string);
        int n3 = this.executeUpdate(string, (ParamManager)null);
        this._retGeneratedKeys = false;
        return n3;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (nArray == null || nArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnIndexes");
        }
        return this.executeUpdate(string, 1);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (stringArray == null || stringArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnNames");
        }
        return this.executeUpdate(string, 1);
    }

    public void close() throws SQLException {
        this.close(true);
    }

    protected void close(boolean bl) throws SQLException {
        if (this._state == 4) {
            return;
        }
        this._context._conn.checkConnection();
        this._context._conn._stmtList.removeElement(this);
        this._closing = true;
        this.a(true, false);
        try {
            this.deallocateDynamic();
            this._statementManager.clear();
            if (this._cursor != null) {
                this._cursor.close(true);
                this._cursor = null;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        this._statementManager = null;
        if (bl) {
            this._context.drop();
        }
        this._state = 4;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkDead();
        return this._context._maxFieldSize;
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        if (n2 < 0) {
            ErrorMessage.raiseError("JZ0SN");
        }
        this.checkStatement(true);
        this._context._maxFieldSize = n2;
    }

    public int getMaxRows() throws SQLException {
        this.checkDead();
        return this._protocol.getIntOption(this._context, 4);
    }

    public void setMaxRows(int n2) throws SQLException {
        if (n2 < 0) {
            ErrorMessage.raiseError("JZ0SR");
        }
        this.checkStatement(true);
        try {
            this._protocol.setOption(this._context, 4, n2);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkDead();
        this._doEscapes = bl;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkDead();
        return this._context._timeout / 1000;
    }

    public void setQueryTimeout(int n2) throws SQLException {
        if (n2 < 0) {
            ErrorMessage.raiseError("JZ0SS");
        }
        this.checkDead();
        this._context._timeout = n2 * 1000;
    }

    public void cancel() throws SQLException {
        this.checkDead();
        this.a(true, false);
    }

    private void a(boolean bl, boolean bl2) throws SQLException {
        if (!bl2 && this._context._conn.getHAState() != 8) {
            this._protocol.cancel(this._context, false);
        }
        if (this._cursor != null) {
            this._cursor.close(bl);
            if (bl) {
                this._cursor = null;
            }
        }
        if (this._currentRS != null) {
            if (this._context._conn.getHAState() == 8) {
                this._currentRS.close(false);
            } else {
                this._currentRS.close(true);
            }
            this._currentRS = null;
        }
        if (this._genKeysRS != null) {
            this._genKeysRS.close();
            this._genKeysRS = null;
        }
        if (!this._currentOpenRS.isEmpty()) {
            Enumeration enumeration = this._currentOpenRS.elements();
            while (enumeration.hasMoreElements()) {
                ((SybResultSet)enumeration.nextElement()).close();
            }
            this._currentOpenRS.clear();
        }
        try {
            this._statementManager.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.a();
        this._state = 1;
        this._currentQT = -1;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this._state == 4) {
            ErrorMessage.raiseError("JZ0S2");
        }
        return this.if;
    }

    public void clearWarnings() throws SQLException {
        this.checkDead();
        this.if = null;
    }

    public void setCursorName(String string) throws SQLException {
        this.checkDead();
        try {
            this.checkCursor(true);
            this._cursor.setName(string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void setFetchSize(int n2) throws SQLException {
        if (n2 == 0) {
            return;
        }
        int n3 = this.getMaxRows();
        if (n2 < 0 || n3 > 0 && n2 > n3) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this.checkCursor(false);
        this._cursor.setFetchSize(n2);
    }

    public int getFetchSize() throws SQLException {
        if (this._cursor != null) {
            return this._cursor.getFetchSize();
        }
        return 0;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkDead();
        if (this._genKeysRS == null || this._genKeysRS.next() && this._genKeysRS.getBigDecimal(1).longValue() == 0L) {
            ErrorMessage.raiseError("JZ0NK");
        }
        if (!this._genKeysRS.isBeforeFirst()) {
            this._genKeysRS.beforeFirst();
        }
        return this._genKeysRS;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this._currentRS != null) {
            return this._currentRS.getConcurrency();
        }
        if (this._rsConcur == -9) {
            return 1007;
        }
        return this._rsConcur;
    }

    public int getResultSetHoldability() throws SQLException {
        return this.new;
    }

    public Connection getConnection() throws SQLException {
        return this._context._conn;
    }

    public boolean execute(String string) throws SQLException {
        string = this.doEscapeProcessing(string);
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
        tdsProtocolContext.resetRowFmt();
        return this.execute(string, (ParamManager)null);
    }

    public boolean execute(String string, int n2) throws SQLException {
        string = this.doEscapeProcessing(string);
        string = this.processGenKeysRequest(n2, string);
        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
        tdsProtocolContext.resetRowFmt();
        boolean bl = this.execute(string, (ParamManager)null);
        if (this._retGeneratedKeys) {
            this.nextResult();
        }
        this._retGeneratedKeys = false;
        return bl;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        if (nArray == null || nArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnIndexes");
        }
        return this.execute(string, 1);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (stringArray == null || stringArray.length != 1) {
            ErrorMessage.raiseError("JZ0GK", "columnNames");
        }
        return this.execute(string, 1);
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkDead();
        if (this.int != 5) {
            this.setRowCount(-1);
        }
        if (this._context.getState() == 5) {
            ErrorMessage.raiseError("JZ0PA");
        }
        return this._currentRS;
    }

    public int getUpdateCount() throws SQLException {
        this.checkDead();
        if (this._context.getState() == 5) {
            ErrorMessage.raiseError("JZ0PA");
        }
        if (!this.do) {
            ErrorMessage.raiseError("JZ0CU");
        }
        int n2 = this.for;
        this.a();
        return n2;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int n2) throws SQLException {
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            ErrorMessage.raiseError("JZ0FP", "current");
        }
        this.checkDead();
        if (this._state == 1) {
            this.do = true;
            return false;
        }
        if (this.int == 1 && this._currentRS != null && this instanceof CallableStatement) {
            this._currentRS._currentStatus = n2;
        }
        int n3 = this.nextResult();
        switch (n3) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setFetchDirection(int n2) throws SQLException {
        switch (n2) {
            case 1000: 
            case 1001: 
            case 1002: {
                this._rsFetchDir = n2;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0I3", String.valueOf(n2), "setFetchDirection(int)");
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        return this._rsFetchDir;
    }

    public int getResultSetType() throws SQLException {
        if (this._currentRS != null) {
            return this._currentRS.getType();
        }
        return this._rsType;
    }

    public void addBatch(String string) throws SQLException {
        this.checkBatch();
        if (this._batchCmds == null) {
            this._batchCmds = new Vector();
            this._batchCmdsCount = 0;
        }
        this._batchCmds.add(string);
        ++this._batchCmdsCount;
    }

    public void clearBatch() throws SQLException {
        this.checkBatch();
        this._batchCmds = null;
        this._batchCmdsCount = 0;
    }

    public int[] executeBatch() throws SQLException {
        return this.executeBatch(null, true);
    }

    protected void setResultSetParams(int n2, int n3) throws SQLException {
        boolean bl = false;
        switch (n2) {
            case 1003: 
            case 1004: {
                break;
            }
            case 1005: {
                bl = true;
                n2 = 1004;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SP", String.valueOf(n2));
            }
        }
        switch (n3) {
            case 1007: {
                break;
            }
            case 1008: {
                if (n2 != 1004) break;
                n3 = 1007;
                bl = true;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SO", String.valueOf(n3));
            }
        }
        this._rsType = n2;
        this._rsConcur = n3;
        if (bl) {
            this._context._conn.chainWarnings(ErrorMessage.createWarning("010RC"));
        }
    }

    protected void setResultSetHoldability(int n2) throws SQLException {
        if (n2 != 1 && n2 != 2) {
            ErrorMessage.raiseError("JZ0SW", String.valueOf(n2));
        }
        if (n2 == 2) {
            this._context._conn._stmtList.addElement(this);
        }
        this.new = n2;
    }

    protected int[] executeBatch(ParamManager paramManager) throws SQLException {
        return this.executeBatch(paramManager, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int[] executeBatch(ParamManager paramManager, boolean bl) throws SQLException {
        int[] nArray;
        block14: {
            if (this._batchCmds == null) {
                return new int[0];
            }
            int[] nArray2 = new int[this._batchCmds.size()];
            String string = "";
            try {
                block15: {
                    try {
                        if (this.checkBatch()) {
                            if (paramManager != null) {
                                nArray = this.sendBatch((String)this._batchCmds.elementAt(0), paramManager);
                                Object var8_8 = null;
                                if (!bl) return nArray;
                                break block14;
                            }
                            for (int i2 = 0; i2 < this._batchCmds.size(); ++i2) {
                                try {
                                    int[] nArray3 = this.sendBatch((String)this._batchCmds.elementAt(i2), paramManager);
                                    nArray2[i2] = nArray3[0];
                                    continue;
                                }
                                catch (SQLException sQLException) {
                                    this.handleBatchException(sQLException, nArray2, i2);
                                }
                            }
                            break block15;
                        }
                        nArray2 = this.sendBatch(this.batchToString(), paramManager);
                    }
                    catch (SQLException sQLException) {
                        if (!this.checkBatch()) {
                            this.clearBatch();
                        }
                        this._context._batch = false;
                        throw sQLException;
                    }
                }
                Object var8_9 = null;
                if (!bl) return nArray2;
                if (!this.checkBatch()) {
                    this.clearBatch();
                }
                this._context._batch = false;
                return nArray2;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (!bl) throw throwable;
                if (!this.checkBatch()) {
                    this.clearBatch();
                }
                this._context._batch = false;
                throw throwable;
            }
        }
        if (!this.checkBatch()) {
            this.clearBatch();
        }
        this._context._batch = false;
        return nArray;
    }

    protected int[] sendBatch(String string, ParamManager paramManager) throws SQLException {
        String string2 = this.doEscapeProcessing(string);
        this._context._batch = true;
        this.checkStatement(true);
        this.sendQuery(string2, paramManager);
        return this.batchLoop(paramManager);
    }

    protected int[] batchLoop(ParamManager paramManager) throws SQLException {
        int n2;
        int n3 = 0;
        this._currentQT = 3;
        int[] nArray = new int[this._batchCmdsCount];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        n2 = 0;
        int n4 = 5;
        try {
            while (true) {
                if (n4 != 3) {
                    n4 = 5;
                    n3 = 0;
                }
                block11: while (true) {
                    int n5 = this.nextResult(paramManager);
                    switch (n5) {
                        case 5: {
                            if (this._doneinproc) {
                                TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
                                if (tdsProtocolContext.isProcDone()) {
                                    n3 += this.for;
                                    n4 = 5;
                                    break block11;
                                }
                                n3 += this.for;
                                continue block11;
                            }
                            n3 += this.for;
                            break block11;
                        }
                        case 0: {
                            n4 = 0;
                            break block11;
                        }
                        case 3: {
                            if (!this._doneinproc) continue block11;
                            n4 = 3;
                            break block11;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0P1");
                            continue block11;
                        }
                    }
                    break;
                }
                if (n4 == 3) continue;
                if (n2 < nArray.length) {
                    nArray[n2++] = n3;
                }
                if (n4 == 0) break;
            }
        }
        catch (SQLException sQLException) {
            if ("JZ0F2".equals(sQLException.getSQLState())) {
                this.a(false, true);
                throw sQLException;
            }
            try {
                this.a(false, false);
            }
            catch (SQLException sQLException2) {
                if (sQLException2.getSQLState().equals("JZ0F2")) {
                    sQLException2.setNextException(sQLException);
                }
                throw sQLException2;
            }
            int[] nArray2 = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray2[i2] = nArray[i2];
            }
            ErrorMessage.raiseBatchUpdateException(sQLException, nArray2);
        }
        return nArray;
    }

    protected String batchToString() {
        int n2 = this._batchCmds.size() * (((String)this._batchCmds.elementAt(this._batchCmds.size() / 2)).length() + 1);
        StringWriter stringWriter = new StringWriter(n2);
        stringWriter.write((String)this._batchCmds.elementAt(0));
        for (int i2 = 1; i2 < this._batchCmds.size(); ++i2) {
            stringWriter.write(" ");
            stringWriter.write((String)this._batchCmds.elementAt(i2));
        }
        String string = stringWriter.toString();
        return string;
    }

    protected boolean sendQuery(String string, ParamManager paramManager) throws SQLException {
        if (this._type == 4100 || this._type == 4104) {
            string.trim();
            int n2 = string.lastIndexOf(32);
            String string2 = string.substring(n2 + 1);
            SybCursorResultSet sybCursorResultSet = (SybCursorResultSet)this._context._conn.getCursorResultSet(string2);
            if (sybCursorResultSet != null && !sybCursorResultSet._cursor.isLanguageCursor()) {
                sybCursorResultSet._cursor.setTable(this._table);
                if (this._type == 4100) {
                    sybCursorResultSet.deleteRow();
                } else {
                    sybCursorResultSet._cursor.update(sybCursorResultSet._prs, paramManager, string.substring(0, this._setEnd));
                }
                return true;
            }
            if (paramManager != null) {
                paramManager.literalizeAll();
            }
        }
        try {
            this._protocol.language(this._context, string, paramManager);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        this._state = 2;
        return false;
    }

    protected ResultSet executeQuery(String string, ParamManager paramManager) throws SQLException {
        this.checkStatement(true);
        if (this._rsConcur == -9) {
            this._rsConcur = 1007;
        }
        if (this._cursor == null && this._rsConcur == 1008) {
            this.checkCursor(false);
        }
        this.checkForImplicitCursor();
        if (this._cursor != null) {
            this._cursor.setTable(this._table);
            ProtocolResultSet protocolResultSet = null;
            protocolResultSet = this instanceof SybPreparedStatement && ((SybPreparedStatement)this)._dynStmtName != null ? this._cursor.open(((SybPreparedStatement)this)._dynStmtName, paramManager, false) : this._cursor.open(string, paramManager, false);
            if (protocolResultSet == null) {
                ErrorMessage.raiseError("JZ0R2");
            }
            protocolResultSet.setType(this._rsType);
            this._currentRS = this._cursor.scrollingAtServer() ? new SybScrollCursorResultSet(this, protocolResultSet) : new SybCursorResultSet(this, protocolResultSet);
            this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
            this._state = 2;
        } else {
            this.sendQuery(string, paramManager);
            this.queryLoop();
        }
        return this._currentRS;
    }

    protected ResultSet queryLoop() throws SQLException {
        this._currentQT = 2;
        boolean bl = true;
        try {
            block10: while (true) {
                int n2 = this.nextResult();
                switch (n2) {
                    case 1: {
                        return this._currentRS;
                    }
                    case 5: {
                        continue block10;
                    }
                    case 0: {
                        bl = false;
                        ErrorMessage.raiseError("JZ0R2");
                    }
                    case 3: {
                        continue block10;
                    }
                }
                ErrorMessage.raiseError("JZ0P1");
            }
        }
        catch (SQLException sQLException) {
            if (bl && !"JZ0T4".equals(sQLException.getSQLState()) && !this._context._conn.isDead()) {
                try {
                    if ("JZ0F2".equals(sQLException.getSQLState())) {
                        this.a(false, true);
                    } else {
                        this.a(false, false);
                    }
                }
                catch (SQLException sQLException2) {
                    if (sQLException2.getSQLState().equals("JZ0F2")) {
                        sQLException2.setNextException(sQLException);
                        throw sQLException2;
                    }
                    sQLException.setNextException(sQLException2);
                }
            }
            throw sQLException;
        }
    }

    protected int executeUpdate(String string, ParamManager paramManager) throws SQLException {
        this.checkStatement(true);
        if (this.sendQuery(string, paramManager)) {
            return 1;
        }
        return this.updateLoop();
    }

    protected int updateLoop() throws SQLException {
        int n2 = 0;
        this._currentQT = 1;
        try {
            block8: while (true) {
                int n3 = this.nextResult();
                switch (n3) {
                    case 5: {
                        n2 = this.for;
                        continue block8;
                    }
                    case 0: {
                        this.for = n2;
                        break block8;
                    }
                    case 3: {
                        if (!(this instanceof CallableStatement)) continue block8;
                        TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
                        this.setRowCount(tdsProtocolContext.getPreviousCount());
                        n2 = this.for;
                        break block8;
                    }
                    case 1: {
                        if (this._retGeneratedKeys) break block8;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0P1");
                        continue block8;
                    }
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            boolean bl = false;
            if ("JZ0F2".equals(sQLException.getSQLState())) {
                bl = true;
            }
            this.a(false, bl);
            throw sQLException;
        }
        return n2;
    }

    protected boolean execute(String string, ParamManager paramManager) throws SQLException {
        this.checkStatement(true);
        this.sendQuery(string, paramManager);
        return this.executeLoop();
    }

    protected boolean executeLoop() throws SQLException {
        this._currentQT = 3;
        int n2 = this.nextResult();
        switch (n2) {
            case 0: 
            case 1: 
            case 5: {
                break;
            }
            case 3: {
                TdsProtocolContext tdsProtocolContext = (TdsProtocolContext)this._context;
                this.setRowCount(tdsProtocolContext.getPreviousCount());
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0P1");
            }
        }
        return this._currentRS != null;
    }

    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._context.setMessageHandler(sybMessageHandler);
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._context.getMessageHandler();
    }

    public SybMessageHandler getMessageHandler() {
        return this.getSybMessageHandler();
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        sQLWarning = !bl ? (SQLWarning)sQLException : SybConnection.getAllTheWarnings(sQLException);
        if (sQLWarning != null) {
            if (this.if == null) {
                this.if = sQLWarning;
            } else {
                this.if.setNextWarning(sQLWarning);
            }
        }
        if (bl) {
            throw sQLException;
        }
    }

    protected void handleBatchException(SQLException sQLException, int[] nArray, int n2) throws SQLException {
        if (sQLException instanceof BatchUpdateException) {
            int[] nArray2 = ((BatchUpdateException)sQLException).getUpdateCounts();
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                nArray[n2] = nArray2[i2];
                ++n2;
            }
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            if (sQLException instanceof SybBatchUpdateException) {
                SQLException sQLException2 = ((SybBatchUpdateException)sQLException).getOrigSQE();
                ErrorMessage.raiseBatchUpdateException(sQLException2, nArray3);
            } else {
                ErrorMessage.raiseBatchUpdateException(sQLException, nArray3);
            }
        } else {
            throw sQLException;
        }
    }

    protected void checkStatement(boolean bl) throws SQLException {
        this.checkDead();
        if (this._cursor != null && this._currentRS != null && this._currentRS._state == 2 && this._cursor.isLanguageCursor()) {
            ErrorMessage.raiseError("JZ00E");
        }
        if (this._closing) {
            return;
        }
        if (bl) {
            this.if = null;
            this.a(false, false);
            this._state = 2;
        } else if (this._state != 2) {
            ErrorMessage.raiseError("JZ0S1");
        }
    }

    protected void checkDead() throws SQLException {
        if (this._state == 4) {
            ErrorMessage.raiseError("JZ0S2");
        }
        this._context._conn.checkConnection();
    }

    protected boolean isClosed() {
        return this._closing;
    }

    protected void handleParam(ParamManager paramManager) throws SQLException {
        this.nextResult();
    }

    protected void setRowCount(int n2) {
        this.for = n2;
    }

    private void a() {
        this.do = false;
        this.for = -1;
    }

    protected String handleCallBody(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = string;
        boolean bl = false;
        String string3 = null;
        this._allowsOutputParms = true;
        this._sendAsRpc = true;
        try {
            String string4;
            this._rpcName = stringTokenizer.nextToken(CALL_DELIMS);
            int n2 = this._rpcName.length();
            if (this._rpcName.toLowerCase().equals("exec")) {
                bl = true;
                this._rpcName = stringTokenizer.nextToken(CALL_DELIMS);
                int n3 = string.indexOf(this._rpcName);
                string3 = string.substring(0, n3);
                string2 = string.substring(n3);
                n2 += this._rpcName.length();
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(string.indexOf(this._rpcName) + this._rpcName.length()));
            String string5 = stringTokenizer2.nextToken(" ");
            int n4 = string.lastIndexOf(41);
            if (string5.startsWith("(") && n4 > 0) {
                string2 = this._rpcName + " " + string.substring(string.indexOf(40) + 1, n4);
            }
            while ((string4 = stringTokenizer.nextToken(CALL_DELIMS)).charAt(0) == '?') {
            }
            this._sendAsRpc = false;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (bl && !this._protocol.getBoolOption(this._context, 12)) {
            string2 = string3 + string2;
        }
        return string2;
    }

    protected void deallocateDynamic() throws SQLException {
    }

    protected void checkCursor(boolean bl) throws SQLException {
        boolean bl2 = false;
        try {
            if (this._cursor == null) {
                this._cursor = this._protocol.getCursor(this._context, bl);
                this._cursor.setFetchSize(this._context._conn._props.getInteger(16));
                if (this._rsConcur == -9) {
                    this._rsConcur = 1008;
                }
                if (this instanceof SybPreparedStatement && ((SybPreparedStatement)this)._dynStmtName != null) {
                    bl2 = true;
                }
                this._cursor.setTypeAndConcurrency(this._rsType, this._rsConcur, bl2);
            }
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkBatch() throws SQLException {
        try {
            if (this._dbmda == null) {
                this._dbmda = (SybDatabaseMetaData)this._context._conn.getMetaData();
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        if (this._dbmda._batchSupport != 1) {
            if (!this._dbmda.supportsBatchUpdates()) {
                this._dbmda._batchSupport = 0;
                ErrorMessage.raiseError("JZ0BS");
            }
            this._dbmda._batchSupport = 1;
        } else if (this._dbmda._execBatchInLoop == -1) {
            this._dbmda._execBatchInLoop = this._dbmda.execBatchUpdatesInLoop() ? 1 : 0;
        }
        if (this._dbmda._execBatchInLoop != 1) return false;
        return true;
    }

    protected void checkForImplicitCursor() throws SQLException {
        int n2;
        if (this._cursor != null) {
            return;
        }
        if (this._context._conn._props.getBoolean(33) && !this._context._conn._props.getBoolean(27) && (n2 = this._context._conn._props.getInteger(47)) > 0) {
            int n3 = this.getMaxRows();
            if (n3 > 0 && n2 > n3) {
                n2 = n3;
            }
            this.setFetchSize(n2);
        }
    }

    protected String processGenKeysRequest(int n2, String string) throws SQLException {
        if (n2 != 1 && n2 != 2) {
            ErrorMessage.raiseError("JZ0FP", "autoGeneratedKeys");
        }
        boolean bl = this._retGeneratedKeys = this._type == 16 && n2 == 1;
        if (this._retGeneratedKeys) {
            string = string + " select @@identity";
        }
        return string;
    }
}

