/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.LDAPException;
import com.sybase.util.ds.ldap.LibctlDriver;
import com.sybase.util.ds.ldap.SyASEServer;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class DirectoryServiceHelper {
    private SyInterfacesDriver _interfacesDriver = null;
    private LibctlDriver _libtclDriver = null;

    public DirectoryServiceHelper() {
    }

    public DirectoryServiceHelper(boolean bl, boolean bl2) throws Exception, InterfacesException, LDAPException {
        this.init(bl, bl2);
    }

    public void init(boolean bl, boolean bl2) throws Exception {
        if (bl) {
            this.initInterfacesDriver();
        }
        if (bl2) {
            this.initLibtclDriver();
        }
    }

    public void initInterfacesDriver() throws Exception {
        this._interfacesDriver = new SyInterfacesDriver();
        this._interfacesDriver.open();
    }

    public void initLibtclDriver() throws FileNotFoundException, IOException, LDAPException {
        this._libtclDriver = new LibctlDriver();
    }

    public SyInterfacesDriver getInterfacesDriver(Boolean bl) throws Exception {
        if (this._interfacesDriver == null || bl.booleanValue()) {
            this.initInterfacesDriver();
        }
        return this._interfacesDriver;
    }

    public LibctlDriver getLibctlDriver() throws FileNotFoundException, IOException, LDAPException {
        if (this._libtclDriver == null) {
            this.initLibtclDriver();
        }
        return this._libtclDriver;
    }

    public String[] doesServerEntryExistInInterfaces(String string) {
        Vector vector = this._interfacesDriver.getEntries();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SyInterfacesEntry syInterfacesEntry = (SyInterfacesEntry)vector.elementAt(i);
                if (!syInterfacesEntry.getName().trim().equals(string.trim())) continue;
                return new String[]{syInterfacesEntry.getHost(), syInterfacesEntry.getPort()};
            }
        }
        return null;
    }

    public void addEntryToInterfaces(String string, String string2, String string3) throws Exception {
        this._interfacesDriver.setSaveOnChange(true);
        if (Utils.OS_WINDOWS) {
            this._interfacesDriver.setValue(string, "master", "NLWNSCK," + string2 + "," + string3);
            this._interfacesDriver.setValue(string, "query", "NLWNSCK," + string2 + "," + string3);
        } else {
            this._interfacesDriver.setValue(string, "master", "tcp ether " + string2 + " " + string3);
            this._interfacesDriver.setValue(string, "query", "tcp ether " + string2 + " " + string3);
        }
        this._interfacesDriver.setSaveOnChange(false);
    }

    public static void main(String[] stringArray) {
        try {
            DirectoryServiceHelper directoryServiceHelper = new DirectoryServiceHelper(true, true);
            directoryServiceHelper.printServerInfoFromInterfacesFile();
            directoryServiceHelper.printServerInfoFromLDAPFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void printServerInfoFromLDAPFile() {
        if (this._libtclDriver == null) {
            return;
        }
        Vector vector = this._libtclDriver.getLDAPServers();
        for (int i = 0; i < vector.size(); ++i) {
            SyLDAPServer syLDAPServer = (SyLDAPServer)vector.elementAt(i);
            try {
                syLDAPServer.connectLDAP();
                syLDAPServer.initASEEntries();
                Vector vector2 = syLDAPServer.getASEServers();
                if (vector2 != null) {
                    for (int j = 0; j < vector2.size(); ++j) {
                        SyASEServer syASEServer = (SyASEServer)vector2.elementAt(j);
                        System.out.println(syASEServer.getServerName() + " = " + syASEServer.getHost() + " : " + syASEServer.getPort());
                    }
                    continue;
                }
                System.out.println("Empty LDAP File");
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    private void printServerInfoFromInterfacesFile() {
        Vector vector = this._interfacesDriver.getEntries();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SyInterfacesEntry syInterfacesEntry = (SyInterfacesEntry)vector.elementAt(i);
                System.out.println(syInterfacesEntry.getName() + " = " + syInterfacesEntry.getHost() + " : " + syInterfacesEntry.getPort());
            }
        } else {
            System.out.println("Empty Interfaces File");
        }
    }

    public String[] getServersFromInterfacesFile() {
        String[] stringArray = this._interfacesDriver.getServers();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
        return stringArray;
    }

    public Enumeration getEntriesFromInterfacesFile() {
        return this._interfacesDriver.getASEServers().elements();
    }

    public Enumeration getEntriesFromLDAP(Integer n) {
        Vector vector = new Vector();
        if (this._libtclDriver == null) {
            return vector.elements();
        }
        Vector vector2 = this._libtclDriver.getLDAPServers();
        for (int i = 0; i < vector2.size(); ++i) {
            SyLDAPServer syLDAPServer = (SyLDAPServer)vector2.elementAt(i);
            try {
                if (!syLDAPServer.connectLDAP(n)) continue;
                syLDAPServer.initASEEntries();
                vector.addAll(syLDAPServer.getASEServers());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector.elements();
    }
}

