/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.SyInterfacesDriverBase;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.SyASEServer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SyInterfacesDriver
extends SyInterfacesDriverBase {
    private Hashtable _lookup = new Hashtable();
    private static final char OPTION = '-';
    private static final char PROPERTY_OPTION = 'D';

    public SyInterfacesDriver() {
    }

    public SyInterfacesDriver(String string) throws Exception, InterfacesException {
        super(string);
        this.fetch();
    }

    public SyInterfacesDriver(String string, boolean bl) throws Exception, InterfacesException {
        super(string, bl);
        this.fetch();
    }

    public void setBundle(String string) {
        this._fileName = string;
    }

    public String getBundle() {
        return this._fileName;
    }

    public void setSaveOnChange(boolean bl) {
        this._saveOnChange = bl;
    }

    public boolean getSaveOnChange() {
        return this._saveOnChange;
    }

    public void open(String string) throws Exception, InterfacesException {
        Serializable serializable;
        String string2 = null;
        String string3 = System.getProperty("interfaces.file");
        if (string3 != null) {
            string2 = this._fileName = string3;
        } else if (string != null && (serializable = new File(string)) != null && serializable.isDirectory()) {
            string2 = Utils.OS_WINDOWS ? string + System.getProperty("file.separator") + "ini" + System.getProperty("file.separator") + "sql.ini" : string + System.getProperty("file.separator") + "interfaces";
        }
        if (string2 == null) {
            this._fileName = null;
            serializable = new InterfacesException("ERR_SYBASE_ENV_NOT_DEFINED", "MSG_INTERFACES");
            throw serializable;
        }
        super.load(string2);
        this.fetch();
    }

    public void open() throws Exception, InterfacesException {
        this.open(Utils.getSybasePath());
    }

    public synchronized void refresh() throws IOException, InterfacesException {
        this.loadFile();
        this.parseLines();
        this.fetch();
    }

    public Enumeration servers() {
        return this._lookup.keys();
    }

    public String[] getServers() {
        Vector vector = new Vector();
        Object[] objectArray = this._lookup.keys();
        while (objectArray.hasMoreElements()) {
            vector.addElement(objectArray.nextElement());
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public String[] getServers(int n) {
        Vector vector = new Vector();
        Object[] objectArray = this._lookup.keys();
        while (objectArray.hasMoreElements()) {
            vector.addElement(objectArray.nextElement());
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public Enumeration entries() {
        return this._lookup.elements();
    }

    public Vector getEntries() {
        Vector<SyInterfacesEntry> vector = new Vector<SyInterfacesEntry>();
        Enumeration enumeration = this._lookup.elements();
        while (enumeration.hasMoreElements()) {
            SyInterfacesEntry syInterfacesEntry = (SyInterfacesEntry)enumeration.nextElement();
            vector.addElement(syInterfacesEntry);
        }
        return vector;
    }

    public Vector getASEServers() {
        Vector<SyASEServer> vector = new Vector<SyASEServer>();
        Enumeration enumeration = this._lookup.elements();
        while (enumeration.hasMoreElements()) {
            SyInterfacesEntry syInterfacesEntry = (SyInterfacesEntry)enumeration.nextElement();
            vector.addElement(new SyASEServer(syInterfacesEntry));
        }
        return vector;
    }

    public synchronized boolean contains(SyInterfacesEntry syInterfacesEntry) {
        String string;
        this.fetch();
        if (syInterfacesEntry != null && (string = syInterfacesEntry.getName()) != null) {
            return this._lookup.contains(string);
        }
        return false;
    }

    public synchronized boolean containsServer(String string) {
        if (string != null) {
            return this._lookup.contains(string);
        }
        return false;
    }

    public SyInterfacesEntry getEntry(String string) {
        return (SyInterfacesEntry)this._lookup.get(string);
    }

    public synchronized boolean addEntry(SyInterfacesEntry syInterfacesEntry) {
        if (syInterfacesEntry == null || syInterfacesEntry.getName() == null) {
            return false;
        }
        if (!this.contains(syInterfacesEntry)) {
            this._lookup.put(syInterfacesEntry.getName(), syInterfacesEntry);
            this.addSubjectLine(syInterfacesEntry.getName());
            String[] stringArray = syInterfacesEntry.getKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addValue(syInterfacesEntry.getName(), stringArray[i], syInterfacesEntry.getValue(stringArray[i]), true);
            }
            return true;
        }
        return false;
    }

    private void fetch() {
        String[] stringArray = this.getSubjects();
        for (int i = 0; i < stringArray.length; ++i) {
            SyInterfacesEntry syInterfacesEntry = new SyInterfacesEntry(stringArray[i]);
            String[] stringArray2 = this.getVariables(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                syInterfacesEntry.setValue(stringArray2[j], this.getValue(stringArray[i], stringArray2[j]));
                this._lookup.put(stringArray[i], syInterfacesEntry);
            }
        }
    }

    public String toString() {
        Enumeration enumeration = this.entries();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            SyInterfacesDriver.parseArgs(stringArray);
        }
        catch (InterfacesException interfacesException) {
            System.out.println(interfacesException.getMessage());
        }
        SyInterfacesDriver syInterfacesDriver = null;
        try {
            syInterfacesDriver = new SyInterfacesDriver();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
        }
        if (syInterfacesDriver == null) {
            syInterfacesDriver = new SyInterfacesDriver();
            try {
                syInterfacesDriver.open();
            }
            catch (InterfacesException interfacesException) {
                System.out.println(interfacesException.getMessage());
                System.exit(1);
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                System.exit(1);
            }
        }
        if (syInterfacesDriver != null) {
            System.out.println("----- Start unit test: toString()");
            System.out.println(syInterfacesDriver.toString());
            System.out.println("----- End of unit test\n");
            try {
                syInterfacesDriver.open();
            }
            catch (InterfacesException interfacesException) {
                System.out.println(interfacesException.getMessage());
                System.exit(1);
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                System.exit(1);
            }
            System.out.println("----- Start unit test: getServers(), getEntry()");
            String[] stringArray2 = syInterfacesDriver.getServers();
            for (int i = 0; i < stringArray2.length; ++i) {
                SyInterfacesEntry syInterfacesEntry = syInterfacesDriver.getEntry(stringArray2[i]);
                System.out.println(syInterfacesEntry.toString());
            }
            System.out.println("----- End of unit test\n");
        }
    }

    private static void parseArgs(String[] stringArray) throws InterfacesException {
        block3: for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(String.valueOf('-'))) continue;
            switch (stringArray[i].charAt(1)) {
                case 'D': {
                    SyInterfacesDriver.processPropertyOption(stringArray[i].substring(2));
                    continue block3;
                }
            }
        }
    }

    private static void processPropertyOption(String string) throws InterfacesException {
        SyInterfacesDriver.setProperty(string);
    }

    public static String setProperty(String string) throws InterfacesException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = "";
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                return System.setProperty(string2, string3);
            }
            InterfacesException interfacesException = new InterfacesException("ERR_PARAM_PARSE_ERROR", new String[]{string});
            throw interfacesException;
        }
        InterfacesException interfacesException = new InterfacesException(string);
        throw interfacesException;
    }
}

