/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.IniFileParser;
import com.sybase.util.ds.interfaces.InterfacesBaseParser;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.InterfacesFileParser;
import com.sybase.util.ds.interfaces.InterfacesLocator;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class SyInterfacesDriverBase {
    protected Vector _lines;
    protected Vector _subjects;
    protected Vector _variables;
    protected Vector _values;
    protected String _fileName;
    protected boolean _saveOnChange = false;
    protected InterfacesBaseParser _interfacesParser;
    protected long _nextLine = 0L;
    protected InterfacesLocator _interfacesLocator;

    public SyInterfacesDriverBase() {
    }

    public SyInterfacesDriverBase(String string) throws Exception, InterfacesException {
        this(string, false);
    }

    public SyInterfacesDriverBase(String string, boolean bl) throws Exception, InterfacesException {
        this._saveOnChange = bl;
        this._fileName = string;
        try {
            URL uRL = new URL(string);
            this._interfacesParser = new IniFileParser();
            if (!this._interfacesParser.probe(uRL)) {
                this._interfacesParser = new InterfacesFileParser();
                if (!this._interfacesParser.probe(uRL)) {
                    this._fileName = null;
                    InterfacesException interfacesException = new InterfacesException("ERR_FORMAT_ERROR", "MSG_INTERFACES", uRL.getFile());
                    throw interfacesException;
                }
            }
            this.loadFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            if (!new File(string).exists()) {
                this._fileName = null;
                InterfacesException interfacesException = new InterfacesException("ERR_FILE_NOT_FOUND", "MSG_INTERFACES", string);
                throw interfacesException;
            }
            this._interfacesParser = new IniFileParser();
            if (!this._interfacesParser.probe(string)) {
                this._interfacesParser = new InterfacesFileParser();
                if (!this._interfacesParser.probe(string)) {
                    this._fileName = null;
                    InterfacesException interfacesException = new InterfacesException("ERR_FORMAT_ERROR", "MSG_INTERFACES", string);
                    throw interfacesException;
                }
            }
            this.loadFile();
        }
        this.parseLines();
    }

    protected void load(String string) throws Exception, InterfacesException {
        this._saveOnChange = false;
        this._fileName = string;
        try {
            URL uRL = new URL(string);
            this._interfacesParser = new IniFileParser();
            if (!this._interfacesParser.probe(uRL)) {
                this._interfacesParser = new InterfacesFileParser();
                if (!this._interfacesParser.probe(uRL)) {
                    this._fileName = null;
                    InterfacesException interfacesException = new InterfacesException("ERR_FORMAT_ERROR", "MSG_INTERFACES", uRL.getFile());
                    throw interfacesException;
                }
            }
            this.loadFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            if (!new File(string).exists()) {
                this._fileName = null;
                InterfacesException interfacesException = new InterfacesException("ERR_FILE_NOT_FOUND", "MSG_INTERFACES", string);
                throw interfacesException;
            }
            this._interfacesParser = new IniFileParser();
            if (!this._interfacesParser.probe(string)) {
                this._interfacesParser = new InterfacesFileParser();
                if (!this._interfacesParser.probe(string)) {
                    this._fileName = null;
                    InterfacesException interfacesException = new InterfacesException("ERR_FORMAT_ERROR", "MSG_INTERFACES", string);
                    throw interfacesException;
                }
            }
            this.loadFile();
        }
        this.parseLines();
    }

    public void loadFile(URL uRL) throws IOException {
        this._lines = new Vector();
        this._subjects = new Vector();
        this._variables = new Vector();
        this._values = new Vector();
        InputStream inputStream = uRL.openStream();
        this.loadFile(inputStream);
    }

    public void loadFile() throws IOException {
        this._lines = new Vector();
        this._subjects = new Vector();
        this._variables = new Vector();
        this._values = new Vector();
        this.loadFile(new FileInputStream(this._fileName));
    }

    public void loadFile(InputStream inputStream) throws IOException {
        this._lines = new Vector();
        this._subjects = new Vector();
        this._variables = new Vector();
        this._values = new Vector();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            this._lines.addElement(string);
        }
        bufferedReader.close();
    }

    protected boolean createFile() {
        return this._interfacesParser.createFile(this._fileName);
    }

    protected void parseLines() {
        String string = null;
        String string2 = null;
        for (int i = 0; i < this._lines.size(); ++i) {
            string = (String)this._lines.elementAt(i);
            if (this._interfacesParser.isBlankLine(string) || this._interfacesParser.isCommentLine(string)) continue;
            if (this.isaSubject(string)) {
                string2 = this._interfacesParser.getSubject(string);
                continue;
            }
            if (!this.isanAssignment(string)) continue;
            String string3 = string.trim();
            this.addAttributes(string2, string3);
        }
    }

    protected boolean addAttributes(String string, String string2) {
        String[] stringArray = new String[2];
        if (this._interfacesParser.addAttributes(string, string2, stringArray)) {
            return this.addValue(string, stringArray[0], stringArray[1], false);
        }
        return false;
    }

    public boolean setValue(String string, String string2, String string3) throws Exception {
        boolean bl = this.addValue(string, string2, string3, true);
        if (this._saveOnChange) {
            this.saveFile();
        }
        return bl;
    }

    protected boolean addValue(String string, String string2, String string3, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (!this._subjects.contains(string)) {
            this._subjects.addElement(string);
            this._variables.addElement(new Vector());
            this._values.addElement(new Vector());
        }
        int n = this._subjects.indexOf(string);
        Vector vector = (Vector)this._variables.elementAt(n);
        Vector vector2 = (Vector)this._values.elementAt(n);
        if (!vector.contains(string2)) {
            vector.addElement(string2);
            vector2.addElement(this._values);
        }
        int n2 = vector.indexOf(string2);
        vector2.setElementAt(string3, n2);
        if (bl) {
            this.setLine(string, string2, string3);
        }
        return true;
    }

    protected boolean isaSubject(String string) {
        return this._interfacesParser.isaSubject(string);
    }

    protected void setLine(String string, String string2, String string3) {
        int n;
        int n2;
        int n3 = this.findSubjectLine(string);
        if (n3 == -1) {
            String string4 = this.refineSubject(string);
            this.addSubjectLine(string4);
            n3 = this._lines.size() - 1;
        }
        if ((n2 = this.findAssignmentBetween(string2, n3, n = this.endOfSubject(n3))) == -1) {
            if (Utils.OS_WINDOWS) {
                this._lines.insertElementAt(string2 + "=" + string3, n);
            } else {
                this._lines.insertElementAt("\t" + string2 + " " + string3, n);
            }
        } else if (Utils.OS_WINDOWS) {
            this._lines.setElementAt(string2 + "=" + string3, n2);
        } else {
            this._lines.setElementAt("\t" + string2 + " " + string3, n2);
        }
    }

    protected String refineSubject(String string) {
        return this._interfacesParser.refineSubject(string);
    }

    protected int findAssignmentLine(String string, String string2) {
        int n = this.findSubjectLine(string);
        int n2 = this.endOfSubject(n);
        return this.findAssignmentBetween(string2, n, n2);
    }

    protected int findAssignmentBetween(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!((String)this._lines.elementAt(i)).trim().startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    protected void addSubjectLine(String string) {
        this._lines.addElement("");
        this._lines.addElement(this.refineSubject(string));
    }

    protected int findSubjectLine(String string) {
        String string2 = this.refineSubject(string);
        for (int i = 0; i < this._lines.size(); ++i) {
            String string3 = (String)this._lines.elementAt(i);
            if (!string2.equals(string3)) continue;
            return i;
        }
        return -1;
    }

    protected int endOfSubject(int n) {
        int n2 = n + 1;
        if (n >= this._lines.size()) {
            return this._lines.size();
        }
        for (int i = n + 1; i < this._lines.size(); ++i) {
            if (this.isanAssignment((String)this._lines.elementAt(i))) {
                n2 = i + 1;
            }
            if (!this.isaSubject((String)this._lines.elementAt(i))) continue;
            return n2;
        }
        return n2;
    }

    protected boolean isanAssignment(String string) {
        return this._interfacesParser.isAttributes(string);
    }

    public Vector getLines() {
        return (Vector)this._lines.clone();
    }

    public String[] getVariables(String string) {
        int n = this._subjects.indexOf(string);
        if (n != -1) {
            Vector vector = (Vector)this._variables.elementAt(n);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public String[] getSubjects() {
        Object[] objectArray = new String[this._subjects.size()];
        this._subjects.copyInto(objectArray);
        return objectArray;
    }

    public String getValue(String string, String string2) {
        int n = this._subjects.indexOf(string);
        if (n == -1) {
            return "";
        }
        Vector vector = (Vector)this._values.elementAt(n);
        Vector vector2 = (Vector)this._variables.elementAt(n);
        int n2 = vector2.indexOf(string2);
        if (n2 != -1) {
            return (String)vector.elementAt(n2);
        }
        return "";
    }

    public void deleteValue(String string, String string2) throws Exception {
        int n = this._subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        Vector vector = (Vector)this._values.elementAt(n);
        Vector vector2 = (Vector)this._variables.elementAt(n);
        int n2 = vector2.indexOf(string2);
        if (n2 != -1) {
            vector.removeElementAt(n2);
            vector2.removeElementAt(n2);
            int n3 = this.findAssignmentLine(string, string2);
            if (n3 != -1) {
                this._lines.removeElementAt(n3);
            }
            if (vector2.size() == 0) {
                this.deleteSubject(string);
            }
            if (this._saveOnChange) {
                this.saveFile();
            }
        }
    }

    public void deleteSubject(String string) throws Exception {
        int n = this._subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        this._values.removeElementAt(n);
        this._variables.removeElementAt(n);
        this._subjects.removeElementAt(n);
        int n2 = this.findSubjectLine(string);
        int n3 = this.endOfSubject(n2);
        for (int i = n2; i < n3; ++i) {
            this._lines.removeElementAt(n2);
        }
        if (this._saveOnChange) {
            this.saveFile();
        }
    }

    public void saveFile() throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._fileName)));
        for (int i = 0; i < this._lines.size(); ++i) {
            dataOutputStream.writeBytes((String)this._lines.elementAt(i) + System.getProperty("line.separator"));
        }
        dataOutputStream.close();
    }

    protected void finalize() {
    }

    public static SyInterfacesEntry getServer(String string, String string2) {
        return null;
    }

    public Enumeration forService(String string) {
        return null;
    }

    public String getAttribute(String string) {
        return null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("SyInterfacesDriverBase <filename>");
            System.exit(0);
        } else {
            SyInterfacesDriverBase syInterfacesDriverBase = null;
            try {
                syInterfacesDriverBase = new SyInterfacesDriverBase(stringArray[0]);
            }
            catch (InterfacesException interfacesException) {
                System.out.println(interfacesException.getMessage());
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
            }
            if (syInterfacesDriverBase != null) {
                String[] stringArray2 = syInterfacesDriverBase.getSubjects();
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println(stringArray2[i]);
                    String[] stringArray3 = syInterfacesDriverBase.getVariables(stringArray2[i]);
                    for (int j = 0; j < stringArray3.length; ++j) {
                        System.out.println("  " + stringArray3[j] + " = " + syInterfacesDriverBase.getValue(stringArray2[i], stringArray3[j]));
                    }
                }
            }
        }
    }
}

