/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.uaf;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionFactory;
import com.sybase.ua.AgentInfo;
import com.sybase.util.ds.ASEVersionHelper;
import com.sybase.util.ds.uaf.SyUAF;
import com.sybase.util.ds.uaf.SyUAFEntry;
import java.rmi.RemoteException;
import java.util.Map;

public class SyUAFASEEntry
extends SyUAFEntry {
    private String _serverName = this.getValue("serverName");
    private String _host = this.getValue("host");
    private String _port = this.getValue("port");
    private String _versionString = "";
    private String _platform = "";
    private String _os = "";
    private ASEVersionHelper _versionHelper = null;
    private String _status = this.getValue("ASEStatus");

    public SyUAFASEEntry(Map map, String string, int n, AgentInfo agentInfo) {
        super(map, string, n, agentInfo);
        this._versionString = this.getValue("ASEVersion");
        this._platform = this.getValue("OSArchitecture");
        this._os = this.getValue("OSName");
        if (this.hasVersionString()) {
            this._versionHelper = new ASEVersionHelper(this._versionString);
        }
    }

    public String getName() {
        return this._serverName;
    }

    public String getHostName() {
        return this._host;
    }

    public String getPortNumber() {
        return this._port;
    }

    public int getPort() {
        if (this._port != null & this._port.length() > 0) {
            try {
                Integer n = new Integer(this._port);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean hasVersionString() {
        return this._versionString != null && this._versionString.length() > 0;
    }

    public String getVersionString() {
        return this._versionString;
    }

    public String getVersionNumber() {
        return this.hasVersionString() ? this._versionHelper.getVersion() : "";
    }

    public String getPlatform() {
        return this.hasVersionString() ? this._versionHelper.getPlatform() : "";
    }

    public String getAgentPlatform() {
        return this._platform;
    }

    public String getOperatingSystem() {
        return this.hasVersionString() ? this._versionHelper.getOperatingSystem() : "";
    }

    public String getAgentOperatingSystem() {
        return this._os;
    }

    public String getReleaseType() {
        return this.hasVersionString() ? this._versionHelper.getReleaseType() : "";
    }

    public String getServerType() {
        return this.hasVersionString() ? this._versionHelper.getType() : "";
    }

    public String getBuild1() {
        return this.hasVersionString() ? this._versionHelper.getBuild1() : "";
    }

    public String getBuild2() {
        return this.hasVersionString() ? this._versionHelper.getBuild2() : "";
    }

    public String getBuildDate() {
        return this.hasVersionString() ? this._versionHelper.getBuildDate() : "";
    }

    public String getStatus() {
        return this._status;
    }

    public void setStatus(String string) {
        this._status = string;
    }

    public String toString() {
        return this._map == null ? "name = " + this.getName() + ", host = " + this.getHostName() + ", port = " + this.getPortNumber() + ", version string = " + this._versionString + ", status = " + this.getStatus() + ", id = " + this.getInstanceNumber() : this._map.toString();
    }

    public boolean hasHostAndPort() {
        boolean bl = this._host != null && this._host.length() > 0;
        boolean bl2 = this.getPort() > 0;
        return bl && bl2;
    }

    public void start(String string, String string2) {
        try {
            AgentConnection agentConnection = AgentConnectionFactory.createAgentConnection((String)"rmi", (String)this.getHostName(), (String)this.getRMIPort());
            agentConnection.connect();
            agentConnection.login(string, string2.toCharArray());
            agentConnection.invokeAgentPluginMethod(SyUAF.ASE_PLUGIN_ID, this.getPluginVersion(), this.getInstanceNumber(), "start", null, null);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }
}

